/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import androidx.annotation.RestrictTo;
import androidx.benchmark.macro.ProfileRule;
import androidx.benchmark.macro.ProfileRuleKt;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/macro/ProfileRule;", "", "underlying", "", "flags", "classDescriptor", "methodDescriptor", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassDescriptor", "()Ljava/lang/String;", "getFlags", "getMethodDescriptor", "getUnderlying", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ProfileRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String underlying;
    @NotNull
    private final String flags;
    @NotNull
    private final String classDescriptor;
    @Nullable
    private final String methodDescriptor;
    @NotNull
    private static final Comparator<ProfileRule> comparator;

    public ProfileRule(@NotNull String underlying, @NotNull String flags, @NotNull String classDescriptor, @Nullable String methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        this.underlying = underlying;
        this.flags = flags;
        this.classDescriptor = classDescriptor;
        this.methodDescriptor = methodDescriptor;
    }

    @NotNull
    public final String getUnderlying() {
        return this.underlying;
    }

    @NotNull
    public final String getFlags() {
        return this.flags;
    }

    @NotNull
    public final String getClassDescriptor() {
        return this.classDescriptor;
    }

    @Nullable
    public final String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @NotNull
    public final String component1() {
        return this.underlying;
    }

    @NotNull
    public final String component2() {
        return this.flags;
    }

    @NotNull
    public final String component3() {
        return this.classDescriptor;
    }

    @Nullable
    public final String component4() {
        return this.methodDescriptor;
    }

    @NotNull
    public final ProfileRule copy(@NotNull String underlying, @NotNull String flags, @NotNull String classDescriptor, @Nullable String methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        return new ProfileRule(underlying, flags, classDescriptor, methodDescriptor);
    }

    public static /* synthetic */ ProfileRule copy$default(ProfileRule profileRule, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = profileRule.underlying;
        }
        if ((n & 2) != 0) {
            string2 = profileRule.flags;
        }
        if ((n & 4) != 0) {
            string3 = profileRule.classDescriptor;
        }
        if ((n & 8) != 0) {
            string4 = profileRule.methodDescriptor;
        }
        return profileRule.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "ProfileRule(underlying=" + this.underlying + ", flags=" + this.flags + ", classDescriptor=" + this.classDescriptor + ", methodDescriptor=" + this.methodDescriptor + ')';
    }

    public int hashCode() {
        int result = this.underlying.hashCode();
        result = result * 31 + this.flags.hashCode();
        result = result * 31 + this.classDescriptor.hashCode();
        result = result * 31 + (this.methodDescriptor == null ? 0 : this.methodDescriptor.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileRule)) {
            return false;
        }
        ProfileRule profileRule = (ProfileRule)other;
        if (!Intrinsics.areEqual((Object)this.underlying, (Object)profileRule.underlying)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.flags, (Object)profileRule.flags)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classDescriptor, (Object)profileRule.classDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.methodDescriptor, (Object)profileRule.methodDescriptor);
    }

    @JvmStatic
    @Nullable
    public static final ProfileRule parse(@NotNull String rule) {
        return Companion.parse(rule);
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.comparator.1.INSTANCE, Companion.comparator.2.INSTANCE};
        comparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Landroidx/benchmark/macro/ProfileRule$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Landroidx/benchmark/macro/ProfileRule;", "Lkotlin/Comparator;", "getComparator$benchmark_macro_release", "()Ljava/util/Comparator;", "parse", "rule", "", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ProfileRule parse(@NotNull String rule) {
            ProfileRule profileRule;
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            MatchResult result = Regex.find$default((Regex)ProfileRuleKt.access$getPROFILE_RULE_REGEX$p(), (CharSequence)rule, (int)0, (int)2, null);
            if (result != null) {
                MatchResult.Destructured destructured = result.getDestructured();
                String flags = (String)destructured.getMatch().getGroupValues().get(1);
                String classDescriptor = (String)destructured.getMatch().getGroupValues().get(2);
                String methodDescriptor = (String)destructured.getMatch().getGroupValues().get(4);
                profileRule = new ProfileRule(rule, flags, classDescriptor, methodDescriptor);
            } else {
                profileRule = null;
            }
            return profileRule;
        }

        @NotNull
        public final Comparator<ProfileRule> getComparator$benchmark_macro_release() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

