/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import androidx.annotation.RestrictTo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import androidx.benchmark.Profiler;
import androidx.benchmark.macro.perfetto.server.PerfettoHttpServer;
import androidx.benchmark.perfetto.ExperimentalPerfettoTraceProcessorApi;
import androidx.benchmark.perfetto.PerfettoTrace;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.PerfettoTraceProcessorKt;
import androidx.benchmark.perfetto.QueryResultIterator;
import androidx.benchmark.perfetto.Row;
import androidx.benchmark.perfetto.Slice;
import androidx.benchmark.perfetto.SliceKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.AppendTraceDataResult;
import perfetto.protos.ComputeMetricResult;
import perfetto.protos.QueryResult;
import perfetto.protos.TraceMetrics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/perfetto/PerfettoTraceProcessor;", "", "()V", "perfettoHttpServer", "Landroidx/benchmark/macro/perfetto/server/PerfettoHttpServer;", "traceLoaded", "", "clearTrace", "", "loadTrace", "T", "trace", "Landroidx/benchmark/perfetto/PerfettoTrace;", "block", "Lkotlin/Function1;", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/benchmark/perfetto/PerfettoTrace;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadTraceImpl", "absoluteTracePath", "", "startServer", "stopServer", "Companion", "Session", "benchmark-macro_release"})
@ExperimentalPerfettoTraceProcessorApi
@SourceDebugExtension(value={"SMAP\nPerfettoTraceProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n141#2,6:369\n141#2,6:375\n141#2,3:381\n145#2,2:386\n141#2,6:388\n1855#3,2:384\n*S KotlinDebug\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor\n*L\n312#1:369,6\n318#1:375,6\n328#1:381,3\n328#1:386,2\n356#1:388,6\n344#1:384,2\n*E\n"})
public final class PerfettoTraceProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PerfettoHttpServer perfettoHttpServer = new PerfettoHttpServer();
    private boolean traceLoaded;
    public static final int PORT = 9001;
    @NotNull
    private static final Lazy<String> shellPath$delegate = LazyKt.lazy((Function0)Companion.shellPath.2.INSTANCE);

    public final <T> T loadTrace(@NotNull PerfettoTrace trace, @NotNull Function1<? super Session, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.loadTraceImpl(trace.getPath());
        try {
            return (T)block.invoke((Object)new Session(this));
        }
        catch (Throwable t) {
            String string = trace.getPath();
            String string2 = Outputs.INSTANCE.getOutputDirectory().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Outputs.outputDirectory.absolutePath");
            if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                InstrumentationResults.INSTANCE.instrumentationReport((Function1)new Function1<InstrumentationResultScope, Unit>(t, trace){
                    final /* synthetic */ Throwable $t;
                    final /* synthetic */ PerfettoTrace $trace;
                    {
                        this.$t = $t;
                        this.$trace = $trace;
                        super(1);
                    }

                    public final void invoke(@NotNull InstrumentationResultScope $this$instrumentationReport) {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                        String label = "Trace with processing error: " + ((string = this.$t.getMessage()) != null && (string = StringsKt.take((String)string, (int)50)) != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null) + "...";
                        InstrumentationResultScope.reportSummaryToIde$default((InstrumentationResultScope)$this$instrumentationReport, null, null, null, null, null, (List)CollectionsKt.listOf((Object)new Profiler.ResultFile(label, this.$trace.getPath())), (int)31, null);
                    }
                });
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PerfettoTraceProcessor startServer() {
        PerfettoTraceProcessor perfettoTraceProcessor;
        String label$iv = "PerfettoTraceProcessor#startServer";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            System.out.println((Object)"startserver");
            this.perfettoHttpServer.startServer();
            perfettoTraceProcessor = this;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
        return perfettoTraceProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopServer() {
        String label$iv = "PerfettoTraceProcessor#stopServer";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            System.out.println((Object)"stopserver");
            this.perfettoHttpServer.stopServer();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadTraceImpl(String absoluteTracePath) {
        String label$iv = "PerfettoTraceProcessor#loadTraceImpl";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)absoluteTracePath, (CharSequence)" ", (boolean)false, (int)2, null))) {
                boolean $i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$32 = false;
                String $i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$32 = "Trace path must not contain spaces: " + absoluteTracePath;
                throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$32.toString());
            }
            File traceFile = new File(absoluteTracePath);
            if (!(traceFile.exists() && traceFile.isFile())) {
                boolean $i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$42 = false;
                String $i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$42 = "Trace path must exist and not be a directory: " + absoluteTracePath;
                throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$loadTraceImpl$1$42.toString());
            }
            if (this.traceLoaded) {
                this.clearTrace();
            }
            List<AppendTraceDataResult> parseResults = this.perfettoHttpServer.parse(new FileInputStream(traceFile));
            Iterable $this$forEach$iv = parseResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AppendTraceDataResult it = (AppendTraceDataResult)((Object)element$iv);
                boolean bl2 = false;
                if (it.getError() == null) continue;
                throw new IllegalStateException(it.getError());
            }
            this.perfettoHttpServer.notifyEof();
            this.traceLoaded = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearTrace() {
        String label$iv = "PerfettoTraceProcessor#clearTrace";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            this.perfettoHttpServer.restoreInitialTables();
            this.traceLoaded = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    @JvmStatic
    public static final <T> T runServer(@NotNull Function1<? super PerfettoTraceProcessor, ? extends T> block) {
        return Companion.runServer(block);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0007\u00a2\u0006\u0002\u0010\u0011J4\u0010\u0012\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u0010H\u0007\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Companion;", "", "()V", "PORT", "", "shellPath", "", "getShellPath$benchmark_macro_release", "()Ljava/lang/String;", "shellPath$delegate", "Lkotlin/Lazy;", "runServer", "T", "block", "Lkotlin/Function1;", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "runSingleSessionServer", "absoluteTracePath", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "benchmark-macro_release"})
    @SourceDebugExtension(value={"SMAP\nPerfettoTraceProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor$Companion\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,368:1\n141#2,3:369\n141#2,6:372\n145#2,2:378\n*S KotlinDebug\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor$Companion\n*L\n99#1:369,3\n107#1:372,6\n99#1:378,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShellPath$benchmark_macro_release() {
            Lazy lazy = shellPath$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T runServer(@NotNull Function1<? super PerfettoTraceProcessor, ? extends T> block) {
            Object object;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            String label$iv = "PerfettoTraceProcessor#runServer";
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                PerfettoTraceProcessor perfettoTraceProcessor;
                Object object2;
                boolean bl = false;
                PerfettoTraceProcessor perfettoTraceProcessor2 = null;
                try {
                    Object object3;
                    perfettoTraceProcessor2 = new PerfettoTraceProcessor().startServer();
                    String label$iv2 = "PerfettoTraceProcessor#runServer#block";
                    boolean $i$f$inMemoryTrace2 = false;
                    InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv2, (long)0L, (int)2, null);
                    try {
                        boolean bl2 = false;
                        object3 = block.invoke((Object)perfettoTraceProcessor2);
                    }
                    finally {
                        InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
                    }
                    object2 = object3;
                    perfettoTraceProcessor = perfettoTraceProcessor2;
                }
                catch (Throwable throwable) {
                    PerfettoTraceProcessor perfettoTraceProcessor3 = perfettoTraceProcessor2;
                    if (perfettoTraceProcessor3 != null) {
                        perfettoTraceProcessor3.stopServer();
                    }
                    throw throwable;
                }
                if (perfettoTraceProcessor != null) {
                    perfettoTraceProcessor.stopServer();
                }
                object = object2;
            }
            finally {
                InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
            }
            return (T)object;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final <T> T runSingleSessionServer(@NotNull String absoluteTracePath, @NotNull Function1<? super Session, ? extends T> block) {
            Intrinsics.checkNotNullParameter((Object)absoluteTracePath, (String)"absoluteTracePath");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return this.runServer((Function1)new Function1<PerfettoTraceProcessor, T>(absoluteTracePath, block){
                final /* synthetic */ String $absoluteTracePath;
                final /* synthetic */ Function1<Session, T> $block;
                {
                    this.$absoluteTracePath = $absoluteTracePath;
                    this.$block = $block;
                    super(1);
                }

                public final T invoke(@NotNull PerfettoTraceProcessor $this$runServer) {
                    Intrinsics.checkNotNullParameter((Object)$this$runServer, (String)"$this$runServer");
                    return $this$runServer.loadTrace(new PerfettoTrace(this.$absoluteTracePath), (Function1)new Function1<Session, T>(this.$block){
                        final /* synthetic */ Function1<Session, T> $block;
                        {
                            this.$block = $block;
                            super(1);
                        }

                        public final T invoke(@NotNull Session $this$loadTrace) {
                            Intrinsics.checkNotNullParameter((Object)$this$loadTrace, (String)"$this$loadTrace");
                            return (T)this.$block.invoke((Object)$this$loadTrace);
                        }
                    });
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\t\u001a\u00020\bJ1\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\t\u001a\u00020\bJ\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "", "traceProcessor", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor;", "(Landroidx/benchmark/perfetto/PerfettoTraceProcessor;)V", "getTraceMetrics", "Lperfetto/protos/TraceMetrics;", "metric", "", "query", "Lkotlin/sequences/Sequence;", "Landroidx/benchmark/perfetto/Row;", "querySlices", "", "Landroidx/benchmark/perfetto/Slice;", "sliceNames", "", "packageName", "([Ljava/lang/String;Ljava/lang/String;)Ljava/util/List;", "rawQuery", "", "decodeAndCheckError", "Lperfetto/protos/QueryResult;", "Lperfetto/protos/QueryResult$Companion;", "inputStream", "Ljava/io/InputStream;", "benchmark-macro_release"})
    @SourceDebugExtension(value={"SMAP\nPerfettoTraceProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor$Session\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n*L\n1#1,368:1\n141#2,6:369\n141#2,6:375\n141#2,6:381\n*S KotlinDebug\n*F\n+ 1 PerfettoTraceProcessor.kt\nandroidx/benchmark/perfetto/PerfettoTraceProcessor$Session\n*L\n173#1:369,6\n214#1:375,6\n252#1:381,6\n*E\n"})
    public static final class Session {
        @NotNull
        private final PerfettoTraceProcessor traceProcessor;

        public Session(@NotNull PerfettoTraceProcessor traceProcessor) {
            Intrinsics.checkNotNullParameter((Object)traceProcessor, (String)"traceProcessor");
            this.traceProcessor = traceProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final TraceMetrics getTraceMetrics(@NotNull String metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            String label$iv = "PerfettoTraceProcessor#getTraceMetrics " + metric;
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                boolean bl = false;
                if (!(!StringsKt.contains$default((CharSequence)metric, (CharSequence)" ", (boolean)false, (int)2, null))) {
                    boolean $i$a$-require-PerfettoTraceProcessor$Session$getTraceMetrics$1$32 = false;
                    String $i$a$-require-PerfettoTraceProcessor$Session$getTraceMetrics$1$32 = "Metric must not contain spaces: " + metric;
                    throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$Session$getTraceMetrics$1$32.toString());
                }
                if (!this.traceProcessor.perfettoHttpServer.isRunning()) {
                    boolean bl2 = false;
                    String string = "Perfetto trace_shell_process is not running.";
                    throw new IllegalArgumentException(string.toString());
                }
                ComputeMetricResult computeResult = this.traceProcessor.perfettoHttpServer.computeMetric(CollectionsKt.listOf((Object)metric));
                if (computeResult.getError() != null) {
                    throw new IllegalStateException(computeResult.getError());
                }
                ByteString byteString = computeResult.getMetrics();
                Intrinsics.checkNotNull((Object)byteString);
                TraceMetrics traceMetrics = (TraceMetrics)((Object)TraceMetrics.ADAPTER.decode(byteString));
                return traceMetrics;
            }
            finally {
                InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Sequence<Row> query(@Language(value="sql") @NotNull String query2) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            String label$iv = StringsKt.take((String)("PerfettoTraceProcessor#query " + query2), (int)127);
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                boolean bl = false;
                if (!this.traceProcessor.perfettoHttpServer.isRunning()) {
                    boolean bl2 = false;
                    String string = "Perfetto trace_shell_process is not running.";
                    throw new IllegalArgumentException(string.toString());
                }
                QueryResult queryResult2 = (QueryResult)((Object)this.traceProcessor.perfettoHttpServer.rawQuery(query2, (Function1)new Function1<InputStream, QueryResult>(this, query2){
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ String $query;
                    {
                        this.this$0 = $receiver;
                        this.$query = $query;
                        super(1);
                    }

                    @NotNull
                    public final QueryResult invoke(@NotNull InputStream it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Session.access$decodeAndCheckError(this.this$0, QueryResult.Companion, this.$query, it);
                    }
                }));
                Sequence sequence = (Sequence)new Sequence<Row>(queryResult2){
                    final /* synthetic */ QueryResult $queryResult$inlined;
                    {
                        this.$queryResult$inlined = queryResult2;
                    }

                    @NotNull
                    public Iterator<Row> iterator() {
                        boolean bl = false;
                        return new QueryResultIterator(this.$queryResult$inlined);
                    }
                };
                return sequence;
            }
            finally {
                InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
            }
        }

        private final QueryResult decodeAndCheckError(QueryResult.Companion $this$decodeAndCheckError, String query2, InputStream inputStream) {
            Object object = QueryResult.ADAPTER.decode(inputStream);
            QueryResult it = (QueryResult)((Object)object);
            boolean bl = false;
            if (!(it.getError() == null)) {
                boolean bl2 = false;
                throw new IllegalStateException("Error with query: --" + query2 + "--, error=" + it.getError());
            }
            return (QueryResult)((Object)object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] rawQuery(@Language(value="sql") @NotNull String query2) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            String label$iv = StringsKt.take((String)("PerfettoTraceProcessor#query " + query2), (int)127);
            boolean $i$f$inMemoryTrace = false;
            InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
            try {
                boolean bl = false;
                if (!this.traceProcessor.perfettoHttpServer.isRunning()) {
                    boolean bl2 = false;
                    String string = "Perfetto trace_shell_process is not running.";
                    throw new IllegalArgumentException(string.toString());
                }
                byte[] byArray = (byte[])this.traceProcessor.perfettoHttpServer.rawQuery(query2, rawQuery.1.2.INSTANCE);
                return byArray;
            }
            finally {
                InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final List<Slice> querySlices(@NotNull String[] sliceNames, @Nullable String packageName) {
            Intrinsics.checkNotNullParameter((Object)sliceNames, (String)"sliceNames");
            if (!this.traceProcessor.perfettoHttpServer.isRunning()) {
                boolean $i$a$-require-PerfettoTraceProcessor$Session$querySlices$22 = false;
                String $i$a$-require-PerfettoTraceProcessor$Session$querySlices$22 = "Perfetto trace_shell_process is not running.";
                throw new IllegalArgumentException($i$a$-require-PerfettoTraceProcessor$Session$querySlices$22.toString());
            }
            String whereClause2 = ArraysKt.joinToString$default((Object[])sliceNames, (CharSequence)" OR ", (CharSequence)(packageName == null ? "(" : PerfettoTraceProcessorKt.processNameLikePkg(packageName) + " AND ("), (CharSequence)")", (int)0, null, (Function1)querySlices.whereClause.1.INSTANCE, (int)24, null);
            String innerJoins = packageName != null ? "                INNER JOIN thread_track on slice.track_id = thread_track.id\n                INNER JOIN thread USING(utid)\n                INNER JOIN process USING(upid)" : "";
            return SliceKt.toSlices(this.query(StringsKt.trimMargin$default((String)("\n                    SELECT slice.name,ts,dur\n                    FROM slice\n                    " + innerJoins + "\n                    WHERE " + whereClause2 + "\n                    ORDER BY ts\n                    "), null, (int)1, null)));
        }

        public static final /* synthetic */ QueryResult access$decodeAndCheckError(Session $this, QueryResult.Companion $receiver, String query2, InputStream inputStream) {
            return $this.decodeAndCheckError($receiver, query2, inputStream);
        }
    }
}

