/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import android.util.Log;
import androidx.benchmark.macro.StartupMode;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.PerfettoTraceProcessorKt;
import androidx.benchmark.perfetto.Row;
import androidx.benchmark.perfetto.Slice;
import androidx.benchmark.perfetto.SliceKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nH\u0002J(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0003\u00a8\u0006\u0019"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery;", "", "()V", "findEndRenderTimeForUiFrame", "", "uiSlices", "", "Landroidx/benchmark/perfetto/Slice;", "rtSlices", "predicate", "Lkotlin/Function1;", "", "getFrameSubMetrics", "Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "session", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "captureApiLevel", "", "targetPackageName", "", "startupMode", "Landroidx/benchmark/macro/StartupMode;", "getFullQuery", "StartupSliceType", "SubMetrics", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nStartupTimingQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupTimingQuery.kt\nandroidx/benchmark/macro/perfetto/StartupTimingQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n223#2,2:201\n223#2,2:203\n766#2:205\n857#2,2:206\n1477#2:208\n1502#2,3:209\n1505#2,3:219\n288#2,2:223\n533#2,6:225\n372#3,7:212\n1#4:222\n*S KotlinDebug\n*F\n+ 1 StartupTimingQuery.kt\nandroidx/benchmark/macro/perfetto/StartupTimingQuery\n*L\n100#1:201,2\n103#1:203,2\n123#1:205\n123#1:206,2\n124#1:208\n124#1:209,3\n124#1:219,3\n151#1:223,2\n158#1:225,6\n124#1:212,7\n*E\n"})
public final class StartupTimingQuery {
    @NotNull
    public static final StartupTimingQuery INSTANCE = new StartupTimingQuery();

    private StartupTimingQuery() {
    }

    @Language(value="sql")
    private final String getFullQuery(String targetPackageName) {
        return StringsKt.trimIndent((String)("\n        ------ Select all startup-relevant slices from slice table\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN thread_track on slice.track_id = thread_track.id\n            INNER JOIN thread USING(utid)\n            INNER JOIN process USING(upid)\n        WHERE (\n                " + PerfettoTraceProcessorKt.processNameLikePkg(targetPackageName) + " AND (\n                    (slice.name LIKE \"activityResume\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"Choreographer#doFrame%\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"reportFullyDrawn() for %\" AND process.pid LIKE thread.tid) OR\n                    (slice.name LIKE \"DrawFrame%\" AND thread.name LIKE \"RenderThread\")\n            ) OR\n            (\n                -- Signals beginning of launch event, only present in API 29+\n                process.name LIKE \"system_server\" AND\n                slice.name LIKE \"MetricsLogger:launchObserverNotifyIntentStarted\"\n            )\n        )\n        ------ Add in async slices\n        UNION\n        SELECT\n            slice.name as name,\n            slice.ts as ts,\n            slice.dur as dur\n        FROM slice\n            INNER JOIN process_track on slice.track_id = process_track.id\n            INNER JOIN process USING(upid)\n        WHERE (\n            -- API 23+:   \"launching: <target>\"\n            -- API 19-22: \"launching\"\n            slice.name LIKE \"launching%\" AND process.name LIKE \"system_server\"\n        )\n        ORDER BY ts ASC\n    "));
    }

    private final long findEndRenderTimeForUiFrame(List<Slice> uiSlices, List<Slice> rtSlices, Function1<? super Slice, Boolean> predicate) {
        Object element$iv3;
        block3: {
            Object element$iv22;
            block2: {
                Iterable $this$first$iv = uiSlices;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    if (!((Boolean)predicate.invoke(element$iv22)).booleanValue()) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Slice uiSlice = (Slice)element$iv22;
            Iterable $this$first$iv = rtSlices;
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                Slice rtSlice = (Slice)element$iv3;
                boolean bl = false;
                if (!(rtSlice.getTs() > uiSlice.getTs())) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Slice rtSlice = (Slice)element$iv3;
        return rtSlice.getEndTs();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SubMetrics getFrameSubMetrics(@NotNull PerfettoTraceProcessor.Session session, int captureApiLevel, @NotNull String targetPackageName, @NotNull StartupMode startupMode) {
        Long l;
        Slice reportFullyDrawnSlice;
        long initialDisplayTs;
        long startTs;
        List rtSlices;
        List uiSlices;
        Object groupedData;
        block39: {
            block32: {
                long l2;
                Object launchingSlice;
                block38: {
                    block35: {
                        Object object;
                        block37: {
                            block36: {
                                Object v7;
                                block31: {
                                    Object object2;
                                    block34: {
                                        block33: {
                                            Object v5;
                                            block30: {
                                                Object $this$groupByTo$iv$iv;
                                                void $this$groupBy$iv;
                                                Slice it;
                                                void $this$filterTo$iv$iv;
                                                Iterable $this$filter$iv;
                                                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                                                Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
                                                Intrinsics.checkNotNullParameter((Object)((Object)startupMode), (String)"startupMode");
                                                Sequence<Row> queryResultIterator = session.query(this.getFullQuery(targetPackageName));
                                                List<Slice> slices = SliceKt.toSlices(queryResultIterator);
                                                Iterable iterable = slices;
                                                boolean $i$f$filter = false;
                                                void var10_10 = $this$filter$iv;
                                                Object destination$iv$iv = new ArrayList();
                                                boolean $i$f$filterTo = false;
                                                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                    it = (Slice)element$iv$iv;
                                                    boolean bl = false;
                                                    if (!(it.getDur() > 0L)) continue;
                                                    destination$iv$iv.add(element$iv$iv);
                                                }
                                                $this$filter$iv = (List)destination$iv$iv;
                                                boolean $i$f$groupBy22 = false;
                                                $this$filterTo$iv$iv = $this$groupBy$iv;
                                                destination$iv$iv = new LinkedHashMap();
                                                boolean $i$f$groupByTo = false;
                                                Iterator iterator = $this$groupByTo$iv$iv.iterator();
                                                while (iterator.hasNext()) {
                                                    Object object3;
                                                    StartupSliceType startupSliceType;
                                                    Object element$iv$iv;
                                                    element$iv$iv = iterator.next();
                                                    it = (Slice)element$iv$iv;
                                                    boolean bl = false;
                                                    if (StringsKt.startsWith$default((String)it.getName(), (String)"Choreographer#doFrame", (boolean)false, (int)2, null)) {
                                                        startupSliceType = StartupSliceType.FrameUiThread;
                                                    } else if (StringsKt.startsWith$default((String)it.getName(), (String)"DrawFrame", (boolean)false, (int)2, null)) {
                                                        startupSliceType = StartupSliceType.FrameRenderThread;
                                                    } else if (StringsKt.startsWith$default((String)it.getName(), (String)"launching", (boolean)false, (int)2, null)) {
                                                        startupSliceType = StartupSliceType.Launching;
                                                    } else if (StringsKt.startsWith$default((String)it.getName(), (String)"reportFullyDrawn", (boolean)false, (int)2, null)) {
                                                        startupSliceType = StartupSliceType.ReportFullyDrawn;
                                                    } else if (Intrinsics.areEqual((Object)it.getName(), (Object)"MetricsLogger:launchObserverNotifyIntentStarted")) {
                                                        startupSliceType = StartupSliceType.NotifyStarted;
                                                    } else if (Intrinsics.areEqual((Object)it.getName(), (Object)"activityResume")) {
                                                        startupSliceType = StartupSliceType.ActivityResume;
                                                    } else {
                                                        throw new IllegalStateException("Unexpected slice " + it);
                                                    }
                                                    StartupSliceType key$iv$iv = startupSliceType;
                                                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                                    boolean $i$f$getOrPut = false;
                                                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                                                    if (value$iv$iv$iv == null) {
                                                        boolean bl2 = false;
                                                        List answer$iv$iv$iv = new ArrayList();
                                                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                                        object3 = answer$iv$iv$iv;
                                                    } else {
                                                        object3 = value$iv$iv$iv;
                                                    }
                                                    List list$iv$iv = (List)object3;
                                                    list$iv$iv.add(element$iv$iv);
                                                }
                                                groupedData = destination$iv$iv;
                                                Object $i$f$groupBy22 = groupedData;
                                                Object object4 = $i$f$groupBy22.get((Object)StartupSliceType.FrameUiThread);
                                                if (object4 == null) {
                                                    boolean bl = false;
                                                    object4 = CollectionsKt.emptyList();
                                                }
                                                uiSlices = (List)object4;
                                                $this$groupByTo$iv$iv = groupedData;
                                                Object object5 = $this$groupByTo$iv$iv.get((Object)StartupSliceType.FrameRenderThread);
                                                if (object5 == null) {
                                                    boolean bl = false;
                                                    object5 = CollectionsKt.emptyList();
                                                }
                                                rtSlices = (List)object5;
                                                if (uiSlices.isEmpty() || rtSlices.isEmpty()) {
                                                    Log.d((String)"Benchmark", (String)"No UI / RT slices seen, not reporting startup.");
                                                    return null;
                                                }
                                                startTs = 0L;
                                                initialDisplayTs = 0L;
                                                if (captureApiLevel < 29 && startupMode == StartupMode.HOT) break block32;
                                                object2 = (List)groupedData.get((Object)StartupSliceType.Launching);
                                                if (object2 == null) break block33;
                                                Iterable $this$firstOrNull$iv = (Iterable)object2;
                                                boolean $i$f$firstOrNull = false;
                                                for (Object element$iv : $this$firstOrNull$iv) {
                                                    Slice it2 = (Slice)element$iv;
                                                    boolean bl = false;
                                                    if (!(captureApiLevel < 23 || Intrinsics.areEqual((Object)it2.getName(), (Object)("launching: " + targetPackageName)))) continue;
                                                    v5 = element$iv;
                                                    break block30;
                                                }
                                                v5 = null;
                                            }
                                            if ((object2 = (Slice)v5) != null) break block34;
                                        }
                                        return null;
                                    }
                                    launchingSlice = object2;
                                    if (captureApiLevel < 29) break block35;
                                    object = (List)groupedData.get((Object)StartupSliceType.NotifyStarted);
                                    if (object == null) break block36;
                                    List $this$lastOrNull$iv = object;
                                    boolean $i$f$lastOrNull = false;
                                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                                    while (iterator$iv.hasPrevious()) {
                                        Object element$iv = iterator$iv.previous();
                                        Slice it = (Slice)element$iv;
                                        boolean bl = false;
                                        if (!(it.getTs() < ((Slice)launchingSlice).getTs())) continue;
                                        v7 = element$iv;
                                        break block31;
                                    }
                                    v7 = null;
                                }
                                if ((object = (Slice)v7) != null) break block37;
                            }
                            return null;
                        }
                        Object notifyStartedSlice = object;
                        l2 = ((Slice)notifyStartedSlice).getTs();
                        break block38;
                    }
                    l2 = ((Slice)launchingSlice).getTs();
                }
                startTs = l2;
                initialDisplayTs = this.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>((Slice)launchingSlice){
                    final /* synthetic */ Slice $launchingSlice;
                    {
                        this.$launchingSlice = $launchingSlice;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Slice uiSlice) {
                        Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                        return uiSlice.getTs() > this.$launchingSlice.getTs();
                    }
                }));
                break block39;
            }
            Object object = (List)groupedData.get((Object)StartupSliceType.ActivityResume);
            if (object == null || (object = (Slice)CollectionsKt.first((List)object)) == null) {
                return null;
            }
            startTs = ((Slice)object).getTs();
            initialDisplayTs = this.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>(startTs){
                final /* synthetic */ long $startTs;
                {
                    this.$startTs = $startTs;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Slice uiSlice) {
                    Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                    return uiSlice.getTs() > this.$startTs;
                }
            }));
        }
        List list = (List)groupedData.get((Object)StartupSliceType.ReportFullyDrawn);
        Slice slice = reportFullyDrawnSlice = list != null ? (Slice)CollectionsKt.firstOrNull((List)list) : null;
        if (slice != null) {
            Slice it = slice;
            boolean bl = false;
            l = INSTANCE.findEndRenderTimeForUiFrame(uiSlices, rtSlices, (Function1<? super Slice, Boolean>)((Function1)new Function1<Slice, Boolean>(reportFullyDrawnSlice){
                final /* synthetic */ Slice $reportFullyDrawnSlice;
                {
                    this.$reportFullyDrawnSlice = $reportFullyDrawnSlice;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Slice uiSlice) {
                    Intrinsics.checkNotNullParameter((Object)uiSlice, (String)"uiSlice");
                    return uiSlice.getEndTs() > this.$reportFullyDrawnSlice.getTs();
                }
            }));
        } else {
            l = null;
        }
        Long reportFullyDrawnEndTs2 = l;
        return new SubMetrics(startTs, initialDisplayTs, reportFullyDrawnEndTs2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery$StartupSliceType;", "", "(Ljava/lang/String;I)V", "NotifyStarted", "Launching", "ReportFullyDrawn", "FrameUiThread", "FrameRenderThread", "ActivityResume", "benchmark-macro_release"})
    public static final class StartupSliceType
    extends Enum<StartupSliceType> {
        public static final /* enum */ StartupSliceType NotifyStarted = new StartupSliceType();
        public static final /* enum */ StartupSliceType Launching = new StartupSliceType();
        public static final /* enum */ StartupSliceType ReportFullyDrawn = new StartupSliceType();
        public static final /* enum */ StartupSliceType FrameUiThread = new StartupSliceType();
        public static final /* enum */ StartupSliceType FrameRenderThread = new StartupSliceType();
        public static final /* enum */ StartupSliceType ActivityResume = new StartupSliceType();
        private static final /* synthetic */ StartupSliceType[] $VALUES;

        public static StartupSliceType[] values() {
            return (StartupSliceType[])$VALUES.clone();
        }

        public static StartupSliceType valueOf(String value) {
            return Enum.valueOf(StartupSliceType.class, value);
        }

        static {
            $VALUES = startupSliceTypeArray = new StartupSliceType[]{StartupSliceType.NotifyStarted, StartupSliceType.Launching, StartupSliceType.ReportFullyDrawn, StartupSliceType.FrameUiThread, StartupSliceType.FrameRenderThread, StartupSliceType.ActivityResume};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J.\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "", "startTs", "", "initialDisplayTs", "fullDisplayTs", "(JJLjava/lang/Long;)V", "timeToInitialDisplayNs", "timeToFullDisplayNs", "timelineRangeNs", "Lkotlin/ranges/LongRange;", "(JLjava/lang/Long;Lkotlin/ranges/LongRange;)V", "getTimeToFullDisplayNs", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getTimeToInitialDisplayNs", "()J", "getTimelineRangeNs", "()Lkotlin/ranges/LongRange;", "component1", "component2", "component3", "copy", "(JLjava/lang/Long;Lkotlin/ranges/LongRange;)Landroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics;", "equals", "", "other", "hashCode", "", "toString", "", "benchmark-macro_release"})
    @SourceDebugExtension(value={"SMAP\nStartupTimingQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupTimingQuery.kt\nandroidx/benchmark/macro/perfetto/StartupTimingQuery$SubMetrics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
    public static final class SubMetrics {
        private final long timeToInitialDisplayNs;
        @Nullable
        private final Long timeToFullDisplayNs;
        @NotNull
        private final LongRange timelineRangeNs;

        public SubMetrics(long timeToInitialDisplayNs, @Nullable Long timeToFullDisplayNs, @NotNull LongRange timelineRangeNs) {
            Intrinsics.checkNotNullParameter((Object)timelineRangeNs, (String)"timelineRangeNs");
            this.timeToInitialDisplayNs = timeToInitialDisplayNs;
            this.timeToFullDisplayNs = timeToFullDisplayNs;
            this.timelineRangeNs = timelineRangeNs;
        }

        public final long getTimeToInitialDisplayNs() {
            return this.timeToInitialDisplayNs;
        }

        @Nullable
        public final Long getTimeToFullDisplayNs() {
            return this.timeToFullDisplayNs;
        }

        @NotNull
        public final LongRange getTimelineRangeNs() {
            return this.timelineRangeNs;
        }

        /*
         * WARNING - void declaration
         */
        public SubMetrics(long startTs, long initialDisplayTs, @Nullable Long fullDisplayTs) {
            Long l;
            SubMetrics subMetrics = this;
            long l2 = initialDisplayTs - startTs;
            Long l3 = fullDisplayTs;
            if (l3 != null) {
                void it;
                long l4 = ((Number)l3).longValue();
                long l5 = l2;
                SubMetrics subMetrics2 = subMetrics;
                boolean bl = false;
                Long l6 = (long)(it - startTs);
                subMetrics = subMetrics2;
                l2 = l5;
                l = l6;
            } else {
                l = null;
            }
            Long l7 = fullDisplayTs;
            subMetrics(l2, l, new LongRange(startTs, l7 != null ? l7 : initialDisplayTs));
        }

        public final long component1() {
            return this.timeToInitialDisplayNs;
        }

        @Nullable
        public final Long component2() {
            return this.timeToFullDisplayNs;
        }

        @NotNull
        public final LongRange component3() {
            return this.timelineRangeNs;
        }

        @NotNull
        public final SubMetrics copy(long timeToInitialDisplayNs, @Nullable Long timeToFullDisplayNs, @NotNull LongRange timelineRangeNs) {
            Intrinsics.checkNotNullParameter((Object)timelineRangeNs, (String)"timelineRangeNs");
            return new SubMetrics(timeToInitialDisplayNs, timeToFullDisplayNs, timelineRangeNs);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, long l, Long l2, LongRange longRange, int n, Object object) {
            if ((n & 1) != 0) {
                l = subMetrics.timeToInitialDisplayNs;
            }
            if ((n & 2) != 0) {
                l2 = subMetrics.timeToFullDisplayNs;
            }
            if ((n & 4) != 0) {
                longRange = subMetrics.timelineRangeNs;
            }
            return subMetrics.copy(l, l2, longRange);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(timeToInitialDisplayNs=" + this.timeToInitialDisplayNs + ", timeToFullDisplayNs=" + this.timeToFullDisplayNs + ", timelineRangeNs=" + this.timelineRangeNs + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.timeToInitialDisplayNs);
            result = result * 31 + (this.timeToFullDisplayNs == null ? 0 : ((Object)this.timeToFullDisplayNs).hashCode());
            result = result * 31 + this.timelineRangeNs.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (this.timeToInitialDisplayNs != subMetrics.timeToInitialDisplayNs) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeToFullDisplayNs, (Object)subMetrics.timeToFullDisplayNs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timelineRangeNs, (Object)subMetrics.timelineRangeNs);
        }
    }
}

