/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto.server;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Shell;
import androidx.benchmark.ShellScript;
import androidx.benchmark.StartedShellScript;
import androidx.benchmark.macro.perfetto.server.Api24Impl;
import androidx.benchmark.macro.perfetto.server.PerfettoHttpServer;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.AppendTraceDataResult;
import perfetto.protos.ComputeMetricArgs;
import perfetto.protos.ComputeMetricResult;
import perfetto.protos.QueryArgs;
import perfetto.protos.StatusResult;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJW\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\n2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u001e\u001a\u00020\u0017J-\u0010\u001f\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010 \u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u0015J\u001a\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020\u0015R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"Landroidx/benchmark/macro/perfetto/server/PerfettoHttpServer;", "", "()V", "processId", "", "Ljava/lang/Integer;", "computeMetric", "Lperfetto/protos/ComputeMetricResult;", "metrics", "", "", "resultFormat", "Lperfetto/protos/ComputeMetricArgs$ResultFormat;", "httpRequest", "T", "method", "url", "contentType", "encodeBlock", "Lkotlin/Function1;", "Ljava/io/OutputStream;", "", "decodeBlock", "Ljava/io/InputStream;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isRunning", "", "notifyEof", "parse", "Lperfetto/protos/AppendTraceDataResult;", "inputStream", "rawQuery", "sqlQuery", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "restoreInitialTables", "startServer", "timeout", "Lkotlin/time/Duration;", "startServer-LRDsOJo", "(J)V", "status", "Lperfetto/protos/StatusResult;", "stopServer", "Companion", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nPerfettoHttpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoHttpServer.kt\nandroidx/benchmark/macro/perfetto/server/PerfettoHttpServer\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n141#2,3:321\n145#2,2:327\n141#2,6:329\n141#2,6:335\n123#3,2:324\n1#4:326\n*S KotlinDebug\n*F\n+ 1 PerfettoHttpServer.kt\nandroidx/benchmark/macro/perfetto/server/PerfettoHttpServer\n*L\n109#1:321,3\n109#1:327,2\n176#1:329,6\n188#1:335,6\n134#1:324,2\n*E\n"})
public final class PerfettoHttpServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer processId;
    @NotNull
    private static final String HTTP_ADDRESS = "http://localhost";
    @NotNull
    private static final String METHOD_GET = "GET";
    @NotNull
    private static final String METHOD_POST = "POST";
    @NotNull
    private static final String PATH_QUERY = "/query";
    @NotNull
    private static final String PATH_COMPUTE_METRIC = "/compute_metric";
    @NotNull
    private static final String PATH_PARSE = "/parse";
    @NotNull
    private static final String PATH_NOTIFY_EOF = "/notify_eof";
    @NotNull
    private static final String PATH_STATUS = "/status";
    @NotNull
    private static final String PATH_RESTORE_INITIAL_TABLES = "/restore_initial_tables";
    @NotNull
    private static final String TAG = "PerfettoHttpServer";
    @NotNull
    private static final String SERVER_PROCESS_NAME = "trace_processor_shell";
    private static final long WAIT_INTERVAL = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MILLISECONDS);
    private static final long READ_TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    private static final int PARSE_PAYLOAD_SIZE = 0x1000000;
    @Nullable
    private static ShellScript shellScript;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"BanThreadSleep"})
    public final void startServer-LRDsOJo(long timeout) {
        String label$iv = "PerfettoHttpServer#startServer";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (this.processId != null) {
                Log.w((String)TAG, (String)"Tried to start a trace shell processor that is already running.");
            } else {
                Object element$iv2;
                String[] stringArray;
                StartedShellScript shellScript;
                block11: {
                    void $this$first$iv;
                    if (Build.VERSION.SDK_INT >= 24 && !Api24Impl.INSTANCE.isCleartextTrafficPermittedForLocalhost()) {
                        throw new IOException("Macrobenchmark requires cleartext HTTP traffic to the on-device localhost to enable\nquerying data from perfetto traces, such as timestamps that are used to calculate\nmetrics. This should be enabled by default via manifest merging when building with\nGradle.  Please refer to\nhttps://d.android.com/training/articles/security-config#CleartextTrafficPermitted\nand enable cleartext http requests towards localhost in your test android manifest.");
                    }
                    shellScript = Companion.getOrCreateShellScript().start();
                    stringArray = shellScript.stdOutLineSequence();
                    PerfettoHttpServer perfettoHttpServer = this;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        String it = (String)element$iv2;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"pid:", (boolean)false, (int)2, null)) continue;
                        break block11;
                    }
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                stringArray = new String[]{"pid:"};
                perfettoHttpServer.processId = Integer.parseInt((String)StringsKt.split$default((CharSequence)((CharSequence)element$iv2), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
                long elapsed = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MILLISECONDS);
                while (!this.isRunning()) {
                    boolean processRunning;
                    boolean bl3;
                    Thread.sleep(Duration.toLong-impl((long)WAIT_INTERVAL, (DurationUnit)DurationUnit.MILLISECONDS));
                    if (Duration.compareTo-LRDsOJo((long)(elapsed = Duration.plus-LRDsOJo((long)elapsed, (long)WAIT_INTERVAL)), (long)timeout) < 0) continue;
                    Integer n = this.processId;
                    if (n != null) {
                        int it = ((Number)n).intValue();
                        boolean bl4 = false;
                        bl3 = Shell.INSTANCE.isProcessAlive(it, SERVER_PROCESS_NAME);
                    } else {
                        bl3 = processRunning = false;
                    }
                    if (processRunning) {
                        throw new IllegalStateException("The instrumentation app cannot connect to the trace_processor_shell server.");
                    }
                    throw new IllegalStateException(StringsKt.trimIndent((String)("\n                        Perfetto trace_processor_shell did not start correctly.\n                        Process stderr:\n                        " + shellScript.getOutputAndClose().getStderr() + "\n                        ")));
                }
                Log.i((String)TAG, (String)("Perfetto trace processor shell server started (pid=" + this.processId + ")."));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopServer() {
        String label$iv = "PerfettoHttpServer#stopServer";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl = false;
            if (this.processId == null) {
                Log.w((String)TAG, (String)"Tried to stop trace shell processor http server without starting it.");
            } else {
                Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("kill -TERM " + this.processId), null, (int)2, null);
                Log.i((String)TAG, (String)("Perfetto trace processor shell server stopped (pid=" + this.processId + ")."));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        boolean bl;
        String label$iv = "PerfettoHttpServer#isRunning";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, (int)2, null);
        try {
            boolean bl2;
            block6: {
                boolean bl3;
                boolean bl4 = false;
                try {
                    StatusResult statusResult = this.status();
                    bl2 = statusResult.getApi_version() != null && statusResult.getApi_version() > 0;
                    break block6;
                }
                catch (ConnectException e) {
                    bl3 = false;
                }
                catch (FileNotFoundException e) {
                    bl3 = false;
                }
                bl2 = bl3;
            }
            bl = bl2;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
        return bl;
    }

    public final <T> T rawQuery(@NotNull String sqlQuery, @NotNull Function1<? super InputStream, ? extends T> decodeBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlQuery, (String)"sqlQuery");
        Intrinsics.checkNotNullParameter(decodeBlock, (String)"decodeBlock");
        return (T)PerfettoHttpServer.httpRequest$default(this, METHOD_POST, PATH_QUERY, null, (Function1)new Function1<OutputStream, Unit>(sqlQuery){
            final /* synthetic */ String $sqlQuery;
            {
                this.$sqlQuery = $sqlQuery;
                super(1);
            }

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                QueryArgs.ADAPTER.encode(it, (Object)((Object)new QueryArgs(this.$sqlQuery, null, null, 6, null)));
            }
        }, decodeBlock, 4, null);
    }

    @NotNull
    public final ComputeMetricResult computeMetric(@NotNull List<String> metrics, @NotNull ComputeMetricArgs.ResultFormat resultFormat) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)((Object)resultFormat), (String)"resultFormat");
        return (ComputeMetricResult)((Object)PerfettoHttpServer.httpRequest$default(this, METHOD_POST, PATH_COMPUTE_METRIC, null, (Function1)new Function1<OutputStream, Unit>(metrics, resultFormat){
            final /* synthetic */ List<String> $metrics;
            final /* synthetic */ ComputeMetricArgs.ResultFormat $resultFormat;
            {
                this.$metrics = $metrics;
                this.$resultFormat = $resultFormat;
                super(1);
            }

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ComputeMetricArgs.ADAPTER.encode(it, (Object)((Object)new ComputeMetricArgs(this.$metrics, this.$resultFormat, null, 4, null)));
            }
        }, computeMetric.2.INSTANCE, 4, null));
    }

    @NotNull
    public final List<AppendTraceDataResult> parse(@NotNull InputStream inputStream) {
        byte[] buffer;
        int read;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        List responses = new ArrayList();
        while ((read = inputStream.read(buffer = new byte[0x1000000])) > 0) {
            responses.add(PerfettoHttpServer.httpRequest$default(this, METHOD_POST, PATH_PARSE, null, (Function1)new Function1<OutputStream, Unit>(buffer, read){
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ int $read;
                {
                    this.$buffer = $buffer;
                    this.$read = $read;
                    super(1);
                }

                public final void invoke(@NotNull OutputStream it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.write(this.$buffer, 0, this.$read);
                }
            }, parse.2.INSTANCE, 4, null));
        }
        return responses;
    }

    public final void notifyEof() {
        PerfettoHttpServer.httpRequest$default(this, METHOD_GET, PATH_NOTIFY_EOF, null, null, notifyEof.1.INSTANCE, 4, null);
    }

    public final void restoreInitialTables() {
        PerfettoHttpServer.httpRequest$default(this, METHOD_GET, PATH_RESTORE_INITIAL_TABLES, null, null, restoreInitialTables.1.INSTANCE, 4, null);
    }

    private final StatusResult status() {
        return (StatusResult)((Object)PerfettoHttpServer.httpRequest$default(this, METHOD_GET, PATH_STATUS, null, null, status.1.INSTANCE, 4, null));
    }

    private final <T> T httpRequest(String method, String url, String contentType, Function1<? super OutputStream, Unit> encodeBlock, Function1<? super InputStream, ? extends T> decodeBlock) {
        URLConnection uRLConnection = new URL("http://localhost:9001" + url).openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$httpRequest_u24lambda_u245 = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        $this$httpRequest_u24lambda_u245.setRequestMethod(method);
        $this$httpRequest_u24lambda_u245.setReadTimeout(Duration.toInt-impl((long)READ_TIMEOUT, (DurationUnit)DurationUnit.MILLISECONDS));
        $this$httpRequest_u24lambda_u245.setRequestProperty("Content-Type", contentType);
        if (encodeBlock != null) {
            $this$httpRequest_u24lambda_u245.setDoOutput(true);
            OutputStream outputStream = $this$httpRequest_u24lambda_u245.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
            encodeBlock.invoke((Object)outputStream);
            $this$httpRequest_u24lambda_u245.getOutputStream().close();
        }
        InputStream inputStream = $this$httpRequest_u24lambda_u245.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        Object value = decodeBlock.invoke((Object)inputStream);
        if ($this$httpRequest_u24lambda_u245.getResponseCode() != 200) {
            throw new IllegalStateException($this$httpRequest_u24lambda_u245.getResponseMessage());
        }
        return (T)value;
    }

    static /* synthetic */ Object httpRequest$default(PerfettoHttpServer perfettoHttpServer, String string, String string2, String string3, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "application/octet-stream";
        }
        return perfettoHttpServer.httpRequest(string, string2, string3, (Function1<? super OutputStream, Unit>)function1, function12);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Landroidx/benchmark/macro/perfetto/server/PerfettoHttpServer$Companion;", "", "()V", "HTTP_ADDRESS", "", "METHOD_GET", "METHOD_POST", "PARSE_PAYLOAD_SIZE", "", "PATH_COMPUTE_METRIC", "PATH_NOTIFY_EOF", "PATH_PARSE", "PATH_QUERY", "PATH_RESTORE_INITIAL_TABLES", "PATH_STATUS", "READ_TIMEOUT", "Lkotlin/time/Duration;", "J", "SERVER_PROCESS_NAME", "TAG", "WAIT_INTERVAL", "shellScript", "Landroidx/benchmark/ShellScript;", "cleanUpShellScript", "", "getOrCreateShellScript", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final ShellScript getOrCreateShellScript() {
            ShellScript shellScript = shellScript;
            if (shellScript == null) {
                Companion companion = this;
                synchronized (companion) {
                    ShellScript shellScript2;
                    boolean bl = false;
                    ShellScript instance = shellScript;
                    if (instance != null) {
                        shellScript2 = instance;
                    } else {
                        void var3_5;
                        String script = "echo pid:$$ ; exec " + PerfettoTraceProcessor.Companion.getShellPath$benchmark_macro_release() + " -D --http-port \"9001\" ";
                        instance = Shell.createShellScript$default((Shell)Shell.INSTANCE, (String)script, null, (int)2, null);
                        PerfettoHttpServer.shellScript = instance;
                        shellScript2 = var3_5;
                    }
                    ShellScript shellScript3 = shellScript2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var1_1
                    shellScript = shellScript3;
                }
            }
            return shellScript;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cleanUpShellScript() {
            Companion companion = this;
            synchronized (companion) {
                boolean bl = false;
                ShellScript shellScript = shellScript;
                if (shellScript != null) {
                    shellScript.cleanUp();
                }
                PerfettoHttpServer.shellScript = null;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

