/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import androidx.benchmark.macro.ExperimentalMetricApi;
import androidx.benchmark.macro.Metric;
import androidx.benchmark.macro.TraceMetric;
import androidx.benchmark.macro.perfetto.MemoryCountersQuery;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Landroidx/benchmark/macro/MemoryCountersMetric;", "Landroidx/benchmark/macro/TraceMetric;", "()V", "getMeasurements", "", "Landroidx/benchmark/macro/Metric$Measurement;", "captureInfo", "Landroidx/benchmark/macro/Metric$CaptureInfo;", "traceSession", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "benchmark-macro_release"})
@ExperimentalMetricApi
public final class MemoryCountersMetric
extends TraceMetric {
    @Override
    @NotNull
    public List<Metric.Measurement> getMeasurements(@NotNull Metric.CaptureInfo captureInfo, @NotNull PerfettoTraceProcessor.Session traceSession) {
        Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
        Intrinsics.checkNotNullParameter((Object)traceSession, (String)"traceSession");
        MemoryCountersQuery.SubMetrics subMetrics = MemoryCountersQuery.INSTANCE.getMemoryCounters(traceSession, captureInfo.getTargetPackageName());
        if (subMetrics == null) {
            return CollectionsKt.emptyList();
        }
        MemoryCountersQuery.SubMetrics metrics = subMetrics;
        Object[] objectArray = new Metric.Measurement[]{new Metric.Measurement("minorPageFaults", metrics.getMinorPageFaults()), new Metric.Measurement("majorPageFaults", metrics.getMajorPageFaults()), new Metric.Measurement("pageFaultsBackedBySwapCache", metrics.getPageFaultsBackedBySwapCache()), new Metric.Measurement("pageFaultsBackedByReadIO", metrics.getPageFaultsBackedByReadIO()), new Metric.Measurement("memoryCompactionEvents", metrics.getMemoryCompactionEvents()), new Metric.Measurement("memoryReclaimEvents", metrics.getMemoryReclaimEvents())};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

