/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro.perfetto;

import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.benchmark.perfetto.PerfettoTraceProcessorKt;
import androidx.benchmark.perfetto.Row;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/benchmark/macro/perfetto/MemoryCountersQuery;", "", "()V", "MAJOR_PAGE_FAULTS_COUNT", "", "MEMORY_COMPACTION_EVENTS_COUNT", "MEMORY_RECLAIM_EVENTS_COUNT", "MINOR_PAGE_FAULTS_COUNT", "PAGE_FAULTS_BACKED_BY_READ_IO_COUNT", "PAGE_FAULTS_BACKED_BY_SWAP_CACHE_COUNT", "getMemoryCounters", "Landroidx/benchmark/macro/perfetto/MemoryCountersQuery$SubMetrics;", "session", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "targetPackageName", "getQuery", "getQuery$benchmark_macro_release", "SubMetrics", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nMemoryCountersQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCountersQuery.kt\nandroidx/benchmark/macro/perfetto/MemoryCountersQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1179#2,2:89\n1253#2,4:91\n*S KotlinDebug\n*F\n+ 1 MemoryCountersQuery.kt\nandroidx/benchmark/macro/perfetto/MemoryCountersQuery\n*L\n75#1:89,2\n75#1:91,4\n*E\n"})
public final class MemoryCountersQuery {
    @NotNull
    public static final MemoryCountersQuery INSTANCE = new MemoryCountersQuery();
    @NotNull
    private static final String MINOR_PAGE_FAULTS_COUNT = "mem.mm.min_flt.count";
    @NotNull
    private static final String MAJOR_PAGE_FAULTS_COUNT = "mem.mm.maj_flt.count";
    @NotNull
    private static final String PAGE_FAULTS_BACKED_BY_SWAP_CACHE_COUNT = "mem.mm.swp_flt.count";
    @NotNull
    private static final String PAGE_FAULTS_BACKED_BY_READ_IO_COUNT = "mem.mm.read_io.count";
    @NotNull
    private static final String MEMORY_COMPACTION_EVENTS_COUNT = "mem.mm.compaction.count";
    @NotNull
    private static final String MEMORY_RECLAIM_EVENTS_COUNT = "mem.mm.reclaim.count";

    private MemoryCountersQuery() {
    }

    @Language(value="sql")
    @NotNull
    public final String getQuery$benchmark_macro_release(@NotNull String targetPackageName) {
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        return StringsKt.trimIndent((String)("\n        SELECT\n            track.name as counter_name,\n            SUM(value)\n        FROM counter\n            LEFT JOIN process_counter_track as track on counter.track_id = track.id\n            LEFT JOIN process using (upid)\n        WHERE\n            " + PerfettoTraceProcessorKt.processNameLikePkg(targetPackageName) + " AND\n            track.name LIKE 'mem.%.count'\n        GROUP BY counter_name\n    "));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SubMetrics getMemoryCounters(@NotNull PerfettoTraceProcessor.Session session, @NotNull String targetPackageName) {
        SubMetrics subMetrics;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        Sequence<Row> queryResultIterator = session.query(this.getQuery$benchmark_macro_release(targetPackageName));
        List rows = SequencesKt.toList(queryResultIterator);
        if (rows.isEmpty()) {
            subMetrics = null;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = rows;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Row it = (Row)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.string("counter_name"), (Object)it.double("SUM(value)"));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map summations = destination$iv$iv;
            Double d = (Double)summations.get(MINOR_PAGE_FAULTS_COUNT);
            Double d2 = (Double)summations.get(MAJOR_PAGE_FAULTS_COUNT);
            Double d3 = (Double)summations.get(PAGE_FAULTS_BACKED_BY_SWAP_CACHE_COUNT);
            Double d4 = (Double)summations.get(PAGE_FAULTS_BACKED_BY_READ_IO_COUNT);
            Double d5 = (Double)summations.get(MEMORY_COMPACTION_EVENTS_COUNT);
            Double d6 = (Double)summations.get(MEMORY_RECLAIM_EVENTS_COUNT);
            subMetrics = new SubMetrics(d != null ? d : 0.0, d2 != null ? d2 : 0.0, d3 != null ? d3 : 0.0, d4 != null ? d4 : 0.0, d5 != null ? d5 : 0.0, d6 != null ? d6 : 0.0);
        }
        return subMetrics;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Landroidx/benchmark/macro/perfetto/MemoryCountersQuery$SubMetrics;", "", "minorPageFaults", "", "majorPageFaults", "pageFaultsBackedBySwapCache", "pageFaultsBackedByReadIO", "memoryCompactionEvents", "memoryReclaimEvents", "(DDDDDD)V", "getMajorPageFaults", "()D", "getMemoryCompactionEvents", "getMemoryReclaimEvents", "getMinorPageFaults", "getPageFaultsBackedByReadIO", "getPageFaultsBackedBySwapCache", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "benchmark-macro_release"})
    public static final class SubMetrics {
        private final double minorPageFaults;
        private final double majorPageFaults;
        private final double pageFaultsBackedBySwapCache;
        private final double pageFaultsBackedByReadIO;
        private final double memoryCompactionEvents;
        private final double memoryReclaimEvents;

        public SubMetrics(double minorPageFaults, double majorPageFaults, double pageFaultsBackedBySwapCache, double pageFaultsBackedByReadIO, double memoryCompactionEvents, double memoryReclaimEvents) {
            this.minorPageFaults = minorPageFaults;
            this.majorPageFaults = majorPageFaults;
            this.pageFaultsBackedBySwapCache = pageFaultsBackedBySwapCache;
            this.pageFaultsBackedByReadIO = pageFaultsBackedByReadIO;
            this.memoryCompactionEvents = memoryCompactionEvents;
            this.memoryReclaimEvents = memoryReclaimEvents;
        }

        public final double getMinorPageFaults() {
            return this.minorPageFaults;
        }

        public final double getMajorPageFaults() {
            return this.majorPageFaults;
        }

        public final double getPageFaultsBackedBySwapCache() {
            return this.pageFaultsBackedBySwapCache;
        }

        public final double getPageFaultsBackedByReadIO() {
            return this.pageFaultsBackedByReadIO;
        }

        public final double getMemoryCompactionEvents() {
            return this.memoryCompactionEvents;
        }

        public final double getMemoryReclaimEvents() {
            return this.memoryReclaimEvents;
        }

        public final double component1() {
            return this.minorPageFaults;
        }

        public final double component2() {
            return this.majorPageFaults;
        }

        public final double component3() {
            return this.pageFaultsBackedBySwapCache;
        }

        public final double component4() {
            return this.pageFaultsBackedByReadIO;
        }

        public final double component5() {
            return this.memoryCompactionEvents;
        }

        public final double component6() {
            return this.memoryReclaimEvents;
        }

        @NotNull
        public final SubMetrics copy(double minorPageFaults, double majorPageFaults, double pageFaultsBackedBySwapCache, double pageFaultsBackedByReadIO, double memoryCompactionEvents, double memoryReclaimEvents) {
            return new SubMetrics(minorPageFaults, majorPageFaults, pageFaultsBackedBySwapCache, pageFaultsBackedByReadIO, memoryCompactionEvents, memoryReclaimEvents);
        }

        public static /* synthetic */ SubMetrics copy$default(SubMetrics subMetrics, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
            if ((n & 1) != 0) {
                d = subMetrics.minorPageFaults;
            }
            if ((n & 2) != 0) {
                d2 = subMetrics.majorPageFaults;
            }
            if ((n & 4) != 0) {
                d3 = subMetrics.pageFaultsBackedBySwapCache;
            }
            if ((n & 8) != 0) {
                d4 = subMetrics.pageFaultsBackedByReadIO;
            }
            if ((n & 0x10) != 0) {
                d5 = subMetrics.memoryCompactionEvents;
            }
            if ((n & 0x20) != 0) {
                d6 = subMetrics.memoryReclaimEvents;
            }
            return subMetrics.copy(d, d2, d3, d4, d5, d6);
        }

        @NotNull
        public String toString() {
            return "SubMetrics(minorPageFaults=" + this.minorPageFaults + ", majorPageFaults=" + this.majorPageFaults + ", pageFaultsBackedBySwapCache=" + this.pageFaultsBackedBySwapCache + ", pageFaultsBackedByReadIO=" + this.pageFaultsBackedByReadIO + ", memoryCompactionEvents=" + this.memoryCompactionEvents + ", memoryReclaimEvents=" + this.memoryReclaimEvents + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.minorPageFaults);
            result = result * 31 + Double.hashCode(this.majorPageFaults);
            result = result * 31 + Double.hashCode(this.pageFaultsBackedBySwapCache);
            result = result * 31 + Double.hashCode(this.pageFaultsBackedByReadIO);
            result = result * 31 + Double.hashCode(this.memoryCompactionEvents);
            result = result * 31 + Double.hashCode(this.memoryReclaimEvents);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubMetrics)) {
                return false;
            }
            SubMetrics subMetrics = (SubMetrics)other;
            if (Double.compare(this.minorPageFaults, subMetrics.minorPageFaults) != 0) {
                return false;
            }
            if (Double.compare(this.majorPageFaults, subMetrics.majorPageFaults) != 0) {
                return false;
            }
            if (Double.compare(this.pageFaultsBackedBySwapCache, subMetrics.pageFaultsBackedBySwapCache) != 0) {
                return false;
            }
            if (Double.compare(this.pageFaultsBackedByReadIO, subMetrics.pageFaultsBackedByReadIO) != 0) {
                return false;
            }
            if (Double.compare(this.memoryCompactionEvents, subMetrics.memoryCompactionEvents) != 0) {
                return false;
            }
            return Double.compare(this.memoryReclaimEvents, subMetrics.memoryReclaimEvents) == 0;
        }
    }
}

