/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import androidx.annotation.RestrictTo;
import androidx.benchmark.DeviceInfo;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/benchmark/macro/BatteryCharge;", "", "()V", "MIN_BATTERY_PERCENT", "", "hasMinimumCharge", "", "throwOnMissingMetrics", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class BatteryCharge {
    @NotNull
    public static final BatteryCharge INSTANCE = new BatteryCharge();
    private static final int MIN_BATTERY_PERCENT = 50;

    private BatteryCharge() {
    }

    public final boolean hasMinimumCharge(boolean throwOnMissingMetrics) {
        if (DeviceInfo.INSTANCE.getInitialBatteryPercent() >= 50) {
            return true;
        }
        if (throwOnMissingMetrics) {
            throw new AssertionError((Object)StringsKt.trimIndent((String)("\n                ERROR: Device has low battery (" + DeviceInfo.INSTANCE.getInitialBatteryPercent() + ")\n                When battery is low during a test that involves disconnecting the charge, devices\n                risk running out of power during the test. Wait for your battery to charge to at\n                least 50%.  Currently at " + DeviceInfo.INSTANCE.getInitialBatteryPercent() + "%.\n            ")));
        }
        return false;
    }

    public static /* synthetic */ boolean hasMinimumCharge$default(BatteryCharge batteryCharge, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return batteryCharge.hasMinimumCharge(bl);
    }
}

