/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.app.Instrumentation;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JankCollectionHelper {
    private static final String LOG_TAG = JankCollectionHelper.class.getSimpleName();
    @VisibleForTesting
    static final String GFXINFO_METRICS_PREFIX = "gfxinfo";
    @VisibleForTesting
    static final String GFXINFO_COMMAND_GET = "dumpsys gfxinfo %s";
    @VisibleForTesting
    static final String GFXINFO_COMMAND_RESET = "dumpsys gfxinfo %s reset";
    private static final String GFXINFO_OUTPUT_HEADER = "Graphics info for pid (\\d+) \\[(%s)\\]";
    private static final String MULTILINE_MATCHER = "[\\s\\S]*%s[\\s\\S]*";
    private final Set<String> mTrackedPackages = new HashSet<String>();
    private UiDevice mDevice;

    JankCollectionHelper() {
    }

    public boolean startCollecting() {
        if (this.mTrackedPackages.isEmpty()) {
            this.clearGfxInfo();
        } else {
            int exceptionCount = 0;
            Exception lastException = null;
            for (String pkg : this.mTrackedPackages) {
                try {
                    this.clearGfxInfo(pkg);
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)"Encountered exception resetting gfxinfo.", (Throwable)e);
                    lastException = e;
                    ++exceptionCount;
                }
            }
            if (exceptionCount > 1) {
                throw new RuntimeException("Multiple exceptions were encountered resetting gfxinfo. Reporting the last one only; others are visible in logs.", lastException);
            }
            if (exceptionCount == 1) {
                throw new RuntimeException("Encountered exception resetting gfxinfo.", lastException);
            }
        }
        return true;
    }

    @NonNull
    public Map<String, Double> getMetrics() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (this.mTrackedPackages.isEmpty()) {
            result.putAll(this.getGfxInfoMetrics());
        } else {
            int exceptionCount = 0;
            Exception lastException = null;
            for (String pkg : this.mTrackedPackages) {
                try {
                    result.putAll(this.getGfxInfoMetrics(pkg));
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)"Encountered exception getting gfxinfo.", (Throwable)e);
                    lastException = e;
                    ++exceptionCount;
                }
            }
            if (exceptionCount > 1) {
                throw new RuntimeException("Multiple exceptions were encountered getting gfxinfo. Reporting the last one only; others are visible in logs.", lastException);
            }
            if (exceptionCount == 1) {
                throw new RuntimeException("Encountered exception getting gfxinfo.", lastException);
            }
        }
        return result;
    }

    public boolean stopCollecting() {
        return true;
    }

    public void addTrackedPackages(String ... packages) {
        Collections.addAll(this.mTrackedPackages, packages);
    }

    @VisibleForTesting
    void clearGfxInfo() {
        this.clearGfxInfo("");
    }

    @VisibleForTesting
    void clearGfxInfo(String pkg) {
        try {
            if (pkg.isEmpty()) {
                String command = String.format(GFXINFO_COMMAND_RESET, "--");
                String output = this.getDevice().executeShellCommand(command);
                this.verifyMatches(output, this.getHeaderMatcher(""), "No package headers in output.", new Object[0]);
                Log.v((String)LOG_TAG, (String)"Cleared all gfxinfo.");
            } else {
                String command = String.format(GFXINFO_COMMAND_RESET, pkg);
                String output = this.getDevice().executeShellCommand(command);
                if (output.trim().equals("No process found for: " + pkg)) {
                    Log.v((String)LOG_TAG, (String)("Skipped clearing " + pkg + " gfxinfo, not running."));
                } else {
                    this.verifyMatches(output, this.getHeaderMatcher(pkg), "No package header in output.", new Object[0]);
                    Log.v((String)LOG_TAG, (String)String.format("Cleared %s gfxinfo.", pkg));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clear gfxinfo.", e);
        }
    }

    @VisibleForTesting
    Map<String, Double> getGfxInfoMetrics() {
        return this.getGfxInfoMetrics("");
    }

    @VisibleForTesting
    Map<String, Double> getGfxInfoMetrics(String pkg) {
        try {
            String command = String.format(GFXINFO_COMMAND_GET, pkg);
            String output = this.getDevice().executeShellCommand(command);
            this.verifyMatches(output, this.getHeaderMatcher(pkg), "Missing package header.", new Object[0]);
            String[] pkgMetricSections = output.split("\n\\*\\*");
            HashMap<String, Double> result = new HashMap<String, Double>();
            for (int i = 1; i < pkgMetricSections.length; ++i) {
                result.putAll(this.parseGfxInfoMetrics(pkgMetricSections[i]));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get gfxinfo.", e);
        }
    }

    private Map<String, Double> parseGfxInfoMetrics(String output) {
        Matcher header = Pattern.compile(this.getHeaderMatcher("")).matcher(output);
        if (!header.matches()) {
            throw new RuntimeException("Failed to parse package from gfxinfo output.");
        }
        String packageName = header.group(2);
        Log.v((String)LOG_TAG, (String)String.format("Collecting metrics for: %s", packageName));
        HashMap<String, Double> results = new HashMap<String, Double>();
        for (GfxInfoMetric metric : GfxInfoMetric.values()) {
            String metricKey = this.constructKey(GFXINFO_METRICS_PREFIX, packageName, metric.getMetricId());
            Double value = metric.parse(output);
            if (value == null) {
                Log.d((String)LOG_TAG, (String)String.format("Did not find %s from %s", metricKey, packageName));
                continue;
            }
            results.put(metricKey, value);
        }
        return results;
    }

    private String constructKey(String ... tokens) {
        return TextUtils.join((CharSequence)"_", (Object[])tokens);
    }

    private String getHeaderMatcher(String pkg) {
        return String.format(MULTILINE_MATCHER, String.format(GFXINFO_OUTPUT_HEADER, pkg.isEmpty() ? ".*" : pkg));
    }

    private void verifyMatches(String output, String match, String message, Object ... args) {
        if (!output.matches(match)) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    @NonNull
    @VisibleForTesting
    protected UiDevice getDevice() {
        if (this.mDevice == null) {
            this.mDevice = UiDevice.getInstance((Instrumentation)InstrumentationRegistry.getInstrumentation());
        }
        return this.mDevice;
    }

    public static enum GfxInfoMetric {
        TOTAL_FRAMES(Pattern.compile(".*Total frames rendered: (\\d+).*", 32), 1, "total_frames"),
        JANKY_FRAMES_COUNT(Pattern.compile(".*Janky frames: (\\d+) \\(([0-9]+[\\.]?[0-9]+)\\%\\).*", 32), 1, "janky_frames_count"),
        JANKY_FRAMES_PRCNT(Pattern.compile(".*Janky frames: (\\d+) \\(([0-9]+[\\.]?[0-9]+)\\%\\).*", 32), 2, "janky_frames_percent"),
        JANKY_FRAMES_LEGACY_COUNT(Pattern.compile(".*Janky frames \\(legacy\\): (\\d+) \\(([0-9]+[\\.]?[0-9]+)\\%\\).*", 32), 1, "janky_frames_legacy_count"),
        JANKY_FRAMES_LEGACY_PRCNT(Pattern.compile(".*Janky frames \\(legacy\\): (\\d+) \\(([0-9]+[\\.]?[0-9]+)\\%\\).*", 32), 2, "janky_frames_legacy_percent"),
        FRAME_TIME_50TH(Pattern.compile(".*50th percentile: (\\d+)ms.*", 32), 1, "frame_render_time_percentile_50"),
        FRAME_TIME_90TH(Pattern.compile(".*90th percentile: (\\d+)ms.*", 32), 1, "frame_render_time_percentile_90"),
        FRAME_TIME_95TH(Pattern.compile(".*95th percentile: (\\d+)ms.*", 32), 1, "frame_render_time_percentile_95"),
        FRAME_TIME_99TH(Pattern.compile(".*99th percentile: (\\d+)ms.*", 32), 1, "frame_render_time_percentile_99"),
        NUM_MISSED_VSYNC(Pattern.compile(".*Number Missed Vsync: (\\d+).*", 32), 1, "missed_vsync"),
        NUM_HIGH_INPUT_LATENCY(Pattern.compile(".*Number High input latency: (\\d+).*", 32), 1, "high_input_latency"),
        NUM_SLOW_UI_THREAD(Pattern.compile(".*Number Slow UI thread: (\\d+).*", 32), 1, "slow_ui_thread"),
        NUM_SLOW_BITMAP_UPLOADS(Pattern.compile(".*Number Slow bitmap uploads: (\\d+).*", 32), 1, "slow_bmp_upload"),
        NUM_SLOW_DRAW(Pattern.compile(".*Number Slow issue draw commands: (\\d+).*", 32), 1, "slow_issue_draw_cmds"),
        NUM_FRAME_DEADLINE_MISSED(Pattern.compile(".*Number Frame deadline missed: (\\d+).*", 32), 1, "deadline_missed"),
        NUM_FRAME_DEADLINE_MISSED_LEGACY(Pattern.compile(".*Number Frame deadline missed \\(legacy\\): (\\d+).*", 32), 1, "deadline_missed_legacy"),
        GPU_FRAME_TIME_50TH(Pattern.compile(".*50th gpu percentile: (\\d+)ms.*", 32), 1, "gpu_frame_render_time_percentile_50"),
        GPU_FRAME_TIME_90TH(Pattern.compile(".*90th gpu percentile: (\\d+)ms.*", 32), 1, "gpu_frame_render_time_percentile_90"),
        GPU_FRAME_TIME_95TH(Pattern.compile(".*95th gpu percentile: (\\d+)ms.*", 32), 1, "gpu_frame_render_time_percentile_95"),
        GPU_FRAME_TIME_99TH(Pattern.compile(".*99th gpu percentile: (\\d+)ms.*", 32), 1, "gpu_frame_render_time_percentile_99");

        private final Pattern mPattern;
        private final int mGroupIndex;
        private final String mMetricId;

        private GfxInfoMetric(Pattern pattern, int groupIndex, String metricId) {
            this.mPattern = pattern;
            this.mGroupIndex = groupIndex;
            this.mMetricId = metricId;
        }

        @Nullable
        public Double parse(@NonNull String lines) {
            Matcher matcher = this.mPattern.matcher(lines);
            if (matcher.matches()) {
                return Double.valueOf(matcher.group(this.mGroupIndex));
            }
            return null;
        }

        @NonNull
        public String getMetricId() {
            return this.mMetricId;
        }
    }
}

