/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.perfetto;

import androidx.benchmark.perfetto.QueryResultIterator;
import androidx.benchmark.perfetto.Row;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import perfetto.protos.QueryResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0011\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0006\u0010\u0015\u001a\u00020\u0014J\t\u0010\u0016\u001a\u00020\u0002H\u0096\u0002J\u0006\u0010\u0017\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/perfetto/QueryResultIterator;", "", "Landroidx/benchmark/perfetto/Row;", "queryResult", "Lperfetto/protos/QueryResult;", "(Lperfetto/protos/QueryResult;)V", "cells", "", "Lperfetto/protos/QueryResult$CellsBatch$CellType;", "columnCount", "", "columnNames", "", "", "count", "currentIndex", "dataLists", "androidx/benchmark/perfetto/QueryResultIterator$dataLists$1", "Landroidx/benchmark/perfetto/QueryResultIterator$dataLists$1;", "hasNext", "", "isEmpty", "next", "size", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nQueryResultIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryResultIterator.kt\nandroidx/benchmark/perfetto/QueryResultIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 QueryResultIterator.kt\nandroidx/benchmark/perfetto/QueryResultIterator\n*L\n50#1:124\n50#1:125,3\n*E\n"})
public final class QueryResultIterator
implements Iterator<Row>,
KMappedMarker {
    @NotNull
    private final dataLists.1 dataLists;
    @NotNull
    private final List<QueryResult.CellsBatch.CellType> cells;
    @NotNull
    private final List<String> columnNames;
    private final int columnCount;
    private final int count;
    private int currentIndex;

    /*
     * WARNING - void declaration
     */
    public QueryResultIterator(@NotNull QueryResult queryResult2) {
        Intrinsics.checkNotNullParameter((Object)((Object)queryResult2), (String)"queryResult");
        this.dataLists = new Object(){
            private final List<String> stringBatches;
            private final List<Long> varIntBatches;
            private final List<Double> float64Batches;
            private final List<byte[]> blobBatches;
            private int stringIndex;
            private int varIntIndex;
            private int float64Index;
            private int blobIndex;
            {
                this.stringBatches = new ArrayList<E>();
                this.varIntBatches = new ArrayList<E>();
                this.float64Batches = new ArrayList<E>();
                this.blobBatches = new ArrayList<E>();
            }

            public final List<String> getStringBatches() {
                return this.stringBatches;
            }

            public final List<Long> getVarIntBatches() {
                return this.varIntBatches;
            }

            public final List<Double> getFloat64Batches() {
                return this.float64Batches;
            }

            public final List<byte[]> getBlobBatches() {
                return this.blobBatches;
            }

            public final int getStringIndex() {
                return this.stringIndex;
            }

            public final void setStringIndex(int n) {
                this.stringIndex = n;
            }

            public final int getVarIntIndex() {
                return this.varIntIndex;
            }

            public final void setVarIntIndex(int n) {
                this.varIntIndex = n;
            }

            public final int getFloat64Index() {
                return this.float64Index;
            }

            public final void setFloat64Index(int n) {
                this.float64Index = n;
            }

            public final int getBlobIndex() {
                return this.blobIndex;
            }

            public final void setBlobIndex(int n) {
                this.blobIndex = n;
            }
        };
        this.cells = new ArrayList();
        this.columnNames = queryResult2.getColumn_names();
        for (QueryResult.CellsBatch batch : queryResult2.getBatch()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string = batch.getString_cells();
            Intrinsics.checkNotNull((Object)string);
            Object object = new char[]{'\u0000'};
            List stringsBatch = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null), (int)1);
            this.dataLists.getStringBatches().addAll(stringsBatch);
            this.dataLists.getVarIntBatches().addAll((Collection<Long>)batch.getVarint_cells());
            this.dataLists.getFloat64Batches().addAll((Collection<Double>)batch.getFloat64_cells());
            object = batch.getBlob_cells();
            List<byte[]> list = this.dataLists.getBlobBatches();
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ByteString byteString = (ByteString)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toByteArray());
            }
            list.addAll((List)destination$iv$iv);
            this.cells.addAll((Collection<QueryResult.CellsBatch.CellType>)batch.getCells());
        }
        this.columnCount = this.columnNames.size();
        this.count = this.columnCount > 0 ? this.cells.size() / this.columnCount : 0;
    }

    public final int size() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.count;
    }

    @Override
    @NotNull
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map row = new LinkedHashMap();
        int baseCellIndex = this.currentIndex * this.columnCount;
        Iterator iterator = ((Iterable)this.columnNames).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Serializable serializable;
            int num = n++;
            String columnName = (String)iterator.next();
            QueryResult.CellsBatch.CellType colType = this.cells.get(baseCellIndex + num);
            int colIndex = 0;
            Map map = row;
            switch (WhenMappings.$EnumSwitchMapping$0[colType.ordinal()]) {
                case 1: {
                    colIndex = this.dataLists.getStringIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setStringIndex(var11_11.getStringIndex() + 1);
                    serializable = (Serializable)((Object)this.dataLists.getStringBatches().get(colIndex));
                    break;
                }
                case 2: {
                    colIndex = this.dataLists.getVarIntIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setVarIntIndex(var11_11.getVarIntIndex() + 1);
                    serializable = this.dataLists.getVarIntBatches().get(colIndex);
                    break;
                }
                case 3: {
                    colIndex = this.dataLists.getFloat64Index();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setFloat64Index(var11_11.getFloat64Index() + 1);
                    serializable = this.dataLists.getFloat64Batches().get(colIndex);
                    break;
                }
                case 4: {
                    colIndex = this.dataLists.getBlobIndex();
                    dataLists.1 var11_11 = this.dataLists;
                    var11_11.setBlobIndex(var11_11.getBlobIndex() + 1);
                    serializable = (Serializable)this.dataLists.getBlobBatches().get(colIndex);
                    break;
                }
                case 5: {
                    throw new IllegalArgumentException("Invalid cell type");
                }
                case 6: {
                    serializable = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Serializable serializable2 = serializable;
            map.put(columnName, serializable2);
        }
        ++this.currentIndex;
        return new Row(row);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QueryResult.CellsBatch.CellType.values().length];
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_VARINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_FLOAT64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_BLOB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_INVALID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QueryResult.CellsBatch.CellType.CELL_NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

