/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.InstrumentationResultScope;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import androidx.benchmark.Shell;
import androidx.benchmark.UserInfo;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.benchmark.macro.BaselineProfilesKt;
import androidx.benchmark.macro.CompilationMode;
import androidx.benchmark.macro.MacrobenchmarkKt;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.ProfileRule;
import androidx.benchmark.macro.Summary;
import androidx.tracing.Trace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001ag\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0013\u00a2\u0006\u0002\b\u0015H\u0007\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0003\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a.\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\b\b\u0002\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0013H\u0001\u001a\u001e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0002\u001a(\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001a\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006'"}, d2={"deviceSpecifier", "", "getDeviceSpecifier", "()Ljava/lang/String;", "deviceSpecifier$delegate", "Lkotlin/Lazy;", "buildMacrobenchmarkScope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "packageName", "collect", "", "uniqueName", "stableIterations", "", "maxIterations", "strictStability", "", "includeInStartupProfile", "filterPredicate", "Lkotlin/Function1;", "profileBlock", "Lkotlin/ExtensionFunctionType;", "extractProfile", "extractProfileRooted", "uid", "filterProfileRulesToTargetP", "profile", "sortRules", "profmanGetProfileRules", "apkPath", "pathOptions", "", "reportResults", "uniqueFilePrefix", "startTime", "", "summaryRecord", "record", "Landroidx/benchmark/macro/Summary;", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nBaselineProfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaselineProfiles.kt\nandroidx/benchmark/macro/BaselineProfilesKt\n+ 2 Trace.kt\nandroidx/tracing/TraceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n27#2,5:371\n1549#3:376\n1620#3,3:377\n1603#3,9:380\n1855#3:389\n1856#3:392\n1612#3:393\n1855#3,2:394\n1855#3,2:396\n819#3:398\n847#3,2:399\n766#3:401\n857#3,2:402\n1603#3,9:404\n1855#3:413\n1856#3:415\n1612#3:416\n1549#3:417\n1620#3,3:418\n1#4:390\n1#4:391\n1#4:414\n*S KotlinDebug\n*F\n+ 1 BaselineProfiles.kt\nandroidx/benchmark/macro/BaselineProfilesKt\n*L\n64#1:371,5\n246#1:376\n246#1:377,3\n266#1:380,9\n266#1:389\n266#1:392\n266#1:393\n281#1:394,2\n283#1:396,2\n299#1:398\n299#1:399,2\n306#1:401\n306#1:402,2\n311#1:404,9\n311#1:413\n311#1:415\n311#1:416\n313#1:417\n313#1:418,3\n266#1:391\n311#1:414\n*E\n"})
public final class BaselineProfilesKt {
    @NotNull
    private static final Lazy deviceSpecifier$delegate = LazyKt.lazy((Function0)deviceSpecifier.2.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=28)
    public static final void collect(@NotNull String uniqueName, @NotNull String packageName, int stableIterations, int maxIterations, boolean strictStability, boolean includeInStartupProfile, @NotNull Function1<? super String, Boolean> filterPredicate, @NotNull Function1<? super MacrobenchmarkScope, Unit> profileBlock) {
        Intrinsics.checkNotNullParameter((Object)uniqueName, (String)"uniqueName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(filterPredicate, (String)"filterPredicate");
        Intrinsics.checkNotNullParameter(profileBlock, (String)"profileBlock");
        MacrobenchmarkScope scope = BaselineProfilesKt.buildMacrobenchmarkScope(packageName);
        int uid = UserInfo.INSTANCE.getCurrentUserId();
        long startTime = System.nanoTime();
        scope.getDevice().wakeUp();
        scope.killProcess();
        try {
            CharSequence unfilteredProfile;
            int finalMaxIterations;
            int stableCount = 1;
            Object lastProfile = null;
            Ref.IntRef iteration = new Ref.IntRef();
            iteration.element = 1;
            int n = finalMaxIterations = Arguments.INSTANCE.getDryRunMode() ? 1 : maxIterations;
            while (iteration.element <= finalMaxIterations) {
                Set existingRuleSet;
                Collection lastRuleSet;
                String label$iv = "generate profile for " + packageName + " (" + iteration.element + ')';
                boolean $i$f$trace = false;
                try {
                    Trace.beginSection((String)label$iv);
                    boolean bl = false;
                    CompilationMode.Partial mode = new CompilationMode.Partial(BaselineProfileMode.Disable, 1);
                    if (iteration.element == 1) {
                        Log.d((String)"Benchmark", (String)("Resetting compiled state for " + packageName + " for stable profiles."));
                        mode.resetAndCompile$benchmark_macro_release(scope, false, (Function0<Unit>)((Function0)new Function0<Unit>(scope, iteration, profileBlock){
                            final /* synthetic */ MacrobenchmarkScope $scope;
                            final /* synthetic */ Ref.IntRef $iteration;
                            final /* synthetic */ Function1<MacrobenchmarkScope, Unit> $profileBlock;
                            {
                                this.$scope = $scope;
                                this.$iteration = $iteration;
                                this.$profileBlock = $profileBlock;
                                super(0);
                            }

                            public final void invoke() {
                                this.$scope.setIteration$benchmark_macro_release(this.$iteration.element);
                                this.$profileBlock.invoke((Object)this.$scope);
                            }
                        }));
                    } else {
                        Log.d((String)"Benchmark", (String)("Killing package " + packageName));
                        scope.killProcess();
                        mode.compileImpl$benchmark_macro_release(scope, (Function0<Unit>)((Function0)new Function0<Unit>(scope, iteration, packageName, profileBlock){
                            final /* synthetic */ MacrobenchmarkScope $scope;
                            final /* synthetic */ Ref.IntRef $iteration;
                            final /* synthetic */ String $packageName;
                            final /* synthetic */ Function1<MacrobenchmarkScope, Unit> $profileBlock;
                            {
                                this.$scope = $scope;
                                this.$iteration = $iteration;
                                this.$packageName = $packageName;
                                this.$profileBlock = $profileBlock;
                                super(0);
                            }

                            public final void invoke() {
                                this.$scope.setIteration$benchmark_macro_release(this.$iteration.element);
                                Log.d((String)"Benchmark", (String)("Compile iteration (" + this.$scope.getIteration() + ") for " + this.$packageName));
                                this.$profileBlock.invoke((Object)this.$scope);
                            }
                        }));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Trace.endSection();
                }
                unfilteredProfile = Build.VERSION.SDK_INT >= 33 ? BaselineProfilesKt.extractProfile(packageName) : BaselineProfilesKt.extractProfileRooted(uid, packageName);
                Object object = lastProfile;
                if (object == null || (object = StringsKt.lines((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                    object = SetsKt.emptySet();
                }
                if (!Intrinsics.areEqual((Object)(lastRuleSet = object), (Object)(existingRuleSet = CollectionsKt.toSet((Iterable)StringsKt.lines((CharSequence)unfilteredProfile))))) {
                    if (iteration.element != 1) {
                        Log.d((String)"Benchmark", (String)("Unstable profiles during iteration " + iteration.element));
                    }
                    lastProfile = unfilteredProfile;
                    stableCount = 1;
                } else {
                    Log.d((String)"Benchmark", (String)("Profiles stable in iteration " + iteration.element + " (for " + stableCount + " iterations)"));
                    if (++stableCount == stableIterations) {
                        Log.d((String)"Benchmark", (String)("Baseline profile for " + packageName + " is stable."));
                        break;
                    }
                }
                ++iteration.element;
            }
            if (strictStability && !Arguments.INSTANCE.getDryRunMode() && !(stableCount == stableIterations)) {
                boolean $i$a$-check-BaselineProfilesKt$collect$42 = false;
                String $i$a$-check-BaselineProfilesKt$collect$42 = "Baseline profiles for " + packageName + " are not stable after " + maxIterations + '.';
                throw new IllegalStateException($i$a$-check-BaselineProfilesKt$collect$42.toString());
            }
            unfilteredProfile = (CharSequence)lastProfile;
            if (!(!(unfilteredProfile == null || StringsKt.isBlank((CharSequence)unfilteredProfile)))) {
                boolean bl = false;
                String string = "Generated Profile is empty, before filtering. Ensure your profileBlock invokes the target app, and runs a non-trivial amount of code";
                throw new IllegalStateException(string.toString());
            }
            String profile = BaselineProfilesKt.filterProfileRulesToTargetP(lastProfile, true, filterPredicate);
            BaselineProfilesKt.reportResults(profile, uniqueName, startTime, includeInStartupProfile);
        }
        finally {
            scope.killProcess();
        }
    }

    public static /* synthetic */ void collect$default(String string, String string2, int n, int n2, boolean bl, boolean bl2, Function1 function1, Function1 function12, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        BaselineProfilesKt.collect(string, string2, n, n2, bl, bl2, (Function1<? super String, Boolean>)function1, (Function1<? super MacrobenchmarkScope, Unit>)function12);
    }

    private static final MacrobenchmarkScope buildMacrobenchmarkScope(String packageName) {
        Arguments.INSTANCE.throwIfError();
        if (!(DeviceInfo.INSTANCE.getSupportsBaselineProfileCaptureError() == null)) {
            boolean bl = false;
            String string = DeviceInfo.INSTANCE.getSupportsBaselineProfileCaptureError();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
        MacrobenchmarkKt.getInstalledPackageInfo(packageName);
        return new MacrobenchmarkScope(packageName, true);
    }

    private static final void reportResults(String profile, String uniqueFilePrefix, long startTime, boolean includeInStartupProfile) {
        String[] stringArray;
        String[] stringArray2;
        if (includeInStartupProfile && Arguments.INSTANCE.getEnableStartupProfiles()) {
            stringArray2 = new String[]{uniqueFilePrefix + "-startup-prof.txt", uniqueFilePrefix + "-startup-prof-" + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".txt"};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{uniqueFilePrefix + "-baseline-prof.txt", uniqueFilePrefix + "-baseline-prof-" + Outputs.dateToFileName$default((Outputs)Outputs.INSTANCE, null, (int)1, null) + ".txt"};
            stringArray = stringArray2;
        }
        String[] stringArray3 = stringArray;
        String fileName = stringArray3[0];
        String tsFileName = stringArray3[1];
        String absolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)fileName, (boolean)false, (Function1)((Function1)new Function1<File, Unit>(profile){
            final /* synthetic */ String $profile;
            {
                this.$profile = $profile;
                super(1);
            }

            public final void invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FilesKt.writeText$default((File)it, (String)this.$profile, null, (int)2, null);
            }
        }), (int)2, null);
        String tsAbsolutePath2 = Outputs.writeFile$default((Outputs)Outputs.INSTANCE, (String)tsFileName, (boolean)false, (Function1)((Function1)new Function1<File, Unit>(profile){
            final /* synthetic */ String $profile;
            {
                this.$profile = $profile;
                super(1);
            }

            public final void invoke(File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Log.d((String)"Benchmark", (String)("Pull Baseline Profile with: `adb pull \"" + it.getAbsolutePath() + "\" .`"));
                FilesKt.writeText$default((File)it, (String)this.$profile, null, (int)2, null);
            }
        }), (int)2, null);
        long totalRunTime = System.nanoTime() - startTime;
        Summary results = new Summary(totalRunTime, absolutePath2, tsAbsolutePath2);
        InstrumentationResults.INSTANCE.instrumentationReport((Function1)new Function1<InstrumentationResultScope, Unit>(uniqueFilePrefix, results, totalRunTime){
            final /* synthetic */ String $uniqueFilePrefix;
            final /* synthetic */ Summary $results;
            final /* synthetic */ long $totalRunTime;
            {
                this.$uniqueFilePrefix = $uniqueFilePrefix;
                this.$results = $results;
                this.$totalRunTime = $totalRunTime;
                super(1);
            }

            public final void invoke(InstrumentationResultScope $this$instrumentationReport) {
                Intrinsics.checkNotNullParameter((Object)$this$instrumentationReport, (String)"$this$instrumentationReport");
                InstrumentationResultScope.reportSummaryToIde$default((InstrumentationResultScope)$this$instrumentationReport, null, (String)this.$uniqueFilePrefix, (String)BaselineProfilesKt.access$summaryRecord(this.$results), null, null, null, null, (boolean)false, (int)249, null);
                Log.d((String)"Benchmark", (String)("Total Run Time Ns: " + this.$totalRunTime));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=33)
    private static final String extractProfile(String packageName) {
        String dumpCommand = "pm dump-profiles --dump-classes-and-methods " + packageName;
        String stdout = ((Object)StringsKt.trim((CharSequence)Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)dumpCommand, null, (int)2, null))).toString();
        String expected = "Profile saved to '/data/misc/profman/" + packageName + "-primary.prof.txt'";
        if (!(StringsKt.isBlank((CharSequence)stdout) || Intrinsics.areEqual((Object)stdout, (Object)expected))) {
            boolean $i$a$-check-BaselineProfilesKt$extractProfile$22 = false;
            String $i$a$-check-BaselineProfilesKt$extractProfile$22 = "Expected `pm dump-profiles` stdout to be either black or `" + expected + "` but was " + stdout;
            throw new IllegalStateException($i$a$-check-BaselineProfilesKt$extractProfile$22.toString());
        }
        String fileName = packageName + "-primary.prof.txt";
        Shell.executeScriptSilent$default((Shell)Shell.INSTANCE, (String)("mv /data/misc/profman/" + fileName + ' ' + Outputs.INSTANCE.getDirUsableByAppAndShell() + '/'), null, (int)2, null);
        File rawRuleOutput = new File(Outputs.INSTANCE.getDirUsableByAppAndShell(), fileName);
        try {
            String string = FilesKt.readText$default((File)rawRuleOutput, null, (int)1, null);
            return string;
        }
        finally {
            rawRuleOutput.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String extractProfileRooted(int uid, String packageName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String referenceProfile = "/data/misc/profiles/ref/" + packageName + "/primary.prof";
        String currentProfile = "/data/misc/profiles/cur/" + uid + '/' + packageName + "/primary.prof";
        Log.d((String)"Benchmark", (String)("Reference profile location: " + referenceProfile));
        Iterable iterable = Shell.INSTANCE.pmPath(packageName);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void apkPath;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Log.d((String)"Benchmark", (String)("APK Path: " + (String)apkPath));
            Log.d((String)"Benchmark", (String)"Converting to human readable profile format");
            Object[] objectArray = new String[]{referenceProfile, currentProfile};
            collection.add(BaselineProfilesKt.profmanGetProfileRules((String)apkPath, CollectionsKt.listOf((Object[])objectArray)));
        }
        String mergedProfile = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.isBlank((CharSequence)mergedProfile)) {
            throw new IllegalStateException("No profiles found for all apks in app");
        }
        return mergedProfile;
    }

    /*
     * WARNING - void declaration
     */
    private static final String profmanGetProfileRules(String apkPath, List<String> pathOptions) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = pathOptions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            CharSequence charSequence;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String currentPath = (String)element$iv$iv;
            boolean bl2 = false;
            Log.d((String)"Benchmark", (String)("Using profile location: " + currentPath));
            String profile = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("profman --dump-classes-and-methods --profile-file=" + currentPath + " --apk=" + apkPath), null, (int)2, null);
            CharSequence charSequence2 = profile;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl3 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            if ((String)charSequence == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List profiles = (List)destination$iv$iv;
        if (profiles.isEmpty()) {
            Log.d((String)"Benchmark", (String)("No profiles found for " + apkPath));
            return "";
        }
        Set rules = new LinkedHashSet();
        Iterable $this$forEach$iv = profiles;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String profile = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = StringsKt.lines((CharSequence)profile);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String rule = (String)element$iv2;
                boolean bl5 = false;
                rules.add(rule);
            }
        }
        StringBuilder builder = new StringBuilder();
        Iterable $this$forEach$iv3 = rules;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv3) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.append(it);
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final String filterProfileRulesToTargetP(@NotNull String profile, boolean sortRules, @NotNull Function1<? super String, Boolean> filterPredicate) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object rule;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(filterPredicate, (String)"filterPredicate");
        List rules = StringsKt.lines((CharSequence)profile);
        Iterable iterable = rules;
        boolean $i$f$filterNot = false;
        void var7_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            rule = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)rule, (String)"[", (boolean)false, (int)2, null) ? true : StringsKt.contains$default((CharSequence)((CharSequence)rule), (CharSequence)"+", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filterPredicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredRules = (List)destination$iv$iv;
        if (sortRules) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            $this$filter$iv = filteredRules;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            rule = $this$forEach$iv$iv$iv.iterator();
            while (rule.hasNext()) {
                ProfileRule it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = rule.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (ProfileRule.Companion.parse(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), ProfileRule.Companion.getComparator$benchmark_macro_release());
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                rule = (ProfileRule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUnderlying());
            }
            filteredRules = (List)destination$iv$iv;
        }
        return CollectionsKt.joinToString$default((Iterable)filteredRules, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String filterProfileRulesToTargetP$default(String string, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return BaselineProfilesKt.filterProfileRulesToTargetP(string, bl, (Function1<? super String, Boolean>)function1);
    }

    private static final String summaryRecord(Summary record) {
        StringBuilder summary = new StringBuilder();
        String relativePath = StringsKt.replace$default((String)StringsKt.replace$default((String)Outputs.INSTANCE.relativePathFor(record.getProfileTsPath()), (String)"(", (String)"\\(", (boolean)false, (int)4, null), (String)")", (String)"\\)", (boolean)false, (int)4, null);
        summary.append(StringsKt.trimIndent((String)("\n            Total run time Ns: " + record.getTotalRunTime() + ".\n            Baseline profile [results](file://" + relativePath + ")\n        ")));
        summary.append("\n").append("\n").append(StringsKt.trimIndent((String)("\n                To copy the profile use:\n                adb " + BaselineProfilesKt.getDeviceSpecifier() + "pull \"" + record.getProfilePath() + "\" .\n            ")));
        String string = summary.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getDeviceSpecifier() {
        Lazy lazy = deviceSpecifier$delegate;
        return (String)lazy.getValue();
    }

    public static final /* synthetic */ String access$summaryRecord(Summary record) {
        return BaselineProfilesKt.summaryRecord(record);
    }
}

