/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.util.Log;
import androidx.benchmark.Measurements;
import androidx.benchmark.MetricResult;
import androidx.benchmark.macro.ExperimentalMetricApi;
import androidx.benchmark.macro.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003H\u0000\u001a*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u000e0\u0003H\u0000\u001a$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0003*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e0\u0003H\u0000\u00a8\u0006\u0011"}, d2={"assertEqualMeasurements", "", "expected", "", "Landroidx/benchmark/macro/Metric$Measurement;", "observed", "threshold", "", "merge", "other", "mergeMultiIterResults", "Landroidx/benchmark/Measurements;", "mergeToSampledMetricResults", "Landroidx/benchmark/MetricResult;", "", "", "mergeToSingleMetricResults", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nMetricResultExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricResultExtensions.kt\nandroidx/benchmark/macro/MetricResultExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,167:1\n1045#2:168\n1045#2:169\n1549#2:170\n1620#2,3:171\n1549#2:174\n1620#2,3:175\n3433#2,5:178\n1864#2,3:183\n3439#2:186\n1549#2:187\n1620#2,3:188\n1549#2:191\n1620#2,3:192\n1549#2:195\n1620#2,2:196\n766#2:198\n857#2,2:199\n1179#2,2:201\n1253#2,4:203\n1622#2:207\n1549#2:208\n1620#2,2:209\n766#2:211\n857#2,2:212\n1179#2,2:214\n1253#2,4:216\n1622#2:220\n1360#2:221\n1446#2,5:222\n1271#2,2:227\n1285#2,2:229\n1569#2,11:231\n1864#2,2:242\n1866#2:245\n1580#2:246\n1288#2:247\n1045#2:252\n1360#2:253\n1446#2,5:254\n1271#2,2:259\n1285#2,2:261\n1559#2:263\n1590#2,4:264\n1288#2:268\n1045#2:273\n1#3:244\n125#4:248\n152#4,3:249\n125#4:269\n152#4,3:270\n*S KotlinDebug\n*F\n+ 1 MetricResultExtensions.kt\nandroidx/benchmark/macro/MetricResultExtensionsKt\n*L\n36#1:168\n37#1:169\n38#1:170\n38#1:171,3\n39#1:174\n39#1:175,3\n48#1:178,5\n64#1:183,3\n48#1:186\n82#1:187\n82#1:188,3\n83#1:191\n83#1:192,3\n105#1:195\n105#1:196,2\n106#1:198\n106#1:199,2\n107#1:201,2\n107#1:203,4\n105#1:207\n113#1:208\n113#1:209,2\n114#1:211\n114#1:212,2\n115#1:214,2\n115#1:216,4\n113#1:220\n122#1:221\n122#1:222,5\n126#1:227,2\n126#1:229,2\n127#1:231,11\n127#1:242,2\n127#1:245\n127#1:246\n126#1:247\n144#1:252\n149#1:253\n149#1:254,5\n153#1:259,2\n153#1:261,2\n154#1:263\n154#1:264,4\n153#1:268\n165#1:273\n127#1:244\n143#1:248\n143#1:249,3\n162#1:269\n162#1:270,3\n*E\n"})
public final class MetricResultExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @ExperimentalMetricApi
    public static final void assertEqualMeasurements(@NotNull List<Metric.Measurement> expected, @NotNull List<Metric.Measurement> observed, double threshold) {
        void $this$mapTo$iv$iv;
        ArrayList<String> arrayList;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(observed, (String)"observed");
        Iterable $this$sortedBy$iv = expected;
        boolean $i$f$sortedBy = false;
        List expectedSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Metric.Measurement it = (Metric.Measurement)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Metric.Measurement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Iterable $this$sortedBy$iv2 = observed;
        boolean $i$f$sortedBy2 = false;
        List observedSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Metric.Measurement it = (Metric.Measurement)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Metric.Measurement)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Iterable $this$map$iv = expectedSorted;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable<String> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Metric.Measurement measurement = (Metric.Measurement)item$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(it.getName());
        }
        List expectedNames = CollectionsKt.listOf((Object)destination$iv$iv);
        Iterable $this$map$iv2 = observedSorted;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Metric.Measurement bl = (Metric.Measurement)item$iv$iv;
            arrayList = destination$iv$iv2;
            boolean bl2 = false;
            arrayList.add(it.getName());
        }
        List observedNames = CollectionsKt.listOf((Object)((List)destination$iv$iv2));
        if (!Intrinsics.areEqual((Object)expectedNames, (Object)observedNames)) {
            throw new AssertionError((Object)("expected same measurement names, expected = " + expectedNames + ", observed = " + observedNames));
        }
        String errorString = null;
        errorString = "";
        Iterable $this$zip$iv = expectedSorted;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)observedSorted).iterator();
        ArrayList<String> list$iv = new ArrayList<String>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)observedSorted, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void observedMeasurement;
            void expectedMeasurement;
            Object item$iv$iv;
            item$iv$iv = (Metric.Measurement)second$iv.next();
            Metric.Measurement it = (Metric.Measurement)first$iv.next();
            arrayList = list$iv;
            boolean bl = false;
            String name = expectedMeasurement.getName();
            if (expectedMeasurement.getRequireSingleValue() != observedMeasurement.getRequireSingleValue()) {
                errorString = errorString + "expected value of requireSingleValue (" + expectedMeasurement.getRequireSingleValue() + ") does not match observed value " + observedMeasurement.getRequireSingleValue() + '\n';
            }
            List<Double> expectedSamples = expectedMeasurement.getData();
            List<Double> observedSamples = observedMeasurement.getData();
            if (expectedSamples.size() != observedSamples.size()) {
                errorString = errorString + name + " expected " + expectedSamples.size() + " samples, observed " + observedSamples.size() + '\n';
            } else {
                Iterable $this$forEachIndexed$iv = CollectionsKt.zip((Iterable)expectedSamples, (Iterable)observedSamples);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void pair;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair2 = (Pair)item$iv;
                    int index = n;
                    boolean bl3 = false;
                    if (!(Math.abs(((Number)pair.getFirst()).doubleValue() - ((Number)pair.getSecond()).doubleValue()) > threshold)) continue;
                    errorString = errorString + name + " sample " + index + " observed " + ((Number)pair.getSecond()).doubleValue() + ", which is more than " + threshold + " from expected " + ((Number)pair.getFirst()).doubleValue() + '\n';
                }
            }
            arrayList.add((String)Unit.INSTANCE);
        }
        if (!StringsKt.isBlank((CharSequence)errorString)) {
            throw new AssertionError((Object)errorString);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Metric.Measurement> merge(@NotNull List<Metric.Measurement> $this$merge, @NotNull List<Metric.Measurement> other) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$merge, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterable $this$map$iv = $this$merge;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Metric.Measurement measurement = (Metric.Measurement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set nameSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = other;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Metric.Measurement bl = (Metric.Measurement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        Set otherNameSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set intersectingNames = CollectionsKt.intersect((Iterable)nameSet, (Iterable)otherNameSet);
        if (!((Collection)intersectingNames).isEmpty()) {
            throw new IllegalStateException("Multiple metrics produced measurements with overlapping names: " + intersectingNames);
        }
        return CollectionsKt.plus((Collection)$this$merge, (Iterable)other);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Measurements mergeMultiIterResults(@NotNull List<? extends List<Metric.Measurement>> $this$mergeMultiIterResults) {
        Metric.Measurement singleResult;
        void $this$associateTo$iv$iv;
        boolean $i$f$associateTo;
        Map destination$iv$iv;
        int capacity$iv22;
        void $this$associate$iv;
        boolean $i$f$associate;
        Metric.Measurement measurement;
        Collection destination$iv$iv2;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        List it;
        List<MetricResult> list;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mergeMultiIterResults, (String)"<this>");
        Iterable $this$map$iv = $this$mergeMultiIterResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection<Object> destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv$iv2;
            void $this$filterTo$iv$iv;
            List list2 = (List)item$iv$iv;
            list = destination$iv$iv3;
            boolean bl = false;
            $this$filter$iv = it;
            $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                measurement = (Metric.Measurement)element$iv$iv2;
                boolean bl2 = false;
                if (!measurement.getRequireSingleValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$associate = false;
            capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv2 = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv22);
            $i$f$associateTo = false;
            element$iv$iv2 = $this$associateTo$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                Map bl2 = destination$iv$iv;
                singleResult = (Metric.Measurement)element$iv$iv3;
                boolean bl3 = false;
                singleResult = TuplesKt.to((Object)singleResult.getName(), (Object)CollectionsKt.first(singleResult.getData()));
                bl2.put(singleResult.getFirst(), singleResult.getSecond());
            }
            list.add((MetricResult)destination$iv$iv);
        }
        $this$map$iv = $this$mergeMultiIterResults;
        list = MetricResultExtensionsKt.mergeToSingleMetricResults((List)destination$iv$iv3);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            it = (List)item$iv$iv;
            Collection<Object> collection = destination$iv$iv3;
            boolean bl = false;
            $this$filter$iv = it;
            $i$f$filter = false;
            Iterable capacity$iv22 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                measurement = (Metric.Measurement)element$iv$iv2;
                boolean bl4 = false;
                if (!(!measurement.getRequireSingleValue())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$associate = false;
            capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv2 = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv22);
            $i$f$associateTo = false;
            for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                singleResult = (Metric.Measurement)element$iv$iv3;
                boolean bl5 = false;
                Pair pair = TuplesKt.to((Object)singleResult.getName(), singleResult.getData());
                map.put(pair.getFirst(), pair.getSecond());
            }
            collection.add((MetricResult)destination$iv$iv);
        }
        List<MetricResult> list3 = MetricResultExtensionsKt.mergeToSampledMetricResults(destination$iv$iv3);
        List<MetricResult> list4 = list;
        return new Measurements(list4, list3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MetricResult> mergeToSingleMetricResults(@NotNull List<? extends Map<String, Double>> $this$mergeToSingleMetricResults) {
        void $this$mapTo$iv$iv;
        Map listResults;
        Object object;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mergeToSingleMetricResults, (String)"<this>");
        Iterable $this$flatMap$iv = $this$mergeToSingleMetricResults;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set setOfAllKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = setOfAllKeys;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapIndexedNotNullTo$iv$iv;
            String bl = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            Iterable $this$mapIndexedNotNull$iv = $this$mergeToSingleMetricResults;
            boolean $i$f$mapIndexedNotNull = false;
            Iterable iterable2 = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                Double d;
                void resultMap;
                void element$iv$iv2;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t2 = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl3 = false;
                Map map = (Map)element$iv$iv2;
                int iteration = index$iv$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual(resultMap.keySet(), (Object)setOfAllKeys)) {
                    Log.d((String)"Benchmark", (String)("Skipping results from iter " + iteration + ", it didn't capture all metrics"));
                    d = null;
                } else {
                    void key;
                    Double d2 = (Double)resultMap.get(key);
                    if (d2 == null) {
                        throw new IllegalStateException(("Metric " + (String)key + " not observed in iteration").toString());
                    }
                    d = (double)d2;
                }
                if (d == null) continue;
                Double it$iv$iv = d;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            object.put(t, list);
        }
        Map $this$map$iv = listResults = (Map)result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            object = destination$iv$iv3;
            boolean bl = false;
            String metricName = (String)entry.getKey();
            List values = (List)entry.getValue();
            object.add(new MetricResult(metricName, values, null, 4, null));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv3;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MetricResult it = (MetricResult)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (MetricResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MetricResult> mergeToSampledMetricResults(@NotNull List<? extends Map<String, ? extends List<Double>>> $this$mergeToSampledMetricResults) {
        void $this$mapTo$iv$iv;
        Map listResults;
        Object object;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$mergeToSampledMetricResults, (String)"<this>");
        Iterable $this$flatMap$iv = $this$mergeToSampledMetricResults;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set setOfAllKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = setOfAllKeys;
        boolean $i$f$associateWith = false;
        Map result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            String bl = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            Iterable $this$mapIndexed$iv = $this$mergeToSampledMetricResults;
            boolean $i$f$mapIndexed = false;
            Iterable iterable2 = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void key;
                void iterationSamples;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Map map = (Map)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                List list = (List)iterationSamples.get(key);
                if (list == null) {
                    void index;
                    throw new IllegalStateException("Iteration " + (int)index + " didn't capture metric " + (String)key);
                }
                collection.add(list);
            }
            List list = (List)destination$iv$iv2;
            object.put(t, list);
        }
        Map $this$map$iv = listResults = (Map)result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            object = destination$iv$iv3;
            boolean bl = false;
            String metricName = (String)entry.getKey();
            List values = (List)entry.getValue();
            object.add(new MetricResult(metricName, CollectionsKt.flatten((Iterable)values), values));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv3;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MetricResult it = (MetricResult)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (MetricResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }
}

