/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Arguments;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.InMemoryTracing;
import androidx.benchmark.Shell;
import androidx.benchmark.macro.BaselineProfileMode;
import androidx.benchmark.macro.ExperimentalMacrobenchmarkApi;
import androidx.benchmark.macro.MacrobenchmarkScope;
import androidx.benchmark.macro.ProfileInstallBroadcast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00172\u00020\u0001:\u0006\u0017\u0018\u0019\u001a\u001b\u001cB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH!\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0007J-\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0011H!\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u0082\u0001\u0005\u001d\u001e\u001f !\u00a8\u0006\""}, d2={"Landroidx/benchmark/macro/CompilationMode;", "", "()V", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "copiedApkPaths", "", "packageName", "installPackageFromPaths", "reinstallPackage", "resetAndCompile", "allowCompilationSkipping", "", "resetAndCompile$benchmark_macro_release", "shouldReset", "shouldReset$benchmark_macro_release", "uninstallPackage", "writeProfileInstallerSkipFile", "Companion", "Full", "Ignore", "Interpreted", "None", "Partial", "Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode$Ignore;", "Landroidx/benchmark/macro/CompilationMode$Interpreted;", "Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode$Partial;", "benchmark-macro_release"})
@SourceDebugExtension(value={"SMAP\nCompilationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationMode.kt\nandroidx/benchmark/macro/CompilationMode\n+ 2 InMemoryTracing.kt\nandroidx/benchmark/InMemoryTracingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,516:1\n186#2,6:517\n1559#3:523\n1590#3,4:524\n1#4:528\n*S KotlinDebug\n*F\n+ 1 CompilationMode.kt\nandroidx/benchmark/macro/CompilationMode\n*L\n146#1:517,6\n173#1:523\n173#1:524,4\n*E\n"})
public abstract class CompilationMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final CompilationMode DEFAULT = Build.VERSION.SDK_INT >= 24 ? (CompilationMode)new Partial(BaselineProfileMode.UseIfAvailable, 0) : (CompilationMode)new Full();

    private CompilationMode() {
    }

    public final void resetAndCompile$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, boolean allowCompilationSkipping, @NotNull Function0<Unit> warmupBlock) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        String packageName = scope.getPackageName();
        if (Build.VERSION.SDK_INT >= 24) {
            if (Arguments.INSTANCE.getEnableCompilation() || !allowCompilationSkipping) {
                Log.d((String)"Benchmark", (String)("Clearing ART profiles for " + packageName));
                if (this.shouldReset$benchmark_macro_release()) {
                    Log.d((String)"Benchmark", (String)("Resetting profiles for " + packageName));
                    if (Build.VERSION.SDK_INT >= 34) {
                        Companion.cmdPackageCompile$benchmark_macro_release(packageName, "verify");
                        String output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("pm art clear-app-profiles " + packageName), null, (int)2, null);
                        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Profiles cleared")) {
                            boolean $i$a$-check-CompilationMode$resetAndCompile$32 = false;
                            String $i$a$-check-CompilationMode$resetAndCompile$32 = Companion.compileResetErrorString(packageName, output, DeviceInfo.INSTANCE.isEmulator());
                            throw new IllegalStateException($i$a$-check-CompilationMode$resetAndCompile$32.toString());
                        }
                    } else if (Shell.INSTANCE.isSessionRooted()) {
                        String output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("cmd package compile --reset " + packageName), null, (int)2, null);
                        if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)output, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
                            boolean bl = false;
                            String string = Companion.compileResetErrorString(packageName, output, DeviceInfo.INSTANCE.isEmulator());
                            throw new IllegalStateException(string.toString());
                        }
                    } else {
                        Log.d((String)"Benchmark", (String)("Reinstalling " + packageName));
                        this.reinstallPackage(packageName);
                    }
                }
                this.writeProfileInstallerSkipFile(scope);
                this.compileImpl$benchmark_macro_release(scope, warmupBlock);
            } else {
                Log.d((String)"Benchmark", (String)("Compilation is disabled, skipping compilation of " + packageName));
            }
        }
    }

    public static /* synthetic */ void resetAndCompile$benchmark_macro_release$default(CompilationMode compilationMode, MacrobenchmarkScope macrobenchmarkScope, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resetAndCompile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        compilationMode.resetAndCompile$benchmark_macro_release(macrobenchmarkScope, bl, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void reinstallPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String label$iv = "reinstallPackage";
        boolean $i$f$inMemoryTrace = false;
        InMemoryTracing.beginSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (String)label$iv, (long)0L, null, null, (int)14, null);
        try {
            boolean bl = false;
            String copiedApkPaths = this.copiedApkPaths(packageName);
            try {
                this.uninstallPackage(packageName);
                this.installPackageFromPaths(packageName, copiedApkPaths);
            }
            finally {
                Log.d((String)"Benchmark", (String)("Deleting " + copiedApkPaths));
                Shell.INSTANCE.rm(copiedApkPaths);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InMemoryTracing.endSection$default((InMemoryTracing)InMemoryTracing.INSTANCE, (long)0L, (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String copiedApkPaths(@NotNull String packageName) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        List apkPaths = Shell.INSTANCE.pmPath(packageName);
        Iterable $this$mapIndexed$iv = apkPaths;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void apkPath;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String tempApkPath = "/data/local/tmp/" + packageName + '-' + (int)index + '-' + System.currentTimeMillis() + ".apk";
            Log.d((String)"Benchmark", (String)("Copying APK " + (String)apkPath + " to " + tempApkPath));
            Shell.INSTANCE.cp((String)apkPath, tempApkPath);
            collection.add(tempApkPath);
        }
        List tempApkPaths = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)tempApkPaths, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void uninstallPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)("Uninstalling " + packageName));
        String output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("pm uninstall " + packageName), null, (int)2, null);
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success")) {
            boolean bl = false;
            String string = "Unable to uninstall " + packageName + " (" + output + ')';
            throw new IllegalStateException(string.toString());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void installPackageFromPaths(@NotNull String packageName, @NotNull String copiedApkPaths) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)copiedApkPaths, (String)"copiedApkPaths");
        Log.d((String)"Benchmark", (String)("Installing " + packageName));
        StringBuilder builder = new StringBuilder("pm install");
        builder.append(" -t");
        if (Build.VERSION.SDK_INT >= 30) {
            builder.append(" --skip-verification");
        }
        builder.append(' ' + copiedApkPaths);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String output = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)string, null, (int)2, null);
        if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)output, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string2 = "Unable to install " + packageName + " (out=" + output + ')';
            throw new IllegalStateException(string2.toString());
        }
    }

    private final void writeProfileInstallerSkipFile(MacrobenchmarkScope scope) {
        String packageName = scope.getPackageName();
        String result = ProfileInstallBroadcast.INSTANCE.skipFileOperation(packageName, "WRITE_SKIP_FILE");
        if (result != null) {
            Log.w((String)"Benchmark", (String)StringsKt.trimIndent((String)("\n                    " + packageName + " should use the latest version of `androidx.profileinstaller`\n                    for stable benchmarks. (" + result + ")\"\n                ")));
        }
        Log.d((String)"Benchmark", (String)("Killing process " + packageName));
        scope.killProcess();
    }

    @RequiresApi(value=24)
    public abstract void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope var1, @NotNull Function0<Unit> var2);

    @RequiresApi(value=24)
    public abstract boolean shouldReset$benchmark_macro_release();

    public /* synthetic */ CompilationMode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Companion;", "", "()V", "DEFAULT", "Landroidx/benchmark/macro/CompilationMode;", "cmdPackageCompile", "", "packageName", "", "compileArgument", "cmdPackageCompile$benchmark_macro_release", "compileResetErrorString", "output", "isEmulator", "", "benchmark-macro_release"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresApi(value=24)
        public final void cmdPackageCompile$benchmark_macro_release(@NotNull String packageName, @NotNull String compileArgument) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)compileArgument, (String)"compileArgument");
            String stdout = Shell.executeScriptCaptureStdout$default((Shell)Shell.INSTANCE, (String)("cmd package compile -f -m " + compileArgument + ' ' + packageName), null, (int)2, null);
            if (!(Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)stdout)).toString(), (Object)"Success") || StringsKt.contains$default((CharSequence)stdout, (CharSequence)"PERFORMED", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string = "Failed to compile (out=" + stdout + ')';
                throw new IllegalStateException(string.toString());
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String compileResetErrorString(@NotNull String packageName, @NotNull String output, boolean isEmulator) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return "Unable to reset compilation of " + packageName + " (out=" + output + ")." + (StringsKt.contains$default((CharSequence)output, (CharSequence)"could not be compiled", (boolean)false, (int)2, null) && isEmulator ? " Try updating your emulator - see https://issuetracker.google.com/issue?id=251540646" : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Full;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "", "benchmark-macro_release"})
    public static final class Full
    extends CompilationMode {
        public Full() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Full";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            if (Build.VERSION.SDK_INT >= 24) {
                Companion.cmdPackageCompile$benchmark_macro_release(scope.getPackageName(), "speed");
            }
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Ignore;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "", "benchmark-macro_release"})
    @ExperimentalMacrobenchmarkApi
    public static final class Ignore
    extends CompilationMode {
        public Ignore() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Ignore";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$Interpreted;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "", "benchmark-macro_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Interpreted
    extends CompilationMode {
        @NotNull
        public static final Interpreted INSTANCE = new Interpreted();

        private Interpreted() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "Interpreted";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0010\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/CompilationMode$None;", "Landroidx/benchmark/macro/CompilationMode;", "()V", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "", "benchmark-macro_release"})
    @RequiresApi(value=24)
    public static final class None
    extends CompilationMode {
        public None() {
            super(null);
        }

        @NotNull
        public String toString() {
            return "None";
        }

        @Override
        public void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/macro/CompilationMode$Partial;", "Landroidx/benchmark/macro/CompilationMode;", "baselineProfileMode", "Landroidx/benchmark/macro/BaselineProfileMode;", "warmupIterations", "", "(Landroidx/benchmark/macro/BaselineProfileMode;I)V", "getBaselineProfileMode", "()Landroidx/benchmark/macro/BaselineProfileMode;", "getWarmupIterations", "()I", "compileImpl", "", "scope", "Landroidx/benchmark/macro/MacrobenchmarkScope;", "warmupBlock", "Lkotlin/Function0;", "compileImpl$benchmark_macro_release", "shouldReset", "", "shouldReset$benchmark_macro_release", "toString", "", "benchmark-macro_release"})
    @RequiresApi(value=24)
    @SourceDebugExtension(value={"SMAP\nCompilationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationMode.kt\nandroidx/benchmark/macro/CompilationMode$Partial\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,516:1\n1#2:517\n*E\n"})
    public static final class Partial
    extends CompilationMode {
        @NotNull
        private final BaselineProfileMode baselineProfileMode;
        private final int warmupIterations;

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode, @IntRange(from=0L) int warmupIterations) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            super(null);
            this.baselineProfileMode = baselineProfileMode;
            this.warmupIterations = warmupIterations;
            if (!(this.warmupIterations >= 0)) {
                boolean $i$a$-require-CompilationMode$Partial$32 = false;
                String $i$a$-require-CompilationMode$Partial$32 = "warmupIterations must be non-negative, was " + this.warmupIterations;
                throw new IllegalArgumentException($i$a$-require-CompilationMode$Partial$32.toString());
            }
            if (!(this.baselineProfileMode != BaselineProfileMode.Disable || this.warmupIterations > 0)) {
                boolean bl = false;
                String string = "Must set baselineProfileMode != Ignore, or warmup iterations > 0 to define which portion of the app to pre-compile.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Partial(BaselineProfileMode baselineProfileMode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                baselineProfileMode = BaselineProfileMode.Require;
            }
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(baselineProfileMode, n);
        }

        @NotNull
        public final BaselineProfileMode getBaselineProfileMode() {
            return this.baselineProfileMode;
        }

        public final int getWarmupIterations() {
            return this.warmupIterations;
        }

        @NotNull
        public String toString() {
            return this.baselineProfileMode == BaselineProfileMode.Require && this.warmupIterations == 0 ? "BaselineProfile" : (this.baselineProfileMode == BaselineProfileMode.Disable && this.warmupIterations > 0 ? "WarmupProfile(iterations=" + this.warmupIterations + ')' : "Partial(baselineProfile=" + (Object)((Object)this.baselineProfileMode) + ",iterations=" + this.warmupIterations + ')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compileImpl$benchmark_macro_release(@NotNull MacrobenchmarkScope scope, @NotNull Function0<Unit> warmupBlock) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter(warmupBlock, (String)"warmupBlock");
            String packageName = scope.getPackageName();
            if (this.baselineProfileMode != BaselineProfileMode.Disable) {
                String installErrorString = ProfileInstallBroadcast.INSTANCE.installProfile(packageName);
                if (installErrorString == null) {
                    Log.d((String)"Benchmark", (String)("Killing process " + packageName));
                    scope.killProcess();
                    Companion.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
                } else {
                    if (this.baselineProfileMode == BaselineProfileMode.Require) {
                        throw new RuntimeException(installErrorString);
                    }
                    Log.d((String)"Benchmark", (String)installErrorString);
                }
            }
            if (this.warmupIterations > 0) {
                scope.setFlushArtProfiles$benchmark_macro_release(true);
                if (!(!scope.getHasFlushedArtProfiles$benchmark_macro_release())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                try {
                    int n = this.warmupIterations;
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        warmupBlock.invoke();
                    }
                    scope.killProcessAndFlushArtProfiles$benchmark_macro_release();
                    if (!scope.getHasFlushedArtProfiles$benchmark_macro_release()) {
                        boolean bl = false;
                        String string = "Process " + packageName + " never flushed profiles in any process - check that you launched the process, and that you only killed it with scope.killProcess, which will save profiles.";
                        throw new IllegalStateException(string.toString());
                    }
                    Companion.cmdPackageCompile$benchmark_macro_release(packageName, "speed-profile");
                }
                finally {
                    scope.setFlushArtProfiles$benchmark_macro_release(false);
                }
            }
        }

        @Override
        public boolean shouldReset$benchmark_macro_release() {
            return true;
        }

        @JvmOverloads
        public Partial(@NotNull BaselineProfileMode baselineProfileMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)baselineProfileMode), (String)"baselineProfileMode");
            this(baselineProfileMode, 0, 2, null);
        }

        @JvmOverloads
        public Partial() {
            this(null, 0, 3, null);
        }
    }
}

