/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.os.Build;
import androidx.benchmark.DeviceInfo;
import androidx.benchmark.macro.ExperimentalMetricApi;
import androidx.benchmark.macro.StartupMode;
import androidx.benchmark.perfetto.PerfettoTraceProcessor;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH \u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0011\u0082\u0001\b\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/macro/Metric;", "", "()V", "configure", "", "captureInfo", "Landroidx/benchmark/macro/Metric$CaptureInfo;", "configure$benchmark_macro_release", "getMeasurements", "", "Landroidx/benchmark/macro/Metric$Measurement;", "traceSession", "Landroidx/benchmark/perfetto/PerfettoTraceProcessor$Session;", "getMeasurements$benchmark_macro_release", "start", "start$benchmark_macro_release", "stop", "stop$benchmark_macro_release", "CaptureInfo", "Measurement", "Landroidx/benchmark/macro/ArtMetric;", "Landroidx/benchmark/macro/FrameTimingGfxInfoMetric;", "Landroidx/benchmark/macro/FrameTimingMetric;", "Landroidx/benchmark/macro/PowerMetric;", "Landroidx/benchmark/macro/StartupTimingLegacyMetric;", "Landroidx/benchmark/macro/StartupTimingMetric;", "Landroidx/benchmark/macro/TraceMetric;", "Landroidx/benchmark/macro/TraceSectionMetric;", "benchmark-macro_release"})
public abstract class Metric {
    private Metric() {
    }

    public void configure$benchmark_macro_release(@NotNull CaptureInfo captureInfo) {
        Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
    }

    public void start$benchmark_macro_release() {
    }

    public void stop$benchmark_macro_release() {
    }

    @NotNull
    public abstract List<Measurement> getMeasurements$benchmark_macro_release(@NotNull CaptureInfo var1, @NotNull PerfettoTraceProcessor.Session var2);

    public /* synthetic */ Metric(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0017"}, d2={"Landroidx/benchmark/macro/Metric$CaptureInfo;", "", "apiLevel", "", "targetPackageName", "", "testPackageName", "startupMode", "Landroidx/benchmark/macro/StartupMode;", "artMainlineVersion", "", "(ILjava/lang/String;Ljava/lang/String;Landroidx/benchmark/macro/StartupMode;Ljava/lang/Long;)V", "getApiLevel", "()I", "getArtMainlineVersion", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getStartupMode", "()Landroidx/benchmark/macro/StartupMode;", "getTargetPackageName", "()Ljava/lang/String;", "getTestPackageName", "Companion", "benchmark-macro_release"})
    @ExperimentalMetricApi
    public static final class CaptureInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int apiLevel;
        @NotNull
        private final String targetPackageName;
        @NotNull
        private final String testPackageName;
        @Nullable
        private final StartupMode startupMode;
        @Nullable
        private final Long artMainlineVersion;

        public CaptureInfo(int apiLevel, @NotNull String targetPackageName, @NotNull String testPackageName, @Nullable StartupMode startupMode, @Nullable Long artMainlineVersion) {
            Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
            Intrinsics.checkNotNullParameter((Object)testPackageName, (String)"testPackageName");
            this.apiLevel = apiLevel;
            this.targetPackageName = targetPackageName;
            this.testPackageName = testPackageName;
            this.startupMode = startupMode;
            this.artMainlineVersion = artMainlineVersion;
            Long expectedArtMainlineVersion = Companion.expectedArtMainlineVersion$benchmark_macro_release(this.apiLevel);
            if (expectedArtMainlineVersion != null) {
                if (!Intrinsics.areEqual((Object)this.artMainlineVersion, (Object)expectedArtMainlineVersion)) {
                    boolean $i$a$-require-Metric$CaptureInfo$32 = false;
                    String $i$a$-require-Metric$CaptureInfo$32 = "For API level " + this.apiLevel + ", expected artMainlineVersion to be " + expectedArtMainlineVersion + ", observed " + this.artMainlineVersion;
                    throw new IllegalArgumentException($i$a$-require-Metric$CaptureInfo$32.toString());
                }
            } else if (this.artMainlineVersion != null && !(this.artMainlineVersion > 1L)) {
                boolean bl = false;
                String string = "For API level " + this.apiLevel + ", expected artMainlineVersion to be > 1, observed " + this.artMainlineVersion;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ CaptureInfo(int n, String string, String string2, StartupMode startupMode, Long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                l = Companion.expectedArtMainlineVersion$benchmark_macro_release(n);
            }
            this(n, string, string2, startupMode, l);
        }

        public final int getApiLevel() {
            return this.apiLevel;
        }

        @NotNull
        public final String getTargetPackageName() {
            return this.targetPackageName;
        }

        @NotNull
        public final String getTestPackageName() {
            return this.testPackageName;
        }

        @Nullable
        public final StartupMode getStartupMode() {
            return this.startupMode;
        }

        @Nullable
        public final Long getArtMainlineVersion() {
            return this.artMainlineVersion;
        }

        @JvmStatic
        @NotNull
        public static final CaptureInfo forLocalCapture(@NotNull String targetPackageName, @Nullable StartupMode startupMode) {
            return Companion.forLocalCapture(targetPackageName, startupMode);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/Metric$CaptureInfo$Companion;", "", "()V", "expectedArtMainlineVersion", "", "apiLevel", "", "expectedArtMainlineVersion$benchmark_macro_release", "(I)Ljava/lang/Long;", "forLocalCapture", "Landroidx/benchmark/macro/Metric$CaptureInfo;", "targetPackageName", "", "startupMode", "Landroidx/benchmark/macro/StartupMode;", "benchmark-macro_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Long expectedArtMainlineVersion$benchmark_macro_release(int apiLevel) {
                return apiLevel == 30 ? Long.valueOf(1L) : (apiLevel < 30 ? Long.valueOf(-1L) : null);
            }

            @JvmStatic
            @NotNull
            public final CaptureInfo forLocalCapture(@NotNull String targetPackageName, @Nullable StartupMode startupMode) {
                Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
                int n = Build.VERSION.SDK_INT;
                long l = DeviceInfo.INSTANCE.getArtMainlineVersion();
                String string = InstrumentationRegistry.getInstrumentation().getContext().getPackageName();
                Intrinsics.checkNotNull((Object)string);
                return new CaptureInfo(n, targetPackageName, string, startupMode, l);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\tB%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Landroidx/benchmark/macro/Metric$Measurement;", "", "name", "", "data", "", "(Ljava/lang/String;D)V", "dataSamples", "", "(Ljava/lang/String;Ljava/util/List;)V", "requireSingleValue", "", "(Ljava/lang/String;Ljava/util/List;Z)V", "getData", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getRequireSingleValue", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "benchmark-macro_release"})
    @ExperimentalMetricApi
    public static final class Measurement {
        @NotNull
        private final String name;
        @NotNull
        private final List<Double> data;
        private final boolean requireSingleValue;

        public Measurement(@NotNull String name, @NotNull List<Double> data, boolean requireSingleValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.name = name;
            this.data = data;
            this.requireSingleValue = requireSingleValue;
            if (!(!this.requireSingleValue || this.data.size() == 1)) {
                boolean bl = false;
                String string = "Metric.Measurement must be in multi-sample mode, or include only one data item";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Double> getData() {
            return this.data;
        }

        public final boolean getRequireSingleValue() {
            return this.requireSingleValue;
        }

        public Measurement(@NotNull String name, double data) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name, CollectionsKt.listOf((Object)data), true);
        }

        public Measurement(@NotNull String name, @NotNull List<Double> dataSamples) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dataSamples, (String)"dataSamples");
            this(name, dataSamples, false);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<Double> component2() {
            return this.data;
        }

        public final boolean component3() {
            return this.requireSingleValue;
        }

        @NotNull
        public final Measurement copy(@NotNull String name, @NotNull List<Double> data, boolean requireSingleValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new Measurement(name, data, requireSingleValue);
        }

        public static /* synthetic */ Measurement copy$default(Measurement measurement, String string, List list, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = measurement.name;
            }
            if ((n & 2) != 0) {
                list = measurement.data;
            }
            if ((n & 4) != 0) {
                bl = measurement.requireSingleValue;
            }
            return measurement.copy(string, list, bl);
        }

        @NotNull
        public String toString() {
            return "Measurement(name=" + this.name + ", data=" + this.data + ", requireSingleValue=" + this.requireSingleValue + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.data).hashCode();
            result = result * 31 + Boolean.hashCode(this.requireSingleValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Measurement)) {
                return false;
            }
            Measurement measurement = (Measurement)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)measurement.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.data, measurement.data)) {
                return false;
            }
            return this.requireSingleValue == measurement.requireSingleValue;
        }
    }
}

