/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark.macro;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.benchmark.Arguments;
import androidx.benchmark.Shell;
import androidx.profileinstaller.ProfileInstallReceiver;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/benchmark/macro/ProfileInstallBroadcast;", "", "()V", "receiverName", "", "kotlin.jvm.PlatformType", "benchmarkOperation", "packageName", "operation", "Landroidx/benchmark/macro/ProfileInstallBroadcast$Operation;", "pid", "", "dropShaderCache", "installProfile", "saveProfile", "saveProfilesForAllProcesses", "Landroidx/benchmark/macro/ProfileInstallBroadcast$SaveProfileResult;", "skipFileOperation", "Operation", "SaveProfileResult", "benchmark-macro_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nProfileInstallBroadcast.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileInstallBroadcast.kt\nandroidx/benchmark/macro/ProfileInstallBroadcast\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1045#2:288\n1855#2,2:289\n*S KotlinDebug\n*F\n+ 1 ProfileInstallBroadcast.kt\nandroidx/benchmark/macro/ProfileInstallBroadcast\n*L\n261#1:288\n262#1:289,2\n*E\n"})
public final class ProfileInstallBroadcast {
    @NotNull
    public static final ProfileInstallBroadcast INSTANCE = new ProfileInstallBroadcast();
    private static final String receiverName = ProfileInstallReceiver.class.getName();

    private ProfileInstallBroadcast() {
    }

    @Nullable
    public final String installProfile(@NotNull String packageName) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)"Profile Installer - Install profile");
        String action = "androidx.profileinstaller.action.INSTALL_PROFILE";
        Integer result = Shell.INSTANCE.amBroadcast("-a " + action + ' ' + packageName + '/' + receiverName);
        if (result == null ? true : result == 0) {
            return "The baseline profile install broadcast was not received. This most likely means that the profileinstaller library is missing from the target apk.";
        }
        Integer n = result;
        int n2 = 1;
        if (n != null && n == n2) {
            return null;
        }
        Integer n3 = result;
        n2 = 2;
        if (n3 != null && n3 == n2) {
            throw new RuntimeException("Unable to install baseline profile. This most likely means that the latest version of the profileinstaller library is not being used. Please use the latest profileinstaller library version in the target app.");
        }
        Integer n4 = result;
        n2 = 3;
        if (n4 != null && n4 == n2) {
            int sdkInt = Build.VERSION.SDK_INT;
            throw new RuntimeException(sdkInt <= 23 ? "Baseline profiles aren't supported on this device version, as all apps are fully ahead-of-time compiled." : "The device SDK version (" + sdkInt + ") isn't supported by the target app's copy of profileinstaller." + ((31 <= sdkInt ? sdkInt < 34 : false) ? " Please use profileinstaller `1.2.1` or newer for API 31-33 support" : (sdkInt >= 34 ? " Please use profileinstaller `1.4.0` or newer for API 34+ support" : "")));
        }
        Integer n5 = result;
        n2 = 6;
        if (n5 != null && n5 == n2) {
            return "No baseline profile was found in the target apk.";
        }
        Integer n6 = result;
        n2 = 4;
        if (n6 != null && n6 == n2) {
            bl3 = true;
        } else {
            Integer n7 = result;
            n2 = 5;
            bl3 = n7 != null && n7 == n2;
        }
        if (bl3) {
            bl2 = true;
        } else {
            Integer n8 = result;
            n2 = 7;
            bl2 = n8 != null && n8 == n2;
        }
        if (bl2) {
            bl = true;
        } else {
            Integer n9 = result;
            n2 = 8;
            bl = n9 != null && n9 == n2;
        }
        if (bl) {
            throw new RuntimeException("Baseline Profile wasn't successfully installed");
        }
        throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String skipFileOperation(@NotNull String packageName, @NotNull String operation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Log.d((String)"Benchmark", (String)("Profile Installer - Skip File Operation: " + operation));
        String action = "androidx.profileinstaller.action.SKIP_FILE";
        String operationKey = "EXTRA_SKIP_FILE_OPERATION";
        String extras = operationKey + ' ' + operation;
        Integer result = Shell.INSTANCE.amBroadcast("-a " + action + " -e " + extras + ' ' + packageName + '/' + receiverName);
        if (result == null) return "The baseline profile skip file broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.2.0-alpha03` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        if (result == 0) {
            return "The baseline profile skip file broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `1.2.0-alpha03` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"WRITE_SKIP_FILE")) {
            n = 10;
            if (result == n) {
                return null;
            }
        }
        if (!Intrinsics.areEqual((Object)operation, (Object)"DELETE_SKIP_FILE")) throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
        n = 11;
        if (result != n) throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
        return null;
    }

    @RequiresApi(value=24)
    @Nullable
    public final String saveProfile(@NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Log.d((String)"Benchmark", (String)"Profile Installer - Save Profile");
        String action = "androidx.profileinstaller.action.SAVE_PROFILE";
        Integer result = Shell.INSTANCE.amBroadcast("-a " + action + ' ' + packageName + '/' + receiverName);
        if (result == null ? true : result == 0) {
            string = "The save profile broadcast event was not received. This can be because the specified package name is incorrect or the `androidx.profileinstaller` library used by the target apk is old. Please use version `1.3.1` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller.";
        } else {
            Integer n = result;
            int n2 = 12;
            if (n != null && n == n2) {
                Thread.sleep(1000L);
                string = null;
            } else {
                throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
            }
        }
        return string;
    }

    private final String benchmarkOperation(String packageName, Operation operation, int pid) {
        String string;
        int n;
        boolean bl;
        String string2;
        Log.d((String)"Benchmark", (String)("Profile Installer - Benchmark Operation: " + operation.getExtraValue()));
        String action = "androidx.profileinstaller.action.BENCHMARK_OPERATION";
        String operationKey = "EXTRA_BENCHMARK_OPERATION";
        if (pid != -1) {
            if (!(operation == Operation.SaveProfile)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            string2 = " --ei EXTRA_PID " + pid;
        } else {
            if (!(operation != Operation.SaveProfile)) {
                String string4 = "Failed requirement.";
                throw new IllegalArgumentException(string4.toString());
            }
            string2 = "";
        }
        String pidExtra = string2;
        String broadcastArguments = "-a " + action + " -e " + operationKey + ' ' + operation.getExtraValue() + pidExtra + ' ' + packageName + '/' + receiverName;
        Integer result = Shell.INSTANCE.amBroadcast(broadcastArguments);
        if (result == null ? true : result == 0) {
            bl = true;
        } else {
            Integer n2 = result;
            n = 16;
            bl = n2 != null && n2 == n;
        }
        if (bl) {
            string = "The " + operation.getExtraValue() + " broadcast was not received. This most likely means that the `androidx.profileinstaller` library used by the target apk is old. Please use `" + operation.getMinimumVersion() + "` or newer. For more information refer to the release notes at https://developer.android.com/jetpack/androidx/releases/profileinstaller. If you are already using androidx.profileinstaller library and still seeing error, verify: 1) androidx.profileinstaller.ProfileInstallReceiver appears unobfuscated in your APK's AndroidManifest and dex, and 2) the following command executes successfully (should print 14): adb shell am broadcast " + broadcastArguments;
        } else {
            Integer n3 = result;
            n = 15;
            if (n3 != null && n3 == n) {
                string = "The " + (Object)((Object)operation) + " broadcast failed.";
            } else {
                Integer n4 = result;
                n = operation.getSuccessCode();
                if (n4 != null && n4 == n) {
                    string = null;
                } else {
                    throw new RuntimeException("unrecognized ProfileInstaller result code: " + result);
                }
            }
        }
        return string;
    }

    static /* synthetic */ String benchmarkOperation$default(ProfileInstallBroadcast profileInstallBroadcast, String string, Operation operation, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return profileInstallBroadcast.benchmarkOperation(string, operation, n);
    }

    @Nullable
    public final String dropShaderCache(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return ProfileInstallBroadcast.benchmarkOperation$default(this, packageName, Operation.DropShaderCache, 0, 4, null);
    }

    @SuppressLint(value={"BanThreadSleep"})
    @RequiresApi(value=24)
    @NotNull
    public final SaveProfileResult saveProfilesForAllProcesses(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        List processes = Shell.INSTANCE.getRunningPidsAndProcessesForPackage(packageName);
        Iterable $this$sortedBy$iv = processes;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Shell.ProcessPid it = (Shell.ProcessPid)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getProcessName());
                it = (Shell.ProcessPid)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getProcessName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String error;
            Shell.ProcessPid runningProcess = (Shell.ProcessPid)element$iv;
            boolean bl = false;
            Log.d((String)"Benchmark", (String)("Saving profiles for process " + runningProcess));
            if (StringsKt.contains$default((CharSequence)runningProcess.getProcessName(), (CharSequence)":", (boolean)false, (int)2, null)) {
                error = INSTANCE.benchmarkOperation(packageName, Operation.SaveProfile, runningProcess.getPid());
                if (error != null) {
                    return new SaveProfileResult(processes.size(), error);
                }
                Thread.sleep(Arguments.INSTANCE.getSaveProfileWaitMillis());
                continue;
            }
            error = INSTANCE.saveProfile(packageName);
            if (error == null) continue;
            return new SaveProfileResult(processes.size(), error);
        }
        return new SaveProfileResult(processes.size(), null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/benchmark/macro/ProfileInstallBroadcast$Operation;", "", "extraValue", "", "minimumVersion", "successCode", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;I)V", "getExtraValue", "()Ljava/lang/String;", "getMinimumVersion", "getSuccessCode", "()I", "DropShaderCache", "SaveProfile", "benchmark-macro_release"})
    public static final class Operation
    extends Enum<Operation> {
        @NotNull
        private final String extraValue;
        @NotNull
        private final String minimumVersion;
        private final int successCode;
        public static final /* enum */ Operation DropShaderCache = new Operation("DROP_SHADER_CACHE", "1.3.0-alpha02", 14);
        public static final /* enum */ Operation SaveProfile = new Operation("SAVE_PROFILE", "1.5.0-alpha01", 12);
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Operation(String extraValue, String minimumVersion, int successCode) {
            this.extraValue = extraValue;
            this.minimumVersion = minimumVersion;
            this.successCode = successCode;
        }

        @NotNull
        public final String getExtraValue() {
            return this.extraValue;
        }

        @NotNull
        public final String getMinimumVersion() {
            return this.minimumVersion;
        }

        public final int getSuccessCode() {
            return this.successCode;
        }

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        @NotNull
        public static EnumEntries<Operation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.DropShaderCache, Operation.SaveProfile};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/benchmark/macro/ProfileInstallBroadcast$SaveProfileResult;", "", "processCount", "", "error", "", "(ILjava/lang/String;)V", "getError", "()Ljava/lang/String;", "getProcessCount", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "benchmark-macro_release"})
    public static final class SaveProfileResult {
        private final int processCount;
        @Nullable
        private final String error;

        public SaveProfileResult(int processCount, @Nullable String error) {
            this.processCount = processCount;
            this.error = error;
        }

        public final int getProcessCount() {
            return this.processCount;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final int component1() {
            return this.processCount;
        }

        @Nullable
        public final String component2() {
            return this.error;
        }

        @NotNull
        public final SaveProfileResult copy(int processCount, @Nullable String error) {
            return new SaveProfileResult(processCount, error);
        }

        public static /* synthetic */ SaveProfileResult copy$default(SaveProfileResult saveProfileResult, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = saveProfileResult.processCount;
            }
            if ((n2 & 2) != 0) {
                string = saveProfileResult.error;
            }
            return saveProfileResult.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "SaveProfileResult(processCount=" + this.processCount + ", error=" + this.error + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.processCount);
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaveProfileResult)) {
                return false;
            }
            SaveProfileResult saveProfileResult = (SaveProfileResult)other;
            if (this.processCount != saveProfileResult.processCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)saveProfileResult.error);
        }
    }
}

