/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.SurfaceRequest;

final class AutoValue_SurfaceRequest_TransformationInfo
extends SurfaceRequest.TransformationInfo {
    private final Rect cropRect;
    private final int rotationDegrees;
    private final int targetRotation;

    AutoValue_SurfaceRequest_TransformationInfo(Rect cropRect, int rotationDegrees, int targetRotation) {
        if (cropRect == null) {
            throw new NullPointerException("Null cropRect");
        }
        this.cropRect = cropRect;
        this.rotationDegrees = rotationDegrees;
        this.targetRotation = targetRotation;
    }

    @Override
    @NonNull
    public Rect getCropRect() {
        return this.cropRect;
    }

    @Override
    public int getRotationDegrees() {
        return this.rotationDegrees;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getTargetRotation() {
        return this.targetRotation;
    }

    public String toString() {
        return "TransformationInfo{cropRect=" + this.cropRect + ", rotationDegrees=" + this.rotationDegrees + ", targetRotation=" + this.targetRotation + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SurfaceRequest.TransformationInfo) {
            SurfaceRequest.TransformationInfo that = (SurfaceRequest.TransformationInfo)o;
            return this.cropRect.equals((Object)that.getCropRect()) && this.rotationDegrees == that.getRotationDegrees() && this.targetRotation == that.getTargetRotation();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.cropRect.hashCode();
        h$ *= 1000003;
        h$ ^= this.rotationDegrees;
        h$ *= 1000003;
        return h$ ^= this.targetRotation;
    }
}

