/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.location.Location;
import android.media.ImageReader;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.CameraClosedException;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.CaptureProcessorPipeline;
import androidx.camera.core.ExperimentalZeroShutterLag;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageSaver;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.ModifiableImageReaderProxy;
import androidx.camera.core.ProcessingImageReader;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.SingleCloseImageProxy;
import androidx.camera.core.UseCase;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.MutableTagBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.IoConfig;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.YuvToJpegProcessor;
import androidx.camera.core.internal.compat.quirk.SoftwareJpegEncodingPreferredQuirk;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public final class ImageCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    @ExperimentalZeroShutterLag
    public static final int CAPTURE_MODE_ZERO_SHUTTER_LAG = 2;
    private static final int FLASH_MODE_UNKNOWN = -1;
    public static final int FLASH_MODE_AUTO = 0;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_ONE_SHOT_FLASH = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FLASH_TYPE_USE_TORCH_AS_FLASH = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "ImageCapture";
    private static final int MAX_IMAGES = 2;
    private static final byte JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    private static final byte JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;
    private static final int DEFAULT_CAPTURE_MODE = 1;
    private static final int DEFAULT_FLASH_MODE = 2;
    boolean mUseProcessingPipeline = false;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    private final ImageReaderProxy.OnImageAvailableListener mClosingListener = imageReader -> {
        try (ImageProxy image = imageReader.acquireLatestImage();){
            Log.d((String)TAG, (String)("Discarding ImageProxy which was inadvertently acquired: " + image));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
        }
    };
    @NonNull
    final Executor mIoExecutor;
    private final int mCaptureMode;
    @GuardedBy(value="mLockedFlashMode")
    private final AtomicReference<Integer> mLockedFlashMode = new AtomicReference<Object>(null);
    private final int mFlashType;
    @GuardedBy(value="mLockedFlashMode")
    private int mFlashMode = -1;
    private Rational mCropAspectRatio = null;
    private ExecutorService mExecutor;
    private CaptureConfig mCaptureConfig;
    private CaptureBundle mCaptureBundle;
    private int mMaxCaptureStages;
    private CaptureProcessor mCaptureProcessor;
    private boolean mUseSoftwareJpeg = false;
    SessionConfig.Builder mSessionConfigBuilder;
    SafeCloseImageReaderProxy mImageReader;
    ProcessingImageReader mProcessingImageReader;
    private ListenableFuture<Void> mImageReaderCloseFuture = Futures.immediateFuture(null);
    private CameraCaptureCallback mMetadataMatchingCaptureCallback;
    private DeferrableSurface mDeferrableSurface;
    private ImageCaptureRequestProcessor mImageCaptureRequestProcessor;
    final Executor mSequentialIoExecutor;
    private ImagePipeline mImagePipeline;
    private TakePictureManager mTakePictureManager;
    private final ImageCaptureControl mImageCaptureControl = new ImageCaptureControl(){

        @Override
        @MainThread
        public void lockFlashMode() {
            ImageCapture.this.lockFlashMode();
        }

        @Override
        @MainThread
        public void unlockFlashMode() {
            ImageCapture.this.unlockFlashMode();
        }

        @Override
        @MainThread
        @NonNull
        public ListenableFuture<Void> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs) {
            return ImageCapture.this.submitStillCaptureRequest(captureConfigs);
        }
    };

    ImageCapture(@NonNull ImageCaptureConfig userConfig) {
        super(userConfig);
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        this.mCaptureMode = useCaseConfig.containsOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE) ? useCaseConfig.getCaptureMode() : 1;
        this.mFlashType = useCaseConfig.getFlashType(0);
        this.mIoExecutor = (Executor)Preconditions.checkNotNull((Object)useCaseConfig.getIoExecutor(CameraXExecutors.ioExecutor()));
        this.mSequentialIoExecutor = CameraXExecutors.newSequentialExecutor(this.mIoExecutor);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull ImageCaptureConfig config, @NonNull Size resolution) {
        Threads.checkMainThread();
        if (this.isNodeEnabled()) {
            return this.createPipelineWithNode(cameraId, config, resolution);
        }
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        YuvToJpegProcessor softwareJpegProcessor = null;
        if (Build.VERSION.SDK_INT >= 23 && this.getCaptureMode() == 2) {
            this.getCameraControl().addZslConfig(sessionConfigBuilder);
        }
        if (config.getImageReaderProxyProvider() != null) {
            this.mImageReader = new SafeCloseImageReaderProxy(config.getImageReaderProxyProvider().newInstance(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), 2, 0L));
            this.mMetadataMatchingCaptureCallback = new CameraCaptureCallback(){};
        } else if (this.isSessionProcessorEnabledInCurrentCamera()) {
            void var6_8;
            if (this.getImageFormat() == 256) {
                AndroidImageReaderProxy androidImageReaderProxy = new AndroidImageReaderProxy(ImageReader.newInstance((int)resolution.getWidth(), (int)resolution.getHeight(), (int)this.getImageFormat(), (int)2));
            } else {
                if (this.getImageFormat() != 35) throw new IllegalArgumentException("Unsupported image format:" + this.getImageFormat());
                if (Build.VERSION.SDK_INT < 26) throw new UnsupportedOperationException("Does not support API level < 26");
                softwareJpegProcessor = new YuvToJpegProcessor(this.getJpegQualityInternal(), 2);
                ModifiableImageReaderProxy inputReader = new ModifiableImageReaderProxy(ImageReader.newInstance((int)resolution.getWidth(), (int)resolution.getHeight(), (int)35, (int)2));
                CaptureBundle captureBundle = CaptureBundles.singleDefaultCaptureBundle();
                ProcessingImageReader processingImageReader = new ProcessingImageReader.Builder(inputReader, captureBundle, softwareJpegProcessor).setPostProcessExecutor(this.mExecutor).setOutputFormat(256).build();
                MutableTagBundle tagBundle = MutableTagBundle.create();
                tagBundle.putTag(processingImageReader.getTagBundleKey(), captureBundle.getCaptureStages().get(0).getId());
                inputReader.setImageTagBundle(tagBundle);
                ProcessingImageReader processingImageReader2 = processingImageReader;
            }
            this.mMetadataMatchingCaptureCallback = new CameraCaptureCallback(){};
            this.mImageReader = new SafeCloseImageReaderProxy((ImageReaderProxy)var6_8);
        } else if (this.mCaptureProcessor != null || this.mUseSoftwareJpeg) {
            void var6_13;
            CaptureProcessor captureProcessor = this.mCaptureProcessor;
            int inputFormat = this.getImageFormat();
            int outputFormat = this.getImageFormat();
            if (this.mUseSoftwareJpeg) {
                if (Build.VERSION.SDK_INT < 26) throw new IllegalStateException("Software JPEG only supported on API 26+");
                Logger.i(TAG, "Using software JPEG encoder.");
                if (this.mCaptureProcessor != null) {
                    softwareJpegProcessor = new YuvToJpegProcessor(this.getJpegQualityInternal(), this.mMaxCaptureStages);
                    CaptureProcessorPipeline captureProcessorPipeline = new CaptureProcessorPipeline(this.mCaptureProcessor, this.mMaxCaptureStages, softwareJpegProcessor, this.mExecutor);
                } else {
                    YuvToJpegProcessor yuvToJpegProcessor = softwareJpegProcessor = new YuvToJpegProcessor(this.getJpegQualityInternal(), this.mMaxCaptureStages);
                }
                outputFormat = 256;
            }
            this.mProcessingImageReader = new ProcessingImageReader.Builder(resolution.getWidth(), resolution.getHeight(), inputFormat, this.mMaxCaptureStages, this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()), (CaptureProcessor)var6_13).setPostProcessExecutor(this.mExecutor).setOutputFormat(outputFormat).build();
            this.mMetadataMatchingCaptureCallback = this.mProcessingImageReader.getCameraCaptureCallback();
            this.mImageReader = new SafeCloseImageReaderProxy(this.mProcessingImageReader);
        } else {
            MetadataImageReader metadataImageReader = new MetadataImageReader(resolution.getWidth(), resolution.getHeight(), this.getImageFormat(), 2);
            this.mMetadataMatchingCaptureCallback = metadataImageReader.getCameraCaptureCallback();
            this.mImageReader = new SafeCloseImageReaderProxy(metadataImageReader);
        }
        if (this.mImageCaptureRequestProcessor != null) {
            this.mImageCaptureRequestProcessor.cancelRequests(new CancellationException("Request is canceled."));
        }
        YuvToJpegProcessor yuvToJpegProcessor = softwareJpegProcessor;
        this.mImageCaptureRequestProcessor = new ImageCaptureRequestProcessor(2, this::takePictureInternal, yuvToJpegProcessor == null ? null : imageCaptureRequest -> {
            if (Build.VERSION.SDK_INT >= 26) {
                yuvToJpegProcessor.setJpegQuality(imageCaptureRequest.mJpegQuality);
                yuvToJpegProcessor.setRotationDegrees(imageCaptureRequest.mRotationDegrees);
            }
        });
        this.mImageReader.setOnImageAvailableListener(this.mClosingListener, CameraXExecutors.mainThreadExecutor());
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(Objects.requireNonNull(this.mImageReader.getSurface()), new Size(this.mImageReader.getWidth(), this.mImageReader.getHeight()), this.getImageFormat());
        this.mImageReaderCloseFuture = this.mProcessingImageReader != null ? this.mProcessingImageReader.getCloseFuture() : Futures.immediateFuture(null);
        this.mDeferrableSurface.getTerminationFuture().addListener(this.mImageReader::safeClose, (Executor)CameraXExecutors.mainThreadExecutor());
        sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            List<ImageCaptureRequest> pendingRequests = this.mImageCaptureRequestProcessor != null ? this.mImageCaptureRequestProcessor.pullOutUnfinishedRequests() : Collections.emptyList();
            this.clearPipeline();
            if (this.isCurrentCamera(cameraId)) {
                this.mSessionConfigBuilder = this.createPipeline(cameraId, config, resolution);
                if (this.mImageCaptureRequestProcessor != null) {
                    for (ImageCaptureRequest request : pendingRequests) {
                        this.mImageCaptureRequestProcessor.sendRequest(request);
                    }
                }
                this.updateSessionConfig(this.mSessionConfigBuilder.build());
                this.notifyReset();
            }
        });
        return sessionConfigBuilder;
    }

    private boolean isSessionProcessorEnabledInCurrentCamera() {
        if (this.getCamera() == null) {
            return false;
        }
        CameraConfig cameraConfig = this.getCamera().getExtendedConfig();
        return cameraConfig.getSessionProcessor(null) != null;
    }

    @UiThread
    void clearPipeline() {
        Threads.checkMainThread();
        if (this.isNodeEnabled()) {
            this.clearPipelineWithNode();
            return;
        }
        if (this.mImageCaptureRequestProcessor != null) {
            this.mImageCaptureRequestProcessor.cancelRequests(new CancellationException("Request is canceled."));
            this.mImageCaptureRequestProcessor = null;
        }
        DeferrableSurface deferrableSurface = this.mDeferrableSurface;
        this.mDeferrableSurface = null;
        this.mImageReader = null;
        this.mProcessingImageReader = null;
        this.mImageReaderCloseFuture = Futures.immediateFuture(null);
        if (deferrableSurface != null) {
            deferrableSurface.close();
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.IMAGE_CAPTURE, this.getCaptureMode());
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        if (builder.getUseCaseConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null && Build.VERSION.SDK_INT >= 29) {
            Logger.i(TAG, "Requesting software JPEG due to a CaptureProcessor is set.");
            builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true);
        } else if (cameraInfo.getCameraQuirks().contains(SoftwareJpegEncodingPreferredQuirk.class)) {
            if (Boolean.FALSE.equals(builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true))) {
                Logger.w(TAG, "Device quirk suggests software JPEG encoder, but it has been explicitly disabled.");
            } else {
                Logger.i(TAG, "Requesting software JPEG due to device quirk.");
                builder.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, true);
            }
        }
        boolean useSoftwareJpeg = ImageCapture.enforceSoftwareJpegConstraints(builder.getMutableConfig());
        Integer bufferFormat = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            Preconditions.checkArgument((builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) == null ? 1 : 0) != 0, (Object)"Cannot set buffer format with CaptureProcessor defined.");
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, useSoftwareJpeg ? 35 : bufferFormat);
        } else if (builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null || useSoftwareJpeg) {
            builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
        } else {
            List supportedSizes = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, null);
            if (supportedSizes == null) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 256)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            } else if (ImageCapture.isImageFormatSupported(supportedSizes, 35)) {
                builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            }
        }
        Integer maxCaptureStages = builder.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, 2);
        Preconditions.checkNotNull((Object)maxCaptureStages, (Object)"Maximum outstanding image count must be at least 1");
        Preconditions.checkArgument((maxCaptureStages >= 1 ? 1 : 0) != 0, (Object)"Maximum outstanding image count must be at least 1");
        return builder.getUseCaseConfig();
    }

    private static boolean isImageFormatSupported(List<Pair<Integer, Size[]>> supportedSizes, int imageFormat) {
        if (supportedSizes == null) {
            return false;
        }
        for (Pair<Integer, Size[]> supportedSize : supportedSizes) {
            if (!((Integer)supportedSize.first).equals(imageFormat)) continue;
            return true;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onCameraControlReady() {
        this.trySetFlashModeToCameraControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            return this.mFlashMode != -1 ? this.mFlashMode : ((ImageCaptureConfig)this.getCurrentConfig()).getFlashMode(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlashMode(int flashMode) {
        if (flashMode != 0 && flashMode != 1 && flashMode != 2) {
            throw new IllegalArgumentException("Invalid flash mode: " + flashMode);
        }
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            this.mFlashMode = flashMode;
            this.trySetFlashModeToCameraControl();
        }
    }

    public void setCropAspectRatio(@NonNull Rational aspectRatio) {
        this.mCropAspectRatio = aspectRatio;
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public void setTargetRotation(int rotation) {
        int oldRotation = this.getTargetRotation();
        if (this.setTargetRotationInternal(rotation) && this.mCropAspectRatio != null) {
            int oldRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(oldRotation);
            int newRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(rotation);
            this.mCropAspectRatio = ImageUtil.getRotatedAspectRatio(Math.abs(newRotationDegrees - oldRotationDegrees), this.mCropAspectRatio);
        }
    }

    public int getCaptureMode() {
        return this.mCaptureMode;
    }

    @IntRange(from=1L, to=100L)
    public int getJpegQuality() {
        return this.getJpegQualityInternal();
    }

    @Override
    @Nullable
    public ResolutionInfo getResolutionInfo() {
        return super.getResolutionInfo();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    protected ResolutionInfo getResolutionInfoInternal() {
        CameraInternal camera = this.getCamera();
        Size resolution = this.getAttachedSurfaceResolution();
        if (camera == null || resolution == null) {
            return null;
        }
        Rect cropRect = this.getViewPortCropRect();
        Rational cropAspectRatio = this.mCropAspectRatio;
        if (cropRect == null) {
            cropRect = cropAspectRatio != null ? ImageUtil.computeCropRectFromAspectRatio(resolution, cropAspectRatio) : new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
        }
        int rotationDegrees = this.getRelativeRotation(camera);
        return ResolutionInfo.create(resolution, Objects.requireNonNull(cropRect), rotationDegrees);
    }

    public void takePicture(@NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(executor, callback));
            return;
        }
        if (this.isNodeEnabled()) {
            this.takePictureWithNode(executor, callback, null, null);
            return;
        }
        this.sendImageCaptureRequest(executor, callback, false);
    }

    public void takePicture(final @NonNull OutputFileOptions outputFileOptions, final @NonNull Executor executor, final @NonNull OnImageSavedCallback imageSavedCallback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.takePicture(outputFileOptions, executor, imageSavedCallback));
            return;
        }
        if (this.isNodeEnabled()) {
            this.takePictureWithNode(executor, null, imageSavedCallback, outputFileOptions);
            return;
        }
        final ImageSaver.OnImageSavedCallback imageSavedCallbackWrapper = new ImageSaver.OnImageSavedCallback(){

            @Override
            public void onImageSaved(@NonNull OutputFileResults outputFileResults) {
                imageSavedCallback.onImageSaved(outputFileResults);
            }

            @Override
            public void onError(@NonNull ImageSaver.SaveError error, @NonNull String message, @Nullable Throwable cause) {
                int imageCaptureError = 0;
                if (error == ImageSaver.SaveError.FILE_IO_FAILED) {
                    imageCaptureError = 1;
                }
                imageSavedCallback.onError(new ImageCaptureException(imageCaptureError, message, cause));
            }
        };
        final int outputJpegQuality = this.getJpegQualityInternal();
        OnImageCapturedCallback imageCaptureCallbackWrapper = new OnImageCapturedCallback(){

            @Override
            public void onCaptureSuccess(@NonNull ImageProxy image) {
                ImageCapture.this.mIoExecutor.execute(new ImageSaver(image, outputFileOptions, image.getImageInfo().getRotationDegrees(), outputJpegQuality, executor, ImageCapture.this.mSequentialIoExecutor, imageSavedCallbackWrapper));
            }

            @Override
            public void onError(@NonNull ImageCaptureException exception) {
                imageSavedCallback.onError(exception);
            }
        };
        this.sendImageCaptureRequest(CameraXExecutors.mainThreadExecutor(), imageCaptureCallbackWrapper, true);
    }

    @NonNull
    static Rect computeDispatchCropRect(@Nullable Rect viewPortCropRect, @Nullable Rational cropAspectRatio, int rotationDegrees, @NonNull Size dispatchResolution, int dispatchRotationDegrees) {
        if (viewPortCropRect != null) {
            return ImageUtil.computeCropRectFromDispatchInfo(viewPortCropRect, rotationDegrees, dispatchResolution, dispatchRotationDegrees);
        }
        if (cropAspectRatio != null) {
            Rational aspectRatio = cropAspectRatio;
            if (dispatchRotationDegrees % 180 != 0) {
                aspectRatio = new Rational(cropAspectRatio.getDenominator(), cropAspectRatio.getNumerator());
            }
            if (ImageUtil.isAspectRatioValid(dispatchResolution, aspectRatio)) {
                return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(dispatchResolution, aspectRatio));
            }
        }
        return new Rect(0, 0, dispatchResolution.getWidth(), dispatchResolution.getHeight());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void onStateDetached() {
        this.abortImageCaptureRequests();
    }

    @UiThread
    private void abortImageCaptureRequests() {
        if (this.mImageCaptureRequestProcessor != null) {
            CameraClosedException throwable = new CameraClosedException("Camera is closed.");
            this.mImageCaptureRequestProcessor.cancelRequests(throwable);
        }
    }

    @UiThread
    private void sendImageCaptureRequest(@NonNull Executor callbackExecutor, @NonNull OnImageCapturedCallback callback, boolean saveImage) {
        CameraInternal attachedCamera = this.getCamera();
        if (attachedCamera == null) {
            callbackExecutor.execute(() -> callback.onError(new ImageCaptureException(4, "Not bound to a valid Camera [" + this + "]", null)));
            return;
        }
        if (this.mImageCaptureRequestProcessor == null) {
            callbackExecutor.execute(() -> callback.onError(new ImageCaptureException(0, "Request is canceled", null)));
            return;
        }
        this.mImageCaptureRequestProcessor.sendRequest(new ImageCaptureRequest(this.getRelativeRotation(attachedCamera), this.getJpegQualityForImageCaptureRequest(attachedCamera, saveImage), this.mCropAspectRatio, this.getViewPortCropRect(), this.getSensorToBufferTransformMatrix(), callbackExecutor, callback));
    }

    @UiThread
    private int getJpegQualityForImageCaptureRequest(@NonNull CameraInternal cameraInternal, boolean saveImage) {
        int jpegQuality;
        if (saveImage) {
            int rotationDegrees = this.getRelativeRotation(cameraInternal);
            Size dispatchResolution = Objects.requireNonNull(this.getAttachedSurfaceResolution());
            Rect cropRect = ImageCapture.computeDispatchCropRect(this.getViewPortCropRect(), this.mCropAspectRatio, rotationDegrees, dispatchResolution, rotationDegrees);
            boolean shouldCropImage = ImageUtil.shouldCropImage(dispatchResolution.getWidth(), dispatchResolution.getHeight(), cropRect.width(), cropRect.height());
            jpegQuality = shouldCropImage ? (this.mCaptureMode == 0 ? 100 : 95) : this.getJpegQualityInternal();
        } else {
            jpegQuality = this.getJpegQualityInternal();
        }
        return jpegQuality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.mLockedFlashMode.set(this.getFlashMode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockFlashMode() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            Integer lockedFlashMode = this.mLockedFlashMode.getAndSet(null);
            if (lockedFlashMode == null) {
                return;
            }
            if (lockedFlashMode.intValue() != this.getFlashMode()) {
                this.trySetFlashModeToCameraControl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetFlashModeToCameraControl() {
        AtomicReference<Integer> atomicReference = this.mLockedFlashMode;
        synchronized (atomicReference) {
            if (this.mLockedFlashMode.get() != null) {
                return;
            }
            this.getCameraControl().setFlashMode(this.getFlashMode());
        }
    }

    @IntRange(from=1L, to=100L)
    private int getJpegQualityInternal() {
        ImageCaptureConfig imageCaptureConfig = (ImageCaptureConfig)this.getCurrentConfig();
        if (imageCaptureConfig.containsOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY)) {
            return imageCaptureConfig.getJpegQuality();
        }
        switch (this.mCaptureMode) {
            case 0: {
                return 100;
            }
            case 1: 
            case 2: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mCaptureMode + " is invalid");
    }

    @NonNull
    private ListenableFuture<ImageProxy> takePictureInternal(@NonNull ImageCaptureRequest imageCaptureRequest) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mImageReader.setOnImageAvailableListener(imageReader -> {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        if (!completer.set((Object)image)) {
                            image.close();
                        }
                    } else {
                        completer.setException((Throwable)new IllegalStateException("Unable to acquire image"));
                    }
                }
                catch (IllegalStateException e) {
                    completer.setException((Throwable)e);
                }
            }, CameraXExecutors.mainThreadExecutor());
            this.lockFlashMode();
            ListenableFuture<Void> future = this.issueTakePicture(imageCaptureRequest);
            Futures.addCallback(future, new FutureCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                    ImageCapture.this.unlockFlashMode();
                }

                @Override
                public void onFailure(@NonNull Throwable throwable) {
                    ImageCapture.this.unlockFlashMode();
                    completer.setException(throwable);
                }
            }, this.mExecutor);
            completer.addCancellationListener(() -> future.cancel(true), CameraXExecutors.directExecutor());
            return "takePictureInternal";
        });
    }

    @NonNull
    public String toString() {
        return "ImageCapture:" + this.getName();
    }

    static int getError(Throwable throwable) {
        if (throwable instanceof CameraClosedException) {
            return 3;
        }
        if (throwable instanceof ImageCaptureException) {
            return ((ImageCaptureException)throwable).getImageCaptureError();
        }
        return 0;
    }

    static boolean enforceSoftwareJpegConstraints(@NonNull MutableConfig mutableConfig) {
        if (Boolean.TRUE.equals(mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false))) {
            Integer bufferFormat;
            boolean supported = true;
            if (Build.VERSION.SDK_INT < 26) {
                Logger.w(TAG, "Software JPEG only supported on API 26+, but current API level is " + Build.VERSION.SDK_INT);
                supported = false;
            }
            if ((bufferFormat = (Integer)mutableConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null)) != null && bufferFormat != 256) {
                Logger.w(TAG, "Software JPEG cannot be used with non-JPEG output buffer format.");
                supported = false;
            }
            if (!supported) {
                Logger.w(TAG, "Unable to support software JPEG. Disabling.");
                mutableConfig.insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, false);
            }
            return supported;
        }
        return false;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        ListenableFuture<Void> imageReaderCloseFuture = this.mImageReaderCloseFuture;
        this.abortImageCaptureRequests();
        this.clearPipeline();
        this.mUseSoftwareJpeg = false;
        ExecutorService executorService = this.mExecutor;
        imageReaderCloseFuture.addListener(executorService::shutdown, CameraXExecutors.directExecutor());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttached() {
        ImageCaptureConfig useCaseConfig = (ImageCaptureConfig)this.getCurrentConfig();
        CaptureConfig.Builder captureBuilder = CaptureConfig.Builder.createFrom(useCaseConfig);
        this.mCaptureConfig = captureBuilder.build();
        this.mCaptureProcessor = useCaseConfig.getCaptureProcessor(null);
        this.mMaxCaptureStages = useCaseConfig.getMaxCaptureStages(2);
        this.mCaptureBundle = useCaseConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
        this.mUseSoftwareJpeg = useCaseConfig.isSoftwareJpegEncoderRequested();
        CameraInternal camera = this.getCamera();
        Preconditions.checkNotNull((Object)camera, (Object)"Attached camera cannot be null");
        this.mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
            private final AtomicInteger mId = new AtomicInteger(0);

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "CameraX-image_capture_" + this.mId.getAndIncrement());
            }
        });
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        this.mSessionConfigBuilder = this.createPipeline(this.getCameraId(), (ImageCaptureConfig)this.getCurrentConfig(), suggestedResolution);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyActive();
        return suggestedResolution;
    }

    ListenableFuture<Void> issueTakePicture(@NonNull ImageCaptureRequest imageCaptureRequest) {
        List<CaptureStage> captureStages;
        CaptureBundle captureBundle;
        Logger.d(TAG, "issueTakePicture");
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        String tagBundleKey = null;
        if (this.mProcessingImageReader != null) {
            captureBundle = this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
            if (captureBundle == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture cannot set empty CaptureBundle."));
            }
            captureStages = captureBundle.getCaptureStages();
            if (captureStages == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture has CaptureBundle with null capture stages"));
            }
            if (this.mCaptureProcessor == null && captureStages.size() > 1) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("No CaptureProcessor can be found to process the images captured for multiple CaptureStages."));
            }
            if (captureStages.size() > this.mMaxCaptureStages) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture has CaptureStages > Max CaptureStage size"));
            }
            this.mProcessingImageReader.setCaptureBundle(captureBundle);
            this.mProcessingImageReader.setOnProcessingErrorCallback(CameraXExecutors.directExecutor(), (message, cause) -> {
                Logger.e(TAG, "Processing image failed! " + message);
                imageCaptureRequest.notifyCallbackError(2, message, cause);
            });
            tagBundleKey = this.mProcessingImageReader.getTagBundleKey();
        } else {
            captureBundle = this.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle());
            if (captureBundle == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture cannot set empty CaptureBundle."));
            }
            captureStages = captureBundle.getCaptureStages();
            if (captureStages == null) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture has CaptureBundle with null capture stages"));
            }
            if (captureStages.size() > 1) {
                return Futures.immediateFailedFuture(new IllegalArgumentException("ImageCapture have no CaptureProcess set with CaptureBundle size > 1."));
            }
        }
        for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks());
            builder.addSurface(this.mDeferrableSurface);
            if (this.getImageFormat() == 256) {
                if (EXIF_ROTATION_AVAILABILITY.isRotationOptionSupported()) {
                    builder.addImplementationOption(CaptureConfig.OPTION_ROTATION, imageCaptureRequest.mRotationDegrees);
                }
                builder.addImplementationOption(CaptureConfig.OPTION_JPEG_QUALITY, imageCaptureRequest.mJpegQuality);
            }
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            if (tagBundleKey != null) {
                builder.addTag(tagBundleKey, captureStage.getId());
            }
            builder.addCameraCaptureCallback(this.mMetadataMatchingCaptureCallback);
            captureConfigs.add(builder.build());
        }
        return this.submitStillCaptureRequest(captureConfigs);
    }

    private CaptureBundle getCaptureBundle(CaptureBundle defaultCaptureBundle) {
        List<CaptureStage> captureStages = this.mCaptureBundle.getCaptureStages();
        if (captureStages == null || captureStages.isEmpty()) {
            return defaultCaptureBundle;
        }
        return CaptureBundles.createCaptureBundle(captureStages);
    }

    @MainThread
    private boolean isNodeEnabled() {
        Threads.checkMainThread();
        ImageCaptureConfig config = (ImageCaptureConfig)this.getCurrentConfig();
        if (config.getImageReaderProxyProvider() != null) {
            return false;
        }
        if (this.isSessionProcessorEnabledInCurrentCamera()) {
            return false;
        }
        if (this.mCaptureProcessor != null) {
            return false;
        }
        if (this.getCaptureStageSize(config) > 1) {
            return false;
        }
        if (Objects.requireNonNull(config.retrieveOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256)) != 256) {
            return false;
        }
        return this.mUseProcessingPipeline;
    }

    private int getCaptureStageSize(@NonNull ImageCaptureConfig config) {
        CaptureBundle captureBundle = config.getCaptureBundle(null);
        if (captureBundle == null) {
            return 1;
        }
        List<CaptureStage> captureStages = captureBundle.getCaptureStages();
        if (captureStages == null) {
            return 1;
        }
        return captureStages.size();
    }

    @OptIn(markerClass={ExperimentalZeroShutterLag.class})
    @MainThread
    private SessionConfig.Builder createPipelineWithNode(@NonNull String cameraId, @NonNull ImageCaptureConfig config, @NonNull Size resolution) {
        Threads.checkMainThread();
        Log.d((String)TAG, (String)String.format("createPipelineWithNode(cameraId: %s, resolution: %s)", cameraId, resolution));
        Preconditions.checkState((this.mImagePipeline == null ? 1 : 0) != 0);
        this.mImagePipeline = new ImagePipeline(config, resolution);
        Preconditions.checkState((this.mTakePictureManager == null ? 1 : 0) != 0);
        this.mTakePictureManager = new TakePictureManager(this.mImageCaptureControl, this.mImagePipeline);
        SessionConfig.Builder sessionConfigBuilder = this.mImagePipeline.createSessionConfigBuilder();
        if (Build.VERSION.SDK_INT >= 23 && this.getCaptureMode() == 2) {
            this.getCameraControl().addZslConfig(sessionConfigBuilder);
        }
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            if (this.isCurrentCamera(cameraId)) {
                this.mTakePictureManager.pause();
                this.updateSessionConfig(this.mSessionConfigBuilder.build());
                this.notifyReset();
                this.mTakePictureManager.resume();
            } else {
                this.clearPipelineWithNode();
            }
        });
        return sessionConfigBuilder;
    }

    @MainThread
    private void takePictureWithNode(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback, @Nullable OutputFileOptions outputFileOptions) {
        Threads.checkMainThread();
        Log.d((String)TAG, (String)"takePictureWithNode");
        CameraInternal camera = this.getCamera();
        if (camera == null) {
            this.sendInvalidCameraError(executor, inMemoryCallback, onDiskCallback);
            return;
        }
        this.mTakePictureManager.offerRequest(TakePictureRequest.of(executor, inMemoryCallback, onDiskCallback, outputFileOptions, this.getTakePictureCropRect(), this.getSensorToBufferTransformMatrix(), this.getRelativeRotation(camera), this.getJpegQualityInternal(), this.getCaptureMode(), this.mSessionConfigBuilder.getSingleCameraCaptureCallbacks()));
    }

    private void sendInvalidCameraError(@NonNull Executor executor, @Nullable OnImageCapturedCallback inMemoryCallback, @Nullable OnImageSavedCallback onDiskCallback) {
        ImageCaptureException exception = new ImageCaptureException(4, "Not bound to a valid Camera [" + this + "]", null);
        if (inMemoryCallback != null) {
            inMemoryCallback.onError(exception);
        } else if (onDiskCallback != null) {
            onDiskCallback.onError(exception);
        } else {
            throw new IllegalArgumentException("Must have either in-memory or on-disk callback.");
        }
    }

    @NonNull
    private Rect getTakePictureCropRect() {
        Rect rect = this.getViewPortCropRect();
        Size resolution = Objects.requireNonNull(this.getAttachedSurfaceResolution());
        if (rect != null) {
            return rect;
        }
        if (ImageUtil.isAspectRatioValid(this.mCropAspectRatio)) {
            int rotationDegrees = this.getRelativeRotation(Objects.requireNonNull(this.getCamera()));
            Rational rotatedAspectRatio = new Rational(this.mCropAspectRatio.getDenominator(), this.mCropAspectRatio.getNumerator());
            Rational sensorCropRatio = TransformUtils.is90or270(rotationDegrees) ? rotatedAspectRatio : this.mCropAspectRatio;
            return Objects.requireNonNull(ImageUtil.computeCropRectFromAspectRatio(resolution, sensorCropRatio));
        }
        return new Rect(0, 0, resolution.getWidth(), resolution.getHeight());
    }

    @MainThread
    private void clearPipelineWithNode() {
        Log.d((String)TAG, (String)"clearPipelineWithNode");
        Threads.checkMainThread();
        this.mImagePipeline.close();
        this.mImagePipeline = null;
        this.mTakePictureManager.abortRequests();
        this.mTakePictureManager = null;
    }

    @MainThread
    ListenableFuture<Void> submitStillCaptureRequest(@NonNull List<CaptureConfig> captureConfigs) {
        Threads.checkMainThread();
        return Futures.transform(this.getCameraControl().submitStillCaptureRequests(captureConfigs, this.mCaptureMode, this.mFlashType), input -> null, CameraXExecutors.directExecutor());
    }

    @VisibleForTesting
    boolean isProcessingPipelineEnabled() {
        return this.mImagePipeline != null && this.mTakePictureManager != null;
    }

    public static final class Builder
    implements UseCaseConfig.Builder<ImageCapture, ImageCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    IoConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(ImageCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)ImageCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull ImageCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public ImageCaptureConfig getUseCaseConfig() {
            return new ImageCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public ImageCapture build() {
            Integer flashMode;
            if (this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            Integer bufferFormat = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
            if (bufferFormat != null) {
                Preconditions.checkArgument((this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) == null ? 1 : 0) != 0, (Object)"Cannot set buffer format with CaptureProcessor defined.");
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, bufferFormat);
            } else if (this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, null) != null) {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 35);
            } else {
                this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 256);
            }
            ImageCapture imageCapture = new ImageCapture(this.getUseCaseConfig());
            Size targetResolution = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, null);
            if (targetResolution != null) {
                imageCapture.setCropAspectRatio(new Rational(targetResolution.getWidth(), targetResolution.getHeight()));
            }
            Integer maxCaptureStages = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, 2);
            Preconditions.checkNotNull((Object)maxCaptureStages, (Object)"Maximum outstanding image count must be at least 1");
            Preconditions.checkArgument((maxCaptureStages >= 1 ? 1 : 0) != 0, (Object)"Maximum outstanding image count must be at least 1");
            Preconditions.checkNotNull((Object)this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, CameraXExecutors.ioExecutor()), (Object)"The IO executor can't be null");
            if (this.getMutableConfig().containsOption(ImageCaptureConfig.OPTION_FLASH_MODE) && ((flashMode = this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_FLASH_MODE)) == null || flashMode != 0 && flashMode != 1 && flashMode != 2)) {
                throw new IllegalArgumentException("The flash mode is not allowed to set: " + flashMode);
            }
            return imageCapture;
        }

        @NonNull
        public Builder setCaptureMode(int captureMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_CAPTURE_MODE, captureMode);
            return this;
        }

        @NonNull
        public Builder setFlashMode(int flashMode) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_MODE, flashMode);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureBundle(@NonNull CaptureBundle captureBundle) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_BUNDLE, captureBundle);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureProcessor(@NonNull CaptureProcessor captureProcessor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_PROCESSOR, captureProcessor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBufferFormat(int bufferImageFormat) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, bufferImageFormat);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMaxCaptureStages(int maxCaptureStages) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_CAPTURE_STAGES, maxCaptureStages);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<ImageCapture> targetClass) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(ImageCaptureConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setImageReaderProxyProvider(@NonNull ImageReaderProxyProvider imageReaderProxyProvider) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IMAGE_READER_PROXY_PROVIDER, imageReaderProxyProvider);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setSoftwareJpegEncoderRequested(boolean requestSoftwareJpeg) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_SOFTWARE_JPEG_ENCODER, requestSoftwareJpeg);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setFlashType(int flashType) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_FLASH_TYPE, flashType);
            return this;
        }

        @NonNull
        public Builder setJpegQuality(@IntRange(from=1L, to=100L) int jpegQuality) {
            Preconditions.checkArgumentInRange((int)jpegQuality, (int)1, (int)100, (String)"jpegQuality");
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_JPEG_COMPRESSION_QUALITY, jpegQuality);
            return this;
        }

        @Override
        @NonNull
        public Builder setIoExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_IO_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(ImageCaptureConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }
    }

    @VisibleForTesting
    static class ImageCaptureRequest {
        final int mRotationDegrees;
        @IntRange(from=1L, to=100L)
        final int mJpegQuality;
        private final Rational mTargetRatio;
        @NonNull
        private final Executor mListenerExecutor;
        @NonNull
        private final OnImageCapturedCallback mCallback;
        AtomicBoolean mDispatched = new AtomicBoolean(false);
        private final Rect mViewPortCropRect;
        @NonNull
        private final Matrix mSensorToBufferTransformMatrix;

        ImageCaptureRequest(int rotationDegrees, @IntRange(from=1L, to=100L) int jpegQuality, Rational targetRatio, @Nullable Rect viewPortCropRect, @NonNull Matrix sensorToBufferTransformMatrix, @NonNull Executor executor, @NonNull OnImageCapturedCallback callback) {
            this.mRotationDegrees = rotationDegrees;
            this.mJpegQuality = jpegQuality;
            if (targetRatio != null) {
                Preconditions.checkArgument((!targetRatio.isZero() ? 1 : 0) != 0, (Object)"Target ratio cannot be zero");
                Preconditions.checkArgument((targetRatio.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"Target ratio must be positive");
            }
            this.mTargetRatio = targetRatio;
            this.mViewPortCropRect = viewPortCropRect;
            this.mSensorToBufferTransformMatrix = sensorToBufferTransformMatrix;
            this.mListenerExecutor = executor;
            this.mCallback = callback;
        }

        void dispatchImage(ImageProxy image) {
            int dispatchRotationDegrees;
            Size dispatchResolution;
            if (!this.mDispatched.compareAndSet(false, true)) {
                image.close();
                return;
            }
            if (EXIF_ROTATION_AVAILABILITY.shouldUseExifOrientation(image)) {
                try {
                    ImageProxy.PlaneProxy[] planes = image.getPlanes();
                    ByteBuffer buffer = planes[0].getBuffer();
                    buffer.rewind();
                    byte[] data = new byte[buffer.capacity()];
                    buffer.get(data);
                    Exif exif = Exif.createFromInputStream(new ByteArrayInputStream(data));
                    buffer.rewind();
                    dispatchResolution = new Size(exif.getWidth(), exif.getHeight());
                    dispatchRotationDegrees = exif.getRotation();
                }
                catch (IOException e) {
                    this.notifyCallbackError(1, "Unable to parse JPEG exif", e);
                    image.close();
                    return;
                }
            } else {
                dispatchResolution = new Size(image.getWidth(), image.getHeight());
                dispatchRotationDegrees = this.mRotationDegrees;
            }
            ImageInfo imageInfo = ImmutableImageInfo.create(image.getImageInfo().getTagBundle(), image.getImageInfo().getTimestamp(), dispatchRotationDegrees, this.mSensorToBufferTransformMatrix);
            SettableImageProxy dispatchedImageProxy = new SettableImageProxy(image, dispatchResolution, imageInfo);
            Rect cropRect = ImageCapture.computeDispatchCropRect(this.mViewPortCropRect, this.mTargetRatio, this.mRotationDegrees, dispatchResolution, dispatchRotationDegrees);
            dispatchedImageProxy.setCropRect(cropRect);
            try {
                this.mListenerExecutor.execute(() -> this.mCallback.onCaptureSuccess(dispatchedImageProxy));
            }
            catch (RejectedExecutionException e) {
                Logger.e(ImageCapture.TAG, "Unable to post to the supplied executor.");
                image.close();
            }
        }

        void notifyCallbackError(int imageCaptureError, String message, Throwable cause) {
            if (!this.mDispatched.compareAndSet(false, true)) {
                return;
            }
            try {
                this.mListenerExecutor.execute(() -> this.mCallback.onError(new ImageCaptureException(imageCaptureError, message, cause)));
            }
            catch (RejectedExecutionException e) {
                Logger.e(ImageCapture.TAG, "Unable to post to the supplied executor.");
            }
        }
    }

    public static final class Metadata {
        private boolean mIsReversedHorizontal;
        private boolean mIsReversedHorizontalSet = false;
        private boolean mIsReversedVertical;
        @Nullable
        private Location mLocation;

        public boolean isReversedHorizontal() {
            return this.mIsReversedHorizontal;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isReversedHorizontalSet() {
            return this.mIsReversedHorizontalSet;
        }

        public void setReversedHorizontal(boolean isReversedHorizontal) {
            this.mIsReversedHorizontal = isReversedHorizontal;
            this.mIsReversedHorizontalSet = true;
        }

        public boolean isReversedVertical() {
            return this.mIsReversedVertical;
        }

        public void setReversedVertical(boolean isReversedVertical) {
            this.mIsReversedVertical = isReversedVertical;
        }

        @Nullable
        public Location getLocation() {
            return this.mLocation;
        }

        public void setLocation(@Nullable Location location) {
            this.mLocation = location;
        }
    }

    public static class OutputFileResults {
        @Nullable
        private final Uri mSavedUri;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputFileResults(@Nullable Uri savedUri) {
            this.mSavedUri = savedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    public static final class OutputFileOptions {
        @Nullable
        private final File mFile;
        @Nullable
        private final ContentResolver mContentResolver;
        @Nullable
        private final Uri mSaveCollection;
        @Nullable
        private final ContentValues mContentValues;
        @Nullable
        private final OutputStream mOutputStream;
        @NonNull
        private final Metadata mMetadata;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream, @Nullable Metadata metadata) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
            this.mMetadata = metadata == null ? new Metadata() : metadata;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public File getFile() {
            return this.mFile;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Metadata getMetadata() {
            return this.mMetadata;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private OutputStream mOutputStream;
            @Nullable
            private Metadata mMetadata;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@NonNull OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            @NonNull
            public Builder setMetadata(@NonNull Metadata metadata) {
                this.mMetadata = metadata;
                return this;
            }

            @NonNull
            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream, this.mMetadata);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<ImageCaptureConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 4;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final ImageCaptureConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public ImageCaptureConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setSurfaceOccupancyPriority(4).setTargetAspectRatio(0);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static abstract class OnImageCapturedCallback {
        public void onCaptureSuccess(@NonNull ImageProxy image) {
        }

        public void onError(@NonNull ImageCaptureException exception) {
        }
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(@NonNull ImageCaptureException var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ImageCaptureError {
    }

    @VisibleForTesting
    static class ImageCaptureRequestProcessor
    implements ForwardingImageProxy.OnImageCloseListener {
        @GuardedBy(value="mLock")
        private final Deque<ImageCaptureRequest> mPendingRequests = new ArrayDeque<ImageCaptureRequest>();
        @GuardedBy(value="mLock")
        ImageCaptureRequest mCurrentRequest = null;
        @GuardedBy(value="mLock")
        ListenableFuture<ImageProxy> mCurrentRequestFuture = null;
        @GuardedBy(value="mLock")
        int mOutstandingImages = 0;
        @GuardedBy(value="mLock")
        private final ImageCaptor mImageCaptor;
        private final int mMaxImages;
        @Nullable
        private final RequestProcessCallback mRequestProcessCallback;
        final Object mLock = new Object();

        ImageCaptureRequestProcessor(int maxImages, @NonNull ImageCaptor imageCaptor) {
            this(maxImages, imageCaptor, null);
        }

        ImageCaptureRequestProcessor(int maxImages, @NonNull ImageCaptor imageCaptor, @Nullable RequestProcessCallback requestProcessCallback) {
            this.mMaxImages = maxImages;
            this.mImageCaptor = imageCaptor;
            this.mRequestProcessCallback = requestProcessCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendRequest(@NonNull ImageCaptureRequest imageCaptureRequest) {
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingRequests.offer(imageCaptureRequest);
                Logger.d(ImageCapture.TAG, String.format(Locale.US, "Send image capture request [current, pending] = [%d, %d]", this.mCurrentRequest != null ? 1 : 0, this.mPendingRequests.size()));
                this.processNextRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelRequests(@NonNull Throwable throwable) {
            ArrayList<ImageCaptureRequest> pendingRequests;
            ListenableFuture<ImageProxy> currentRequestFuture;
            ImageCaptureRequest currentRequest;
            Iterator iterator = this.mLock;
            synchronized (iterator) {
                currentRequest = this.mCurrentRequest;
                this.mCurrentRequest = null;
                currentRequestFuture = this.mCurrentRequestFuture;
                this.mCurrentRequestFuture = null;
                pendingRequests = new ArrayList<ImageCaptureRequest>(this.mPendingRequests);
                this.mPendingRequests.clear();
            }
            if (currentRequest != null && currentRequestFuture != null) {
                currentRequest.notifyCallbackError(ImageCapture.getError(throwable), throwable.getMessage(), throwable);
                currentRequestFuture.cancel(true);
            }
            for (ImageCaptureRequest request : pendingRequests) {
                request.notifyCallbackError(ImageCapture.getError(throwable), throwable.getMessage(), throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public List<ImageCaptureRequest> pullOutUnfinishedRequests() {
            ArrayList<ImageCaptureRequest> remainingRequests;
            Object object = this.mLock;
            synchronized (object) {
                remainingRequests = new ArrayList<ImageCaptureRequest>(this.mPendingRequests);
                this.mPendingRequests.clear();
                ImageCaptureRequest currentRequest = this.mCurrentRequest;
                this.mCurrentRequest = null;
                if (currentRequest != null && this.mCurrentRequestFuture != null && this.mCurrentRequestFuture.cancel(true)) {
                    remainingRequests.add(0, currentRequest);
                }
            }
            return remainingRequests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageClose(@NonNull ImageProxy image) {
            Object object = this.mLock;
            synchronized (object) {
                --this.mOutstandingImages;
                CameraXExecutors.mainThreadExecutor().execute(this::processNextRequest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processNextRequest() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCurrentRequest != null) {
                    return;
                }
                if (this.mOutstandingImages >= this.mMaxImages) {
                    Logger.w(ImageCapture.TAG, "Too many acquire images. Close image to be able to process next.");
                    return;
                }
                final ImageCaptureRequest imageCaptureRequest = this.mPendingRequests.poll();
                if (imageCaptureRequest == null) {
                    return;
                }
                this.mCurrentRequest = imageCaptureRequest;
                if (this.mRequestProcessCallback != null) {
                    this.mRequestProcessCallback.onPreProcessRequest(this.mCurrentRequest);
                }
                this.mCurrentRequestFuture = this.mImageCaptor.capture(imageCaptureRequest);
                Futures.addCallback(this.mCurrentRequestFuture, new FutureCallback<ImageProxy>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess(@Nullable ImageProxy image) {
                        Object object = mLock;
                        synchronized (object) {
                            Preconditions.checkNotNull((Object)image);
                            SingleCloseImageProxy wrappedImage = new SingleCloseImageProxy(image);
                            wrappedImage.addOnImageCloseListener(this);
                            ++mOutstandingImages;
                            imageCaptureRequest.dispatchImage(wrappedImage);
                            mCurrentRequest = null;
                            mCurrentRequestFuture = null;
                            this.processNextRequest();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(@NonNull Throwable t) {
                        Object object = mLock;
                        synchronized (object) {
                            if (!(t instanceof CancellationException)) {
                                imageCaptureRequest.notifyCallbackError(ImageCapture.getError(t), t != null ? t.getMessage() : "Unknown error", t);
                            }
                            mCurrentRequest = null;
                            mCurrentRequestFuture = null;
                            this.processNextRequest();
                        }
                    }
                }, CameraXExecutors.mainThreadExecutor());
            }
        }

        static interface RequestProcessCallback {
            public void onPreProcessRequest(@NonNull ImageCaptureRequest var1);
        }

        static interface ImageCaptor {
            @NonNull
            public ListenableFuture<ImageProxy> capture(@NonNull ImageCaptureRequest var1);
        }
    }
}

