/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Matrix;
import android.media.ImageReader;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImmutableImageInfo;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.TagBundle;

@RequiresApi(value=21)
class ModifiableImageReaderProxy
extends AndroidImageReaderProxy {
    private volatile TagBundle mTagBundle = null;
    private volatile Long mTimestamp = null;
    private volatile Integer mRotationDegrees = null;
    private volatile Matrix mSensorToBufferTransformMatrix = null;

    ModifiableImageReaderProxy(@NonNull ImageReader imageReader) {
        super(imageReader);
    }

    void setImageTagBundle(@NonNull TagBundle tagBundle) {
        this.mTagBundle = tagBundle;
    }

    void setImageTimeStamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    void setImageRotationDegrees(int rotationDegrees) {
        this.mRotationDegrees = rotationDegrees;
    }

    void setImageSensorToBufferTransformaMatrix(@NonNull Matrix matrix) {
        this.mSensorToBufferTransformMatrix = matrix;
    }

    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        return this.modifyImage(super.acquireNextImage());
    }

    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        return this.modifyImage(super.acquireNextImage());
    }

    private ImageProxy modifyImage(ImageProxy imageProxy) {
        ImageInfo origin = imageProxy.getImageInfo();
        ImageInfo imageInfo = ImmutableImageInfo.create(this.mTagBundle != null ? this.mTagBundle : origin.getTagBundle(), this.mTimestamp != null ? this.mTimestamp.longValue() : origin.getTimestamp(), this.mRotationDegrees != null ? this.mRotationDegrees.intValue() : origin.getRotationDegrees(), this.mSensorToBufferTransformMatrix != null ? this.mSensorToBufferTransformMatrix : origin.getSensorToBufferTransformMatrix());
        return new SettableImageProxy(imageProxy, imageInfo);
    }
}

