/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SettableImageProxyBundle;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

@RequiresApi(value=21)
class ProcessingImageReader
implements ImageReaderProxy {
    private static final String TAG = "ProcessingImageReader";
    private static final int EXIF_MAX_SIZE_BYTES = 64000;
    final Object mLock = new Object();
    private ImageReaderProxy.OnImageAvailableListener mTransformedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(@NonNull ImageReaderProxy reader) {
            ProcessingImageReader.this.imageIncoming(reader);
        }
    };
    private ImageReaderProxy.OnImageAvailableListener mImageProcessedListener = new ImageReaderProxy.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(@NonNull ImageReaderProxy reader) {
            Executor executor;
            ImageReaderProxy.OnImageAvailableListener listener;
            Object object = ProcessingImageReader.this.mLock;
            synchronized (object) {
                listener = ProcessingImageReader.this.mListener;
                executor = ProcessingImageReader.this.mExecutor;
                ProcessingImageReader.this.mSettableImageProxyBundle.reset();
                ProcessingImageReader.this.setupSettableImageProxyBundleCallbacks();
            }
            if (listener != null) {
                if (executor != null) {
                    executor.execute(() -> listener.onImageAvailable(ProcessingImageReader.this));
                } else {
                    listener.onImageAvailable(ProcessingImageReader.this);
                }
            }
        }
    };
    private FutureCallback<List<ImageProxy>> mCaptureStageReadyCallback = new FutureCallback<List<ImageProxy>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(@Nullable List<ImageProxy> imageProxyList) {
            Executor errorCallbackExecutor;
            OnProcessingErrorCallback errorCallback;
            SettableImageProxyBundle settableImageProxyBundle;
            Object object = ProcessingImageReader.this.mLock;
            synchronized (object) {
                if (ProcessingImageReader.this.mClosed) {
                    return;
                }
                ProcessingImageReader.this.mProcessing = true;
                settableImageProxyBundle = ProcessingImageReader.this.mSettableImageProxyBundle;
                errorCallback = ProcessingImageReader.this.mOnProcessingErrorCallback;
                errorCallbackExecutor = ProcessingImageReader.this.mErrorCallbackExecutor;
            }
            try {
                ProcessingImageReader.this.mCaptureProcessor.process(settableImageProxyBundle);
            }
            catch (Exception e) {
                Object object2 = ProcessingImageReader.this.mLock;
                synchronized (object2) {
                    ProcessingImageReader.this.mSettableImageProxyBundle.reset();
                    if (errorCallback != null && errorCallbackExecutor != null) {
                        errorCallbackExecutor.execute(() -> errorCallback.notifyProcessingError(e.getMessage(), e.getCause()));
                    }
                }
            }
            object = ProcessingImageReader.this.mLock;
            synchronized (object) {
                ProcessingImageReader.this.mProcessing = false;
            }
            ProcessingImageReader.this.closeAndCompleteFutureIfNecessary();
        }

        @Override
        public void onFailure(@NonNull Throwable throwable) {
        }
    };
    @GuardedBy(value="mLock")
    boolean mClosed = false;
    @GuardedBy(value="mLock")
    boolean mProcessing = false;
    @GuardedBy(value="mLock")
    final ImageReaderProxy mInputImageReader;
    @GuardedBy(value="mLock")
    final ImageReaderProxy mOutputImageReader;
    @GuardedBy(value="mLock")
    @Nullable
    ImageReaderProxy.OnImageAvailableListener mListener;
    @GuardedBy(value="mLock")
    @Nullable
    Executor mExecutor;
    @GuardedBy(value="mLock")
    CallbackToFutureAdapter.Completer<Void> mCloseCompleter;
    @GuardedBy(value="mLock")
    private ListenableFuture<Void> mCloseFuture;
    @NonNull
    final Executor mPostProcessExecutor;
    @NonNull
    final CaptureProcessor mCaptureProcessor;
    @NonNull
    private final ListenableFuture<Void> mUnderlyingCaptureProcessorCloseFuture;
    private String mTagBundleKey = new String();
    @GuardedBy(value="mLock")
    @NonNull
    SettableImageProxyBundle mSettableImageProxyBundle = new SettableImageProxyBundle(Collections.emptyList(), this.mTagBundleKey);
    private final List<Integer> mCaptureIdList = new ArrayList<Integer>();
    private ListenableFuture<List<ImageProxy>> mSettableImageProxyFutureList = Futures.immediateFuture(new ArrayList());
    @GuardedBy(value="mLock")
    OnProcessingErrorCallback mOnProcessingErrorCallback;
    @GuardedBy(value="mLock")
    Executor mErrorCallbackExecutor;

    ProcessingImageReader(@NonNull Builder builder) {
        if (builder.mInputImageReader.getMaxImages() < builder.mCaptureBundle.getCaptureStages().size()) {
            throw new IllegalArgumentException("MetadataImageReader is smaller than CaptureBundle.");
        }
        this.mInputImageReader = builder.mInputImageReader;
        int outputWidth = this.mInputImageReader.getWidth();
        int outputHeight = this.mInputImageReader.getHeight();
        if (builder.mOutputFormat == 256) {
            outputWidth = (int)((float)(outputWidth * outputHeight) * 1.5f) + 64000;
            outputHeight = 1;
        }
        this.mOutputImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)outputWidth, (int)outputHeight, (int)builder.mOutputFormat, (int)this.mInputImageReader.getMaxImages()));
        this.mPostProcessExecutor = builder.mPostProcessExecutor;
        this.mCaptureProcessor = builder.mCaptureProcessor;
        this.mCaptureProcessor.onOutputSurface(this.mOutputImageReader.getSurface(), builder.mOutputFormat);
        this.mCaptureProcessor.onResolutionUpdate(new Size(this.mInputImageReader.getWidth(), this.mInputImageReader.getHeight()));
        this.mUnderlyingCaptureProcessorCloseFuture = this.mCaptureProcessor.getCloseFuture();
        this.setCaptureBundle(builder.mCaptureBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireLatestImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireNextImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mInputImageReader.clearOnImageAvailableListener();
            this.mOutputImageReader.clearOnImageAvailableListener();
            this.mClosed = true;
        }
        this.mCaptureProcessor.close();
        this.closeAndCompleteFutureIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAndCompleteFutureIfNecessary() {
        CallbackToFutureAdapter.Completer<Void> closeCompleter;
        boolean processing;
        boolean closed;
        Object object = this.mLock;
        synchronized (object) {
            closed = this.mClosed;
            processing = this.mProcessing;
            closeCompleter = this.mCloseCompleter;
            if (closed && !processing) {
                this.mInputImageReader.close();
                this.mSettableImageProxyBundle.close();
                this.mOutputImageReader.close();
            }
        }
        if (closed && !processing) {
            this.mUnderlyingCaptureProcessorCloseFuture.addListener(() -> {
                this.cancelSettableImageProxyBundleFutureList();
                if (closeCompleter != null) {
                    closeCompleter.set(null);
                }
            }, CameraXExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> getCloseFuture() {
        Object closeFuture;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed && !this.mProcessing) {
                closeFuture = Futures.transform(this.mUnderlyingCaptureProcessorCloseFuture, nullVoid -> null, CameraXExecutors.directExecutor());
            } else {
                if (this.mCloseFuture == null) {
                    this.mCloseFuture = CallbackToFutureAdapter.getFuture(completer -> {
                        Object object = this.mLock;
                        synchronized (object) {
                            this.mCloseCompleter = completer;
                        }
                        return "ProcessingImageReader-close";
                    });
                }
                closeFuture = Futures.nonCancellationPropagating(this.mCloseFuture);
            }
        }
        return closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = (ImageReaderProxy.OnImageAvailableListener)Preconditions.checkNotNull((Object)listener);
            this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
            this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, executor);
            this.mOutputImageReader.setOnImageAvailableListener(this.mImageProcessedListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = null;
            this.mExecutor = null;
            this.mInputImageReader.clearOnImageAvailableListener();
            this.mOutputImageReader.clearOnImageAvailableListener();
            if (!this.mProcessing) {
                this.mSettableImageProxyBundle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaptureBundle(@NonNull CaptureBundle captureBundle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.cancelSettableImageProxyBundleFutureList();
            if (captureBundle.getCaptureStages() != null) {
                if (this.mInputImageReader.getMaxImages() < captureBundle.getCaptureStages().size()) {
                    throw new IllegalArgumentException("CaptureBundle is larger than InputImageReader.");
                }
                this.mCaptureIdList.clear();
                for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
                    if (captureStage == null) continue;
                    this.mCaptureIdList.add(captureStage.getId());
                }
            }
            this.mTagBundleKey = Integer.toString(captureBundle.hashCode());
            this.mSettableImageProxyBundle = new SettableImageProxyBundle(this.mCaptureIdList, this.mTagBundleKey);
            this.setupSettableImageProxyBundleCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSettableImageProxyBundleFutureList() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSettableImageProxyFutureList.isDone()) {
                this.mSettableImageProxyFutureList.cancel(true);
            }
            this.mSettableImageProxyBundle.reset();
        }
    }

    @NonNull
    public String getTagBundleKey() {
        return this.mTagBundleKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CameraCaptureCallback getCameraCaptureCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInputImageReader instanceof MetadataImageReader) {
                return ((MetadataImageReader)this.mInputImageReader).getCameraCaptureCallback();
            }
            return new CameraCaptureCallback(){};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnProcessingErrorCallback(@NonNull Executor executor, @NonNull OnProcessingErrorCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mErrorCallbackExecutor = executor;
            this.mOnProcessingErrorCallback = callback;
        }
    }

    @GuardedBy(value="mLock")
    void setupSettableImageProxyBundleCallbacks() {
        ArrayList<ListenableFuture<ImageProxy>> futureList = new ArrayList<ListenableFuture<ImageProxy>>();
        for (Integer id : this.mCaptureIdList) {
            futureList.add(this.mSettableImageProxyBundle.getImageProxy(id));
        }
        this.mSettableImageProxyFutureList = Futures.allAsList(futureList);
        Futures.addCallback(Futures.allAsList(futureList), this.mCaptureStageReadyCallback, this.mPostProcessExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(ImageReaderProxy imageReader) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            ImageProxy image = null;
            try {
                image = imageReader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Logger.e(TAG, "Failed to acquire latest image.", e);
            }
            finally {
                if (image != null) {
                    Integer tagValue = (Integer)image.getImageInfo().getTagBundle().getTag(this.mTagBundleKey);
                    if (!this.mCaptureIdList.contains(tagValue)) {
                        Logger.w(TAG, "ImageProxyBundle does not contain this id: " + tagValue);
                        image.close();
                    } else {
                        this.mSettableImageProxyBundle.addImageProxy(image);
                    }
                }
            }
        }
    }

    static interface OnProcessingErrorCallback {
        public void notifyProcessingError(@Nullable String var1, @Nullable Throwable var2);
    }

    static final class Builder {
        @NonNull
        protected final ImageReaderProxy mInputImageReader;
        @NonNull
        protected final CaptureBundle mCaptureBundle;
        @NonNull
        protected final CaptureProcessor mCaptureProcessor;
        protected int mOutputFormat;
        @NonNull
        protected Executor mPostProcessExecutor = Executors.newSingleThreadExecutor();

        Builder(@NonNull ImageReaderProxy imageReader, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
            this.mInputImageReader = imageReader;
            this.mCaptureBundle = captureBundle;
            this.mCaptureProcessor = captureProcessor;
            this.mOutputFormat = imageReader.getImageFormat();
        }

        Builder(int width, int height, int inputFormat, int maxImages, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
            this(new MetadataImageReader(width, height, inputFormat, maxImages), captureBundle, captureProcessor);
        }

        @NonNull
        Builder setPostProcessExecutor(@NonNull Executor postProcessExecutor) {
            this.mPostProcessExecutor = postProcessExecutor;
            return this;
        }

        @NonNull
        Builder setOutputFormat(int outputFormat) {
            this.mOutputFormat = outputFormat;
            return this;
        }

        ProcessingImageReader build() {
            return new ProcessingImageReader(this);
        }
    }
}

