/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
final class SettableImageProxyBundle
implements ImageProxyBundle {
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    final SparseArray<CallbackToFutureAdapter.Completer<ImageProxy>> mCompleters = new SparseArray();
    @GuardedBy(value="mLock")
    private final SparseArray<ListenableFuture<ImageProxy>> mFutureResults = new SparseArray();
    @GuardedBy(value="mLock")
    private final List<ImageProxy> mOwnedImageProxies = new ArrayList<ImageProxy>();
    private final List<Integer> mCaptureIdList;
    private String mTagBundleKey = null;
    @GuardedBy(value="mLock")
    private boolean mClosed = false;

    SettableImageProxyBundle(List<Integer> captureIds, String tagBundleKey) {
        this.mCaptureIdList = captureIds;
        this.mTagBundleKey = tagBundleKey;
        this.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<ImageProxy> getImageProxy(int captureId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                throw new IllegalStateException("ImageProxyBundle already closed.");
            }
            ListenableFuture result = (ListenableFuture)this.mFutureResults.get(captureId);
            if (result == null) {
                throw new IllegalArgumentException("ImageProxyBundle does not contain this id: " + captureId);
            }
            return result;
        }
    }

    @Override
    @NonNull
    public List<Integer> getCaptureIds() {
        return Collections.unmodifiableList(this.mCaptureIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addImageProxy(ImageProxy imageProxy) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            Integer captureId = (Integer)imageProxy.getImageInfo().getTagBundle().getTag(this.mTagBundleKey);
            if (captureId == null) {
                throw new IllegalArgumentException("CaptureId is null.");
            }
            CallbackToFutureAdapter.Completer completer = (CallbackToFutureAdapter.Completer)this.mCompleters.get(captureId.intValue());
            if (completer == null) {
                throw new IllegalArgumentException("ImageProxyBundle does not contain this id: " + captureId);
            }
            this.mOwnedImageProxies.add(imageProxy);
            completer.set((Object)imageProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            for (ImageProxy imageProxy : this.mOwnedImageProxies) {
                imageProxy.close();
            }
            this.mOwnedImageProxies.clear();
            this.mFutureResults.clear();
            this.mCompleters.clear();
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            for (ImageProxy imageProxy : this.mOwnedImageProxies) {
                imageProxy.close();
            }
            this.mOwnedImageProxies.clear();
            this.mFutureResults.clear();
            this.mCompleters.clear();
            this.setup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() {
        Object object = this.mLock;
        synchronized (object) {
            for (final int captureId : this.mCaptureIdList) {
                ListenableFuture futureResult = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<ImageProxy>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<ImageProxy> completer) {
                        Object object = SettableImageProxyBundle.this.mLock;
                        synchronized (object) {
                            SettableImageProxyBundle.this.mCompleters.put(captureId, completer);
                        }
                        return "getImageProxy(id: " + captureId + ")";
                    }
                });
                this.mFutureResults.put(captureId, (Object)futureResult);
            }
        }
    }
}

