/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.location.Location;
import android.media.AudioRecord;
import android.media.CamcorderProfile;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.VideoCaptureConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.UseCaseEventConfig;
import androidx.camera.core.internal.utils.VideoUtil;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class VideoCapture
extends UseCase {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_ENCODER = 1;
    public static final int ERROR_MUXER = 2;
    public static final int ERROR_RECORDING_IN_PROGRESS = 3;
    public static final int ERROR_FILE_IO = 4;
    public static final int ERROR_INVALID_CAMERA = 5;
    public static final int ERROR_RECORDING_TOO_SHORT = 6;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "VideoCapture";
    private static final int DEQUE_TIMEOUT_USEC = 10000;
    private static final String VIDEO_MIME_TYPE = "video/avc";
    private static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    private static final int[] CamcorderQuality = new int[]{8, 6, 5, 4};
    private final MediaCodec.BufferInfo mVideoBufferInfo = new MediaCodec.BufferInfo();
    private final Object mMuxerLock = new Object();
    private final AtomicBoolean mEndOfVideoStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioStreamSignal = new AtomicBoolean(true);
    private final AtomicBoolean mEndOfAudioVideoSignal = new AtomicBoolean(true);
    private final MediaCodec.BufferInfo mAudioBufferInfo = new MediaCodec.BufferInfo();
    @VisibleForTesting(otherwise=2)
    public final AtomicBoolean mIsFirstVideoKeyFrameWrite = new AtomicBoolean(false);
    @VisibleForTesting(otherwise=2)
    public final AtomicBoolean mIsFirstAudioSampleWrite = new AtomicBoolean(false);
    private HandlerThread mVideoHandlerThread;
    private Handler mVideoHandler;
    private HandlerThread mAudioHandlerThread;
    private Handler mAudioHandler;
    @NonNull
    MediaCodec mVideoEncoder;
    @NonNull
    private MediaCodec mAudioEncoder;
    @Nullable
    private ListenableFuture<Void> mRecordingFuture = null;
    @NonNull
    private SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    @GuardedBy(value="mMuxerLock")
    private MediaMuxer mMuxer;
    private final AtomicBoolean mMuxerStarted = new AtomicBoolean(false);
    @GuardedBy(value="mMuxerLock")
    private int mVideoTrackIndex;
    @GuardedBy(value="mMuxerLock")
    private int mAudioTrackIndex;
    Surface mCameraSurface;
    @Nullable
    private volatile AudioRecord mAudioRecorder;
    private volatile int mAudioBufferSize;
    private volatile boolean mIsRecording = false;
    private int mAudioChannelCount;
    private int mAudioSampleRate;
    private int mAudioBitRate;
    private DeferrableSurface mDeferrableSurface;
    volatile Uri mSavedVideoUri;
    private volatile ParcelFileDescriptor mParcelFileDescriptor;
    private final AtomicBoolean mIsAudioEnabled = new AtomicBoolean(true);
    private VideoEncoderInitStatus mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED;
    @Nullable
    private Throwable mVideoEncoderErrorMessage;

    VideoCapture(@NonNull VideoCaptureConfig config) {
        super(config);
    }

    private static MediaFormat createVideoMediaFormat(VideoCaptureConfig config, Size resolution) {
        MediaFormat format = MediaFormat.createVideoFormat((String)VIDEO_MIME_TYPE, (int)resolution.getWidth(), (int)resolution.getHeight());
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", config.getBitRate());
        format.setInteger("frame-rate", config.getVideoFrameRate());
        format.setInteger("i-frame-interval", config.getIFrameInterval());
        return format;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE, 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAttached() {
        this.mVideoHandlerThread = new HandlerThread("CameraX-video encoding thread");
        this.mAudioHandlerThread = new HandlerThread("CameraX-audio encoding thread");
        this.mVideoHandlerThread.start();
        this.mVideoHandler = new Handler(this.mVideoHandlerThread.getLooper());
        this.mAudioHandlerThread.start();
        this.mAudioHandler = new Handler(this.mAudioHandlerThread.getLooper());
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        if (this.mCameraSurface != null) {
            this.mVideoEncoder.stop();
            this.mVideoEncoder.release();
            this.mAudioEncoder.stop();
            this.mAudioEncoder.release();
            this.releaseCameraSurface(false);
        }
        try {
            this.mVideoEncoder = MediaCodec.createEncoderByType((String)VIDEO_MIME_TYPE);
            this.mAudioEncoder = MediaCodec.createEncoderByType((String)AUDIO_MIME_TYPE);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create MediaCodec due to: " + e.getCause());
        }
        this.setupEncoder(this.getCameraId(), suggestedResolution);
        this.notifyActive();
        return suggestedResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void startRecording(@NonNull OutputFileOptions outputFileOptions, @NonNull Executor executor, @NonNull OnVideoSavedCallback callback) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.startRecording(outputFileOptions, executor, callback));
            return;
        }
        Logger.i(TAG, "startRecording");
        this.mIsFirstVideoKeyFrameWrite.set(false);
        this.mIsFirstAudioSampleWrite.set(false);
        VideoSavedListenerWrapper postListener = new VideoSavedListenerWrapper(executor, callback);
        CameraInternal attachedCamera = this.getCamera();
        if (attachedCamera == null) {
            postListener.onError(5, "Not bound to a Camera [" + this + "]", null);
            return;
        }
        if (this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE || this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED || this.mVideoEncoderInitStatus == VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED) {
            postListener.onError(1, "Video encoder initialization failed before start recording ", this.mVideoEncoderErrorMessage);
            return;
        }
        if (!this.mEndOfAudioVideoSignal.get()) {
            postListener.onError(3, "It is still in video recording!", null);
            return;
        }
        if (this.mIsAudioEnabled.get()) {
            try {
                if (this.mAudioRecorder.getState() == 1) {
                    this.mAudioRecorder.startRecording();
                }
            }
            catch (IllegalStateException e) {
                Logger.i(TAG, "AudioRecorder cannot start recording, disable audio." + e.getMessage());
                this.mIsAudioEnabled.set(false);
                this.releaseAudioInputResource();
            }
            if (this.mAudioRecorder.getRecordingState() != 3) {
                Logger.i(TAG, "AudioRecorder startRecording failed - incorrect state: " + this.mAudioRecorder.getRecordingState());
                this.mIsAudioEnabled.set(false);
                this.releaseAudioInputResource();
            }
        }
        AtomicReference recordingCompleterRef = new AtomicReference();
        this.mRecordingFuture = CallbackToFutureAdapter.getFuture(completer -> {
            recordingCompleterRef.set(completer);
            return "startRecording";
        });
        CallbackToFutureAdapter.Completer recordingCompleter = (CallbackToFutureAdapter.Completer)Preconditions.checkNotNull((Object)((CallbackToFutureAdapter.Completer)recordingCompleterRef.get()));
        this.mRecordingFuture.addListener(() -> {
            this.mRecordingFuture = null;
            if (this.getCamera() != null) {
                this.setupEncoder(this.getCameraId(), this.getAttachedSurfaceResolution());
                this.notifyReset();
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        try {
            Logger.i(TAG, "videoEncoder start");
            this.mVideoEncoder.start();
            if (this.mIsAudioEnabled.get()) {
                Logger.i(TAG, "audioEncoder start");
                this.mAudioEncoder.start();
            }
        }
        catch (IllegalStateException e) {
            recordingCompleter.set(null);
            postListener.onError(1, "Audio/Video encoder start fail", e);
            return;
        }
        try {
            Object e = this.mMuxerLock;
            synchronized (e) {
                this.mMuxer = this.initMediaMuxer(outputFileOptions);
                Preconditions.checkNotNull((Object)this.mMuxer);
                this.mMuxer.setOrientationHint(this.getRelativeRotation(attachedCamera));
                Metadata metadata = outputFileOptions.getMetadata();
                if (metadata != null && metadata.location != null) {
                    this.mMuxer.setLocation((float)metadata.location.getLatitude(), (float)metadata.location.getLongitude());
                }
            }
        }
        catch (IOException e) {
            recordingCompleter.set(null);
            postListener.onError(2, "MediaMuxer creation failed!", e);
            return;
        }
        this.mEndOfVideoStreamSignal.set(false);
        this.mEndOfAudioStreamSignal.set(false);
        this.mEndOfAudioVideoSignal.set(false);
        this.mIsRecording = true;
        this.mSessionConfigBuilder.clearSurfaces();
        this.mSessionConfigBuilder.addSurface(this.mDeferrableSurface);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyUpdated();
        if (this.mIsAudioEnabled.get()) {
            this.mAudioHandler.post(() -> this.audioEncode(postListener));
        }
        String cameraId = this.getCameraId();
        Size resolution = this.getAttachedSurfaceResolution();
        this.mVideoHandler.post(() -> {
            boolean errorOccurred = this.videoEncode(postListener, cameraId, resolution, outputFileOptions);
            if (!errorOccurred) {
                postListener.onVideoSaved(new OutputFileResults(this.mSavedVideoUri));
                this.mSavedVideoUri = null;
            }
            recordingCompleter.set(null);
        });
    }

    public void stopRecording() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            CameraXExecutors.mainThreadExecutor().execute(() -> this.stopRecording());
            return;
        }
        Logger.i(TAG, "stopRecording");
        this.mSessionConfigBuilder.clearSurfaces();
        this.mSessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.notifyUpdated();
        if (this.mIsRecording) {
            if (this.mIsAudioEnabled.get()) {
                this.mEndOfAudioStreamSignal.set(true);
            } else {
                this.mEndOfVideoStreamSignal.set(true);
            }
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onDetached() {
        this.stopRecording();
        if (this.mRecordingFuture != null) {
            this.mRecordingFuture.addListener(() -> this.releaseResources(), (Executor)CameraXExecutors.mainThreadExecutor());
        } else {
            this.releaseResources();
        }
    }

    private void releaseResources() {
        this.mVideoHandlerThread.quitSafely();
        this.releaseAudioInputResource();
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(true);
        }
    }

    private void releaseAudioInputResource() {
        this.mAudioHandlerThread.quitSafely();
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.release();
            this.mAudioRecorder = null;
        }
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void onStateDetached() {
        this.stopRecording();
    }

    @UiThread
    private void releaseCameraSurface(boolean releaseVideoEncoder) {
        if (this.mDeferrableSurface == null) {
            return;
        }
        MediaCodec videoEncoder = this.mVideoEncoder;
        this.mDeferrableSurface.close();
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
            if (releaseVideoEncoder && videoEncoder != null) {
                videoEncoder.release();
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
        if (releaseVideoEncoder) {
            this.mVideoEncoder = null;
        }
        this.mCameraSurface = null;
        this.mDeferrableSurface = null;
    }

    public void setTargetRotation(int rotation) {
        this.setTargetRotationInternal(rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    void setupEncoder(final @NonNull String cameraId, final @NonNull Size resolution) {
        Surface cameraSurface;
        VideoCaptureConfig config = (VideoCaptureConfig)this.getCurrentConfig();
        this.mVideoEncoder.reset();
        this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED;
        try {
            this.mVideoEncoder.configure(VideoCapture.createVideoMediaFormat(config, resolution), null, null, 1);
        }
        catch (MediaCodec.CodecException e) {
            int errorCode = 0;
            if (Build.VERSION.SDK_INT >= 23) {
                errorCode = Api23Impl.getCodecExceptionErrorCode(e);
                String diagnosticInfo = e.getDiagnosticInfo();
                if (errorCode == 1100) {
                    Logger.i(TAG, "CodecException: code: " + errorCode + " diagnostic: " + diagnosticInfo);
                    this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE;
                } else if (errorCode == 1101) {
                    Logger.i(TAG, "CodecException: code: " + errorCode + " diagnostic: " + diagnosticInfo);
                    this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;
                }
            } else {
                this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED;
            }
            this.mVideoEncoderErrorMessage = e;
            return;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.mVideoEncoderInitStatus = VideoEncoderInitStatus.VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED;
            this.mVideoEncoderErrorMessage = e;
            return;
        }
        if (this.mCameraSurface != null) {
            this.releaseCameraSurface(false);
        }
        this.mCameraSurface = cameraSurface = this.mVideoEncoder.createInputSurface();
        this.mSessionConfigBuilder = SessionConfig.Builder.createFrom(config);
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(this.mCameraSurface, resolution, this.getImageFormat());
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> ((Surface)cameraSurface).release(), (Executor)CameraXExecutors.mainThreadExecutor());
        this.mSessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface);
        this.mSessionConfigBuilder.addErrorListener(new SessionConfig.ErrorListener(){

            @Override
            @RequiresPermission(value="android.permission.RECORD_AUDIO")
            public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionConfig.SessionError error) {
                if (VideoCapture.this.isCurrentCamera(cameraId)) {
                    VideoCapture.this.setupEncoder(cameraId, resolution);
                    VideoCapture.this.notifyReset();
                }
            }
        });
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        this.mIsAudioEnabled.set(true);
        this.setAudioParametersByCamcorderProfile(resolution, cameraId);
        this.mAudioEncoder.reset();
        this.mAudioEncoder.configure(this.createAudioMediaFormat(), null, null, 1);
        if (this.mAudioRecorder != null) {
            this.mAudioRecorder.release();
        }
        this.mAudioRecorder = this.autoConfigAudioRecordSource(config);
        if (this.mAudioRecorder == null) {
            Logger.e(TAG, "AudioRecord object cannot initialized correctly!");
            this.mIsAudioEnabled.set(false);
        }
        Object object = this.mMuxerLock;
        synchronized (object) {
            this.mVideoTrackIndex = -1;
            this.mAudioTrackIndex = -1;
        }
        this.mIsRecording = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeVideoEncodedBuffer(int bufferIndex) {
        if (bufferIndex < 0) {
            Logger.e(TAG, "Output buffer should not have negative index: " + bufferIndex);
            return false;
        }
        ByteBuffer outputBuffer = this.mVideoEncoder.getOutputBuffer(bufferIndex);
        if (outputBuffer == null) {
            Logger.d(TAG, "OutputBuffer was null.");
            return false;
        }
        if (this.mMuxerStarted.get()) {
            if (this.mVideoBufferInfo.size > 0) {
                outputBuffer.position(this.mVideoBufferInfo.offset);
                outputBuffer.limit(this.mVideoBufferInfo.offset + this.mVideoBufferInfo.size);
                this.mVideoBufferInfo.presentationTimeUs = System.nanoTime() / 1000L;
                Object object = this.mMuxerLock;
                synchronized (object) {
                    if (!this.mIsFirstVideoKeyFrameWrite.get()) {
                        boolean isKeyFrame;
                        boolean bl = isKeyFrame = (this.mVideoBufferInfo.flags & 1) != 0;
                        if (isKeyFrame) {
                            Logger.i(TAG, "First video key frame written.");
                            this.mIsFirstVideoKeyFrameWrite.set(true);
                        } else {
                            Bundle syncFrame = new Bundle();
                            syncFrame.putInt("request-sync", 0);
                            this.mVideoEncoder.setParameters(syncFrame);
                        }
                    }
                    this.mMuxer.writeSampleData(this.mVideoTrackIndex, outputBuffer, this.mVideoBufferInfo);
                }
            } else {
                Logger.i(TAG, "mVideoBufferInfo.size <= 0, index " + bufferIndex);
            }
        }
        this.mVideoEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mVideoBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeAudioEncodedBuffer(int bufferIndex) {
        block8: {
            ByteBuffer buffer = this.getOutputBuffer(this.mAudioEncoder, bufferIndex);
            buffer.position(this.mAudioBufferInfo.offset);
            if (this.mMuxerStarted.get()) {
                try {
                    if (this.mAudioBufferInfo.size > 0 && this.mAudioBufferInfo.presentationTimeUs > 0L) {
                        Object object = this.mMuxerLock;
                        synchronized (object) {
                            if (!this.mIsFirstAudioSampleWrite.get()) {
                                Logger.i(TAG, "First audio sample written.");
                                this.mIsFirstAudioSampleWrite.set(true);
                            }
                            this.mMuxer.writeSampleData(this.mAudioTrackIndex, buffer, this.mAudioBufferInfo);
                            break block8;
                        }
                    }
                    Logger.i(TAG, "mAudioBufferInfo size: " + this.mAudioBufferInfo.size + " presentationTimeUs: " + this.mAudioBufferInfo.presentationTimeUs);
                }
                catch (Exception e) {
                    Logger.e(TAG, "audio error:size=" + this.mAudioBufferInfo.size + "/offset=" + this.mAudioBufferInfo.offset + "/timeUs=" + this.mAudioBufferInfo.presentationTimeUs);
                    e.printStackTrace();
                }
            }
        }
        this.mAudioEncoder.releaseOutputBuffer(bufferIndex, false);
        return (this.mAudioBufferInfo.flags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean videoEncode(@NonNull OnVideoSavedCallback videoSavedCallback, @NonNull String cameraId, @NonNull Size resolution, @NonNull OutputFileOptions outputFileOptions) {
        boolean errorOccurred = false;
        boolean videoEos = false;
        while (!videoEos && !errorOccurred) {
            if (this.mEndOfVideoStreamSignal.get()) {
                this.mVideoEncoder.signalEndOfInputStream();
                this.mEndOfVideoStreamSignal.set(false);
            }
            int outputBufferId = this.mVideoEncoder.dequeueOutputBuffer(this.mVideoBufferInfo, 10000L);
            switch (outputBufferId) {
                case -2: {
                    if (this.mMuxerStarted.get()) {
                        videoSavedCallback.onError(1, "Unexpected change in video encoding format.", null);
                        errorOccurred = true;
                    }
                    Object object = this.mMuxerLock;
                    synchronized (object) {
                        this.mVideoTrackIndex = this.mMuxer.addTrack(this.mVideoEncoder.getOutputFormat());
                        if (this.mIsAudioEnabled.get() && this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0 || !this.mIsAudioEnabled.get() && this.mVideoTrackIndex >= 0) {
                            Logger.i(TAG, "MediaMuxer started on video encode thread and audio enabled: " + this.mIsAudioEnabled);
                            this.mMuxer.start();
                            this.mMuxerStarted.set(true);
                        }
                        break;
                    }
                }
                case -1: {
                    break;
                }
                default: {
                    videoEos = this.writeVideoEncodedBuffer(outputBufferId);
                }
            }
        }
        try {
            Logger.i(TAG, "videoEncoder stop");
            this.mVideoEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Video encoder stop failed!", e);
            errorOccurred = true;
        }
        try {
            Object e = this.mMuxerLock;
            synchronized (e) {
                if (this.mMuxer != null) {
                    if (this.mMuxerStarted.get()) {
                        Logger.i(TAG, "Muxer already started");
                        this.mMuxer.stop();
                    }
                    this.mMuxer.release();
                    this.mMuxer = null;
                }
            }
            boolean checkResult = this.removeRecordingResultIfNoVideoKeyFrameArrived(outputFileOptions);
            if (!checkResult) {
                videoSavedCallback.onError(6, "The file has no video key frame.", null);
                errorOccurred = true;
            }
        }
        catch (IllegalStateException e) {
            Logger.i(TAG, "muxer stop IllegalStateException: " + System.currentTimeMillis());
            Logger.i(TAG, "muxer stop exception, mIsFirstVideoKeyFrameWrite: " + this.mIsFirstVideoKeyFrameWrite.get());
            if (this.mIsFirstVideoKeyFrameWrite.get()) {
                videoSavedCallback.onError(2, "Muxer stop failed!", e);
            } else {
                videoSavedCallback.onError(6, "The file has no video key frame.", null);
            }
            errorOccurred = true;
        }
        if (this.mParcelFileDescriptor != null) {
            try {
                this.mParcelFileDescriptor.close();
                this.mParcelFileDescriptor = null;
            }
            catch (IOException e) {
                videoSavedCallback.onError(2, "File descriptor close failed!", e);
                errorOccurred = true;
            }
        }
        this.mMuxerStarted.set(false);
        this.mEndOfAudioVideoSignal.set(true);
        this.mIsFirstVideoKeyFrameWrite.set(false);
        Logger.i(TAG, "Video encode thread end.");
        return errorOccurred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean audioEncode(OnVideoSavedCallback videoSavedCallback) {
        boolean audioEos = false;
        long lastAudioTimestamp = 0L;
        while (!audioEos && this.mIsRecording) {
            int outIndex;
            if (this.mEndOfAudioStreamSignal.get()) {
                this.mEndOfAudioStreamSignal.set(false);
                this.mIsRecording = false;
            }
            if (this.mAudioEncoder == null || this.mAudioRecorder == null) continue;
            try {
                int index = this.mAudioEncoder.dequeueInputBuffer(-1L);
                if (index >= 0) {
                    ByteBuffer buffer = this.getInputBuffer(this.mAudioEncoder, index);
                    buffer.clear();
                    int length = this.mAudioRecorder.read(buffer, this.mAudioBufferSize);
                    if (length > 0) {
                        this.mAudioEncoder.queueInputBuffer(index, 0, length, System.nanoTime() / 1000L, this.mIsRecording ? 0 : 4);
                    }
                }
            }
            catch (MediaCodec.CodecException e) {
                Logger.i(TAG, "audio dequeueInputBuffer CodecException " + e.getMessage());
            }
            catch (IllegalStateException e) {
                Logger.i(TAG, "audio dequeueInputBuffer IllegalStateException " + e.getMessage());
            }
            do {
                outIndex = this.mAudioEncoder.dequeueOutputBuffer(this.mAudioBufferInfo, 0L);
                switch (outIndex) {
                    case -2: {
                        Object e = this.mMuxerLock;
                        synchronized (e) {
                            this.mAudioTrackIndex = this.mMuxer.addTrack(this.mAudioEncoder.getOutputFormat());
                            if (this.mAudioTrackIndex >= 0 && this.mVideoTrackIndex >= 0) {
                                Logger.i(TAG, "MediaMuxer start on audio encoder thread.");
                                this.mMuxer.start();
                                this.mMuxerStarted.set(true);
                            }
                            break;
                        }
                    }
                    case -1: {
                        break;
                    }
                    default: {
                        if (this.mAudioBufferInfo.presentationTimeUs > lastAudioTimestamp) {
                            audioEos = this.writeAudioEncodedBuffer(outIndex);
                            lastAudioTimestamp = this.mAudioBufferInfo.presentationTimeUs;
                            break;
                        }
                        Logger.w(TAG, "Drops frame, current frame's timestamp " + this.mAudioBufferInfo.presentationTimeUs + " is earlier that last frame " + lastAudioTimestamp);
                        this.mAudioEncoder.releaseOutputBuffer(outIndex, false);
                    }
                }
            } while (outIndex >= 0 && !audioEos);
        }
        try {
            Logger.i(TAG, "audioRecorder stop");
            this.mAudioRecorder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio recorder stop failed!", e);
        }
        try {
            this.mAudioEncoder.stop();
        }
        catch (IllegalStateException e) {
            videoSavedCallback.onError(1, "Audio encoder stop failed!", e);
        }
        Logger.i(TAG, "Audio encode thread end");
        this.mEndOfVideoStreamSignal.set(true);
        return false;
    }

    private ByteBuffer getInputBuffer(MediaCodec codec, int index) {
        return codec.getInputBuffer(index);
    }

    private ByteBuffer getOutputBuffer(MediaCodec codec, int index) {
        return codec.getOutputBuffer(index);
    }

    private MediaFormat createAudioMediaFormat() {
        MediaFormat format = MediaFormat.createAudioFormat((String)AUDIO_MIME_TYPE, (int)this.mAudioSampleRate, (int)this.mAudioChannelCount);
        format.setInteger("aac-profile", 2);
        format.setInteger("bitrate", this.mAudioBitRate);
        return format;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    private AudioRecord autoConfigAudioRecordSource(VideoCaptureConfig config) {
        int channelConfig = this.mAudioChannelCount == 1 ? 16 : 12;
        try {
            AudioRecord recorder;
            int bufferSize = AudioRecord.getMinBufferSize((int)this.mAudioSampleRate, (int)channelConfig, (int)2);
            if (bufferSize <= 0) {
                bufferSize = config.getAudioMinBufferSize();
            }
            if ((recorder = new AudioRecord(5, this.mAudioSampleRate, channelConfig, 2, bufferSize * 2)).getState() == 1) {
                this.mAudioBufferSize = bufferSize;
                Logger.i(TAG, "source: 5 audioSampleRate: " + this.mAudioSampleRate + " channelConfig: " + channelConfig + " audioFormat: " + 2 + " bufferSize: " + bufferSize);
                return recorder;
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "Exception, keep trying.", e);
        }
        return null;
    }

    private void setAudioParametersByCamcorderProfile(Size currentResolution, String cameraId) {
        boolean isCamcorderProfileFound = false;
        try {
            for (int quality : CamcorderQuality) {
                if (!CamcorderProfile.hasProfile((int)Integer.parseInt(cameraId), (int)quality)) continue;
                CamcorderProfile profile = CamcorderProfile.get((int)Integer.parseInt(cameraId), (int)quality);
                if (currentResolution.getWidth() != profile.videoFrameWidth || currentResolution.getHeight() != profile.videoFrameHeight) continue;
                this.mAudioChannelCount = profile.audioChannels;
                this.mAudioSampleRate = profile.audioSampleRate;
                this.mAudioBitRate = profile.audioBitRate;
                isCamcorderProfileFound = true;
                break;
            }
        }
        catch (NumberFormatException e) {
            Logger.i(TAG, "The camera Id is not an integer because the camera may be a removable device. Use the default values for the audio related settings.");
        }
        if (!isCamcorderProfileFound) {
            VideoCaptureConfig config = (VideoCaptureConfig)this.getCurrentConfig();
            this.mAudioChannelCount = config.getAudioChannelCount();
            this.mAudioSampleRate = config.getAudioSampleRate();
            this.mAudioBitRate = config.getAudioBitRate();
        }
    }

    private boolean removeRecordingResultIfNoVideoKeyFrameArrived(@NonNull OutputFileOptions outputFileOptions) {
        boolean checkKeyFrame;
        Logger.i(TAG, "check Recording Result First Video Key Frame Write: " + this.mIsFirstVideoKeyFrameWrite.get());
        if (!this.mIsFirstVideoKeyFrameWrite.get()) {
            Logger.i(TAG, "The recording result has no key frame.");
            checkKeyFrame = false;
        } else {
            checkKeyFrame = true;
        }
        if (outputFileOptions.isSavingToFile()) {
            File outputFile = outputFileOptions.getFile();
            if (!checkKeyFrame) {
                Logger.i(TAG, "Delete file.");
                outputFile.delete();
            }
        } else if (outputFileOptions.isSavingToMediaStore() && !checkKeyFrame) {
            Logger.i(TAG, "Delete file.");
            if (this.mSavedVideoUri != null) {
                ContentResolver contentResolver = outputFileOptions.getContentResolver();
                contentResolver.delete(this.mSavedVideoUri, null, null);
            }
        }
        return checkKeyFrame;
    }

    @NonNull
    private MediaMuxer initMediaMuxer(@NonNull OutputFileOptions outputFileOptions) throws IOException {
        MediaMuxer mediaMuxer;
        if (outputFileOptions.isSavingToFile()) {
            File savedVideoFile = outputFileOptions.getFile();
            this.mSavedVideoUri = Uri.fromFile((File)outputFileOptions.getFile());
            mediaMuxer = new MediaMuxer(savedVideoFile.getAbsolutePath(), 0);
        } else if (outputFileOptions.isSavingToFileDescriptor()) {
            if (Build.VERSION.SDK_INT < 26) {
                throw new IllegalArgumentException("Using a FileDescriptor to record a video is only supported for Android 8.0 or above.");
            }
            mediaMuxer = Api26Impl.createMediaMuxer(outputFileOptions.getFileDescriptor(), 0);
        } else if (outputFileOptions.isSavingToMediaStore()) {
            ContentValues values = outputFileOptions.getContentValues() != null ? new ContentValues(outputFileOptions.getContentValues()) : new ContentValues();
            this.mSavedVideoUri = outputFileOptions.getContentResolver().insert(outputFileOptions.getSaveCollection(), values);
            if (this.mSavedVideoUri == null) {
                throw new IOException("Invalid Uri!");
            }
            try {
                if (Build.VERSION.SDK_INT < 26) {
                    String savedLocationPath = VideoUtil.getAbsolutePathFromUri(outputFileOptions.getContentResolver(), this.mSavedVideoUri);
                    Logger.i(TAG, "Saved Location Path: " + savedLocationPath);
                    mediaMuxer = new MediaMuxer(savedLocationPath, 0);
                }
                this.mParcelFileDescriptor = outputFileOptions.getContentResolver().openFileDescriptor(this.mSavedVideoUri, "rw");
                mediaMuxer = Api26Impl.createMediaMuxer(this.mParcelFileDescriptor.getFileDescriptor(), 0);
            }
            catch (IOException e) {
                this.mSavedVideoUri = null;
                throw e;
            }
        } else {
            throw new IllegalArgumentException("The OutputFileOptions should assign before recording");
        }
        return mediaMuxer;
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static int getCodecExceptionErrorCode(MediaCodec.CodecException e) {
            return e.getErrorCode();
        }
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        @NonNull
        static MediaMuxer createMediaMuxer(@NonNull FileDescriptor fileDescriptor, int format) throws IOException {
            return new MediaMuxer(fileDescriptor, format);
        }
    }

    public static final class OutputFileOptions {
        private static final Metadata EMPTY_METADATA = new Metadata();
        @Nullable
        private final File mFile;
        @Nullable
        private final FileDescriptor mFileDescriptor;
        @Nullable
        private final ContentResolver mContentResolver;
        @Nullable
        private final Uri mSaveCollection;
        @Nullable
        private final ContentValues mContentValues;
        @Nullable
        private final Metadata mMetadata;

        OutputFileOptions(@Nullable File file, @Nullable FileDescriptor fileDescriptor, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable Metadata metadata) {
            this.mFile = file;
            this.mFileDescriptor = fileDescriptor;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mMetadata = metadata == null ? EMPTY_METADATA : metadata;
        }

        @Nullable
        File getFile() {
            return this.mFile;
        }

        @Nullable
        FileDescriptor getFileDescriptor() {
            return this.mFileDescriptor;
        }

        @Nullable
        ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        Metadata getMetadata() {
            return this.mMetadata;
        }

        boolean isSavingToMediaStore() {
            return this.getSaveCollection() != null && this.getContentResolver() != null && this.getContentValues() != null;
        }

        boolean isSavingToFile() {
            return this.getFile() != null;
        }

        boolean isSavingToFileDescriptor() {
            return this.getFileDescriptor() != null;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private FileDescriptor mFileDescriptor;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private Metadata mMetadata;

            public Builder(@NonNull File file) {
                this.mFile = file;
            }

            public Builder(@NonNull FileDescriptor fileDescriptor) {
                Preconditions.checkArgument((Build.VERSION.SDK_INT >= 26 ? 1 : 0) != 0, (Object)"Using a FileDescriptor to record a video is only supported for Android 8.0 or above.");
                this.mFileDescriptor = fileDescriptor;
            }

            public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri saveCollection, @NonNull ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            @NonNull
            public Builder setMetadata(@NonNull Metadata metadata) {
                this.mMetadata = metadata;
                return this;
            }

            @NonNull
            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mFileDescriptor, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mMetadata);
            }
        }
    }

    public static class OutputFileResults {
        @Nullable
        private Uri mSavedUri;

        OutputFileResults(@Nullable Uri savedUri) {
            this.mSavedUri = savedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    public static final class Builder
    implements UseCaseConfig.Builder<VideoCapture, VideoCaptureConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(@NonNull MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(VideoCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)VideoCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @NonNull
        public static Builder fromConfig(@NonNull VideoCaptureConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public VideoCaptureConfig getUseCaseConfig() {
            return new VideoCaptureConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public VideoCapture build() {
            if (this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, null) != null && this.getMutableConfig().retrieveOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, null) != null) {
                throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
            }
            return new VideoCapture(this.getUseCaseConfig());
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setVideoFrameRate(int videoFrameRate) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_VIDEO_FRAME_RATE, videoFrameRate);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBitRate(int bitRate) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_BIT_RATE, bitRate);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setIFrameInterval(int interval) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_INTRA_FRAME_INTERVAL, interval);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setAudioBitRate(int bitRate) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_AUDIO_BIT_RATE, bitRate);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setAudioSampleRate(int sampleRate) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_AUDIO_SAMPLE_RATE, sampleRate);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setAudioChannelCount(int channelCount) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_AUDIO_CHANNEL_COUNT, channelCount);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setAudioMinBufferSize(int minBufferSize) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_AUDIO_MIN_BUFFER_SIZE, minBufferSize);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<VideoCapture> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(UseCaseEventConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }
    }

    private static final class VideoSavedListenerWrapper
    implements OnVideoSavedCallback {
        @NonNull
        Executor mExecutor;
        @NonNull
        OnVideoSavedCallback mOnVideoSavedCallback;

        VideoSavedListenerWrapper(@NonNull Executor executor, @NonNull OnVideoSavedCallback onVideoSavedCallback) {
            this.mExecutor = executor;
            this.mOnVideoSavedCallback = onVideoSavedCallback;
        }

        @Override
        public void onVideoSaved(@NonNull OutputFileResults outputFileResults) {
            try {
                this.mExecutor.execute(() -> this.mOnVideoSavedCallback.onVideoSaved(outputFileResults));
            }
            catch (RejectedExecutionException e) {
                Logger.e(VideoCapture.TAG, "Unable to post to the supplied executor.");
            }
        }

        @Override
        public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
            try {
                this.mExecutor.execute(() -> this.mOnVideoSavedCallback.onError(videoCaptureError, message, cause));
            }
            catch (RejectedExecutionException e) {
                Logger.e(VideoCapture.TAG, "Unable to post to the supplied executor.");
            }
        }
    }

    public static final class Metadata {
        @Nullable
        public Location location;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<VideoCaptureConfig> {
        private static final int DEFAULT_VIDEO_FRAME_RATE = 30;
        private static final int DEFAULT_BIT_RATE = 0x800000;
        private static final int DEFAULT_INTRA_FRAME_INTERVAL = 1;
        private static final int DEFAULT_AUDIO_BIT_RATE = 64000;
        private static final int DEFAULT_AUDIO_SAMPLE_RATE = 8000;
        private static final int DEFAULT_AUDIO_CHANNEL_COUNT = 1;
        private static final int DEFAULT_AUDIO_MIN_BUFFER_SIZE = 1024;
        private static final Size DEFAULT_MAX_RESOLUTION = new Size(1920, 1080);
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 3;
        private static final int DEFAULT_ASPECT_RATIO = 1;
        private static final VideoCaptureConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public VideoCaptureConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setVideoFrameRate(30).setBitRate(0x800000).setIFrameInterval(1).setAudioBitRate(64000).setAudioSampleRate(8000).setAudioChannelCount(1).setAudioMinBufferSize(1024).setMaxResolution(DEFAULT_MAX_RESOLUTION).setSurfaceOccupancyPriority(3).setTargetAspectRatio(1);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static interface OnVideoSavedCallback {
        public void onVideoSaved(@NonNull OutputFileResults var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    static enum VideoEncoderInitStatus {
        VIDEO_ENCODER_INIT_STATUS_UNINITIALIZED,
        VIDEO_ENCODER_INIT_STATUS_INITIALIZED_FAILED,
        VIDEO_ENCODER_INIT_STATUS_INSUFFICIENT_RESOURCE,
        VIDEO_ENCODER_INIT_STATUS_RESOURCE_RECLAIMED;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface VideoCaptureError {
    }
}

