/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.RequiresApi;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

@RequiresApi(value=21)
class ByteOrderedDataOutputStream
extends FilterOutputStream {
    final OutputStream mOutputStream;
    private ByteOrder mByteOrder;

    ByteOrderedDataOutputStream(OutputStream out, ByteOrder byteOrder) {
        super(out);
        this.mOutputStream = out;
        this.mByteOrder = byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.mByteOrder = byteOrder;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.mOutputStream.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.mOutputStream.write(bytes, offset, length);
    }

    public void writeByte(int val) throws IOException {
        this.mOutputStream.write(val);
    }

    public void writeShort(short val) throws IOException {
        if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.mOutputStream.write(val >>> 0 & 0xFF);
            this.mOutputStream.write(val >>> 8 & 0xFF);
        } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
            this.mOutputStream.write(val >>> 8 & 0xFF);
            this.mOutputStream.write(val >>> 0 & 0xFF);
        }
    }

    public void writeInt(int val) throws IOException {
        if (this.mByteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.mOutputStream.write(val >>> 0 & 0xFF);
            this.mOutputStream.write(val >>> 8 & 0xFF);
            this.mOutputStream.write(val >>> 16 & 0xFF);
            this.mOutputStream.write(val >>> 24 & 0xFF);
        } else if (this.mByteOrder == ByteOrder.BIG_ENDIAN) {
            this.mOutputStream.write(val >>> 24 & 0xFF);
            this.mOutputStream.write(val >>> 16 & 0xFF);
            this.mOutputStream.write(val >>> 8 & 0xFF);
            this.mOutputStream.write(val >>> 0 & 0xFF);
        }
    }

    public void writeUnsignedShort(int val) throws IOException {
        this.writeShort((short)val);
    }

    public void writeUnsignedInt(long val) throws IOException {
        this.writeInt((int)val);
    }
}

