/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.Absent;
import androidx.camera.core.impl.utils.Present;
import androidx.core.util.Preconditions;
import androidx.core.util.Supplier;
import java.io.Serializable;

@RequiresApi(value=21)
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    @NonNull
    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    @NonNull
    public static <T> Optional<T> of(@NonNull T reference) {
        return new Present<Object>(Preconditions.checkNotNull(reference));
    }

    @NonNull
    public static <T> Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    @NonNull
    public abstract T get();

    @NonNull
    public abstract T or(@NonNull T var1);

    @NonNull
    public abstract Optional<T> or(@NonNull Optional<? extends T> var1);

    @NonNull
    public abstract T or(@NonNull Supplier<? extends T> var1);

    @Nullable
    public abstract T orNull();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    @NonNull
    public abstract String toString();
}

