/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.graphics.Rect;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class Preview
extends UseCase {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Defaults DEFAULT_CONFIG = new Defaults();
    private static final String TAG = "Preview";
    private static final Executor DEFAULT_SURFACE_PROVIDER_EXECUTOR = CameraXExecutors.mainThreadExecutor();
    @Nullable
    private SurfaceProvider mSurfaceProvider;
    @NonNull
    private Executor mSurfaceProviderExecutor = DEFAULT_SURFACE_PROVIDER_EXECUTOR;
    SessionConfig.Builder mSessionConfigBuilder;
    private DeferrableSurface mSessionDeferrableSurface;
    @Nullable
    private SurfaceEdge mCameraEdge;
    @VisibleForTesting
    @Nullable
    SurfaceRequest mCurrentSurfaceRequest;
    @Nullable
    private SurfaceProcessorNode mNode;

    @MainThread
    Preview(@NonNull PreviewConfig config) {
        super(config);
    }

    @NonNull
    @MainThread
    private SessionConfig.Builder createPipeline(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull StreamSpec streamSpec) {
        Threads.checkMainThread();
        CameraInternal camera = Objects.requireNonNull(this.getCamera());
        this.clearPipeline();
        Preconditions.checkState((this.mCameraEdge == null ? 1 : 0) != 0);
        this.mCameraEdge = new SurfaceEdge(1, 34, streamSpec, this.getSensorToBufferTransformMatrix(), camera.getHasTransform(), Objects.requireNonNull(this.getCropRect(streamSpec.getResolution())), this.getRelativeRotation(camera, this.isMirroringRequired(camera)), this.getAppTargetRotation(), this.shouldMirror(camera));
        CameraEffect effect = this.getEffect();
        if (effect != null) {
            this.mNode = new SurfaceProcessorNode(camera, effect.createSurfaceProcessorInternal());
            this.mCameraEdge.addOnInvalidatedListener(this::notifyReset);
            SurfaceProcessorNode.OutConfig outConfig = SurfaceProcessorNode.OutConfig.of(this.mCameraEdge);
            SurfaceProcessorNode.In nodeInput = SurfaceProcessorNode.In.of(this.mCameraEdge, Collections.singletonList(outConfig));
            SurfaceProcessorNode.Out nodeOutput = this.mNode.transform(nodeInput);
            SurfaceEdge appEdge = Objects.requireNonNull((SurfaceEdge)nodeOutput.get(outConfig));
            appEdge.addOnInvalidatedListener(() -> this.onAppEdgeInvalidated(appEdge, camera));
            this.mCurrentSurfaceRequest = appEdge.createSurfaceRequest(camera);
            this.mSessionDeferrableSurface = this.mCameraEdge.getDeferrableSurface();
        } else {
            this.mCameraEdge.addOnInvalidatedListener(this::notifyReset);
            this.mCurrentSurfaceRequest = this.mCameraEdge.createSurfaceRequest(camera);
            this.mSessionDeferrableSurface = this.mCurrentSurfaceRequest.getDeferrableSurface();
        }
        if (this.mSurfaceProvider != null) {
            this.sendSurfaceRequest();
        }
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config, streamSpec.getResolution());
        sessionConfigBuilder.setExpectedFrameRateRange(streamSpec.getExpectedFrameRateRange());
        sessionConfigBuilder.setPreviewStabilization(config.getPreviewStabilizationMode());
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        this.addCameraSurfaceAndErrorListener(sessionConfigBuilder, cameraId, config, streamSpec);
        return sessionConfigBuilder;
    }

    @MainThread
    private void onAppEdgeInvalidated(@NonNull SurfaceEdge appEdge, @NonNull CameraInternal camera) {
        Threads.checkMainThread();
        if (camera == this.getCamera()) {
            this.mCurrentSurfaceRequest = appEdge.createSurfaceRequest(camera);
            this.sendSurfaceRequest();
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @IntRange(from=0L, to=359L)
    protected int getRelativeRotation(@NonNull CameraInternal cameraInternal, boolean requireMirroring) {
        if (cameraInternal.getHasTransform()) {
            return super.getRelativeRotation(cameraInternal, requireMirroring);
        }
        return 0;
    }

    private boolean shouldMirror(@NonNull CameraInternal camera) {
        return camera.getHasTransform() && this.isMirroringRequired(camera);
    }

    private void clearPipeline() {
        SurfaceEdge cameraEdge;
        SurfaceProcessorNode node;
        DeferrableSurface cameraSurface = this.mSessionDeferrableSurface;
        if (cameraSurface != null) {
            cameraSurface.close();
            this.mSessionDeferrableSurface = null;
        }
        if ((node = this.mNode) != null) {
            node.release();
            this.mNode = null;
        }
        if ((cameraEdge = this.mCameraEdge) != null) {
            cameraEdge.close();
            this.mCameraEdge = null;
        }
        this.mCurrentSurfaceRequest = null;
    }

    private void addCameraSurfaceAndErrorListener(@NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull String cameraId, @NonNull PreviewConfig config, @NonNull StreamSpec streamSpec) {
        if (this.mSurfaceProvider != null) {
            sessionConfigBuilder.addSurface(this.mSessionDeferrableSurface, streamSpec.getDynamicRange());
        }
        sessionConfigBuilder.addErrorListener((sessionConfig, error) -> {
            if (this.isCurrentCamera(cameraId)) {
                SessionConfig.Builder sessionConfigBuilder1 = this.createPipeline(cameraId, config, streamSpec);
                this.updateSessionConfig(sessionConfigBuilder1.build());
                this.notifyReset();
            }
        });
    }

    public void setTargetRotation(int targetRotation) {
        if (this.setTargetRotationInternal(targetRotation)) {
            this.sendTransformationInfoIfReady();
        }
    }

    private void sendTransformationInfoIfReady() {
        CameraInternal cameraInternal = this.getCamera();
        SurfaceEdge cameraEdge = this.mCameraEdge;
        if (cameraInternal != null && cameraEdge != null) {
            cameraEdge.updateTransformation(this.getRelativeRotation(cameraInternal, this.isMirroringRequired(cameraInternal)), this.getAppTargetRotation());
        }
    }

    @Nullable
    private Rect getCropRect(@Nullable Size surfaceResolution) {
        if (this.getViewPortCropRect() != null) {
            return this.getViewPortCropRect();
        }
        if (surfaceResolution != null) {
            return new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
        }
        return null;
    }

    @UiThread
    public void setSurfaceProvider(@NonNull Executor executor, @Nullable SurfaceProvider surfaceProvider) {
        Threads.checkMainThread();
        if (surfaceProvider == null) {
            this.mSurfaceProvider = null;
            this.notifyInactive();
        } else {
            this.mSurfaceProvider = surfaceProvider;
            this.mSurfaceProviderExecutor = executor;
            if (this.getAttachedSurfaceResolution() != null) {
                this.updateConfigAndOutput(this.getCameraId(), (PreviewConfig)this.getCurrentConfig(), this.getAttachedStreamSpec());
                this.notifyReset();
            }
            this.notifyActive();
        }
    }

    private void sendSurfaceRequest() {
        this.sendTransformationInfoIfReady();
        SurfaceProvider surfaceProvider = (SurfaceProvider)Preconditions.checkNotNull((Object)this.mSurfaceProvider);
        SurfaceRequest surfaceRequest = (SurfaceRequest)Preconditions.checkNotNull((Object)this.mCurrentSurfaceRequest);
        this.mSurfaceProviderExecutor.execute(() -> surfaceProvider.onSurfaceRequested(surfaceRequest));
    }

    @UiThread
    public void setSurfaceProvider(@Nullable SurfaceProvider surfaceProvider) {
        this.setSurfaceProvider(DEFAULT_SURFACE_PROVIDER_EXECUTOR, surfaceProvider);
    }

    private void updateConfigAndOutput(@NonNull String cameraId, @NonNull PreviewConfig config, @NonNull StreamSpec streamSpec) {
        this.mSessionConfigBuilder = this.createPipeline(cameraId, config, streamSpec);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    @Nullable
    public ResolutionInfo getResolutionInfo() {
        return this.getResolutionInfoInternal();
    }

    @Nullable
    public ResolutionSelector getResolutionSelector() {
        return ((ImageOutputConfig)((Object)this.getCurrentConfig())).getResolutionSelector(null);
    }

    @NonNull
    public String toString() {
        return "Preview:" + this.getName();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        builder.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 34);
        return builder.getUseCaseConfig();
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onUnbind() {
        this.clearPipeline();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec suggestedStreamSpec) {
        this.updateConfigAndOutput(this.getCameraId(), (PreviewConfig)this.getCurrentConfig(), suggestedStreamSpec);
        return suggestedStreamSpec;
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(this.mSessionConfigBuilder.build());
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.sendTransformationInfoIfReady();
    }

    @VisibleForTesting
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SurfaceEdge getCameraEdge() {
        return Objects.requireNonNull(this.mCameraEdge);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(1);
        return targets;
    }

    @NonNull
    public Range<Integer> getTargetFrameRate() {
        return this.getTargetFrameRateInternal();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isPreviewStabilizationEnabled() {
        return this.getCurrentConfig().getPreviewStabilizationMode() == 2;
    }

    public static interface SurfaceProvider {
        public void onSurfaceRequested(@NonNull SurfaceRequest var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<PreviewConfig> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 2;
        private static final int DEFAULT_ASPECT_RATIO = 0;
        private static final int DEFAULT_MIRROR_MODE = 2;
        private static final ResolutionSelector DEFAULT_RESOLUTION_SELECTOR = new ResolutionSelector.Builder().setAspectRatioStrategy(AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY).setResolutionStrategy(ResolutionStrategy.HIGHEST_AVAILABLE_STRATEGY).build();
        private static final PreviewConfig DEFAULT_CONFIG;

        @Override
        @NonNull
        public PreviewConfig getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            Builder builder = new Builder().setSurfaceOccupancyPriority(2).setTargetAspectRatio(0).setResolutionSelector(DEFAULT_RESOLUTION_SELECTOR).setCaptureType(UseCaseConfigFactory.CaptureType.PREVIEW);
            DEFAULT_CONFIG = builder.getUseCaseConfig();
        }
    }

    public static final class Builder
    implements UseCaseConfig.Builder<Preview, PreviewConfig, Builder>,
    ImageOutputConfig.Builder<Builder>,
    ThreadConfig.Builder<Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(Preview.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)Preview.class);
            mutableConfig.insertOption(ImageOutputConfig.OPTION_MIRROR_MODE, 2);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        static Builder fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromConfig(@NonNull PreviewConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PreviewConfig getUseCaseConfig() {
            return new PreviewConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @NonNull
        public Preview build() {
            PreviewConfig previewConfig = this.getUseCaseConfig();
            ImageOutputConfig.validateConfig(previewConfig);
            return new Preview(previewConfig);
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<Preview> targetClass) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(PreviewConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }

        @Override
        @Deprecated
        @NonNull
        public Builder setTargetAspectRatio(int aspectRatio) {
            if (aspectRatio == -1) {
                aspectRatio = 0;
            }
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ASPECT_RATIO, aspectRatio);
            return this;
        }

        @Override
        @NonNull
        public Builder setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_TARGET_ROTATION, rotation);
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_APP_TARGET_ROTATION, rotation);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setMirrorMode(int mirrorMode) {
            throw new UnsupportedOperationException("setMirrorMode is not supported.");
        }

        @Override
        @Deprecated
        @NonNull
        public Builder setTargetResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_RESOLUTION, resolution);
            return this;
        }

        @Override
        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_MAX_RESOLUTION, resolution);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @Override
        @NonNull
        public Builder setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, resolutionSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_BACKGROUND_EXECUTOR, executor);
            return this;
        }

        @NonNull
        public Builder setTargetFrameRate(@NonNull Range<Integer> targetFrameRate) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_FRAME_RATE, targetFrameRate);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setPreviewStabilizationEnabled(boolean enabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE, enabled ? 2 : 1);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_SESSION_CONFIG, sessionConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_DEFAULT_CAPTURE_CONFIG, captureConfig);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SESSION_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_CAPTURE_CONFIG_UNPACKER, optionUnpacker);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, priority);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraSelector(@NonNull CameraSelector cameraSelector) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAMERA_SELECTOR, cameraSelector);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseEventCallback(@NonNull UseCase.EventCallback useCaseEventCallback) {
            this.getMutableConfig().insertOption(PreviewConfig.OPTION_USE_CASE_EVENT_CALLBACK, useCaseEventCallback);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, disabled);
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, captureType);
            return this;
        }
    }
}

