/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_In;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_InputPacket;
import androidx.camera.core.imagecapture.Bitmap2JpegBytes;
import androidx.camera.core.imagecapture.BitmapEffect;
import androidx.camera.core.imagecapture.Image2JpegBytes;
import androidx.camera.core.imagecapture.JpegBytes2CroppedBitmap;
import androidx.camera.core.imagecapture.JpegBytes2Disk;
import androidx.camera.core.imagecapture.JpegBytes2Image;
import androidx.camera.core.imagecapture.JpegImage2Result;
import androidx.camera.core.imagecapture.ProcessingInput2Packet;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.LowMemoryQuirk;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.InternalImageProcessor;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class ProcessingNode
implements Node<In, Void> {
    @NonNull
    final Executor mBlockingExecutor;
    @Nullable
    final InternalImageProcessor mImageProcessor;
    private In mInputEdge;
    private Operation<InputPacket, Packet<ImageProxy>> mInput2Packet;
    private Operation<Image2JpegBytes.In, Packet<byte[]>> mImage2JpegBytes;
    private Operation<Bitmap2JpegBytes.In, Packet<byte[]>> mBitmap2JpegBytes;
    private Operation<JpegBytes2Disk.In, ImageCapture.OutputFileResults> mJpegBytes2Disk;
    private Operation<Packet<byte[]>, Packet<Bitmap>> mJpegBytes2CroppedBitmap;
    private Operation<Packet<ImageProxy>, ImageProxy> mJpegImage2Result;
    private Operation<Packet<byte[]>, Packet<ImageProxy>> mJpegBytes2Image;
    private Operation<Packet<Bitmap>, Packet<Bitmap>> mBitmapEffect;

    @VisibleForTesting
    ProcessingNode(@NonNull Executor blockingExecutor) {
        this(blockingExecutor, null);
    }

    ProcessingNode(@NonNull Executor blockingExecutor, @Nullable InternalImageProcessor imageProcessor) {
        boolean isLowMemoryDevice = DeviceQuirks.get(LowMemoryQuirk.class) != null;
        this.mBlockingExecutor = isLowMemoryDevice ? CameraXExecutors.newSequentialExecutor(blockingExecutor) : blockingExecutor;
        this.mImageProcessor = imageProcessor;
    }

    @Override
    @NonNull
    public Void transform(@NonNull In inputEdge) {
        this.mInputEdge = inputEdge;
        inputEdge.getEdge().setListener((Consumer<InputPacket>)((Consumer)inputPacket -> {
            if (inputPacket.getProcessingRequest().isAborted()) {
                return;
            }
            this.mBlockingExecutor.execute(() -> this.processInputPacket((InputPacket)inputPacket));
        }));
        this.mInput2Packet = new ProcessingInput2Packet();
        this.mImage2JpegBytes = new Image2JpegBytes();
        this.mJpegBytes2CroppedBitmap = new JpegBytes2CroppedBitmap();
        this.mBitmap2JpegBytes = new Bitmap2JpegBytes();
        this.mJpegBytes2Disk = new JpegBytes2Disk();
        this.mJpegImage2Result = new JpegImage2Result();
        if (inputEdge.getInputFormat() == 35 || this.mImageProcessor != null) {
            this.mJpegBytes2Image = new JpegBytes2Image();
        }
        if (this.mImageProcessor != null) {
            this.mBitmapEffect = new BitmapEffect(this.mImageProcessor);
        }
        return null;
    }

    @Override
    public void release() {
    }

    @WorkerThread
    void processInputPacket(@NonNull InputPacket inputPacket) {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        try {
            if (inputPacket.getProcessingRequest().isInMemoryCapture()) {
                ImageProxy result = this.processInMemoryCapture(inputPacket);
                CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
            } else {
                ImageCapture.OutputFileResults result = this.processOnDiskCapture(inputPacket);
                CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
            }
        }
        catch (ImageCaptureException e) {
            ProcessingNode.sendError(request, e);
        }
        catch (OutOfMemoryError e) {
            ProcessingNode.sendError(request, new ImageCaptureException(0, "Processing failed due to low memory.", e));
        }
        catch (RuntimeException e) {
            ProcessingNode.sendError(request, new ImageCaptureException(0, "Processing failed.", e));
        }
    }

    @NonNull
    @WorkerThread
    ImageCapture.OutputFileResults processOnDiskCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        Preconditions.checkArgument((this.mInputEdge.getOutputFormat() == 256 ? 1 : 0) != 0, (Object)String.format("On-disk capture only support JPEG output format. Output format: %s", this.mInputEdge.getOutputFormat()));
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Packet<ImageProxy> originalImage = this.mInput2Packet.apply(inputPacket);
        Packet<byte[]> jpegBytes = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(originalImage, request.getJpegQuality()));
        if (jpegBytes.hasCropping() || this.mBitmapEffect != null) {
            jpegBytes = this.cropAndMaybeApplyEffect(jpegBytes, request.getJpegQuality());
        }
        return this.mJpegBytes2Disk.apply(JpegBytes2Disk.In.of(jpegBytes, Objects.requireNonNull(request.getOutputFileOptions())));
    }

    @NonNull
    @WorkerThread
    ImageProxy processInMemoryCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Packet<ImageProxy> image = this.mInput2Packet.apply(inputPacket);
        if ((image.getFormat() == 35 || this.mBitmapEffect != null) && this.mInputEdge.getOutputFormat() == 256) {
            Packet<byte[]> jpegBytes = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(image, request.getJpegQuality()));
            if (this.mBitmapEffect != null) {
                jpegBytes = this.cropAndMaybeApplyEffect(jpegBytes, request.getJpegQuality());
            }
            image = this.mJpegBytes2Image.apply(jpegBytes);
        }
        return this.mJpegImage2Result.apply(image);
    }

    private Packet<byte[]> cropAndMaybeApplyEffect(Packet<byte[]> jpegPacket, int jpegQuality) throws ImageCaptureException {
        Preconditions.checkState((jpegPacket.getFormat() == 256 ? 1 : 0) != 0);
        Packet<Bitmap> bitmapPacket = this.mJpegBytes2CroppedBitmap.apply(jpegPacket);
        if (this.mBitmapEffect != null) {
            bitmapPacket = this.mBitmapEffect.apply(bitmapPacket);
        }
        return this.mBitmap2JpegBytes.apply(Bitmap2JpegBytes.In.of(bitmapPacket, jpegQuality));
    }

    private static void sendError(@NonNull ProcessingRequest request, @NonNull ImageCaptureException e) {
        CameraXExecutors.mainThreadExecutor().execute(() -> request.onProcessFailure(e));
    }

    @VisibleForTesting
    void injectProcessingInput2Packet(@NonNull Operation<InputPacket, Packet<ImageProxy>> input2Packet) {
        this.mInput2Packet = input2Packet;
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        abstract Edge<InputPacket> getEdge();

        abstract int getInputFormat();

        abstract int getOutputFormat();

        static In of(int inputFormat, int outputFormat) {
            return new AutoValue_ProcessingNode_In(new Edge<InputPacket>(), inputFormat, outputFormat);
        }
    }

    @AutoValue
    static abstract class InputPacket {
        InputPacket() {
        }

        @NonNull
        abstract ProcessingRequest getProcessingRequest();

        @NonNull
        abstract ImageProxy getImageProxy();

        static InputPacket of(@NonNull ProcessingRequest processingRequest, @NonNull ImageProxy imageProxy) {
            return new AutoValue_ProcessingNode_InputPacket(processingRequest, imageProxy);
        }
    }
}

