/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.IoConfig;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public final class ImageCaptureConfig
implements UseCaseConfig<ImageCapture>,
ImageOutputConfig,
IoConfig {
    public static final Config.Option<Integer> OPTION_IMAGE_CAPTURE_MODE = Config.Option.create("camerax.core.imageCapture.captureMode", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_FLASH_MODE = Config.Option.create("camerax.core.imageCapture.flashMode", Integer.TYPE);
    public static final Config.Option<CaptureBundle> OPTION_CAPTURE_BUNDLE = Config.Option.create("camerax.core.imageCapture.captureBundle", CaptureBundle.class);
    public static final Config.Option<Integer> OPTION_BUFFER_FORMAT = Config.Option.create("camerax.core.imageCapture.bufferFormat", Integer.class);
    public static final Config.Option<Integer> OPTION_MAX_CAPTURE_STAGES = Config.Option.create("camerax.core.imageCapture.maxCaptureStages", Integer.class);
    public static final Config.Option<ImageReaderProxyProvider> OPTION_IMAGE_READER_PROXY_PROVIDER = Config.Option.create("camerax.core.imageCapture.imageReaderProxyProvider", ImageReaderProxyProvider.class);
    public static final Config.Option<Boolean> OPTION_USE_SOFTWARE_JPEG_ENCODER = Config.Option.create("camerax.core.imageCapture.useSoftwareJpegEncoder", Boolean.TYPE);
    public static final Config.Option<Integer> OPTION_FLASH_TYPE = Config.Option.create("camerax.core.imageCapture.flashType", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_JPEG_COMPRESSION_QUALITY = Config.Option.create("camerax.core.imageCapture.jpegCompressionQuality", Integer.TYPE);
    private final OptionsBundle mConfig;

    public ImageCaptureConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    public boolean hasCaptureMode() {
        return this.containsOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getCaptureMode() {
        return this.retrieveOption(OPTION_IMAGE_CAPTURE_MODE);
    }

    public int getFlashMode(int valueIfMissing) {
        return this.retrieveOption(OPTION_FLASH_MODE, valueIfMissing);
    }

    public int getFlashMode() {
        return this.retrieveOption(OPTION_FLASH_MODE);
    }

    @Nullable
    public CaptureBundle getCaptureBundle(@Nullable CaptureBundle valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE, valueIfMissing);
    }

    @NonNull
    public CaptureBundle getCaptureBundle() {
        return this.retrieveOption(OPTION_CAPTURE_BUNDLE);
    }

    @Nullable
    public Integer getBufferFormat(@Nullable Integer valueIfMissing) {
        return this.retrieveOption(OPTION_BUFFER_FORMAT, valueIfMissing);
    }

    @NonNull
    public Integer getBufferFormat() {
        return this.retrieveOption(OPTION_BUFFER_FORMAT);
    }

    @Override
    public int getInputFormat() {
        return (Integer)this.retrieveOption(OPTION_INPUT_FORMAT);
    }

    public int getMaxCaptureStages(int valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES, valueIfMissing);
    }

    public int getMaxCaptureStages() {
        return this.retrieveOption(OPTION_MAX_CAPTURE_STAGES);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public ImageReaderProxyProvider getImageReaderProxyProvider() {
        return this.retrieveOption(OPTION_IMAGE_READER_PROXY_PROVIDER, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isSoftwareJpegEncoderRequested() {
        return this.retrieveOption(OPTION_USE_SOFTWARE_JPEG_ENCODER, false);
    }

    public int getFlashType(int valueIfMissing) {
        return this.retrieveOption(OPTION_FLASH_TYPE, valueIfMissing);
    }

    public int getFlashType() {
        return this.retrieveOption(OPTION_FLASH_TYPE);
    }

    @IntRange(from=1L, to=100L)
    public int getJpegQuality(@IntRange(from=1L, to=100L) int valueIfMissing) {
        return this.retrieveOption(OPTION_JPEG_COMPRESSION_QUALITY, valueIfMissing);
    }

    @IntRange(from=1L, to=100L)
    public int getJpegQuality() {
        return this.retrieveOption(OPTION_JPEG_COMPRESSION_QUALITY);
    }

    @Override
    @Nullable
    public Executor getIoExecutor(@Nullable Executor valueIfMissing) {
        return this.retrieveOption(OPTION_IO_EXECUTOR, valueIfMissing);
    }

    @Override
    @NonNull
    public Executor getIoExecutor() {
        return (Executor)this.retrieveOption(OPTION_IO_EXECUTOR);
    }
}

