/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import android.util.SizeF;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import java.util.Locale;

@RequiresApi(value=21)
public class TransformUtils {
    public static final RectF NORMALIZED_RECT = new RectF(-1.0f, -1.0f, 1.0f, 1.0f);

    private TransformUtils() {
    }

    @NonNull
    public static Size rectToSize(@NonNull Rect rect) {
        return new Size(rect.width(), rect.height());
    }

    @NonNull
    public static String rectToString(@NonNull Rect rect) {
        return String.format(Locale.US, "%s(%dx%d)", rect, rect.width(), rect.height());
    }

    @NonNull
    public static Rect sizeToRect(@NonNull Size size) {
        return TransformUtils.sizeToRect(size, 0, 0);
    }

    @NonNull
    public static Rect sizeToRect(@NonNull Size size, int left, int top) {
        return new Rect(left, top, left + size.getWidth(), top + size.getHeight());
    }

    public static boolean hasCropping(@NonNull Rect cropRect, @NonNull Size size) {
        return cropRect.left != 0 || cropRect.top != 0 || cropRect.width() != size.getWidth() || cropRect.height() != size.getHeight();
    }

    @NonNull
    public static RectF sizeToRectF(@NonNull Size size) {
        return TransformUtils.sizeToRectF(size, 0, 0);
    }

    @NonNull
    public static RectF sizeToRectF(@NonNull Size size, int left, int top) {
        return new RectF((float)left, (float)top, (float)(left + size.getWidth()), (float)(top + size.getHeight()));
    }

    @NonNull
    public static Size reverseSize(@NonNull Size size) {
        return new Size(size.getHeight(), size.getWidth());
    }

    @NonNull
    public static SizeF reverseSizeF(@NonNull SizeF sizeF) {
        return new SizeF(sizeF.getHeight(), sizeF.getWidth());
    }

    @NonNull
    public static Size rotateSize(@NonNull Size size, int rotationDegrees) {
        Preconditions.checkArgument((rotationDegrees % 90 == 0 ? 1 : 0) != 0, (Object)("Invalid rotation degrees: " + rotationDegrees));
        return TransformUtils.is90or270(TransformUtils.within360(rotationDegrees)) ? TransformUtils.reverseSize(size) : size;
    }

    @NonNull
    public static RectF rotateRect(@NonNull RectF rect, int rotationDegrees) {
        Preconditions.checkArgument((rotationDegrees % 90 == 0 ? 1 : 0) != 0, (Object)("Invalid rotation degrees: " + rotationDegrees));
        if (TransformUtils.is90or270(TransformUtils.within360(rotationDegrees))) {
            return new RectF(0.0f, 0.0f, rect.height(), rect.width());
        }
        return rect;
    }

    @NonNull
    public static Size getRotatedSize(@NonNull Rect cropRect, int rotationDegrees) {
        return TransformUtils.rotateSize(TransformUtils.rectToSize(cropRect), rotationDegrees);
    }

    public static int within360(int degrees) {
        return (degrees % 360 + 360) % 360;
    }

    @NonNull
    public static RectF verticesToRect(@NonNull float[] vertices) {
        return new RectF(TransformUtils.min(vertices[0], vertices[2], vertices[4], vertices[6]), TransformUtils.min(vertices[1], vertices[3], vertices[5], vertices[7]), TransformUtils.max(vertices[0], vertices[2], vertices[4], vertices[6]), TransformUtils.max(vertices[1], vertices[3], vertices[5], vertices[7]));
    }

    public static float max(float value1, float value2, float value3, float value4) {
        return Math.max(Math.max(value1, value2), Math.max(value3, value4));
    }

    public static float min(float value1, float value2, float value3, float value4) {
        return Math.min(Math.min(value1, value2), Math.min(value3, value4));
    }

    public static boolean is90or270(int rotationDegrees) {
        if (rotationDegrees == 90 || rotationDegrees == 270) {
            return true;
        }
        if (rotationDegrees == 0 || rotationDegrees == 180) {
            return false;
        }
        throw new IllegalArgumentException("Invalid rotation degrees: " + rotationDegrees);
    }

    @NonNull
    public static float[] sizeToVertices(@NonNull Size size) {
        return new float[]{0.0f, 0.0f, size.getWidth(), 0.0f, size.getWidth(), size.getHeight(), 0.0f, size.getHeight()};
    }

    @NonNull
    public static float[] rectToVertices(@NonNull RectF rectF) {
        return new float[]{rectF.left, rectF.top, rectF.right, rectF.top, rectF.right, rectF.bottom, rectF.left, rectF.bottom};
    }

    public static boolean isAspectRatioMatchingWithRoundingError(@NonNull Size size1, @NonNull Size size2) {
        return TransformUtils.isAspectRatioMatchingWithRoundingError(size1, false, size2, false);
    }

    public static boolean isAspectRatioMatchingWithRoundingError(@NonNull Size size1, boolean isAccurate1, @NonNull Size size2, boolean isAccurate2) {
        float ratio2LowerBound;
        float ratio2UpperBound;
        float ratio1LowerBound;
        float ratio1UpperBound;
        if (isAccurate1) {
            ratio1LowerBound = ratio1UpperBound = (float)size1.getWidth() / (float)size1.getHeight();
        } else {
            ratio1UpperBound = ((float)size1.getWidth() + 1.0f) / ((float)size1.getHeight() - 1.0f);
            ratio1LowerBound = ((float)size1.getWidth() - 1.0f) / ((float)size1.getHeight() + 1.0f);
        }
        if (isAccurate2) {
            ratio2LowerBound = ratio2UpperBound = (float)size2.getWidth() / (float)size2.getHeight();
        } else {
            ratio2UpperBound = ((float)size2.getWidth() + 1.0f) / ((float)size2.getHeight() - 1.0f);
            ratio2LowerBound = ((float)size2.getWidth() - 1.0f) / ((float)size2.getHeight() + 1.0f);
        }
        return ratio1UpperBound >= ratio2LowerBound && ratio2UpperBound >= ratio1LowerBound;
    }

    @NonNull
    public static Matrix getRectToRect(@NonNull RectF source, @NonNull RectF target, int rotationDegrees) {
        return TransformUtils.getRectToRect(source, target, rotationDegrees, false);
    }

    @NonNull
    public static Matrix getRectToRect(@NonNull RectF source, @NonNull RectF target, int rotationDegrees, boolean mirroring) {
        Matrix matrix = new Matrix();
        matrix.setRectToRect(source, NORMALIZED_RECT, Matrix.ScaleToFit.FILL);
        matrix.postRotate((float)rotationDegrees);
        if (mirroring) {
            matrix.postScale(-1.0f, 1.0f);
        }
        matrix.postConcat(TransformUtils.getNormalizedToBuffer(target));
        return matrix;
    }

    @NonNull
    public static Matrix getNormalizedToBuffer(@NonNull Rect viewPortRect) {
        return TransformUtils.getNormalizedToBuffer(new RectF(viewPortRect));
    }

    @NonNull
    public static Matrix updateSensorToBufferTransform(@NonNull Matrix original, @NonNull Rect cropRect) {
        Matrix matrix = new Matrix(original);
        matrix.postTranslate((float)(-cropRect.left), (float)(-cropRect.top));
        return matrix;
    }

    @NonNull
    public static Matrix getNormalizedToBuffer(@NonNull RectF viewPortRect) {
        Matrix normalizedToBuffer = new Matrix();
        normalizedToBuffer.setRectToRect(NORMALIZED_RECT, viewPortRect, Matrix.ScaleToFit.FILL);
        return normalizedToBuffer;
    }

    @NonNull
    public static Matrix getExifTransform(int exifOrientation, int width, int height) {
        Matrix matrix = new Matrix();
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        matrix.setRectToRect(rect, NORMALIZED_RECT, Matrix.ScaleToFit.FILL);
        boolean isWidthHeightSwapped = false;
        switch (exifOrientation) {
            case 2: {
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                break;
            }
            case 4: {
                matrix.postScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.postScale(-1.0f, 1.0f);
                matrix.postRotate(270.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 6: {
                matrix.postRotate(90.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 7: {
                matrix.postScale(-1.0f, 1.0f);
                matrix.postRotate(90.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 8: {
                matrix.postRotate(270.0f);
                isWidthHeightSwapped = true;
                break;
            }
        }
        RectF restoredRect = isWidthHeightSwapped ? new RectF(0.0f, 0.0f, (float)height, (float)width) : rect;
        Matrix restore = new Matrix();
        restore.setRectToRect(NORMALIZED_RECT, restoredRect, Matrix.ScaleToFit.FILL);
        matrix.postConcat(restore);
        return matrix;
    }
}

