/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.RestrictedCameraControl;
import androidx.camera.core.impl.RestrictedCameraInfo;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.internal.ViewPorts;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@RequiresApi(value=21)
public final class CameraUseCaseAdapter
implements Camera {
    @NonNull
    private final CameraInternal mCameraInternal;
    private final LinkedHashSet<CameraInternal> mCameraInternals;
    private final CameraDeviceSurfaceManager mCameraDeviceSurfaceManager;
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    private static final String TAG = "CameraUseCaseAdapter";
    private final CameraId mId;
    @GuardedBy(value="mLock")
    private final List<UseCase> mAppUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final List<UseCase> mCameraUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final CameraCoordinator mCameraCoordinator;
    @GuardedBy(value="mLock")
    @Nullable
    private ViewPort mViewPort;
    @GuardedBy(value="mLock")
    @NonNull
    private List<CameraEffect> mEffects = Collections.emptyList();
    @GuardedBy(value="mLock")
    @NonNull
    private CameraConfig mCameraConfig = CameraConfigs.emptyConfig();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAttached = true;
    @GuardedBy(value="mLock")
    private Config mInteropConfig = null;
    @GuardedBy(value="mLock")
    @Nullable
    private UseCase mPlaceholderForExtensions;
    @GuardedBy(value="mLock")
    @Nullable
    private StreamSharing mStreamSharing;
    @NonNull
    private final RestrictedCameraControl mRestrictedCameraControl;
    @NonNull
    private final RestrictedCameraInfo mRestrictedCameraInfo;

    public CameraUseCaseAdapter(@NonNull LinkedHashSet<CameraInternal> cameras, @NonNull CameraCoordinator cameraCoordinator, @NonNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this.mCameraInternal = (CameraInternal)cameras.iterator().next();
        this.mCameraInternals = new LinkedHashSet<CameraInternal>(cameras);
        this.mId = new CameraId(this.mCameraInternals);
        this.mCameraCoordinator = cameraCoordinator;
        this.mCameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mRestrictedCameraControl = new RestrictedCameraControl(this.mCameraInternal.getCameraControlInternal());
        this.mRestrictedCameraInfo = new RestrictedCameraInfo(this.mCameraInternal.getCameraInfoInternal(), this.mRestrictedCameraControl);
    }

    @NonNull
    public static CameraId generateCameraId(@NonNull LinkedHashSet<CameraInternal> cameras) {
        return new CameraId(cameras);
    }

    @NonNull
    public CameraId getCameraId() {
        return this.mId;
    }

    public boolean isEquivalent(@NonNull CameraUseCaseAdapter cameraUseCaseAdapter) {
        return this.mId.equals(cameraUseCaseAdapter.getCameraId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPort(@Nullable ViewPort viewPort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mViewPort = viewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffects(@Nullable List<CameraEffect> effects) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEffects = effects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUseCases(@NonNull Collection<UseCase> appUseCasesToAdd) throws CameraException {
        Object object = this.mLock;
        synchronized (object) {
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.addAll(appUseCasesToAdd);
            try {
                this.updateUseCases(appUseCases);
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUseCases(@NonNull Collection<UseCase> useCasesToRemove) {
        Object object = this.mLock;
        synchronized (object) {
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.removeAll(useCasesToRemove);
            this.updateUseCases(appUseCases);
        }
    }

    void updateUseCases(@NonNull Collection<UseCase> appUseCases) {
        this.updateUseCases(appUseCases, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUseCases(@NonNull Collection<UseCase> appUseCases, boolean applyStreamSharing) {
        Object object = this.mLock;
        synchronized (object) {
            Map<UseCase, StreamSpec> suggestedStreamSpecMap;
            UseCase placeholderForExtensions = this.calculatePlaceholderForExtensions(appUseCases);
            StreamSharing streamSharing = this.createOrReuseStreamSharing(appUseCases, applyStreamSharing);
            Collection<UseCase> cameraUseCases = CameraUseCaseAdapter.calculateCameraUseCases(appUseCases, placeholderForExtensions, streamSharing);
            ArrayList<UseCase> cameraUseCasesToAttach = new ArrayList<UseCase>(cameraUseCases);
            cameraUseCasesToAttach.removeAll(this.mCameraUseCases);
            ArrayList<UseCase> cameraUseCasesToKeep = new ArrayList<UseCase>(cameraUseCases);
            cameraUseCasesToKeep.retainAll(this.mCameraUseCases);
            ArrayList<UseCase> cameraUseCasesToDetach = new ArrayList<UseCase>(this.mCameraUseCases);
            cameraUseCasesToDetach.removeAll(cameraUseCases);
            Map<UseCase, ConfigPair> configs = this.getConfigs(cameraUseCasesToAttach, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
            try {
                suggestedStreamSpecMap = this.calculateSuggestedStreamSpecs(this.getCameraMode(), this.mCameraInternal.getCameraInfoInternal(), cameraUseCasesToAttach, cameraUseCasesToKeep, configs);
            }
            catch (IllegalArgumentException exception) {
                if (!applyStreamSharing && this.hasNoExtension() && this.mCameraCoordinator.getCameraOperatingMode() != 2) {
                    this.updateUseCases(appUseCases, true);
                    return;
                }
                throw exception;
            }
            this.updateViewPort(suggestedStreamSpecMap, cameraUseCases);
            CameraUseCaseAdapter.updateEffects(this.mEffects, cameraUseCases, appUseCases);
            for (UseCase useCase : cameraUseCasesToDetach) {
                useCase.unbindFromCamera(this.mCameraInternal);
            }
            this.mCameraInternal.detachUseCases(cameraUseCasesToDetach);
            if (!cameraUseCasesToDetach.isEmpty()) {
                for (UseCase useCase : cameraUseCasesToKeep) {
                    StreamSpec newStreamSpec;
                    Config config;
                    if (!suggestedStreamSpecMap.containsKey(useCase) || (config = (newStreamSpec = suggestedStreamSpecMap.get(useCase)).getImplementationOptions()) == null || !CameraUseCaseAdapter.hasImplementationOptionChanged(newStreamSpec, useCase.getSessionConfig())) continue;
                    useCase.updateSuggestedStreamSpecImplementationOptions(config);
                }
            }
            for (UseCase useCase : cameraUseCasesToAttach) {
                ConfigPair configPair = Objects.requireNonNull(configs.get(useCase));
                useCase.bindToCamera(this.mCameraInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedStreamSpec((StreamSpec)Preconditions.checkNotNull((Object)suggestedStreamSpecMap.get(useCase)));
            }
            if (this.mAttached) {
                this.mCameraInternal.attachUseCases(cameraUseCasesToAttach);
            }
            for (UseCase useCase : cameraUseCasesToAttach) {
                useCase.notifyState();
            }
            this.mAppUseCases.clear();
            this.mAppUseCases.addAll(appUseCases);
            this.mCameraUseCases.clear();
            this.mCameraUseCases.addAll(cameraUseCases);
            this.mPlaceholderForExtensions = placeholderForExtensions;
            this.mStreamSharing = streamSharing;
        }
    }

    private static boolean hasImplementationOptionChanged(StreamSpec streamSpec, SessionConfig sessionConfig) {
        Config newStreamSpecOptions = streamSpec.getImplementationOptions();
        Config sessionConfigOptions = sessionConfig.getImplementationOptions();
        if (newStreamSpecOptions.listOptions().size() != sessionConfig.getImplementationOptions().listOptions().size()) {
            return true;
        }
        for (Config.Option<?> newOption : newStreamSpecOptions.listOptions()) {
            if (sessionConfigOptions.containsOption(newOption) && Objects.equals(sessionConfigOptions.retrieveOption(newOption), newStreamSpecOptions.retrieveOption(newOption))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraCoordinator.getCameraOperatingMode() == 2) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoExtension() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig == CameraConfigs.emptyConfig();
        }
    }

    @NonNull
    private Set<UseCase> getStreamSharingChildren(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        HashSet<UseCase> children = new HashSet<UseCase>();
        int sharingTargets = this.getSharingTargets(forceSharingToPreviewAndVideo);
        for (UseCase useCase : appUseCases) {
            Preconditions.checkArgument((!StreamSharing.isStreamSharing(useCase) ? 1 : 0) != 0, (Object)"Only support one level of sharing for now.");
            if (!useCase.isEffectTargetsSupported(sharingTargets)) continue;
            children.add(useCase);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSharingTargets(boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            int sharingTargets;
            CameraEffect sharingEffect = null;
            for (CameraEffect effect : this.mEffects) {
                if (TargetUtils.getNumberOfTargets(effect.getTargets()) <= 1) continue;
                Preconditions.checkState((sharingEffect == null ? 1 : 0) != 0, (String)"Can only have one sharing effect.");
                sharingEffect = effect;
            }
            int n = sharingTargets = sharingEffect == null ? 0 : sharingEffect.getTargets();
            if (forceSharingToPreviewAndVideo) {
                sharingTargets |= 3;
            }
            return sharingTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StreamSharing createOrReuseStreamSharing(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            Set<UseCase> newChildren = this.getStreamSharingChildren(appUseCases, forceSharingToPreviewAndVideo);
            if (newChildren.size() < 2) {
                return null;
            }
            if (this.mStreamSharing != null && this.mStreamSharing.getChildren().equals(newChildren)) {
                return Objects.requireNonNull(this.mStreamSharing);
            }
            if (!CameraUseCaseAdapter.isStreamSharingChildrenCombinationValid(newChildren)) {
                return null;
            }
            return new StreamSharing(this.mCameraInternal, newChildren, this.mUseCaseConfigFactory);
        }
    }

    static boolean isStreamSharingChildrenCombinationValid(@NonNull Collection<UseCase> children) {
        int[] validChildrenTypes = new int[]{1, 2, 4};
        HashSet<Integer> childrenTypes = new HashSet<Integer>();
        for (UseCase child : children) {
            for (int type : validChildrenTypes) {
                if (!child.isEffectTargetsSupported(type)) continue;
                if (childrenTypes.contains(type)) {
                    return false;
                }
                childrenTypes.add(type);
            }
        }
        return true;
    }

    static Collection<UseCase> calculateCameraUseCases(@NonNull Collection<UseCase> appUseCases, @Nullable UseCase placeholderForExtensions, @Nullable StreamSharing streamSharing) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(appUseCases);
        if (placeholderForExtensions != null) {
            useCases.add(placeholderForExtensions);
        }
        if (streamSharing != null) {
            useCases.add(streamSharing);
            useCases.removeAll(streamSharing.getChildren());
        }
        return useCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mAppUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    Collection<UseCase> getCameraUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mCameraUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAttached) {
                this.mCameraInternal.attachUseCases(this.mCameraUseCases);
                this.restoreInteropConfig();
                for (UseCase useCase : this.mCameraUseCases) {
                    useCase.notifyState();
                }
                this.mAttached = true;
            }
        }
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mCameraInternal.setActiveResumingMode(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mCameraUseCases));
                this.cacheInteropConfig();
                this.mAttached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteropConfig != null) {
                this.mCameraInternal.getCameraControlInternal().addInteropConfig(this.mInteropConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            CameraControlInternal cameraControlInternal = this.mCameraInternal.getCameraControlInternal();
            this.mInteropConfig = cameraControlInternal.getInteropConfig();
            cameraControlInternal.clearInteropConfig();
        }
    }

    private Map<UseCase, StreamSpec> calculateSuggestedStreamSpecs(int cameraMode, @NonNull CameraInfoInternal cameraInfoInternal, @NonNull Collection<UseCase> newUseCases, @NonNull Collection<UseCase> currentUseCases, @NonNull Map<UseCase, ConfigPair> configPairMap) {
        ArrayList<AttachedSurfaceInfo> existingSurfaces = new ArrayList<AttachedSurfaceInfo>();
        String cameraId = cameraInfoInternal.getCameraId();
        HashMap<UseCase, StreamSpec> suggestedStreamSpecs = new HashMap<UseCase, StreamSpec>();
        HashMap<AttachedSurfaceInfo, UseCase> surfaceInfoUseCaseMap = new HashMap<AttachedSurfaceInfo, UseCase>();
        for (UseCase useCase : currentUseCases) {
            SurfaceConfig surfaceConfig = this.mCameraDeviceSurfaceManager.transformSurfaceConfig(cameraMode, cameraId, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution());
            AttachedSurfaceInfo attachedSurfaceInfo = AttachedSurfaceInfo.create(surfaceConfig, useCase.getImageFormat(), useCase.getAttachedSurfaceResolution(), ((StreamSpec)Preconditions.checkNotNull((Object)useCase.getAttachedStreamSpec())).getDynamicRange(), StreamSharing.getCaptureTypes(useCase), useCase.getAttachedStreamSpec().getImplementationOptions(), useCase.getCurrentConfig().getTargetFrameRate(null));
            existingSurfaces.add(attachedSurfaceInfo);
            surfaceInfoUseCaseMap.put(attachedSurfaceInfo, useCase);
            suggestedStreamSpecs.put(useCase, useCase.getAttachedStreamSpec());
        }
        if (!newUseCases.isEmpty()) {
            Rect sensorRect;
            HashMap configToUseCaseMap = new HashMap();
            HashMap configToSupportedSizesMap = new HashMap();
            try {
                sensorRect = this.mCameraInternal.getCameraControlInternal().getSensorRect();
            }
            catch (NullPointerException e) {
                sensorRect = null;
            }
            SupportedOutputSizesSorter supportedOutputSizesSorter = new SupportedOutputSizesSorter(cameraInfoInternal, sensorRect != null ? TransformUtils.rectToSize(sensorRect) : null);
            boolean isPreviewStabilizationOn = false;
            for (UseCase useCase : newUseCases) {
                ConfigPair configPair = configPairMap.get(useCase);
                UseCaseConfig<?> combinedUseCaseConfig = useCase.mergeConfigs(cameraInfoInternal, configPair.mExtendedConfig, configPair.mCameraConfig);
                configToUseCaseMap.put(combinedUseCaseConfig, useCase);
                configToSupportedSizesMap.put(combinedUseCaseConfig, supportedOutputSizesSorter.getSortedSupportedOutputSizes(combinedUseCaseConfig));
            }
            Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> streamSpecMaps = this.mCameraDeviceSurfaceManager.getSuggestedStreamSpecs(cameraMode, cameraId, existingSurfaces, configToSupportedSizesMap, isPreviewStabilizationOn);
            for (Map.Entry entry : configToUseCaseMap.entrySet()) {
                suggestedStreamSpecs.put((UseCase)entry.getValue(), (StreamSpec)((Map)streamSpecMaps.first).get(entry.getKey()));
            }
            for (Map.Entry entry : ((Map)streamSpecMaps.second).entrySet()) {
                if (!surfaceInfoUseCaseMap.containsKey(entry.getKey())) continue;
                suggestedStreamSpecs.put((UseCase)surfaceInfoUseCaseMap.get(entry.getKey()), (StreamSpec)entry.getValue());
            }
        }
        return suggestedStreamSpecs;
    }

    @VisibleForTesting
    static void updateEffects(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> cameraUseCases, @NonNull Collection<UseCase> appUseCases) {
        List<CameraEffect> unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(effects, cameraUseCases);
        ArrayList<UseCase> appOnlyUseCases = new ArrayList<UseCase>(appUseCases);
        appOnlyUseCases.removeAll(cameraUseCases);
        unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(unusedEffects, appOnlyUseCases);
        if (unusedEffects.size() > 0) {
            Logger.w(TAG, "Unused effects: " + unusedEffects);
        }
    }

    @NonNull
    private static List<CameraEffect> setEffectsOnUseCases(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> useCases) {
        ArrayList<CameraEffect> unusedEffects = new ArrayList<CameraEffect>(effects);
        for (UseCase useCase : useCases) {
            useCase.setEffect(null);
            for (CameraEffect effect : effects) {
                if (!useCase.isEffectTargetsSupported(effect.getTargets())) continue;
                Preconditions.checkState((useCase.getEffect() == null ? 1 : 0) != 0, (String)(useCase + " already has effect" + useCase.getEffect()));
                useCase.setEffect(effect);
                unusedEffects.remove(effect);
            }
        }
        return unusedEffects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewPort(@NonNull Map<UseCase, StreamSpec> suggestedStreamSpecMap, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewPort != null) {
                boolean isFrontCamera;
                Integer lensFacing = this.mCameraInternal.getCameraInfoInternal().getLensFacing();
                if (lensFacing == null) {
                    Logger.w(TAG, "The lens facing is null, probably an external.");
                    isFrontCamera = true;
                } else {
                    isFrontCamera = lensFacing == 0;
                }
                Map<UseCase, Rect> cropRectMap = ViewPorts.calculateViewPortRects(this.mCameraInternal.getCameraControlInternal().getSensorRect(), isFrontCamera, this.mViewPort.getAspectRatio(), this.mCameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.mViewPort.getRotation()), this.mViewPort.getScaleType(), this.mViewPort.getLayoutDirection(), suggestedStreamSpecMap);
                for (UseCase useCase : useCases) {
                    useCase.setViewPortCropRect((Rect)Preconditions.checkNotNull((Object)cropRectMap.get(useCase)));
                    useCase.setSensorToBufferTransformMatrix(CameraUseCaseAdapter.calculateSensorToBufferTransformMatrix(this.mCameraInternal.getCameraControlInternal().getSensorRect(), ((StreamSpec)Preconditions.checkNotNull((Object)suggestedStreamSpecMap.get(useCase))).getResolution()));
                }
            }
        }
    }

    @NonNull
    private static Matrix calculateSensorToBufferTransformMatrix(@NonNull Rect fullSensorRect, @NonNull Size useCaseSize) {
        Preconditions.checkArgument((fullSensorRect.width() > 0 && fullSensorRect.height() > 0 ? 1 : 0) != 0, (Object)"Cannot compute viewport crop rects zero sized sensor rect.");
        RectF fullSensorRectF = new RectF(fullSensorRect);
        Matrix sensorToUseCaseTransformation = new Matrix();
        RectF srcRect = new RectF(0.0f, 0.0f, (float)useCaseSize.getWidth(), (float)useCaseSize.getHeight());
        sensorToUseCaseTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
        sensorToUseCaseTransformation.invert(sensorToUseCaseTransformation);
        return sensorToUseCaseTransformation;
    }

    private Map<UseCase, ConfigPair> getConfigs(Collection<UseCase> useCases, UseCaseConfigFactory extendedFactory, UseCaseConfigFactory cameraFactory) {
        HashMap<UseCase, ConfigPair> configs = new HashMap<UseCase, ConfigPair>();
        for (UseCase useCase : useCases) {
            configs.put(useCase, new ConfigPair(useCase.getDefaultConfig(false, extendedFactory), useCase.getDefaultConfig(true, cameraFactory)));
        }
        return configs;
    }

    @Override
    @NonNull
    public CameraControl getCameraControl() {
        return this.mRestrictedCameraControl;
    }

    @Override
    @NonNull
    public CameraInfo getCameraInfo() {
        return this.mRestrictedCameraInfo;
    }

    @Override
    @NonNull
    public LinkedHashSet<CameraInternal> getCameraInternals() {
        return this.mCameraInternals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public CameraConfig getExtendedConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
        Object object = this.mLock;
        synchronized (object) {
            if (cameraConfig == null) {
                cameraConfig = CameraConfigs.emptyConfig();
            }
            if (!this.mAppUseCases.isEmpty() && !this.mCameraConfig.getCompatibilityId().equals(cameraConfig.getCompatibilityId())) {
                throw new IllegalStateException("Need to unbind all use cases before binding with extension enabled");
            }
            this.mCameraConfig = cameraConfig;
            SessionProcessor sessionProcessor = this.mCameraConfig.getSessionProcessor(null);
            if (sessionProcessor != null) {
                Set<Integer> supportedOps = sessionProcessor.getSupportedCameraOperations();
                this.mRestrictedCameraControl.enableRestrictedOperations(true, supportedOps);
            } else {
                this.mRestrictedCameraControl.enableRestrictedOperations(false, null);
            }
            this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUseCasesCombinationSupported(boolean withStreamSharing, UseCase ... useCases) {
        Collection<UseCase> useCasesToVerify = Arrays.asList(useCases);
        if (withStreamSharing) {
            StreamSharing streamSharing = this.createOrReuseStreamSharing(useCasesToVerify, true);
            useCasesToVerify = CameraUseCaseAdapter.calculateCameraUseCases(useCasesToVerify, null, streamSharing);
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                Map<UseCase, ConfigPair> configs = this.getConfigs(useCasesToVerify, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory);
                this.calculateSuggestedStreamSpecs(this.getCameraMode(), this.mCameraInternal.getCameraInfoInternal(), useCasesToVerify, Collections.emptyList(), configs);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    UseCase calculatePlaceholderForExtensions(@NonNull Collection<UseCase> appUseCases) {
        Object object = this.mLock;
        synchronized (object) {
            UseCase placeholder = null;
            if (this.isCoexistingPreviewImageCaptureRequired()) {
                if (this.isExtraPreviewRequired(appUseCases)) {
                    placeholder = CameraUseCaseAdapter.isPreview(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraPreview();
                } else if (this.isExtraImageCaptureRequired(appUseCases)) {
                    placeholder = CameraUseCaseAdapter.isImageCapture(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraImageCapture();
                }
            }
            return placeholder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoexistingPreviewImageCaptureRequired() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getUseCaseCombinationRequiredRule() == 1;
        }
    }

    private boolean isExtraPreviewRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreview = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase)) {
                hasPreview = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasImageCapture && !hasPreview;
    }

    private boolean isExtraImageCaptureRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreview = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase)) {
                hasPreview = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasPreview && !hasImageCapture;
    }

    private static boolean isPreview(@Nullable UseCase useCase) {
        return useCase instanceof Preview;
    }

    private static boolean isImageCapture(@Nullable UseCase useCase) {
        return useCase instanceof ImageCapture;
    }

    private Preview createExtraPreview() {
        Preview preview = new Preview.Builder().setTargetName("Preview-Extra").build();
        preview.setSurfaceProvider(surfaceRequest -> {
            SurfaceTexture surfaceTexture = new SurfaceTexture(0);
            surfaceTexture.setDefaultBufferSize(surfaceRequest.getResolution().getWidth(), surfaceRequest.getResolution().getHeight());
            surfaceTexture.detachFromGLContext();
            Surface surface = new Surface(surfaceTexture);
            surfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), (Consumer<SurfaceRequest.Result>)((Consumer)surfaceResponse -> {
                surface.release();
                surfaceTexture.release();
            }));
        });
        return preview;
    }

    private ImageCapture createExtraImageCapture() {
        return new ImageCapture.Builder().setTargetName("ImageCapture-Extra").build();
    }

    public static final class CameraId {
        private final List<String> mIds = new ArrayList<String>();

        CameraId(LinkedHashSet<CameraInternal> cameraInternals) {
            for (CameraInternal cameraInternal : cameraInternals) {
                this.mIds.add(cameraInternal.getCameraInfoInternal().getCameraId());
            }
        }

        public boolean equals(Object cameraId) {
            if (cameraId instanceof CameraId) {
                return this.mIds.equals(((CameraId)cameraId).mIds);
            }
            return false;
        }

        public int hashCode() {
            return 53 * this.mIds.hashCode();
        }
    }

    public static final class CameraException
    extends Exception {
        public CameraException() {
        }

        public CameraException(@NonNull String message) {
            super(message);
        }

        public CameraException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    private static class ConfigPair {
        UseCaseConfig<?> mExtendedConfig;
        UseCaseConfig<?> mCameraConfig;

        ConfigPair(UseCaseConfig<?> extendedConfig, UseCaseConfig<?> cameraConfig) {
            this.mExtendedConfig = extendedConfig;
            this.mCameraConfig = cameraConfig;
        }
    }
}

