/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.TagBundle;

@RequiresApi(api=21)
public class VirtualCameraCaptureResult
implements CameraCaptureResult {
    private static final long INVALID_TIMESTAMP = -1L;
    @Nullable
    private final CameraCaptureResult mBaseCameraCaptureResult;
    @NonNull
    private final TagBundle mTagBundle;
    private final long mTimestamp;

    public VirtualCameraCaptureResult(@NonNull TagBundle tagBundle, @Nullable CameraCaptureResult baseCameraCaptureResult) {
        this(baseCameraCaptureResult, tagBundle, -1L);
    }

    public VirtualCameraCaptureResult(@NonNull TagBundle tagBundle, long timestamp) {
        this(null, tagBundle, timestamp);
    }

    private VirtualCameraCaptureResult(@Nullable CameraCaptureResult baseCameraCaptureResult, @NonNull TagBundle tagBundle, long timestamp) {
        this.mBaseCameraCaptureResult = baseCameraCaptureResult;
        this.mTagBundle = tagBundle;
        this.mTimestamp = timestamp;
    }

    @Override
    @NonNull
    public TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    @Override
    @NonNull
    public CameraCaptureMetaData.AfMode getAfMode() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAfMode() : CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @Override
    @NonNull
    public CameraCaptureMetaData.AfState getAfState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAfState() : CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @Override
    @NonNull
    public CameraCaptureMetaData.AeState getAeState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAeState() : CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @Override
    @NonNull
    public CameraCaptureMetaData.AwbState getAwbState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAwbState() : CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @Override
    @NonNull
    public CameraCaptureMetaData.FlashState getFlashState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getFlashState() : CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    @Override
    public long getTimestamp() {
        if (this.mBaseCameraCaptureResult != null) {
            return this.mBaseCameraCaptureResult.getTimestamp();
        }
        if (this.mTimestamp != -1L) {
            return this.mTimestamp;
        }
        throw new IllegalStateException("No timestamp is available.");
    }
}

