/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraExecutor;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.InitializationException;
import androidx.camera.core.Logger;
import androidx.camera.core.RetryPolicy;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraProviderExecutionState;
import androidx.camera.core.impl.CameraRepository;
import androidx.camera.core.impl.CameraThreadConfig;
import androidx.camera.core.impl.CameraValidator;
import androidx.camera.core.impl.MetadataHolderService;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.os.HandlerCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
@OptIn(markerClass={ExperimentalRetryPolicy.class})
@MainThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraX {
    private static final String TAG = "CameraX";
    private static final String RETRY_TOKEN = "retry_token";
    final CameraRepository mCameraRepository = new CameraRepository();
    private final Object mInitializeLock = new Object();
    private final CameraXConfig mCameraXConfig;
    private final Executor mCameraExecutor;
    private final Handler mSchedulerHandler;
    @Nullable
    private final HandlerThread mSchedulerThread;
    private CameraFactory mCameraFactory;
    private CameraDeviceSurfaceManager mSurfaceManager;
    private UseCaseConfigFactory mDefaultConfigFactory;
    private RetryPolicy mRetryPolicy;
    private Context mAppContext;
    private final ListenableFuture<Void> mInitInternalFuture;
    @GuardedBy(value="mInitializeLock")
    private InternalInitState mInitState = InternalInitState.UNINITIALIZED;
    @GuardedBy(value="mInitializeLock")
    private ListenableFuture<Void> mShutdownInternalFuture = Futures.immediateFuture(null);
    private final Integer mMinLogLevel;
    private static final Object MIN_LOG_LEVEL_LOCK = new Object();
    @GuardedBy(value="MIN_LOG_LEVEL_LOCK")
    private static final SparseArray<Integer> sMinLogLevelReferenceCountMap = new SparseArray();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CameraX(@NonNull Context context, @Nullable CameraXConfig.Provider configProvider) {
        if (configProvider != null) {
            this.mCameraXConfig = configProvider.getCameraXConfig();
        } else {
            CameraXConfig.Provider provider = CameraX.getConfigProvider(context);
            if (provider == null) {
                throw new IllegalStateException("CameraX is not configured properly. The most likely cause is you did not include a default implementation in your build such as 'camera-camera2'.");
            }
            this.mCameraXConfig = provider.getCameraXConfig();
        }
        Executor executor = this.mCameraXConfig.getCameraExecutor(null);
        Handler schedulerHandler = this.mCameraXConfig.getSchedulerHandler(null);
        Executor executor2 = this.mCameraExecutor = executor == null ? new CameraExecutor() : executor;
        if (schedulerHandler == null) {
            this.mSchedulerThread = new HandlerThread("CameraX-scheduler", 10);
            this.mSchedulerThread.start();
            this.mSchedulerHandler = HandlerCompat.createAsync((Looper)this.mSchedulerThread.getLooper());
        } else {
            this.mSchedulerThread = null;
            this.mSchedulerHandler = schedulerHandler;
        }
        this.mMinLogLevel = this.mCameraXConfig.retrieveOption(CameraXConfig.OPTION_MIN_LOGGING_LEVEL, null);
        CameraX.increaseMinLogLevelReference(this.mMinLogLevel);
        this.mRetryPolicy = new RetryPolicy.Builder(this.mCameraXConfig.getCameraProviderInitRetryPolicy()).build();
        this.mInitInternalFuture = this.initInternal(context);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CameraFactory getCameraFactory() {
        if (this.mCameraFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mCameraFactory;
    }

    @Nullable
    private static CameraXConfig.Provider getConfigProvider(@NonNull Context context) {
        CameraXConfig.Provider configProvider = null;
        Application application = ContextUtil.getApplicationFromContext(context);
        if (application instanceof CameraXConfig.Provider) {
            configProvider = (CameraXConfig.Provider)application;
        } else {
            try {
                Context appContext = ContextUtil.getApplicationContext(context);
                ServiceInfo serviceInfo = appContext.getPackageManager().getServiceInfo(new ComponentName(appContext, MetadataHolderService.class), 640);
                String defaultProviderClassName = null;
                if (serviceInfo.metaData != null) {
                    defaultProviderClassName = serviceInfo.metaData.getString("androidx.camera.core.impl.MetadataHolderService.DEFAULT_CONFIG_PROVIDER");
                }
                if (defaultProviderClassName == null) {
                    Logger.e(TAG, "No default CameraXConfig.Provider specified in meta-data. The most likely cause is you did not include a default implementation in your build such as 'camera-camera2'.");
                    return null;
                }
                Class<?> providerClass = Class.forName(defaultProviderClassName);
                configProvider = (CameraXConfig.Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
                Logger.e(TAG, "Failed to retrieve default CameraXConfig.Provider from meta-data", e);
            }
        }
        return configProvider;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraDeviceSurfaceManager getCameraDeviceSurfaceManager() {
        if (this.mSurfaceManager == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mSurfaceManager;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraRepository getCameraRepository() {
        return this.mCameraRepository;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public UseCaseConfigFactory getDefaultConfigFactory() {
        if (this.mDefaultConfigFactory == null) {
            throw new IllegalStateException("CameraX not initialized yet.");
        }
        return this.mDefaultConfigFactory;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public ListenableFuture<Void> getInitializeFuture() {
        return this.mInitInternalFuture;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public ListenableFuture<Void> shutdown() {
        return this.shutdownInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Void> initInternal(@NonNull Context context) {
        Object object = this.mInitializeLock;
        synchronized (object) {
            Preconditions.checkState((this.mInitState == InternalInitState.UNINITIALIZED ? 1 : 0) != 0, (String)"CameraX.initInternal() should only be called once per instance");
            this.mInitState = InternalInitState.INITIALIZING;
            return CallbackToFutureAdapter.getFuture(completer -> {
                this.initAndRetryRecursively(this.mCameraExecutor, SystemClock.elapsedRealtime(), 1, context, (CallbackToFutureAdapter.Completer<Void>)completer);
                return "CameraX initInternal";
            });
        }
    }

    private void initAndRetryRecursively(@NonNull Executor cameraExecutor, long startMs, int attemptCount, @NonNull Context context, @NonNull CallbackToFutureAdapter.Completer<Void> completer) {
        cameraExecutor.execute(() -> {
            try {
                CameraFactory.Provider cameraFactoryProvider;
                this.mAppContext = ContextUtil.getApplicationFromContext(context);
                if (this.mAppContext == null) {
                    this.mAppContext = ContextUtil.getApplicationContext(context);
                }
                if ((cameraFactoryProvider = this.mCameraXConfig.getCameraFactoryProvider(null)) == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing CameraFactory."));
                }
                CameraThreadConfig cameraThreadConfig = CameraThreadConfig.create(this.mCameraExecutor, this.mSchedulerHandler);
                CameraSelector availableCamerasLimiter = this.mCameraXConfig.getAvailableCamerasLimiter(null);
                long cameraOpenRetryMaxTimeoutInMillis = this.mCameraXConfig.getCameraOpenRetryMaxTimeoutInMillisWhileResuming();
                this.mCameraFactory = cameraFactoryProvider.newInstance(this.mAppContext, cameraThreadConfig, availableCamerasLimiter, cameraOpenRetryMaxTimeoutInMillis);
                CameraDeviceSurfaceManager.Provider surfaceManagerProvider = this.mCameraXConfig.getDeviceSurfaceManagerProvider(null);
                if (surfaceManagerProvider == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing CameraDeviceSurfaceManager."));
                }
                this.mSurfaceManager = surfaceManagerProvider.newInstance(this.mAppContext, this.mCameraFactory.getCameraManager(), this.mCameraFactory.getAvailableCameraIds());
                UseCaseConfigFactory.Provider configFactoryProvider = this.mCameraXConfig.getUseCaseConfigFactoryProvider(null);
                if (configFactoryProvider == null) {
                    throw new InitializationException(new IllegalArgumentException("Invalid app configuration provided. Missing UseCaseConfigFactory."));
                }
                this.mDefaultConfigFactory = configFactoryProvider.newInstance(this.mAppContext);
                if (cameraExecutor instanceof CameraExecutor) {
                    CameraExecutor executor = (CameraExecutor)cameraExecutor;
                    executor.init(this.mCameraFactory);
                }
                this.mCameraRepository.init(this.mCameraFactory);
                CameraValidator.validateCameras(this.mAppContext, this.mCameraRepository, availableCamerasLimiter);
                this.setStateToInitialized();
                completer.set(null);
            }
            catch (InitializationException | CameraValidator.CameraIdListIncorrectException | RuntimeException e) {
                RetryPolicy.RetryConfig retryConfig = this.mRetryPolicy.onRetryDecisionRequested(new CameraProviderExecutionState(startMs, attemptCount, e));
                if (retryConfig.shouldRetry() && attemptCount < Integer.MAX_VALUE) {
                    Logger.w(TAG, "Retry init. Start time " + startMs + " current time " + SystemClock.elapsedRealtime(), e);
                    HandlerCompat.postDelayed((Handler)this.mSchedulerHandler, () -> this.initAndRetryRecursively(cameraExecutor, startMs, attemptCount + 1, this.mAppContext, completer), (Object)RETRY_TOKEN, (long)retryConfig.getRetryDelayInMillis());
                }
                Object availableCamerasLimiter = this.mInitializeLock;
                synchronized (availableCamerasLimiter) {
                    this.mInitState = InternalInitState.INITIALIZING_ERROR;
                }
                if (retryConfig.shouldCompleteWithoutFailure()) {
                    this.setStateToInitialized();
                    completer.set(null);
                }
                if (e instanceof CameraValidator.CameraIdListIncorrectException) {
                    String message = "Device reporting less cameras than anticipated. On real devices: Retrying initialization might resolve temporary camera errors. On emulators: Ensure virtual camera configuration matches supported camera features as reported by PackageManager#hasSystemFeature. Available cameras: " + ((CameraValidator.CameraIdListIncorrectException)e).getAvailableCameraCount();
                    Logger.e(TAG, message, e);
                    completer.setException((Throwable)new InitializationException(new CameraUnavailableException(3, message)));
                }
                if (e instanceof InitializationException) {
                    completer.setException((Throwable)e);
                }
                completer.setException((Throwable)new InitializationException(e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateToInitialized() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            this.mInitState = InternalInitState.INITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ListenableFuture<Void> shutdownInternal() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            this.mSchedulerHandler.removeCallbacksAndMessages((Object)RETRY_TOKEN);
            switch (this.mInitState.ordinal()) {
                case 0: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    return Futures.immediateFuture(null);
                }
                case 1: {
                    throw new IllegalStateException("CameraX could not be shutdown when it is initializing.");
                }
                case 2: 
                case 3: {
                    this.mInitState = InternalInitState.SHUTDOWN;
                    CameraX.decreaseMinLogLevelReference(this.mMinLogLevel);
                    this.mShutdownInternalFuture = CallbackToFutureAdapter.getFuture(completer -> {
                        ListenableFuture<Void> future = this.mCameraRepository.deinit();
                        future.addListener(() -> {
                            if (this.mSchedulerThread != null) {
                                if (this.mCameraExecutor instanceof CameraExecutor) {
                                    CameraExecutor executor = (CameraExecutor)this.mCameraExecutor;
                                    executor.deinit();
                                }
                                this.mSchedulerThread.quit();
                            }
                            completer.set(null);
                        }, this.mCameraExecutor);
                        return "CameraX shutdownInternal";
                    });
                }
            }
            return this.mShutdownInternalFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInitialized() {
        Object object = this.mInitializeLock;
        synchronized (object) {
            return this.mInitState == InternalInitState.INITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void increaseMinLogLevelReference(@Nullable Integer minLogLevel) {
        Object object = MIN_LOG_LEVEL_LOCK;
        synchronized (object) {
            if (minLogLevel == null) {
                return;
            }
            Preconditions.checkArgumentInRange((int)minLogLevel, (int)3, (int)6, (String)"minLogLevel");
            int refCount = 1;
            if (sMinLogLevelReferenceCountMap.get(minLogLevel.intValue()) != null) {
                refCount = (Integer)sMinLogLevelReferenceCountMap.get(minLogLevel.intValue()) + 1;
            }
            sMinLogLevelReferenceCountMap.put(minLogLevel.intValue(), (Object)refCount);
            CameraX.updateOrResetMinLogLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decreaseMinLogLevelReference(@Nullable Integer minLogLevel) {
        Object object = MIN_LOG_LEVEL_LOCK;
        synchronized (object) {
            if (minLogLevel == null) {
                return;
            }
            int refCount = (Integer)sMinLogLevelReferenceCountMap.get(minLogLevel.intValue()) - 1;
            if (refCount == 0) {
                sMinLogLevelReferenceCountMap.remove(minLogLevel.intValue());
            } else {
                sMinLogLevelReferenceCountMap.put(minLogLevel.intValue(), (Object)refCount);
            }
            CameraX.updateOrResetMinLogLevel();
        }
    }

    @GuardedBy(value="MIN_LOG_LEVEL_LOCK")
    private static void updateOrResetMinLogLevel() {
        if (sMinLogLevelReferenceCountMap.size() == 0) {
            Logger.resetMinLogLevel();
            return;
        }
        if (sMinLogLevelReferenceCountMap.get(3) != null) {
            Logger.setMinLogLevel(3);
        } else if (sMinLogLevelReferenceCountMap.get(4) != null) {
            Logger.setMinLogLevel(4);
        } else if (sMinLogLevelReferenceCountMap.get(5) != null) {
            Logger.setMinLogLevel(5);
        } else if (sMinLogLevelReferenceCountMap.get(6) != null) {
            Logger.setMinLogLevel(6);
        }
    }

    private static enum InternalInitState {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZING_ERROR,
        INITIALIZED,
        SHUTDOWN;

    }
}

