/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import java.nio.ByteBuffer;

@RequiresApi(value=21)
final class ImageProxyDownsampler {
    private ImageProxyDownsampler() {
    }

    static ForwardingImageProxy downsample(ImageProxy image, int downsampledWidth, int downsampledHeight, DownsamplingMethod downsamplingMethod) {
        if (image.getFormat() != 35) {
            throw new UnsupportedOperationException("Only YUV_420_888 format is currently supported.");
        }
        if (image.getWidth() < downsampledWidth || image.getHeight() < downsampledHeight) {
            throw new IllegalArgumentException("Downsampled dimension " + new Size(downsampledWidth, downsampledHeight) + " is not <= original dimension " + new Size(image.getWidth(), image.getHeight()) + ".");
        }
        if (image.getWidth() == downsampledWidth && image.getHeight() == downsampledHeight) {
            return new ForwardingImageProxyImpl(image, image.getPlanes(), downsampledWidth, downsampledHeight);
        }
        int[] inputWidths = new int[]{image.getWidth(), image.getWidth() / 2, image.getWidth() / 2};
        int[] inputHeights = new int[]{image.getHeight(), image.getHeight() / 2, image.getHeight() / 2};
        int[] outputWidths = new int[]{downsampledWidth, downsampledWidth / 2, downsampledWidth / 2};
        int[] outputHeights = new int[]{downsampledHeight, downsampledHeight / 2, downsampledHeight / 2};
        ImageProxy.PlaneProxy[] outputPlanes = new ImageProxy.PlaneProxy[3];
        for (int i = 0; i < 3; ++i) {
            ImageProxy.PlaneProxy inputPlane = image.getPlanes()[i];
            ByteBuffer inputBuffer = inputPlane.getBuffer();
            byte[] output = new byte[outputWidths[i] * outputHeights[i]];
            switch (downsamplingMethod.ordinal()) {
                case 0: {
                    ImageProxyDownsampler.resizeNearestNeighbor(inputBuffer, inputWidths[i], inputPlane.getPixelStride(), inputPlane.getRowStride(), inputHeights[i], output, outputWidths[i], outputHeights[i]);
                    break;
                }
                case 1: {
                    ImageProxyDownsampler.resizeAveraging(inputBuffer, inputWidths[i], inputPlane.getPixelStride(), inputPlane.getRowStride(), inputHeights[i], output, outputWidths[i], outputHeights[i]);
                }
            }
            outputPlanes[i] = ImageProxyDownsampler.createPlaneProxy(outputWidths[i], 1, output);
        }
        return new ForwardingImageProxyImpl(image, outputPlanes, downsampledWidth, downsampledHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resizeNearestNeighbor(ByteBuffer input, int inputWidth, int inputPixelStride, int inputRowStride, int inputHeight, byte[] output, int outputWidth, int outputHeight) {
        float scaleX = (float)inputWidth / (float)outputWidth;
        float scaleY = (float)inputHeight / (float)outputHeight;
        byte[] row = new byte[inputRowStride];
        int[] sourceIndices = new int[outputWidth];
        for (int ix = 0; ix < outputWidth; ++ix) {
            float sourceX = (float)ix * scaleX;
            int floorSourceX = (int)sourceX;
            sourceIndices[ix] = floorSourceX * inputPixelStride;
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            input.rewind();
            for (int iy = 0; iy < outputHeight; ++iy) {
                float sourceY = (float)iy * scaleY;
                int floorSourceY = (int)sourceY;
                int rowOffsetSource = Math.min(floorSourceY, inputHeight - 1) * inputRowStride;
                int rowOffsetTarget = iy * outputWidth;
                input.position(rowOffsetSource);
                input.get(row, 0, Math.min(inputRowStride, input.remaining()));
                for (int ix = 0; ix < outputWidth; ++ix) {
                    output[rowOffsetTarget + ix] = row[sourceIndices[ix]];
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resizeAveraging(ByteBuffer input, int inputWidth, int inputPixelStride, int inputRowStride, int inputHeight, byte[] output, int outputWidth, int outputHeight) {
        float scaleX = (float)inputWidth / (float)outputWidth;
        float scaleY = (float)inputHeight / (float)outputHeight;
        byte[] row0 = new byte[inputRowStride];
        byte[] row1 = new byte[inputRowStride];
        int[] sourceIndices = new int[outputWidth];
        for (int ix = 0; ix < outputWidth; ++ix) {
            float sourceX = (float)ix * scaleX;
            int floorSourceX = (int)sourceX;
            sourceIndices[ix] = floorSourceX * inputPixelStride;
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            input.rewind();
            for (int iy = 0; iy < outputHeight; ++iy) {
                float sourceY = (float)iy * scaleY;
                int floorSourceY = (int)sourceY;
                int rowOffsetSource0 = Math.min(floorSourceY, inputHeight - 1) * inputRowStride;
                int rowOffsetSource1 = Math.min(floorSourceY + 1, inputHeight - 1) * inputRowStride;
                int rowOffsetTarget = iy * outputWidth;
                input.position(rowOffsetSource0);
                input.get(row0, 0, Math.min(inputRowStride, input.remaining()));
                input.position(rowOffsetSource1);
                input.get(row1, 0, Math.min(inputRowStride, input.remaining()));
                for (int ix = 0; ix < outputWidth; ++ix) {
                    int sampleA = row0[sourceIndices[ix]] & 0xFF;
                    int sampleB = row0[sourceIndices[ix] + inputPixelStride] & 0xFF;
                    int sampleC = row1[sourceIndices[ix]] & 0xFF;
                    int sampleD = row1[sourceIndices[ix] + inputPixelStride] & 0xFF;
                    int mixed = (sampleA + sampleB + sampleC + sampleD) / 4;
                    output[rowOffsetTarget + ix] = (byte)(mixed & 0xFF);
                }
            }
        }
    }

    private static ImageProxy.PlaneProxy createPlaneProxy(final int rowStride, final int pixelStride, final byte[] data) {
        return new ImageProxy.PlaneProxy(){
            final ByteBuffer mBuffer;
            {
                this.mBuffer = ByteBuffer.wrap(data);
            }

            @Override
            public int getRowStride() {
                return rowStride;
            }

            @Override
            public int getPixelStride() {
                return pixelStride;
            }

            @Override
            @NonNull
            public ByteBuffer getBuffer() {
                return this.mBuffer;
            }
        };
    }

    private static final class ForwardingImageProxyImpl
    extends ForwardingImageProxy {
        private final ImageProxy.PlaneProxy[] mDownsampledPlanes;
        private final int mDownsampledWidth;
        private final int mDownsampledHeight;

        ForwardingImageProxyImpl(ImageProxy originalImage, ImageProxy.PlaneProxy[] downsampledPlanes, int downsampledWidth, int downsampledHeight) {
            super(originalImage);
            this.mDownsampledPlanes = downsampledPlanes;
            this.mDownsampledWidth = downsampledWidth;
            this.mDownsampledHeight = downsampledHeight;
        }

        @Override
        public int getWidth() {
            return this.mDownsampledWidth;
        }

        @Override
        public int getHeight() {
            return this.mDownsampledHeight;
        }

        @Override
        @NonNull
        public ImageProxy.PlaneProxy[] getPlanes() {
            return this.mDownsampledPlanes;
        }
    }

    static enum DownsamplingMethod {
        NEAREST_NEIGHBOR,
        AVERAGING;

    }
}

