/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.ImageReaderProxys;
import androidx.camera.core.Logger;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SafeCloseImageReaderProxy;
import androidx.camera.core.imagecapture.AutoValue_CaptureNode_In;
import androidx.camera.core.imagecapture.NoMetadataImageReader;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureCallbacks;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.Node;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
class CaptureNode
implements Node<In, ProcessingNode.In> {
    private static final String TAG = "CaptureNode";
    @VisibleForTesting
    static final int MAX_IMAGES = 4;
    ProcessingRequest mCurrentRequest = null;
    @Nullable
    SafeCloseImageReaderProxy mSafeCloseImageReaderProxy;
    @Nullable
    SafeCloseImageReaderProxy mSafeCloseImageReaderForPostview;
    @Nullable
    private ProcessingNode.In mOutputEdge;
    @Nullable
    private In mInputEdge;
    @Nullable
    private NoMetadataImageReader mNoMetadataImageReader = null;

    CaptureNode() {
    }

    @Override
    @NonNull
    public ProcessingNode.In transform(@NonNull In inputEdge) {
        Consumer requestConsumer;
        ImageReaderProxy wrappedImageReader;
        CameraCaptureCallback cameraCaptureCallbacks;
        Preconditions.checkState((this.mInputEdge == null && this.mSafeCloseImageReaderProxy == null ? 1 : 0) != 0, (String)"CaptureNode does not support recreation yet.");
        this.mInputEdge = inputEdge;
        Size size = inputEdge.getSize();
        int format = inputEdge.getInputFormat();
        boolean hasMetadata = !inputEdge.isVirtualCamera();
        CameraCaptureCallback progressCallback = new CameraCaptureCallback(){

            @Override
            public void onCaptureStarted(int captureConfigId) {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    if (CaptureNode.this.mCurrentRequest != null) {
                        CaptureNode.this.mCurrentRequest.onCaptureStarted();
                    }
                });
            }

            @Override
            public void onCaptureProcessProgressed(int captureConfigId, int progress) {
                CameraXExecutors.mainThreadExecutor().execute(() -> {
                    if (CaptureNode.this.mCurrentRequest != null) {
                        CaptureNode.this.mCurrentRequest.onCaptureProcessProgressed(progress);
                    }
                });
            }
        };
        if (hasMetadata && inputEdge.getImageReaderProxyProvider() == null) {
            MetadataImageReader metadataImageReader = new MetadataImageReader(size.getWidth(), size.getHeight(), format, 4);
            cameraCaptureCallbacks = CameraCaptureCallbacks.createComboCallback(progressCallback, metadataImageReader.getCameraCaptureCallback());
            wrappedImageReader = metadataImageReader;
            requestConsumer = this::onRequestAvailable;
        } else {
            cameraCaptureCallbacks = progressCallback;
            this.mNoMetadataImageReader = new NoMetadataImageReader(CaptureNode.createImageReaderProxy(inputEdge.getImageReaderProxyProvider(), size.getWidth(), size.getHeight(), format));
            wrappedImageReader = this.mNoMetadataImageReader;
            requestConsumer = request -> {
                this.onRequestAvailable((ProcessingRequest)request);
                this.mNoMetadataImageReader.acceptProcessingRequest((ProcessingRequest)request);
            };
        }
        inputEdge.setCameraCaptureCallback(cameraCaptureCallbacks);
        inputEdge.setSurface(Objects.requireNonNull(wrappedImageReader.getSurface()));
        this.mSafeCloseImageReaderProxy = new SafeCloseImageReaderProxy(wrappedImageReader);
        wrappedImageReader.setOnImageAvailableListener(imageReader -> {
            block5: {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        this.onImageProxyAvailable(image);
                    } else if (this.mCurrentRequest != null) {
                        this.sendCaptureError(TakePictureManager.CaptureError.of(this.mCurrentRequest.getRequestId(), new ImageCaptureException(2, "Failed to acquire latest image", null)));
                    }
                }
                catch (IllegalStateException e) {
                    if (this.mCurrentRequest == null) break block5;
                    this.sendCaptureError(TakePictureManager.CaptureError.of(this.mCurrentRequest.getRequestId(), new ImageCaptureException(2, "Failed to acquire latest image", e)));
                }
            }
        }, CameraXExecutors.mainThreadExecutor());
        if (inputEdge.getPostviewSize() != null) {
            ImageReaderProxy postviewImageReader = CaptureNode.createImageReaderProxy(inputEdge.getImageReaderProxyProvider(), inputEdge.getPostviewSize().getWidth(), inputEdge.getPostviewSize().getHeight(), inputEdge.getPostviewImageFormat());
            postviewImageReader.setOnImageAvailableListener(imageReader -> {
                try {
                    ImageProxy image = imageReader.acquireLatestImage();
                    if (image != null) {
                        this.propagatePostviewImage(image);
                    }
                }
                catch (IllegalStateException e) {
                    Logger.e(TAG, "Failed to acquire latest image of postview", e);
                }
            }, CameraXExecutors.mainThreadExecutor());
            this.mSafeCloseImageReaderForPostview = new SafeCloseImageReaderProxy(postviewImageReader);
            inputEdge.setPostviewSurface(postviewImageReader.getSurface(), inputEdge.getPostviewSize(), inputEdge.getPostviewImageFormat());
        }
        inputEdge.getRequestEdge().setListener((Consumer<ProcessingRequest>)requestConsumer);
        inputEdge.getErrorEdge().setListener((Consumer<TakePictureManager.CaptureError>)((Consumer)this::sendCaptureError));
        this.mOutputEdge = ProcessingNode.In.of(inputEdge.getInputFormat(), inputEdge.getOutputFormat());
        return this.mOutputEdge;
    }

    @NonNull
    private static ImageReaderProxy createImageReaderProxy(@Nullable ImageReaderProxyProvider imageReaderProxyProvider, int width, int height, int format) {
        if (imageReaderProxyProvider != null) {
            return imageReaderProxyProvider.newInstance(width, height, format, 4, 0L);
        }
        return ImageReaderProxys.createIsolatedReader(width, height, format, 4);
    }

    @VisibleForTesting
    @MainThread
    void onImageProxyAvailable(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mCurrentRequest == null) {
            Logger.w(TAG, "Discarding ImageProxy which was inadvertently acquired: " + imageProxy);
            imageProxy.close();
        } else {
            Integer stageId = (Integer)imageProxy.getImageInfo().getTagBundle().getTag(this.mCurrentRequest.getTagBundleKey());
            if (stageId == null) {
                Logger.w(TAG, "Discarding ImageProxy which was acquired for aborted request");
                imageProxy.close();
                return;
            }
            this.matchAndPropagateImage(imageProxy);
        }
    }

    @MainThread
    private void matchAndPropagateImage(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        Objects.requireNonNull(this.mOutputEdge).getEdge().accept(ProcessingNode.InputPacket.of(this.mCurrentRequest, imageProxy));
        ProcessingRequest request = this.mCurrentRequest;
        this.mCurrentRequest = null;
        request.onImageCaptured();
    }

    private void propagatePostviewImage(@NonNull ImageProxy imageProxy) {
        if (this.mCurrentRequest == null) {
            imageProxy.close();
            return;
        }
        Objects.requireNonNull(this.mOutputEdge).getPostviewEdge().accept(ProcessingNode.InputPacket.of(this.mCurrentRequest, imageProxy));
    }

    @VisibleForTesting
    @MainThread
    void onRequestAvailable(final @NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        Preconditions.checkState((request.getStageIds().size() == 1 ? 1 : 0) != 0, (String)"only one capture stage is supported.");
        Preconditions.checkState((this.getCapacity() > 0 ? 1 : 0) != 0, (String)"Too many acquire images. Close image to be able to process next.");
        this.mCurrentRequest = request;
        Futures.addCallback(request.getCaptureFuture(), new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                Threads.checkMainThread();
                if (request == CaptureNode.this.mCurrentRequest) {
                    Logger.w(CaptureNode.TAG, "request aborted, id=" + CaptureNode.this.mCurrentRequest.getRequestId());
                    if (CaptureNode.this.mNoMetadataImageReader != null) {
                        CaptureNode.this.mNoMetadataImageReader.clearProcessingRequest();
                    }
                    CaptureNode.this.mCurrentRequest = null;
                }
            }
        }, CameraXExecutors.directExecutor());
    }

    @MainThread
    void sendCaptureError(@NonNull TakePictureManager.CaptureError error) {
        Threads.checkMainThread();
        if (this.mCurrentRequest != null && this.mCurrentRequest.getRequestId() == error.getRequestId()) {
            this.mCurrentRequest.onCaptureFailure(error.getImageCaptureException());
        }
    }

    @Override
    @MainThread
    public void release() {
        Threads.checkMainThread();
        this.releaseInputResources(Objects.requireNonNull(this.mInputEdge), Objects.requireNonNull(this.mSafeCloseImageReaderProxy), this.mSafeCloseImageReaderForPostview);
    }

    private void releaseInputResources(@NonNull In inputEdge, @NonNull SafeCloseImageReaderProxy imageReader, @Nullable SafeCloseImageReaderProxy imageReaderForPostview) {
        inputEdge.getSurface().close();
        inputEdge.getSurface().getTerminationFuture().addListener(() -> imageReader.safeClose(), (Executor)CameraXExecutors.mainThreadExecutor());
        if (inputEdge.getPostviewSurface() != null) {
            inputEdge.getPostviewSurface().close();
            inputEdge.getPostviewSurface().getTerminationFuture().addListener(() -> {
                if (imageReaderForPostview != null) {
                    imageReaderForPostview.safeClose();
                }
            }, (Executor)CameraXExecutors.mainThreadExecutor());
        }
    }

    @VisibleForTesting
    @NonNull
    In getInputEdge() {
        return Objects.requireNonNull(this.mInputEdge);
    }

    @VisibleForTesting
    @NonNull
    public SafeCloseImageReaderProxy getSafeCloseImageReaderProxy() {
        return Objects.requireNonNull(this.mSafeCloseImageReaderProxy);
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        return this.mSafeCloseImageReaderProxy.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mSafeCloseImageReaderProxy != null ? 1 : 0) != 0, (String)"The ImageReader is not initialized.");
        this.mSafeCloseImageReaderProxy.setOnImageCloseListener(listener);
    }

    @AutoValue
    static abstract class In {
        @NonNull
        private CameraCaptureCallback mCameraCaptureCallback = new CameraCaptureCallback(){};
        @Nullable
        private DeferrableSurface mSurface;
        @Nullable
        private DeferrableSurface mPostviewSurface = null;

        In() {
        }

        abstract Size getSize();

        abstract int getInputFormat();

        abstract int getOutputFormat();

        abstract boolean isVirtualCamera();

        @Nullable
        abstract ImageReaderProxyProvider getImageReaderProxyProvider();

        @Nullable
        abstract Size getPostviewSize();

        abstract int getPostviewImageFormat();

        @NonNull
        abstract Edge<ProcessingRequest> getRequestEdge();

        @NonNull
        abstract Edge<TakePictureManager.CaptureError> getErrorEdge();

        @NonNull
        DeferrableSurface getSurface() {
            return Objects.requireNonNull(this.mSurface);
        }

        @Nullable
        DeferrableSurface getPostviewSurface() {
            return this.mPostviewSurface;
        }

        void setSurface(@NonNull Surface surface) {
            Preconditions.checkState((this.mSurface == null ? 1 : 0) != 0, (String)"The surface is already set.");
            this.mSurface = new ImmediateSurface(surface, this.getSize(), this.getInputFormat());
        }

        void setPostviewSurface(@NonNull Surface surface, @NonNull Size size, int imageFormat) {
            this.mPostviewSurface = new ImmediateSurface(surface, size, imageFormat);
        }

        @NonNull
        CameraCaptureCallback getCameraCaptureCallback() {
            return this.mCameraCaptureCallback;
        }

        void setCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCameraCaptureCallback = cameraCaptureCallback;
        }

        @NonNull
        static In of(Size size, int inputFormat, int outputFormat, boolean isVirtualCamera, @Nullable ImageReaderProxyProvider imageReaderProxyProvider) {
            return new AutoValue_CaptureNode_In(size, inputFormat, outputFormat, isVirtualCamera, imageReaderProxyProvider, null, 35, new Edge<ProcessingRequest>(), new Edge<TakePictureManager.CaptureError>());
        }

        @NonNull
        static In of(Size size, int inputFormat, int outputFormat, boolean isVirtualCamera, @Nullable ImageReaderProxyProvider imageReaderProxyProvider, @Nullable Size postviewSize, int postviewImageFormat) {
            return new AutoValue_CaptureNode_In(size, inputFormat, outputFormat, isVirtualCamera, imageReaderProxyProvider, postviewSize, postviewImageFormat, new Edge<ProcessingRequest>(), new Edge<TakePictureManager.CaptureError>());
        }
    }
}

