/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.imagecapture.CameraRequest;
import androidx.camera.core.imagecapture.CaptureNode;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.InternalImageProcessor;
import androidx.core.util.Pair;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Objects;

@RequiresApi(api=21)
public class ImagePipeline {
    static final byte JPEG_QUALITY_MAX_QUALITY = 100;
    static final byte JPEG_QUALITY_MIN_LATENCY = 95;
    private static int sNextRequestId = 0;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    @NonNull
    private final ImageCaptureConfig mUseCaseConfig;
    @NonNull
    private final CaptureConfig mCaptureConfig;
    @NonNull
    private final CaptureNode mCaptureNode;
    @NonNull
    private final ProcessingNode mProcessingNode;
    @NonNull
    private final CaptureNode.In mPipelineIn;

    @MainThread
    @VisibleForTesting
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize) {
        this(useCaseConfig, cameraSurfaceSize, null, false, null, 35);
    }

    @MainThread
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize, @Nullable CameraEffect cameraEffect, boolean isVirtualCamera) {
        this(useCaseConfig, cameraSurfaceSize, cameraEffect, isVirtualCamera, null, 35);
    }

    @MainThread
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize, @Nullable CameraEffect cameraEffect, boolean isVirtualCamera, @Nullable Size postviewSize, int postviewImageFormat) {
        Threads.checkMainThread();
        this.mUseCaseConfig = useCaseConfig;
        this.mCaptureConfig = CaptureConfig.Builder.createFrom(useCaseConfig).build();
        this.mCaptureNode = new CaptureNode();
        this.mProcessingNode = new ProcessingNode(Objects.requireNonNull(this.mUseCaseConfig.getIoExecutor(CameraXExecutors.ioExecutor())), cameraEffect != null ? new InternalImageProcessor(cameraEffect) : null);
        this.mPipelineIn = CaptureNode.In.of(cameraSurfaceSize, this.mUseCaseConfig.getInputFormat(), this.getOutputFormat(), isVirtualCamera, this.mUseCaseConfig.getImageReaderProxyProvider(), postviewSize, postviewImageFormat);
        ProcessingNode.In processingIn = this.mCaptureNode.transform(this.mPipelineIn);
        this.mProcessingNode.transform(processingIn);
    }

    @NonNull
    public SessionConfig.Builder createSessionConfigBuilder(@NonNull Size resolution) {
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom(this.mUseCaseConfig, resolution);
        builder.addNonRepeatingSurface(this.mPipelineIn.getSurface());
        if (this.mPipelineIn.getPostviewSurface() != null) {
            builder.setPostviewSurface(this.mPipelineIn.getPostviewSurface());
        }
        return builder;
    }

    @MainThread
    public void close() {
        Threads.checkMainThread();
        this.mCaptureNode.release();
        this.mProcessingNode.release();
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        return this.mCaptureNode.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(@NonNull ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        this.mCaptureNode.setOnImageCloseListener(listener);
    }

    @MainThread
    @NonNull
    Pair<CameraRequest, ProcessingRequest> createRequests(@NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback, @NonNull ListenableFuture<Void> captureFuture) {
        Threads.checkMainThread();
        CaptureBundle captureBundle = this.createCaptureBundle();
        int requestId = sNextRequestId++;
        return new Pair((Object)this.createCameraRequest(requestId, captureBundle, takePictureRequest, takePictureCallback), (Object)this.createProcessingRequest(requestId, captureBundle, takePictureRequest, takePictureCallback, captureFuture));
    }

    @MainThread
    void submitProcessingRequest(@NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        this.mPipelineIn.getRequestEdge().accept(request);
    }

    @MainThread
    void notifyCaptureError(@NonNull TakePictureManager.CaptureError error) {
        Threads.checkMainThread();
        this.mPipelineIn.getErrorEdge().accept(error);
    }

    private int getOutputFormat() {
        Integer bufferFormat = this.mUseCaseConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            return bufferFormat;
        }
        Integer inputFormat = this.mUseCaseConfig.retrieveOption(ImageInputConfig.OPTION_INPUT_FORMAT, null);
        if (inputFormat != null && inputFormat == 4101) {
            return 4101;
        }
        return 256;
    }

    @NonNull
    private CaptureBundle createCaptureBundle() {
        return Objects.requireNonNull(this.mUseCaseConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()));
    }

    @NonNull
    private ProcessingRequest createProcessingRequest(int requestId, @NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback, @NonNull ListenableFuture<Void> captureFuture) {
        return new ProcessingRequest(captureBundle, takePictureRequest.getOutputFileOptions(), takePictureRequest.getCropRect(), takePictureRequest.getRotationDegrees(), takePictureRequest.getJpegQuality(), takePictureRequest.getSensorToBufferTransform(), takePictureCallback, captureFuture, requestId);
    }

    private boolean shouldEnablePostview() {
        return this.mPipelineIn.getPostviewSurface() != null;
    }

    @VisibleForTesting
    @Nullable
    public Size getPostviewSize() {
        return this.mPipelineIn.getPostviewSize();
    }

    private CameraRequest createCameraRequest(int requestId, @NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback) {
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        String tagBundleKey = String.valueOf(captureBundle.hashCode());
        for (CaptureStage captureStage : Objects.requireNonNull(captureBundle.getCaptureStages())) {
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(takePictureRequest.getSessionConfigCameraCaptureCallbacks());
            builder.addSurface(this.mPipelineIn.getSurface());
            builder.setPostviewEnabled(this.shouldEnablePostview());
            if (ImageUtil.isJpegFormats(this.mPipelineIn.getInputFormat())) {
                if (EXIF_ROTATION_AVAILABILITY.isRotationOptionSupported()) {
                    builder.addImplementationOption(CaptureConfig.OPTION_ROTATION, takePictureRequest.getRotationDegrees());
                }
                builder.addImplementationOption(CaptureConfig.OPTION_JPEG_QUALITY, this.getCameraRequestJpegQuality(takePictureRequest));
            }
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            builder.addTag(tagBundleKey, captureStage.getId());
            builder.setId(requestId);
            builder.addCameraCaptureCallback(this.mPipelineIn.getCameraCaptureCallback());
            captureConfigs.add(builder.build());
        }
        return new CameraRequest(captureConfigs, takePictureCallback);
    }

    int getCameraRequestJpegQuality(@NonNull TakePictureRequest request) {
        boolean isOnDisk = request.getOnDiskCallback() != null;
        boolean hasCropping = TransformUtils.hasCropping(request.getCropRect(), this.mPipelineIn.getSize());
        if (isOnDisk && hasCropping) {
            if (request.getCaptureMode() == 0) {
                return 100;
            }
            return 95;
        }
        return request.getJpegQuality();
    }

    @NonNull
    @VisibleForTesting
    CaptureNode getCaptureNode() {
        return this.mCaptureNode;
    }

    @NonNull
    @VisibleForTesting
    ProcessingNode getProcessingNode() {
        return this.mProcessingNode;
    }

    @VisibleForTesting
    public boolean expectsMetadata() {
        return this.mCaptureNode.getSafeCloseImageReaderProxy().getImageReaderProxy() instanceof MetadataImageReader;
    }
}

