/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.core.streamsharing.VirtualCameraCaptureResult;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class NoMetadataImageReader
implements ImageReaderProxy {
    @NonNull
    private final ImageReaderProxy mWrappedImageReader;
    @Nullable
    private ProcessingRequest mPendingRequest;

    NoMetadataImageReader(@NonNull ImageReaderProxy imageReaderProxy) {
        this.mWrappedImageReader = imageReaderProxy;
    }

    void acceptProcessingRequest(@NonNull ProcessingRequest request) {
        Preconditions.checkState((this.mPendingRequest == null ? 1 : 0) != 0, (String)"Pending request should be null");
        this.mPendingRequest = request;
    }

    void clearProcessingRequest() {
        this.mPendingRequest = null;
    }

    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        return this.createImageProxyWithEmptyMetadata(this.mWrappedImageReader.acquireLatestImage());
    }

    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        return this.createImageProxyWithEmptyMetadata(this.mWrappedImageReader.acquireNextImage());
    }

    @Override
    public void close() {
        this.mWrappedImageReader.close();
    }

    @Override
    public int getHeight() {
        return this.mWrappedImageReader.getHeight();
    }

    @Override
    public int getWidth() {
        return this.mWrappedImageReader.getWidth();
    }

    @Override
    public int getImageFormat() {
        return this.mWrappedImageReader.getImageFormat();
    }

    @Override
    public int getMaxImages() {
        return this.mWrappedImageReader.getMaxImages();
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.mWrappedImageReader.getSurface();
    }

    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        this.mWrappedImageReader.setOnImageAvailableListener(imageReader -> listener.onImageAvailable(this), executor);
    }

    @Override
    public void clearOnImageAvailableListener() {
        this.mWrappedImageReader.clearOnImageAvailableListener();
    }

    @Nullable
    private ImageProxy createImageProxyWithEmptyMetadata(@Nullable ImageProxy originalImage) {
        if (originalImage == null) {
            return null;
        }
        TagBundle tagBundle = this.mPendingRequest == null ? TagBundle.emptyBundle() : TagBundle.create((Pair<String, Object>)new Pair((Object)this.mPendingRequest.getTagBundleKey(), (Object)this.mPendingRequest.getStageIds().get(0)));
        this.mPendingRequest = null;
        return new SettableImageProxy(originalImage, new Size(originalImage.getWidth(), originalImage.getHeight()), new CameraCaptureResultImageInfo(new VirtualCameraCaptureResult(tagBundle, originalImage.getImageInfo().getTimestamp())));
    }
}

