/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.CameraCaptureResultImageInfo;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Preconditions;
import java.io.IOException;

@RequiresApi(api=21)
final class ProcessingInput2Packet
implements Operation<ProcessingNode.InputPacket, Packet<ImageProxy>> {
    ProcessingInput2Packet() {
    }

    @Override
    @NonNull
    public Packet<ImageProxy> apply(@NonNull ProcessingNode.InputPacket inputPacket) throws ImageCaptureException {
        ImageProxy image = inputPacket.getImageProxy();
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Exif exif = null;
        if (ImageUtil.isJpegFormats(image.getFormat())) {
            try {
                exif = Exif.createFromImageProxy(image);
                image.getPlanes()[0].getBuffer().rewind();
            }
            catch (IOException e) {
                throw new ImageCaptureException(1, "Failed to extract EXIF data.", e);
            }
        }
        if (ImagePipeline.EXIF_ROTATION_AVAILABILITY.shouldUseExifOrientation(image)) {
            Preconditions.checkNotNull((Object)exif, (Object)"JPEG image must have exif.");
            return ProcessingInput2Packet.createPacketWithHalRotation(request, exif, image);
        }
        return ProcessingInput2Packet.createPacket(request, exif, image);
    }

    private static Packet<ImageProxy> createPacket(@NonNull ProcessingRequest request, @Nullable Exif exif, @NonNull ImageProxy image) {
        return Packet.of(image, exif, request.getCropRect(), request.getRotationDegrees(), request.getSensorToBufferTransform(), ProcessingInput2Packet.getCameraCaptureResult(image));
    }

    private static Packet<ImageProxy> createPacketWithHalRotation(@NonNull ProcessingRequest request, @NonNull Exif exif, @NonNull ImageProxy image) {
        Size surfaceSize = new Size(image.getWidth(), image.getHeight());
        int halRotationDegrees = request.getRotationDegrees() - exif.getRotation();
        Size imageSize = ProcessingInput2Packet.getRotatedSize(halRotationDegrees, surfaceSize);
        Matrix halTransform = TransformUtils.getRectToRect(new RectF(0.0f, 0.0f, (float)surfaceSize.getWidth(), (float)surfaceSize.getHeight()), new RectF(0.0f, 0.0f, (float)imageSize.getWidth(), (float)imageSize.getHeight()), halRotationDegrees);
        return Packet.of(image, exif, imageSize, ProcessingInput2Packet.getUpdatedCropRect(request.getCropRect(), halTransform), exif.getRotation(), ProcessingInput2Packet.getUpdatedTransform(request.getSensorToBufferTransform(), halTransform), ProcessingInput2Packet.getCameraCaptureResult(image));
    }

    private static CameraCaptureResult getCameraCaptureResult(@NonNull ImageProxy image) {
        if (image.getImageInfo() instanceof CameraCaptureResultImageInfo) {
            return ((CameraCaptureResultImageInfo)image.getImageInfo()).getCameraCaptureResult();
        }
        return CameraCaptureResult.EmptyCameraCaptureResult.create();
    }

    @NonNull
    private static Matrix getUpdatedTransform(@NonNull Matrix sensorToSurface, @NonNull Matrix halTransform) {
        Matrix sensorToBuffer = new Matrix(sensorToSurface);
        sensorToBuffer.postConcat(halTransform);
        return sensorToBuffer;
    }

    @NonNull
    private static Rect getUpdatedCropRect(@NonNull Rect cropRect, @NonNull Matrix halTransform) {
        RectF rectF = new RectF(cropRect);
        halTransform.mapRect(rectF);
        rectF.sort();
        Rect rect = new Rect();
        rectF.round(rect);
        return rect;
    }

    private static Size getRotatedSize(int rotationDegrees, Size size) {
        return TransformUtils.is90or270(TransformUtils.within360(rotationDegrees)) ? new Size(size.getHeight(), size.getWidth()) : size;
    }
}

