/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.AutoValue_TakePictureRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.internal.compat.workaround.CaptureFailedRetryEnabler;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
@AutoValue
public abstract class TakePictureRequest {
    private int mRemainingRetires = new CaptureFailedRetryEnabler().getRetryCount();

    @NonNull
    abstract Executor getAppExecutor();

    @Nullable
    public abstract ImageCapture.OnImageCapturedCallback getInMemoryCallback();

    @Nullable
    public abstract ImageCapture.OnImageSavedCallback getOnDiskCallback();

    @Nullable
    abstract ImageCapture.OutputFileOptions getOutputFileOptions();

    @NonNull
    abstract Rect getCropRect();

    @NonNull
    abstract Matrix getSensorToBufferTransform();

    abstract int getRotationDegrees();

    @IntRange(from=1L, to=100L)
    abstract int getJpegQuality();

    abstract int getCaptureMode();

    @NonNull
    abstract List<CameraCaptureCallback> getSessionConfigCameraCaptureCallbacks();

    @MainThread
    boolean decrementRetryCounter() {
        Threads.checkMainThread();
        if (this.mRemainingRetires > 0) {
            --this.mRemainingRetires;
            return true;
        }
        return false;
    }

    @MainThread
    void incrementRetryCounter() {
        Threads.checkMainThread();
        ++this.mRemainingRetires;
    }

    @MainThread
    @VisibleForTesting
    int getRemainingRetries() {
        Threads.checkMainThread();
        return this.mRemainingRetires;
    }

    void onError(@NonNull ImageCaptureException imageCaptureException) {
        this.getAppExecutor().execute(() -> {
            boolean hasOnDisk;
            boolean hasInMemory = this.getInMemoryCallback() != null;
            boolean bl = hasOnDisk = this.getOnDiskCallback() != null;
            if (hasInMemory && !hasOnDisk) {
                Objects.requireNonNull(this.getInMemoryCallback()).onError(imageCaptureException);
            } else if (hasOnDisk && !hasInMemory) {
                Objects.requireNonNull(this.getOnDiskCallback()).onError(imageCaptureException);
            } else {
                throw new IllegalStateException("One and only one callback is allowed.");
            }
        });
    }

    void onResult(@Nullable ImageCapture.OutputFileResults outputFileResults) {
        this.getAppExecutor().execute(() -> Objects.requireNonNull(this.getOnDiskCallback()).onImageSaved(Objects.requireNonNull(outputFileResults)));
    }

    void onResult(@Nullable ImageProxy imageProxy) {
        this.getAppExecutor().execute(() -> Objects.requireNonNull(this.getInMemoryCallback()).onCaptureSuccess(Objects.requireNonNull(imageProxy)));
    }

    void onCaptureProcessProgressed(int progress) {
        this.getAppExecutor().execute(() -> {
            if (this.getOnDiskCallback() != null) {
                this.getOnDiskCallback().onCaptureProcessProgressed(progress);
            } else if (this.getInMemoryCallback() != null) {
                this.getInMemoryCallback().onCaptureProcessProgressed(progress);
            }
        });
    }

    void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        this.getAppExecutor().execute(() -> {
            if (this.getOnDiskCallback() != null) {
                this.getOnDiskCallback().onPostviewBitmapAvailable(bitmap);
            } else if (this.getInMemoryCallback() != null) {
                this.getInMemoryCallback().onPostviewBitmapAvailable(bitmap);
            }
        });
    }

    @NonNull
    public static TakePictureRequest of(@NonNull Executor appExecutor, @Nullable ImageCapture.OnImageCapturedCallback inMemoryCallback, @Nullable ImageCapture.OnImageSavedCallback onDiskCallback, @Nullable ImageCapture.OutputFileOptions outputFileOptions, @NonNull Rect cropRect, @NonNull Matrix sensorToBufferTransform, int rotationDegrees, int jpegQuality, int captureMode, @NonNull List<CameraCaptureCallback> sessionConfigCameraCaptureCallbacks) {
        Preconditions.checkArgument((onDiskCallback == null == (outputFileOptions == null) ? 1 : 0) != 0, (Object)"onDiskCallback and outputFileOptions should be both null or both non-null.");
        Preconditions.checkArgument((boolean)(onDiskCallback == null ^ inMemoryCallback == null), (Object)"One and only one on-disk or in-memory callback should be present.");
        return new AutoValue_TakePictureRequest(appExecutor, inMemoryCallback, onDiskCallback, outputFileOptions, cropRect, sensorToBufferTransform, rotationDegrees, jpegQuality, captureMode, sessionConfigCameraCaptureCallbacks);
    }

    static interface RetryControl {
        public void retryRequest(@NonNull TakePictureRequest var1);
    }
}

