/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.SessionConfig;
import java.util.List;

final class AutoValue_SessionConfig_OutputConfig
extends SessionConfig.OutputConfig {
    private final DeferrableSurface surface;
    private final List<DeferrableSurface> sharedSurfaces;
    private final String physicalCameraId;
    private final int surfaceGroupId;
    private final DynamicRange dynamicRange;

    private AutoValue_SessionConfig_OutputConfig(DeferrableSurface surface, List<DeferrableSurface> sharedSurfaces, @Nullable String physicalCameraId, int surfaceGroupId, DynamicRange dynamicRange) {
        this.surface = surface;
        this.sharedSurfaces = sharedSurfaces;
        this.physicalCameraId = physicalCameraId;
        this.surfaceGroupId = surfaceGroupId;
        this.dynamicRange = dynamicRange;
    }

    @Override
    @NonNull
    public DeferrableSurface getSurface() {
        return this.surface;
    }

    @Override
    @NonNull
    public List<DeferrableSurface> getSharedSurfaces() {
        return this.sharedSurfaces;
    }

    @Override
    @Nullable
    public String getPhysicalCameraId() {
        return this.physicalCameraId;
    }

    @Override
    public int getSurfaceGroupId() {
        return this.surfaceGroupId;
    }

    @Override
    @NonNull
    public DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    public String toString() {
        return "OutputConfig{surface=" + this.surface + ", sharedSurfaces=" + this.sharedSurfaces + ", physicalCameraId=" + this.physicalCameraId + ", surfaceGroupId=" + this.surfaceGroupId + ", dynamicRange=" + this.dynamicRange + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SessionConfig.OutputConfig) {
            SessionConfig.OutputConfig that = (SessionConfig.OutputConfig)o;
            return this.surface.equals(that.getSurface()) && this.sharedSurfaces.equals(that.getSharedSurfaces()) && (this.physicalCameraId == null ? that.getPhysicalCameraId() == null : this.physicalCameraId.equals(that.getPhysicalCameraId())) && this.surfaceGroupId == that.getSurfaceGroupId() && this.dynamicRange.equals(that.getDynamicRange());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.surface.hashCode();
        h$ *= 1000003;
        h$ ^= this.sharedSurfaces.hashCode();
        h$ *= 1000003;
        h$ ^= this.physicalCameraId == null ? 0 : this.physicalCameraId.hashCode();
        h$ *= 1000003;
        h$ ^= this.surfaceGroupId;
        h$ *= 1000003;
        return h$ ^= this.dynamicRange.hashCode();
    }

    static final class Builder
    extends SessionConfig.OutputConfig.Builder {
        private DeferrableSurface surface;
        private List<DeferrableSurface> sharedSurfaces;
        private String physicalCameraId;
        private Integer surfaceGroupId;
        private DynamicRange dynamicRange;

        Builder() {
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSurface(DeferrableSurface surface) {
            if (surface == null) {
                throw new NullPointerException("Null surface");
            }
            this.surface = surface;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSharedSurfaces(List<DeferrableSurface> sharedSurfaces) {
            if (sharedSurfaces == null) {
                throw new NullPointerException("Null sharedSurfaces");
            }
            this.sharedSurfaces = sharedSurfaces;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setPhysicalCameraId(@Nullable String physicalCameraId) {
            this.physicalCameraId = physicalCameraId;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSurfaceGroupId(int surfaceGroupId) {
            this.surfaceGroupId = surfaceGroupId;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setDynamicRange(DynamicRange dynamicRange) {
            if (dynamicRange == null) {
                throw new NullPointerException("Null dynamicRange");
            }
            this.dynamicRange = dynamicRange;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig build() {
            String missing = "";
            if (this.surface == null) {
                missing = missing + " surface";
            }
            if (this.sharedSurfaces == null) {
                missing = missing + " sharedSurfaces";
            }
            if (this.surfaceGroupId == null) {
                missing = missing + " surfaceGroupId";
            }
            if (this.dynamicRange == null) {
                missing = missing + " dynamicRange";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SessionConfig_OutputConfig(this.surface, this.sharedSurfaces, this.physicalCameraId, this.surfaceGroupId, this.dynamicRange);
        }
    }
}

