/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.LensFacingCameraFilter;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.Timebase;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public interface CameraInfoInternal
extends CameraInfo {
    @NonNull
    public String getCameraId();

    @NonNull
    public Object getCameraCharacteristics();

    @Nullable
    public Object getPhysicalCameraCharacteristics(@NonNull String var1);

    public void addSessionCaptureCallback(@NonNull Executor var1, @NonNull CameraCaptureCallback var2);

    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback var1);

    @NonNull
    public Quirks getCameraQuirks();

    @NonNull
    public EncoderProfilesProvider getEncoderProfilesProvider();

    @NonNull
    public Timebase getTimebase();

    @NonNull
    public Set<Integer> getSupportedOutputFormats();

    @NonNull
    public List<Size> getSupportedResolutions(int var1);

    @NonNull
    public List<Size> getSupportedHighResolutions(int var1);

    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges();

    public boolean isPreviewStabilizationSupported();

    public boolean isVideoStabilizationSupported();

    @NonNull
    default public CameraInfoInternal getImplementation() {
        return this;
    }

    default public boolean isPostviewSupported() {
        return false;
    }

    default public boolean isCaptureProcessProgressSupported() {
        return false;
    }

    @Override
    @NonNull
    default public CameraSelector getCameraSelector() {
        return new CameraSelector.Builder().addCameraFilter(cameraInfos -> {
            String cameraId = this.getCameraId();
            for (CameraInfo cameraInfo : cameraInfos) {
                Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal));
                CameraInfoInternal cameraInfoInternal = (CameraInfoInternal)cameraInfo;
                if (!cameraInfoInternal.getCameraId().equals(cameraId)) continue;
                return Collections.singletonList(cameraInfo);
            }
            throw new IllegalStateException("Unable to find camera with id " + cameraId + " from list of available cameras.");
        }).addCameraFilter(new LensFacingCameraFilter(this.getLensFacing())).build();
    }
}

