/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.InitializationException;
import androidx.camera.core.RetryPolicy;
import androidx.camera.core.impl.CameraValidator;

@RequiresApi(value=21)
@ExperimentalRetryPolicy
public final class CameraProviderExecutionState
implements RetryPolicy.ExecutionState {
    private final int mStatus;
    private final int mAttemptCount;
    private final long mTaskExecutedTimeInMillis;
    @Nullable
    private final Throwable mCause;

    public CameraProviderExecutionState(long taskStartTimeInMillis, int attemptCount, @Nullable Throwable throwable) {
        this.mTaskExecutedTimeInMillis = SystemClock.elapsedRealtime() - taskStartTimeInMillis;
        this.mAttemptCount = attemptCount;
        if (throwable instanceof CameraValidator.CameraIdListIncorrectException) {
            this.mStatus = 2;
            this.mCause = throwable;
        } else if (throwable instanceof InitializationException) {
            Throwable cause = throwable.getCause();
            Throwable throwable2 = this.mCause = cause != null ? cause : throwable;
            this.mStatus = this.mCause instanceof CameraUnavailableException ? 2 : (this.mCause instanceof IllegalArgumentException ? 1 : 0);
        } else {
            this.mStatus = 0;
            this.mCause = throwable;
        }
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    @Override
    @Nullable
    public Throwable getCause() {
        return this.mCause;
    }

    @Override
    public long getExecutedTimeInMillis() {
        return this.mTaskExecutedTimeInMillis;
    }

    @Override
    public int getNumOfAttempts() {
        return this.mAttemptCount;
    }
}

