/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ExperimentalLensFacing;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraRepository;

@RequiresApi(value=21)
@OptIn(markerClass={ExperimentalLensFacing.class})
public final class CameraValidator {
    private static final String TAG = "CameraValidator";
    private static final CameraSelector EXTERNAL_LENS_FACING = new CameraSelector.Builder().requireLensFacing(2).build();

    private CameraValidator() {
    }

    public static void validateCameras(@NonNull Context context, @NonNull CameraRepository cameraRepository, @Nullable CameraSelector availableCamerasSelector) throws CameraIdListIncorrectException {
        Integer lensFacing = null;
        try {
            if (availableCamerasSelector != null && (lensFacing = availableCamerasSelector.getLensFacing()) == null) {
                Logger.w(TAG, "No lens facing info in the availableCamerasSelector, don't verify the camera lens facing.");
                return;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "Cannot get lens facing from the availableCamerasSelector don't verify the camera lens facing.", e);
            return;
        }
        Logger.d(TAG, "Verifying camera lens facing on " + Build.DEVICE + ", lensFacingInteger: " + lensFacing);
        PackageManager pm = context.getPackageManager();
        IllegalArgumentException exception = null;
        int availableCameraCount = 0;
        try {
            if (pm.hasSystemFeature("android.hardware.camera") && (availableCamerasSelector == null || lensFacing == 1)) {
                CameraSelector.DEFAULT_BACK_CAMERA.select(cameraRepository.getCameras());
                ++availableCameraCount;
            }
        }
        catch (IllegalArgumentException e) {
            Logger.w(TAG, "Camera LENS_FACING_BACK verification failed", e);
            exception = e;
        }
        try {
            if (pm.hasSystemFeature("android.hardware.camera.front") && (availableCamerasSelector == null || lensFacing == 0)) {
                CameraSelector.DEFAULT_FRONT_CAMERA.select(cameraRepository.getCameras());
                ++availableCameraCount;
            }
        }
        catch (IllegalArgumentException e) {
            Logger.w(TAG, "Camera LENS_FACING_FRONT verification failed", e);
            exception = e;
        }
        try {
            EXTERNAL_LENS_FACING.select(cameraRepository.getCameras());
            Logger.d(TAG, "Found a LENS_FACING_EXTERNAL camera");
            ++availableCameraCount;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (exception != null) {
            Logger.e(TAG, "Camera LensFacing verification failed, existing cameras: " + cameraRepository.getCameras());
            throw new CameraIdListIncorrectException("Expected camera missing from device.", availableCameraCount, exception);
        }
    }

    public static class CameraIdListIncorrectException
    extends Exception {
        private int mAvailableCameraCount;

        public CameraIdListIncorrectException(@Nullable String message, int availableCameraCount, @Nullable Throwable cause) {
            super(message, cause);
            this.mAvailableCameraCount = availableCameraCount;
        }

        public int getAvailableCameraCount() {
            return this.mAvailableCameraCount;
        }
    }
}

