/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;

@RequiresApi(value=21)
public final class DeferrableSurfaces {
    private DeferrableSurfaces() {
    }

    @NonNull
    public static ListenableFuture<List<Surface>> surfaceListWithTimeout(@NonNull Collection<DeferrableSurface> deferrableSurfaces, final boolean removeNullSurfaces, long timeoutMillis, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService) {
        ArrayList<ListenableFuture<Surface>> list = new ArrayList<ListenableFuture<Surface>>();
        for (DeferrableSurface surface : deferrableSurfaces) {
            list.add(Futures.nonCancellationPropagating(surface.getSurface()));
        }
        ListenableFuture listenableFuture = Futures.makeTimeoutFuture(timeoutMillis, scheduledExecutorService, Futures.successfulAsList(list));
        return CallbackToFutureAdapter.getFuture(completer -> {
            completer.addCancellationListener(() -> listenableFuture.cancel(true), executor);
            Futures.addCallback(listenableFuture, new FutureCallback<List<Surface>>(){

                @Override
                public void onSuccess(@Nullable List<Surface> result) {
                    Preconditions.checkNotNull(result);
                    ArrayList<Surface> surfaces = new ArrayList<Surface>(result);
                    if (removeNullSurfaces) {
                        surfaces.removeAll(Collections.singleton(null));
                    }
                    completer.set(surfaces);
                }

                @Override
                public void onFailure(@NonNull Throwable t) {
                    if (t instanceof TimeoutException) {
                        completer.setException(t);
                    } else {
                        completer.set(Collections.emptyList());
                    }
                }
            }, executor);
            return "surfaceList[" + deferrableSurfaces + "]";
        });
    }

    public static boolean tryIncrementAll(@NonNull List<DeferrableSurface> surfaceList) {
        try {
            DeferrableSurfaces.incrementAll(surfaceList);
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            return false;
        }
        return true;
    }

    public static void incrementAll(@NonNull List<DeferrableSurface> surfaceList) throws DeferrableSurface.SurfaceClosedException {
        if (!surfaceList.isEmpty()) {
            int i = 0;
            try {
                do {
                    surfaceList.get(i).incrementUseCount();
                } while (++i < surfaceList.size());
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                --i;
                while (i >= 0) {
                    surfaceList.get(i).decrementUseCount();
                    --i;
                }
                throw e;
            }
        }
    }

    public static void decrementAll(@NonNull List<DeferrableSurface> surfaceList) {
        for (DeferrableSurface surface : surfaceList) {
            surface.decrementUseCount();
        }
    }
}

