/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.AutoValue_SessionConfig_OutputConfig;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.compat.workaround.SurfaceSorter;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(value=21)
public final class SessionConfig {
    public static final int DEFAULT_SESSION_TYPE = 0;
    private final List<OutputConfig> mOutputConfigs;
    private final OutputConfig mPostviewOutputConfig;
    private final List<CameraDevice.StateCallback> mDeviceStateCallbacks;
    private final List<CameraCaptureSession.StateCallback> mSessionStateCallbacks;
    private final List<CameraCaptureCallback> mSingleCameraCaptureCallbacks;
    private final List<ErrorListener> mErrorListeners;
    private final CaptureConfig mRepeatingCaptureConfig;
    private final int mSessionType;
    @Nullable
    private InputConfiguration mInputConfiguration;

    SessionConfig(List<OutputConfig> outputConfigs, List<CameraDevice.StateCallback> deviceStateCallbacks, List<CameraCaptureSession.StateCallback> sessionStateCallbacks, List<CameraCaptureCallback> singleCameraCaptureCallbacks, List<ErrorListener> errorListeners, CaptureConfig repeatingCaptureConfig, @Nullable InputConfiguration inputConfiguration, int sessionType, @Nullable OutputConfig postviewOutputConfig) {
        this.mOutputConfigs = outputConfigs;
        this.mDeviceStateCallbacks = Collections.unmodifiableList(deviceStateCallbacks);
        this.mSessionStateCallbacks = Collections.unmodifiableList(sessionStateCallbacks);
        this.mSingleCameraCaptureCallbacks = Collections.unmodifiableList(singleCameraCaptureCallbacks);
        this.mErrorListeners = Collections.unmodifiableList(errorListeners);
        this.mRepeatingCaptureConfig = repeatingCaptureConfig;
        this.mInputConfiguration = inputConfiguration;
        this.mSessionType = sessionType;
        this.mPostviewOutputConfig = postviewOutputConfig;
    }

    @NonNull
    public static SessionConfig defaultEmptySessionConfig() {
        return new SessionConfig(new ArrayList<OutputConfig>(), new ArrayList<CameraDevice.StateCallback>(0), new ArrayList<CameraCaptureSession.StateCallback>(0), new ArrayList<CameraCaptureCallback>(0), new ArrayList<ErrorListener>(0), new CaptureConfig.Builder().build(), null, 0, null);
    }

    @Nullable
    public InputConfiguration getInputConfiguration() {
        return this.mInputConfiguration;
    }

    @NonNull
    public List<DeferrableSurface> getSurfaces() {
        ArrayList<DeferrableSurface> deferrableSurfaces = new ArrayList<DeferrableSurface>();
        for (OutputConfig outputConfig : this.mOutputConfigs) {
            deferrableSurfaces.add(outputConfig.getSurface());
            for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                deferrableSurfaces.add(sharedSurface);
            }
        }
        return Collections.unmodifiableList(deferrableSurfaces);
    }

    @NonNull
    public List<OutputConfig> getOutputConfigs() {
        return this.mOutputConfigs;
    }

    @Nullable
    public OutputConfig getPostviewOutputConfig() {
        return this.mPostviewOutputConfig;
    }

    @NonNull
    public Config getImplementationOptions() {
        return this.mRepeatingCaptureConfig.getImplementationOptions();
    }

    public int getTemplateType() {
        return this.mRepeatingCaptureConfig.getTemplateType();
    }

    public int getSessionType() {
        return this.mSessionType;
    }

    @NonNull
    public Range<Integer> getExpectedFrameRateRange() {
        return this.mRepeatingCaptureConfig.getExpectedFrameRateRange();
    }

    @NonNull
    public List<CameraDevice.StateCallback> getDeviceStateCallbacks() {
        return this.mDeviceStateCallbacks;
    }

    @NonNull
    public List<CameraCaptureSession.StateCallback> getSessionStateCallbacks() {
        return this.mSessionStateCallbacks;
    }

    @NonNull
    public List<CameraCaptureCallback> getRepeatingCameraCaptureCallbacks() {
        return this.mRepeatingCaptureConfig.getCameraCaptureCallbacks();
    }

    @NonNull
    public List<ErrorListener> getErrorListeners() {
        return this.mErrorListeners;
    }

    @NonNull
    public List<CameraCaptureCallback> getSingleCameraCaptureCallbacks() {
        return this.mSingleCameraCaptureCallbacks;
    }

    @NonNull
    public CaptureConfig getRepeatingCaptureConfig() {
        return this.mRepeatingCaptureConfig;
    }

    @AutoValue
    public static abstract class OutputConfig {
        public static final int SURFACE_GROUP_ID_NONE = -1;

        @NonNull
        public abstract DeferrableSurface getSurface();

        @NonNull
        public abstract List<DeferrableSurface> getSharedSurfaces();

        @Nullable
        public abstract String getPhysicalCameraId();

        public abstract int getSurfaceGroupId();

        @NonNull
        public abstract DynamicRange getDynamicRange();

        @NonNull
        public static Builder builder(@NonNull DeferrableSurface surface) {
            return new AutoValue_SessionConfig_OutputConfig.Builder().setSurface(surface).setSharedSurfaces(Collections.emptyList()).setPhysicalCameraId(null).setSurfaceGroupId(-1).setDynamicRange(DynamicRange.SDR);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @NonNull
            public abstract Builder setSurface(@NonNull DeferrableSurface var1);

            @NonNull
            public abstract Builder setSharedSurfaces(@NonNull List<DeferrableSurface> var1);

            @NonNull
            public abstract Builder setPhysicalCameraId(@Nullable String var1);

            @NonNull
            public abstract Builder setSurfaceGroupId(int var1);

            @NonNull
            public abstract Builder setDynamicRange(@NonNull DynamicRange var1);

            @NonNull
            public abstract OutputConfig build();
        }
    }

    public static final class ValidatingBuilder
    extends BaseBuilder {
        private static final List<Integer> SUPPORTED_TEMPLATE_PRIORITY = Arrays.asList(1, 5, 3);
        private static final String TAG = "ValidatingBuilder";
        private final SurfaceSorter mSurfaceSorter = new SurfaceSorter();
        private boolean mValid = true;
        private boolean mTemplateSet = false;

        public <T> void addImplementationOption(@NonNull Config.Option<T> option, @NonNull T value) {
            this.mCaptureConfigBuilder.addImplementationOption(option, value);
        }

        public void add(@NonNull SessionConfig sessionConfig) {
            String errorMessage;
            CaptureConfig captureConfig = sessionConfig.getRepeatingCaptureConfig();
            if (captureConfig.getTemplateType() != -1) {
                this.mTemplateSet = true;
                this.mCaptureConfigBuilder.setTemplateType(this.selectTemplateType(captureConfig.getTemplateType(), this.mCaptureConfigBuilder.getTemplateType()));
            }
            this.setOrVerifyExpectFrameRateRange(captureConfig.getExpectedFrameRateRange());
            this.setPreviewStabilizationMode(captureConfig.getPreviewStabilizationMode());
            this.setVideoStabilizationMode(captureConfig.getVideoStabilizationMode());
            TagBundle tagBundle = sessionConfig.getRepeatingCaptureConfig().getTagBundle();
            this.mCaptureConfigBuilder.addAllTags(tagBundle);
            this.mDeviceStateCallbacks.addAll(sessionConfig.getDeviceStateCallbacks());
            this.mSessionStateCallbacks.addAll(sessionConfig.getSessionStateCallbacks());
            this.mCaptureConfigBuilder.addAllCameraCaptureCallbacks(sessionConfig.getRepeatingCameraCaptureCallbacks());
            this.mSingleCameraCaptureCallbacks.addAll(sessionConfig.getSingleCameraCaptureCallbacks());
            this.mErrorListeners.addAll(sessionConfig.getErrorListeners());
            if (sessionConfig.getInputConfiguration() != null) {
                this.mInputConfiguration = sessionConfig.getInputConfiguration();
            }
            this.mOutputConfigs.addAll(sessionConfig.getOutputConfigs());
            this.mCaptureConfigBuilder.getSurfaces().addAll(captureConfig.getSurfaces());
            if (!this.getSurfaces().containsAll(this.mCaptureConfigBuilder.getSurfaces())) {
                errorMessage = "Invalid configuration due to capture request surfaces are not a subset of surfaces";
                Logger.d(TAG, errorMessage);
                this.mValid = false;
            }
            if (sessionConfig.getSessionType() != this.mSessionType && sessionConfig.getSessionType() != 0 && this.mSessionType != 0) {
                errorMessage = "Invalid configuration due to that two non-default session types are set";
                Logger.d(TAG, errorMessage);
                this.mValid = false;
            } else if (sessionConfig.getSessionType() != 0) {
                this.mSessionType = sessionConfig.getSessionType();
            }
            if (sessionConfig.mPostviewOutputConfig != null) {
                if (this.mPostviewOutputConfig != sessionConfig.mPostviewOutputConfig && this.mPostviewOutputConfig != null) {
                    errorMessage = "Invalid configuration due to that two different postview output configs are set";
                    Logger.d(TAG, errorMessage);
                    this.mValid = false;
                } else {
                    this.mPostviewOutputConfig = sessionConfig.mPostviewOutputConfig;
                }
            }
            this.mCaptureConfigBuilder.addImplementationOptions(captureConfig.getImplementationOptions());
        }

        private void setOrVerifyExpectFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            if (expectedFrameRateRange.equals(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                return;
            }
            if (this.mCaptureConfigBuilder.getExpectedFrameRateRange().equals(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                this.mCaptureConfigBuilder.setExpectedFrameRateRange(expectedFrameRateRange);
                return;
            }
            if (!this.mCaptureConfigBuilder.getExpectedFrameRateRange().equals(expectedFrameRateRange)) {
                this.mValid = false;
                Logger.d(TAG, "Different ExpectedFrameRateRange values");
            }
        }

        private void setPreviewStabilizationMode(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setPreviewStabilization(mode);
            }
        }

        private void setVideoStabilizationMode(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setVideoStabilization(mode);
            }
        }

        private List<DeferrableSurface> getSurfaces() {
            ArrayList<DeferrableSurface> surfaces = new ArrayList<DeferrableSurface>();
            for (OutputConfig outputConfig : this.mOutputConfigs) {
                surfaces.add(outputConfig.getSurface());
                for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                    surfaces.add(sharedSurface);
                }
            }
            return surfaces;
        }

        public void clearSurfaces() {
            this.mOutputConfigs.clear();
            this.mCaptureConfigBuilder.clearSurfaces();
        }

        public boolean isValid() {
            return this.mTemplateSet && this.mValid;
        }

        @NonNull
        public SessionConfig build() {
            if (!this.mValid) {
                throw new IllegalArgumentException("Unsupported session configuration combination");
            }
            ArrayList<OutputConfig> outputConfigs = new ArrayList<OutputConfig>(this.mOutputConfigs);
            this.mSurfaceSorter.sort(outputConfigs);
            return new SessionConfig(outputConfigs, new ArrayList<CameraDevice.StateCallback>(this.mDeviceStateCallbacks), new ArrayList<CameraCaptureSession.StateCallback>(this.mSessionStateCallbacks), new ArrayList<CameraCaptureCallback>(this.mSingleCameraCaptureCallbacks), new ArrayList<ErrorListener>(this.mErrorListeners), this.mCaptureConfigBuilder.build(), this.mInputConfiguration, this.mSessionType, this.mPostviewOutputConfig);
        }

        private int selectTemplateType(int type1, int type2) {
            return SUPPORTED_TEMPLATE_PRIORITY.indexOf(type1) >= SUPPORTED_TEMPLATE_PRIORITY.indexOf(type2) ? type1 : type2;
        }
    }

    public static class Builder
    extends BaseBuilder {
        @NonNull
        public static Builder createFrom(@NonNull UseCaseConfig<?> config, @NonNull Size resolution) {
            OptionUnpacker unpacker = config.getSessionOptionUnpacker(null);
            if (unpacker == null) {
                throw new IllegalStateException("Implementation is missing option unpacker for " + config.getTargetName(config.toString()));
            }
            Builder builder = new Builder();
            unpacker.unpack(resolution, config, builder);
            return builder;
        }

        @NonNull
        public Builder setInputConfiguration(@Nullable InputConfiguration inputConfiguration) {
            this.mInputConfiguration = inputConfiguration;
            return this;
        }

        @NonNull
        public Builder setTemplateType(int templateType) {
            this.mCaptureConfigBuilder.setTemplateType(templateType);
            return this;
        }

        @NonNull
        public Builder setSessionType(int sessionType) {
            this.mSessionType = sessionType;
            return this;
        }

        @NonNull
        public Builder setExpectedFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            this.mCaptureConfigBuilder.setExpectedFrameRateRange(expectedFrameRateRange);
            return this;
        }

        @NonNull
        public Builder setPreviewStabilization(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setPreviewStabilization(mode);
            }
            return this;
        }

        @NonNull
        public Builder setVideoStabilization(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setVideoStabilization(mode);
            }
            return this;
        }

        @NonNull
        public Builder addTag(@NonNull String key, @NonNull Object tag) {
            this.mCaptureConfigBuilder.addTag(key, tag);
            return this;
        }

        @NonNull
        public Builder addDeviceStateCallback(@NonNull CameraDevice.StateCallback deviceStateCallback) {
            if (this.mDeviceStateCallbacks.contains(deviceStateCallback)) {
                return this;
            }
            this.mDeviceStateCallbacks.add(deviceStateCallback);
            return this;
        }

        @NonNull
        public Builder addAllDeviceStateCallbacks(@NonNull Collection<CameraDevice.StateCallback> deviceStateCallbacks) {
            for (CameraDevice.StateCallback callback : deviceStateCallbacks) {
                this.addDeviceStateCallback(callback);
            }
            return this;
        }

        @NonNull
        public Builder addSessionStateCallback(@NonNull CameraCaptureSession.StateCallback sessionStateCallback) {
            if (this.mSessionStateCallbacks.contains(sessionStateCallback)) {
                return this;
            }
            this.mSessionStateCallbacks.add(sessionStateCallback);
            return this;
        }

        @NonNull
        public Builder addAllSessionStateCallbacks(@NonNull List<CameraCaptureSession.StateCallback> sessionStateCallbacks) {
            for (CameraCaptureSession.StateCallback callback : sessionStateCallbacks) {
                this.addSessionStateCallback(callback);
            }
            return this;
        }

        @NonNull
        public Builder addRepeatingCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCaptureConfigBuilder.addCameraCaptureCallback(cameraCaptureCallback);
            return this;
        }

        @NonNull
        public Builder addAllRepeatingCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            this.mCaptureConfigBuilder.addAllCameraCaptureCallbacks(cameraCaptureCallbacks);
            return this;
        }

        @NonNull
        public Builder addCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCaptureConfigBuilder.addCameraCaptureCallback(cameraCaptureCallback);
            if (!this.mSingleCameraCaptureCallbacks.contains(cameraCaptureCallback)) {
                this.mSingleCameraCaptureCallbacks.add(cameraCaptureCallback);
            }
            return this;
        }

        @NonNull
        public Builder addAllCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            for (CameraCaptureCallback c : cameraCaptureCallbacks) {
                this.mCaptureConfigBuilder.addCameraCaptureCallback(c);
                if (this.mSingleCameraCaptureCallbacks.contains(c)) continue;
                this.mSingleCameraCaptureCallbacks.add(c);
            }
            return this;
        }

        public boolean removeCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            boolean removedFromRepeating = this.mCaptureConfigBuilder.removeCameraCaptureCallback(cameraCaptureCallback);
            boolean removedFromSingle = this.mSingleCameraCaptureCallbacks.remove(cameraCaptureCallback);
            return removedFromRepeating || removedFromSingle;
        }

        @NonNull
        public List<CameraCaptureCallback> getSingleCameraCaptureCallbacks() {
            return Collections.unmodifiableList(this.mSingleCameraCaptureCallbacks);
        }

        @NonNull
        public Builder addErrorListener(@NonNull ErrorListener errorListener) {
            this.mErrorListeners.add(errorListener);
            return this;
        }

        @NonNull
        public Builder addSurface(@NonNull DeferrableSurface surface) {
            return this.addSurface(surface, DynamicRange.SDR, null);
        }

        @NonNull
        public Builder addSurface(@NonNull DeferrableSurface surface, @NonNull DynamicRange dynamicRange, @Nullable String physicalCameraId) {
            OutputConfig outputConfig = OutputConfig.builder(surface).setPhysicalCameraId(physicalCameraId).setDynamicRange(dynamicRange).build();
            this.mOutputConfigs.add(outputConfig);
            this.mCaptureConfigBuilder.addSurface(surface);
            return this;
        }

        @NonNull
        public Builder addOutputConfig(@NonNull OutputConfig outputConfig) {
            this.mOutputConfigs.add(outputConfig);
            this.mCaptureConfigBuilder.addSurface(outputConfig.getSurface());
            for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                this.mCaptureConfigBuilder.addSurface(sharedSurface);
            }
            return this;
        }

        @NonNull
        public Builder addNonRepeatingSurface(@NonNull DeferrableSurface surface) {
            return this.addNonRepeatingSurface(surface, DynamicRange.SDR);
        }

        @NonNull
        public Builder addNonRepeatingSurface(@NonNull DeferrableSurface surface, @NonNull DynamicRange dynamicRange) {
            OutputConfig outputConfig = OutputConfig.builder(surface).setDynamicRange(dynamicRange).build();
            this.mOutputConfigs.add(outputConfig);
            return this;
        }

        @NonNull
        public Builder setPostviewSurface(@NonNull DeferrableSurface surface) {
            this.mPostviewOutputConfig = OutputConfig.builder(surface).build();
            return this;
        }

        @NonNull
        public Builder removeSurface(@NonNull DeferrableSurface surface) {
            OutputConfig outputConfigToRemove = null;
            for (OutputConfig config : this.mOutputConfigs) {
                if (!config.getSurface().equals(surface)) continue;
                outputConfigToRemove = config;
                break;
            }
            if (outputConfigToRemove != null) {
                this.mOutputConfigs.remove(outputConfigToRemove);
            }
            this.mCaptureConfigBuilder.removeSurface(surface);
            return this;
        }

        @NonNull
        public Builder clearSurfaces() {
            this.mOutputConfigs.clear();
            this.mCaptureConfigBuilder.clearSurfaces();
            return this;
        }

        @NonNull
        public Builder setImplementationOptions(@NonNull Config config) {
            this.mCaptureConfigBuilder.setImplementationOptions(config);
            return this;
        }

        @NonNull
        public Builder addImplementationOptions(@NonNull Config config) {
            this.mCaptureConfigBuilder.addImplementationOptions(config);
            return this;
        }

        @NonNull
        public SessionConfig build() {
            return new SessionConfig(new ArrayList<OutputConfig>(this.mOutputConfigs), new ArrayList<CameraDevice.StateCallback>(this.mDeviceStateCallbacks), new ArrayList<CameraCaptureSession.StateCallback>(this.mSessionStateCallbacks), new ArrayList<CameraCaptureCallback>(this.mSingleCameraCaptureCallbacks), new ArrayList<ErrorListener>(this.mErrorListeners), this.mCaptureConfigBuilder.build(), this.mInputConfiguration, this.mSessionType, this.mPostviewOutputConfig);
        }
    }

    static class BaseBuilder {
        final Set<OutputConfig> mOutputConfigs = new LinkedHashSet<OutputConfig>();
        final CaptureConfig.Builder mCaptureConfigBuilder = new CaptureConfig.Builder();
        final List<CameraDevice.StateCallback> mDeviceStateCallbacks = new ArrayList<CameraDevice.StateCallback>();
        final List<CameraCaptureSession.StateCallback> mSessionStateCallbacks = new ArrayList<CameraCaptureSession.StateCallback>();
        final List<ErrorListener> mErrorListeners = new ArrayList<ErrorListener>();
        final List<CameraCaptureCallback> mSingleCameraCaptureCallbacks = new ArrayList<CameraCaptureCallback>();
        @Nullable
        InputConfiguration mInputConfiguration;
        int mSessionType = 0;
        @Nullable
        OutputConfig mPostviewOutputConfig;

        BaseBuilder() {
        }
    }

    public static interface OptionUnpacker {
        public void unpack(@NonNull Size var1, @NonNull UseCaseConfig<?> var2, @NonNull Builder var3);
    }

    public static interface ErrorListener {
        public void onError(@NonNull SessionConfig var1, @NonNull SessionError var2);
    }

    public static enum SessionError {
        SESSION_ERROR_SURFACE_NEEDS_RESET,
        SESSION_ERROR_UNKNOWN;

    }
}

