/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

@RequiresApi(value=21)
public final class ContextUtil {
    @NonNull
    public static Context getApplicationContext(@NonNull Context context) {
        String attributeTag;
        int deviceId;
        Context resultContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 34 && (deviceId = Api34Impl.getDeviceId(context)) != 0) {
            resultContext = Api34Impl.createDeviceContext(resultContext, deviceId);
        }
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag(context)) != null) {
            resultContext = Api30Impl.createAttributionContext(resultContext, attributeTag);
        }
        return resultContext;
    }

    @NonNull
    public static Context getBaseContext(@NonNull ContextWrapper context) {
        String attributeTag;
        int deviceId;
        Context resultContext = context.getBaseContext();
        if (Build.VERSION.SDK_INT >= 34 && (deviceId = Api34Impl.getDeviceId((Context)context)) != 0) {
            resultContext = Api34Impl.createDeviceContext(resultContext, deviceId);
        }
        if (Build.VERSION.SDK_INT >= 30 && (attributeTag = Api30Impl.getAttributionTag((Context)context)) != null) {
            resultContext = Api30Impl.createAttributionContext(resultContext, attributeTag);
        }
        return resultContext;
    }

    @Nullable
    public static Application getApplicationFromContext(@NonNull Context context) {
        Application application = null;
        Context appContext = ContextUtil.getApplicationContext(context);
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ContextUtil.getBaseContext((ContextWrapper)appContext);
        }
        return application;
    }

    private ContextUtil() {
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        @NonNull
        static Context createDeviceContext(@NonNull Context context, int deviceId) {
            return context.createDeviceContext(deviceId);
        }

        @DoNotInline
        static int getDeviceId(@NonNull Context context) {
            return context.getDeviceId();
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        @NonNull
        static Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        @DoNotInline
        @Nullable
        static String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }
}

