/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.futures;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.arch.core.util.Function;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.AsyncFunction;
import androidx.camera.core.impl.utils.futures.ChainingListenableFuture;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.ImmediateFuture;
import androidx.camera.core.impl.utils.futures.ListFuture;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@RequiresApi(value=21)
public final class Futures {
    private static final Function<?, ?> IDENTITY_FUNCTION = new Function<Object, Object>(){

        public Object apply(Object input) {
            return input;
        }
    };

    @NonNull
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        if (value == null) {
            return ImmediateFuture.nullFuture();
        }
        return new ImmediateFuture.ImmediateSuccessfulFuture<V>(value);
    }

    @NonNull
    public static <V> ListenableFuture<V> immediateFailedFuture(@NonNull Throwable cause) {
        return new ImmediateFuture.ImmediateFailedFuture(cause);
    }

    @NonNull
    public static <V> ScheduledFuture<V> immediateFailedScheduledFuture(@NonNull Throwable cause) {
        return new ImmediateFuture.ImmediateFailedScheduledFuture(cause);
    }

    @NonNull
    public static <I, O> ListenableFuture<O> transformAsync(@NonNull ListenableFuture<I> input, @NonNull AsyncFunction<? super I, ? extends O> function, @NonNull Executor executor) {
        ChainingListenableFuture<? super I, ? extends O> output = new ChainingListenableFuture<I, O>(function, input);
        input.addListener(output, executor);
        return output;
    }

    @NonNull
    public static <I, O> ListenableFuture<O> transform(@NonNull ListenableFuture<I> input, final @NonNull Function<? super I, ? extends O> function, @NonNull Executor executor) {
        Preconditions.checkNotNull(function);
        return Futures.transformAsync(input, new AsyncFunction<I, O>(){

            @Override
            @NonNull
            public ListenableFuture<O> apply(I input) {
                return Futures.immediateFuture(function.apply(input));
            }
        }, executor);
    }

    public static <V> void propagate(@NonNull ListenableFuture<V> input, @NonNull CallbackToFutureAdapter.Completer<V> completer) {
        Function<?, ?> identityTransform = IDENTITY_FUNCTION;
        Futures.propagateTransform(input, identityTransform, completer, CameraXExecutors.directExecutor());
    }

    public static <I, O> void propagateTransform(@NonNull ListenableFuture<I> input, @NonNull Function<? super I, ? extends O> function, @NonNull CallbackToFutureAdapter.Completer<O> completer, @NonNull Executor executor) {
        Futures.propagateTransform(true, input, function, completer, executor);
    }

    private static <I, O> void propagateTransform(boolean propagateCancellation, final @NonNull ListenableFuture<I> input, final @NonNull Function<? super I, ? extends O> function, final @NonNull CallbackToFutureAdapter.Completer<O> completer, @NonNull Executor executor) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(completer);
        Preconditions.checkNotNull((Object)executor);
        Futures.addCallback(input, new FutureCallback<I>(){

            @Override
            public void onSuccess(@Nullable I result) {
                try {
                    completer.set(function.apply(result));
                }
                catch (Throwable t) {
                    completer.setException(t);
                }
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                completer.setException(t);
            }
        }, executor);
        if (propagateCancellation) {
            completer.addCancellationListener(new Runnable(){

                @Override
                public void run() {
                    input.cancel(true);
                }
            }, CameraXExecutors.directExecutor());
        }
    }

    @NonNull
    public static <V> ListenableFuture<V> nonCancellationPropagating(@NonNull ListenableFuture<V> future) {
        Preconditions.checkNotNull(future);
        if (future.isDone()) {
            return future;
        }
        ListenableFuture output = CallbackToFutureAdapter.getFuture(completer -> {
            Function<?, ?> identityTransform = IDENTITY_FUNCTION;
            Futures.propagateTransform(false, future, identityTransform, completer, CameraXExecutors.directExecutor());
            return "nonCancellationPropagating[" + future + "]";
        });
        return output;
    }

    @NonNull
    public static <V> ListenableFuture<List<V>> successfulAsList(@NonNull Collection<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(new ArrayList<ListenableFuture<? extends V>>(futures), false, CameraXExecutors.directExecutor());
    }

    @NonNull
    public static <V> ListenableFuture<List<V>> allAsList(@NonNull Collection<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(new ArrayList<ListenableFuture<? extends V>>(futures), true, CameraXExecutors.directExecutor());
    }

    public static <V> void addCallback(@NonNull ListenableFuture<V> future, @NonNull FutureCallback<? super V> callback, @NonNull Executor executor) {
        Preconditions.checkNotNull(callback);
        future.addListener(new CallbackListener<V>(future, callback), executor);
    }

    @Nullable
    public static <V> V getDone(@NonNull Future<V> future) throws ExecutionException {
        Preconditions.checkState((boolean)future.isDone(), (String)("Future was expected to be done, " + future));
        return Futures.getUninterruptibly(future);
    }

    @Nullable
    public static <V> V getUninterruptibly(@NonNull Future<V> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @NonNull
    public static <V> ListenableFuture<V> makeTimeoutFuture(long timeoutMillis, @NonNull ScheduledExecutorService scheduledExecutor, @NonNull ListenableFuture<V> input) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            Futures.propagate(input, completer);
            if (!input.isDone()) {
                ScheduledFuture<Boolean> timeoutFuture = scheduledExecutor.schedule(() -> completer.setException((Throwable)new TimeoutException("Future[" + input + "] is not done within " + timeoutMillis + " ms.")), timeoutMillis, TimeUnit.MILLISECONDS);
                input.addListener(() -> timeoutFuture.cancel(true), CameraXExecutors.directExecutor());
            }
            return "TimeoutFuture[" + input + "]";
        });
    }

    @NonNull
    public static <V> ListenableFuture<V> makeTimeoutFuture(long timeoutMillis, @NonNull ScheduledExecutorService scheduledExecutor, @Nullable V defaultValue, boolean cancelInputAtTimeout, @NonNull ListenableFuture<V> input) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            Futures.propagate(input, completer);
            if (!input.isDone()) {
                ScheduledFuture<?> timeoutFuture = scheduledExecutor.schedule(() -> {
                    completer.set(defaultValue);
                    if (cancelInputAtTimeout) {
                        input.cancel(true);
                    }
                }, timeoutMillis, TimeUnit.MILLISECONDS);
                input.addListener(() -> timeoutFuture.cancel(true), CameraXExecutors.directExecutor());
            }
            return "TimeoutFuture[" + input + "]";
        });
    }

    private Futures() {
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> mFuture;
        final FutureCallback<? super V> mCallback;

        CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
            this.mFuture = future;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            V value;
            try {
                value = Futures.getDone(this.mFuture);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    this.mCallback.onFailure(e);
                } else {
                    this.mCallback.onFailure(cause);
                }
                return;
            }
            catch (Error | RuntimeException e) {
                this.mCallback.onFailure(e);
                return;
            }
            this.mCallback.onSuccess(value);
        }

        @NonNull
        public String toString() {
            return this.getClass().getSimpleName() + "," + this.mCallback;
        }
    }
}

