/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.ImageCaptureRotationOptionQuirk;
import androidx.camera.core.internal.utils.ImageUtil;

@RequiresApi(value=21)
public class ExifRotationAvailability {
    public boolean isRotationOptionSupported() {
        ImageCaptureRotationOptionQuirk quirk = DeviceQuirks.get(ImageCaptureRotationOptionQuirk.class);
        return quirk == null || quirk.isSupported(CaptureConfig.OPTION_ROTATION);
    }

    public boolean shouldUseExifOrientation(@NonNull ImageProxy image) {
        return this.isRotationOptionSupported() && ImageUtil.isJpegFormats(image.getFormat());
    }
}

