/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.utils;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.internal.utils.RingBuffer;
import java.util.ArrayDeque;

public class ArrayRingBuffer<T>
implements RingBuffer<T> {
    private static final String TAG = "ZslRingBuffer";
    private final int mRingBufferCapacity;
    @GuardedBy(value="mLock")
    private final ArrayDeque<T> mBuffer;
    private final Object mLock = new Object();
    @Nullable
    final RingBuffer.OnRemoveCallback<T> mOnRemoveCallback;

    public ArrayRingBuffer(int ringBufferCapacity) {
        this(ringBufferCapacity, null);
    }

    public ArrayRingBuffer(int ringBufferCapacity, @Nullable RingBuffer.OnRemoveCallback<T> onRemoveCallback) {
        this.mRingBufferCapacity = ringBufferCapacity;
        this.mBuffer = new ArrayDeque(this.mRingBufferCapacity);
        this.mOnRemoveCallback = onRemoveCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(@NonNull T element) {
        Object removedItem = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBuffer.size() >= this.mRingBufferCapacity) {
                removedItem = this.dequeue();
            }
            this.mBuffer.addFirst(element);
        }
        if (this.mOnRemoveCallback != null && removedItem != null) {
            this.mOnRemoveCallback.onRemove(removedItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public T dequeue() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBuffer.removeLast();
        }
    }

    @Override
    public int getMaxCapacity() {
        return this.mRingBufferCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mBuffer.isEmpty();
        }
    }
}

