/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.utils;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@RequiresApi(value=21)
public final class SizeUtil {
    public static final Size RESOLUTION_ZERO = new Size(0, 0);
    public static final Size RESOLUTION_QVGA = new Size(320, 240);
    public static final Size RESOLUTION_VGA = new Size(640, 480);
    public static final Size RESOLUTION_480P = new Size(720, 480);
    public static final Size RESOLUTION_720P = new Size(1280, 720);
    public static final Size RESOLUTION_1080P = new Size(1920, 1080);
    public static final Size RESOLUTION_1440P = new Size(1920, 1440);

    private SizeUtil() {
    }

    public static int getArea(@NonNull Size size) {
        return SizeUtil.getArea(size.getWidth(), size.getHeight());
    }

    public static int getArea(int width, int height) {
        return width * height;
    }

    public static boolean isSmallerByArea(@NonNull Size sourceSize, @NonNull Size targetSize) {
        return SizeUtil.getArea(sourceSize) < SizeUtil.getArea(targetSize);
    }

    public static boolean isLongerInAnyEdge(@NonNull Size sourceSize, @NonNull Size targetSize) {
        return sourceSize.getWidth() > targetSize.getWidth() || sourceSize.getHeight() > targetSize.getHeight();
    }

    @Nullable
    public static Size getMaxSize(@NonNull List<Size> sizeList) {
        if (sizeList.isEmpty()) {
            return null;
        }
        return Collections.max(sizeList, new CompareSizesByArea());
    }

    @Nullable
    public static <T> T findNearestHigherFor(@NonNull Size size, @NonNull TreeMap<Size, T> areaSortedSizeMap) {
        Map.Entry<Size, T> ceilEntry = areaSortedSizeMap.ceilingEntry(size);
        if (ceilEntry != null) {
            return ceilEntry.getValue();
        }
        Map.Entry<Size, T> floorEntry = areaSortedSizeMap.floorEntry(size);
        if (floorEntry != null) {
            return floorEntry.getValue();
        }
        return null;
    }
}

