/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.SurfaceOutputImpl;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class SurfaceEdge {
    private final int mFormat;
    private final Matrix mSensorToBufferTransform;
    private final boolean mHasCameraTransform;
    private final Rect mCropRect;
    private final boolean mMirroring;
    private final int mTargets;
    private final StreamSpec mStreamSpec;
    private int mTargetRotation;
    private int mRotationDegrees;
    private boolean mHasConsumer = false;
    @Nullable
    private SurfaceRequest mProviderSurfaceRequest;
    @NonNull
    private SettableSurface mSettableSurface;
    @NonNull
    private final Set<Runnable> mOnInvalidatedListeners = new HashSet<Runnable>();
    private boolean mIsClosed = false;

    public SurfaceEdge(int targets, int format, @NonNull StreamSpec streamSpec, @NonNull Matrix sensorToBufferTransform, boolean hasCameraTransform, @NonNull Rect cropRect, int rotationDegrees, int targetRotation, boolean mirroring) {
        this.mTargets = targets;
        this.mFormat = format;
        this.mStreamSpec = streamSpec;
        this.mSensorToBufferTransform = sensorToBufferTransform;
        this.mHasCameraTransform = hasCameraTransform;
        this.mCropRect = cropRect;
        this.mRotationDegrees = rotationDegrees;
        this.mTargetRotation = targetRotation;
        this.mMirroring = mirroring;
        this.mSettableSurface = new SettableSurface(streamSpec.getResolution(), this.mFormat);
    }

    @MainThread
    public void addOnInvalidatedListener(@NonNull Runnable onInvalidated) {
        Threads.checkMainThread();
        this.checkNotClosed();
        this.mOnInvalidatedListeners.add(onInvalidated);
    }

    @NonNull
    @MainThread
    public DeferrableSurface getDeferrableSurface() {
        Threads.checkMainThread();
        this.checkNotClosed();
        this.checkAndSetHasConsumer();
        return this.mSettableSurface;
    }

    @MainThread
    public void setProvider(@NonNull DeferrableSurface provider) throws DeferrableSurface.SurfaceClosedException {
        Threads.checkMainThread();
        this.checkNotClosed();
        SettableSurface settableSurface = this.mSettableSurface;
        settableSurface.setProvider(provider, settableSurface::close);
    }

    @MainThread
    @NonNull
    public SurfaceRequest createSurfaceRequest(@NonNull CameraInternal cameraInternal) {
        Threads.checkMainThread();
        this.checkNotClosed();
        SurfaceRequest surfaceRequest = new SurfaceRequest(this.mStreamSpec.getResolution(), cameraInternal, this.mStreamSpec.getDynamicRange(), this.mStreamSpec.getExpectedFrameRateRange(), () -> CameraXExecutors.mainThreadExecutor().execute(() -> {
            if (!this.mIsClosed) {
                this.invalidate();
            }
        }));
        try {
            DeferrableSurface deferrableSurface = surfaceRequest.getDeferrableSurface();
            SettableSurface settableSurface = this.mSettableSurface;
            if (settableSurface.setProvider(deferrableSurface, settableSurface::close)) {
                settableSurface.getTerminationFuture().addListener(deferrableSurface::close, CameraXExecutors.directExecutor());
            }
        }
        catch (DeferrableSurface.SurfaceClosedException e) {
            throw new AssertionError("Surface is somehow already closed", e);
        }
        catch (RuntimeException e) {
            surfaceRequest.willNotProvideSurface();
            throw e;
        }
        this.mProviderSurfaceRequest = surfaceRequest;
        this.notifyTransformationInfoUpdate();
        return surfaceRequest;
    }

    @MainThread
    @NonNull
    public ListenableFuture<SurfaceOutput> createSurfaceOutputFuture(@NonNull Size inputSize, int format, @NonNull Rect cropRect, int rotationDegrees, boolean mirroring, @Nullable CameraInternal cameraInternal) {
        Threads.checkMainThread();
        this.checkNotClosed();
        this.checkAndSetHasConsumer();
        SettableSurface settableSurface = this.mSettableSurface;
        return Futures.transformAsync(settableSurface.getSurface(), surface -> {
            Preconditions.checkNotNull((Object)surface);
            try {
                settableSurface.incrementUseCount();
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                return Futures.immediateFailedFuture(e);
            }
            SurfaceOutputImpl surfaceOutputImpl = new SurfaceOutputImpl((Surface)surface, this.getTargets(), format, this.mStreamSpec.getResolution(), inputSize, cropRect, rotationDegrees, mirroring, cameraInternal, this.mSensorToBufferTransform);
            surfaceOutputImpl.getCloseFuture().addListener(settableSurface::decrementUseCount, CameraXExecutors.directExecutor());
            settableSurface.setConsumer(surfaceOutputImpl);
            return Futures.immediateFuture(surfaceOutputImpl);
        }, CameraXExecutors.mainThreadExecutor());
    }

    @MainThread
    public void invalidate() {
        Threads.checkMainThread();
        this.checkNotClosed();
        if (this.mSettableSurface.canSetProvider()) {
            return;
        }
        this.mHasConsumer = false;
        this.mSettableSurface.close();
        this.mSettableSurface = new SettableSurface(this.mStreamSpec.getResolution(), this.mFormat);
        for (Runnable onInvalidated : this.mOnInvalidatedListeners) {
            onInvalidated.run();
        }
    }

    @MainThread
    public final void close() {
        Threads.checkMainThread();
        this.mSettableSurface.close();
        this.mIsClosed = true;
    }

    @MainThread
    public final void disconnect() {
        Threads.checkMainThread();
        this.checkNotClosed();
        this.mSettableSurface.close();
    }

    public int getTargets() {
        return this.mTargets;
    }

    public int getFormat() {
        return this.mFormat;
    }

    @NonNull
    public Matrix getSensorToBufferTransform() {
        return this.mSensorToBufferTransform;
    }

    public boolean hasCameraTransform() {
        return this.mHasCameraTransform;
    }

    @NonNull
    public Rect getCropRect() {
        return this.mCropRect;
    }

    public int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    public void updateTransformation(int rotationDegrees) {
        this.updateTransformation(rotationDegrees, -1);
    }

    public void updateTransformation(int rotationDegrees, int targetRotation) {
        Threads.runOnMain(() -> {
            boolean isDirty = false;
            if (this.mRotationDegrees != rotationDegrees) {
                isDirty = true;
                this.mRotationDegrees = rotationDegrees;
            }
            if (this.mTargetRotation != targetRotation) {
                isDirty = true;
                this.mTargetRotation = targetRotation;
            }
            if (isDirty) {
                this.notifyTransformationInfoUpdate();
            }
        });
    }

    @MainThread
    private void notifyTransformationInfoUpdate() {
        Threads.checkMainThread();
        if (this.mProviderSurfaceRequest != null) {
            this.mProviderSurfaceRequest.updateTransformationInfo(SurfaceRequest.TransformationInfo.of(this.mCropRect, this.mRotationDegrees, this.mTargetRotation, this.hasCameraTransform(), this.mSensorToBufferTransform, this.mMirroring));
        }
    }

    private void checkAndSetHasConsumer() {
        Preconditions.checkState((!this.mHasConsumer ? 1 : 0) != 0, (String)"Consumer can only be linked once.");
        this.mHasConsumer = true;
    }

    public boolean isMirroring() {
        return this.mMirroring;
    }

    @NonNull
    public StreamSpec getStreamSpec() {
        return this.mStreamSpec;
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.mIsClosed ? 1 : 0) != 0, (String)"Edge is already closed.");
    }

    @VisibleForTesting
    @NonNull
    public DeferrableSurface getDeferrableSurfaceForTesting() {
        return this.mSettableSurface;
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.mIsClosed;
    }

    @VisibleForTesting
    public boolean hasProvider() {
        return this.mSettableSurface.hasProvider();
    }

    static class SettableSurface
    extends DeferrableSurface {
        final ListenableFuture<Surface> mSurfaceFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCompleter = completer;
            return "SettableFuture hashCode: " + this.hashCode();
        });
        CallbackToFutureAdapter.Completer<Surface> mCompleter;
        private DeferrableSurface mProvider;
        @Nullable
        private SurfaceOutputImpl mConsumer;

        SettableSurface(@NonNull Size size, int format) {
            super(size, format);
        }

        @Override
        @NonNull
        protected ListenableFuture<Surface> provideSurface() {
            return this.mSurfaceFuture;
        }

        @MainThread
        boolean canSetProvider() {
            Threads.checkMainThread();
            return this.mProvider == null && !this.isClosed();
        }

        @MainThread
        public void setConsumer(@NonNull SurfaceOutputImpl surfaceOutput) {
            Preconditions.checkState((this.mConsumer == null ? 1 : 0) != 0, (String)"Consumer can only be linked once.");
            this.mConsumer = surfaceOutput;
        }

        @VisibleForTesting
        boolean hasProvider() {
            return this.mProvider != null;
        }

        @MainThread
        public boolean setProvider(@NonNull DeferrableSurface provider, @NonNull Runnable onProviderClosed) throws DeferrableSurface.SurfaceClosedException {
            Threads.checkMainThread();
            Preconditions.checkNotNull((Object)provider);
            if (this.mProvider == provider) {
                return false;
            }
            Preconditions.checkState((this.mProvider == null ? 1 : 0) != 0, (String)"A different provider has been set. To change the provider, call SurfaceEdge#invalidate before calling SurfaceEdge#setProvider");
            Preconditions.checkArgument((boolean)this.getPrescribedSize().equals((Object)provider.getPrescribedSize()), (Object)String.format("The provider's size(%s) must match the parent(%s)", this.getPrescribedSize(), provider.getPrescribedSize()));
            Preconditions.checkArgument((this.getPrescribedStreamFormat() == provider.getPrescribedStreamFormat() ? 1 : 0) != 0, (Object)String.format("The provider's format(%s) must match the parent(%s)", this.getPrescribedStreamFormat(), provider.getPrescribedStreamFormat()));
            Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (String)"The parent is closed. Call SurfaceEdge#invalidate() before setting a new provider.");
            this.mProvider = provider;
            Futures.propagate(provider.getSurface(), this.mCompleter);
            provider.incrementUseCount();
            this.getTerminationFuture().addListener(provider::decrementUseCount, CameraXExecutors.directExecutor());
            provider.getCloseFuture().addListener(onProviderClosed, (Executor)CameraXExecutors.mainThreadExecutor());
            return true;
        }

        @Override
        public void close() {
            super.close();
            Threads.runOnMain(() -> {
                if (this.mConsumer != null) {
                    this.mConsumer.requestClose();
                }
                if (this.mProvider == null) {
                    this.mCompleter.setCancelled();
                }
            });
        }
    }
}

