/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraFilter;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.ExperimentalLensFacing;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.LensFacingCameraFilter;
import androidx.core.util.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public final class CameraSelector {
    public static final int LENS_FACING_UNKNOWN = -1;
    public static final int LENS_FACING_FRONT = 0;
    public static final int LENS_FACING_BACK = 1;
    @ExperimentalLensFacing
    public static final int LENS_FACING_EXTERNAL = 2;
    @NonNull
    public static final CameraSelector DEFAULT_FRONT_CAMERA = new Builder().requireLensFacing(0).build();
    @NonNull
    public static final CameraSelector DEFAULT_BACK_CAMERA = new Builder().requireLensFacing(1).build();
    @NonNull
    private final LinkedHashSet<CameraFilter> mCameraFilterSet;
    @Nullable
    private final String mPhysicalCameraId;

    CameraSelector(@NonNull LinkedHashSet<CameraFilter> cameraFilterSet, @Nullable String physicalCameraId) {
        this.mCameraFilterSet = cameraFilterSet;
        this.mPhysicalCameraId = physicalCameraId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public CameraInternal select(@NonNull LinkedHashSet<CameraInternal> cameras) {
        Iterator cameraInternalIterator = this.filter(cameras).iterator();
        if (cameraInternalIterator.hasNext()) {
            return (CameraInternal)cameraInternalIterator.next();
        }
        throw new IllegalArgumentException("No available camera can be found");
    }

    @NonNull
    public List<CameraInfo> filter(@NonNull List<CameraInfo> cameraInfos) {
        List<CameraInfo> output = new ArrayList<CameraInfo>(cameraInfos);
        for (CameraFilter filter : this.mCameraFilterSet) {
            output = filter.filter(Collections.unmodifiableList(output));
        }
        output.retainAll(cameraInfos);
        return output;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public LinkedHashSet<CameraInternal> filter(@NonNull LinkedHashSet<CameraInternal> cameras) {
        ArrayList<CameraInfo> input = new ArrayList<CameraInfo>();
        for (CameraInternal camera : cameras) {
            input.add(camera.getCameraInfo());
        }
        List<CameraInfo> result = this.filter(input);
        LinkedHashSet<CameraInternal> output = new LinkedHashSet<CameraInternal>();
        for (CameraInternal camera : cameras) {
            if (!result.contains(camera.getCameraInfo())) continue;
            output.add(camera);
        }
        return output;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public LinkedHashSet<CameraFilter> getCameraFilterSet() {
        return this.mCameraFilterSet;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Integer getLensFacing() {
        Integer currentLensFacing = null;
        for (CameraFilter filter : this.mCameraFilterSet) {
            if (!(filter instanceof LensFacingCameraFilter)) continue;
            Integer newLensFacing = ((LensFacingCameraFilter)filter).getLensFacing();
            if (currentLensFacing == null) {
                currentLensFacing = newLensFacing;
                continue;
            }
            if (currentLensFacing.equals(newLensFacing)) continue;
            throw new IllegalStateException("Multiple conflicting lens facing requirements exist.");
        }
        return currentLensFacing;
    }

    @Nullable
    public String getPhysicalCameraId() {
        return this.mPhysicalCameraId;
    }

    public static final class Builder {
        @NonNull
        private final LinkedHashSet<CameraFilter> mCameraFilterSet;
        @Nullable
        private String mPhysicalCameraId;

        public Builder() {
            this.mCameraFilterSet = new LinkedHashSet();
        }

        private Builder(@NonNull LinkedHashSet<CameraFilter> cameraFilterSet) {
            this.mCameraFilterSet = new LinkedHashSet<CameraFilter>(cameraFilterSet);
        }

        @NonNull
        public Builder requireLensFacing(int lensFacing) {
            Preconditions.checkState((lensFacing != -1 ? 1 : 0) != 0, (String)"The specified lens facing is invalid.");
            this.mCameraFilterSet.add(new LensFacingCameraFilter(lensFacing));
            return this;
        }

        @NonNull
        public Builder addCameraFilter(@NonNull CameraFilter cameraFilter) {
            this.mCameraFilterSet.add(cameraFilter);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public static Builder fromSelector(@NonNull CameraSelector cameraSelector) {
            Builder builder = new Builder(cameraSelector.getCameraFilterSet());
            return builder;
        }

        @NonNull
        public Builder setPhysicalCameraId(@NonNull String physicalCameraId) {
            this.mPhysicalCameraId = physicalCameraId;
            return this;
        }

        @NonNull
        public CameraSelector build() {
            return new CameraSelector(this.mCameraFilterSet, this.mPhysicalCameraId);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.TYPE_USE, ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE})
    @Retention(value=RetentionPolicy.SOURCE)
    @OptIn(markerClass={ExperimentalLensFacing.class})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LensFacing {
    }
}

