/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CompositionSettings;
import androidx.camera.core.UseCaseGroup;
import androidx.lifecycle.LifecycleOwner;
import java.util.List;

public class ConcurrentCamera {
    @NonNull
    private List<Camera> mCameras;

    public ConcurrentCamera(@NonNull List<Camera> cameras) {
        this.mCameras = cameras;
    }

    @NonNull
    public List<Camera> getCameras() {
        return this.mCameras;
    }

    public static final class SingleCameraConfig {
        @NonNull
        private CameraSelector mCameraSelector;
        @NonNull
        private LifecycleOwner mLifecycleOwner;
        @NonNull
        private UseCaseGroup mUseCaseGroup;
        @NonNull
        private CompositionSettings mCompositionSettings;

        public SingleCameraConfig(@NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup, @NonNull LifecycleOwner lifecycleOwner) {
            this(cameraSelector, useCaseGroup, CompositionSettings.DEFAULT, lifecycleOwner);
        }

        public SingleCameraConfig(@NonNull CameraSelector cameraSelector, @NonNull UseCaseGroup useCaseGroup, @NonNull CompositionSettings compositionSettings, @NonNull LifecycleOwner lifecycleOwner) {
            this.mCameraSelector = cameraSelector;
            this.mUseCaseGroup = useCaseGroup;
            this.mCompositionSettings = compositionSettings;
            this.mLifecycleOwner = lifecycleOwner;
        }

        @NonNull
        public CameraSelector getCameraSelector() {
            return this.mCameraSelector;
        }

        @NonNull
        public LifecycleOwner getLifecycleOwner() {
            return this.mLifecycleOwner;
        }

        @NonNull
        public UseCaseGroup getUseCaseGroup() {
            return this.mUseCaseGroup;
        }

        @NonNull
        public CompositionSettings getCompositionSettings() {
            return this.mCompositionSettings;
        }
    }
}

