/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class DynamicRange {
    public static final int ENCODING_UNSPECIFIED = 0;
    public static final int ENCODING_SDR = 1;
    public static final int ENCODING_HDR_UNSPECIFIED = 2;
    public static final int ENCODING_HLG = 3;
    public static final int ENCODING_HDR10 = 4;
    public static final int ENCODING_HDR10_PLUS = 5;
    public static final int ENCODING_DOLBY_VISION = 6;
    public static final int BIT_DEPTH_UNSPECIFIED = 0;
    public static final int BIT_DEPTH_8_BIT = 8;
    public static final int BIT_DEPTH_10_BIT = 10;
    @NonNull
    public static final DynamicRange UNSPECIFIED = new DynamicRange(0, 0);
    @NonNull
    public static final DynamicRange SDR = new DynamicRange(1, 8);
    @NonNull
    public static final DynamicRange HDR_UNSPECIFIED_10_BIT = new DynamicRange(2, 10);
    @NonNull
    public static final DynamicRange HLG_10_BIT = new DynamicRange(3, 10);
    @NonNull
    public static final DynamicRange HDR10_10_BIT = new DynamicRange(4, 10);
    @NonNull
    public static final DynamicRange HDR10_PLUS_10_BIT = new DynamicRange(5, 10);
    @NonNull
    public static final DynamicRange DOLBY_VISION_10_BIT = new DynamicRange(6, 10);
    @NonNull
    public static final DynamicRange DOLBY_VISION_8_BIT = new DynamicRange(6, 8);
    private final int mEncoding;
    private final int mBitDepth;

    public DynamicRange(int encoding, int bitDepth) {
        this.mEncoding = encoding;
        this.mBitDepth = bitDepth;
    }

    public int getEncoding() {
        return this.mEncoding;
    }

    public int getBitDepth() {
        return this.mBitDepth;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isFullySpecified() {
        return this.getEncoding() != 0 && this.getEncoding() != 2 && this.getBitDepth() != 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean is10BitHdr() {
        return this.isFullySpecified() && this.getEncoding() != 1 && this.getBitDepth() == 10;
    }

    @NonNull
    public String toString() {
        return "DynamicRange@" + Integer.toHexString(System.identityHashCode(this)) + "{encoding=" + DynamicRange.getEncodingLabel(this.mEncoding) + ", bitDepth=" + this.mBitDepth + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DynamicRange) {
            DynamicRange that = (DynamicRange)o;
            return this.mEncoding == that.getEncoding() && this.mBitDepth == that.getBitDepth();
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.mEncoding;
        hashCode *= 1000003;
        return hashCode ^= this.mBitDepth;
    }

    @NonNull
    private static String getEncodingLabel(int encoding) {
        switch (encoding) {
            case 0: {
                return "UNSPECIFIED";
            }
            case 1: {
                return "SDR";
            }
            case 2: {
                return "HDR_UNSPECIFIED";
            }
            case 3: {
                return "HLG";
            }
            case 4: {
                return "HDR10";
            }
            case 5: {
                return "HDR10_PLUS";
            }
            case 6: {
                return "DOLBY_VISION";
            }
        }
        return "<Unknown>";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface BitDepth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface DynamicRangeEncoding {
    }
}

